#include "CAN_Communication_Matrix.h"
#include "Maintenance.h"
#include "Service_Time.h" 
#include "Common_Interface.h"
#include "Services_ODO.h"
#include "Services_TripA.h"
#include "RTE_TIME.h"
#include "Key.h"
#include "EOL_Para.h"
#include "Services_Interval.h"
#include "Line_In.h"
#include "MBD_Model.h"
#include "System_Status_Monitor.h" 
#include "Service_Time.h"
/* 2021/09/27 17:04:01 */
#include "Services_ODO.h"
#include "Gauge_Display.h"
/* 2022/06/20 09:31:15 */
#include "UDS_Common.h"
//----------shi--------//
uint8_t EnergyRecovery_send = 0;
//---------yuan--------//
uint8_t DUSdate_out[3] = {0};

extern uint8_t DID_F193[];
extern uint8_t Ser22_DID_F195[];
extern uint8_t Ser22_DID_F18B[];
const st_CAN_SendAttribute    st_CANSendAttr[ID_SEND_TOTAL] =
{    //ID          Cycle    Cycleoffset SendCnt       pro dlc     
{0x18FDA517ul, 100ul * 1000ul,  0ul,    0u,  MSG_EXT, 2u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_18FDA517, (void *)0},
{0x18FEE017ul, 100ul * 1000ul,  0ul,    0u,  MSG_EXT, 3u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_18FEE017, (void *)0},
{0x18FF6F17ul, 200ul * 1000ul,  0ul,    0u,  MSG_EXT, 4u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_18FF6F17, (void *)0},
//{0x18FF4117ul, 100ul * 1000ul,  0ul,    0u,  MSG_EXT, 5u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_18FF4117, (void *)0},
{0x18FEDA17ul, 1000ul * 1000ul,  0ul,    0u,  MSG_EXT, 6u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_18FEDA17, (void *)0},
   
};

void Can_Set_Buff_18FDA517(canlib_uint8_t *CopyData)
{
    canlib_uint8_t DoorSta = 0;
    if (Get_LINE_IN_Sts(LINE_IN_DOOROPEN))
    {
        DoorSta = 1;
    }
    else 
    {
        DoorSta = 0;
    }
    CopyData [0] &= ~(3<<2);
    CopyData [0] |= DoorSta<<2;
    CopyData [1] &= ~(3<<0);
    CopyData [1] |= 3<<0;
    CopyData [1] &= ~(3<<6);
    CopyData [1] |= 3<<6;
    CopyData [2] &= ~(3<<4);
    CopyData [2] |= 3<<4;    

    CopyData [0] &= ~(3<<0);
    CopyData [0] |= 3<<0;
    CopyData [0] &= ~(3<<6);
    CopyData [0] |= 3<<6;
    CopyData [1] &= ~(3<<4);
    CopyData [1] |= 3<<4;
    CopyData [2] &= ~(3<<2);
    CopyData [2] |= 3<<2;

    CopyData [0] &= ~(3<<4);
    CopyData [0] |= 1<<4;
    CopyData [1] &= ~(3<<2);
    CopyData [1] |= 3<<2;
    CopyData [2] &= ~(3<<0);
    CopyData [2] |= 3<<0;  
    CopyData [2] &= ~(3<<6);
    CopyData [2] |= 3<<6;    

    CopyData [3] &= ~(7<<0);
    EnergyRecovery_send = EnergyRecovery_Level;
    if(EnergyRecovery_send == 2)
    {
        EnergyRecovery_send = 3;
    }
    CopyData [3] |= EnergyRecovery_send;

}

void Can_Set_Buff_18FEE017(canlib_uint8_t *CopyData)
{
    uint32_t IC_TotalVehicleDistance, IC_TripDistance;
    IC_TotalVehicleDistance = Data_ODO_Read() * 8u / 10;
    IC_TripDistance = Data_Read_TripA() * 8u / 10;
    
    CopyData[0] = (canlib_uint8_t)(IC_TripDistance & 0x000000FFul);
    CopyData[1] = (canlib_uint8_t)((IC_TripDistance >>8) & 0x000000FFul);
    CopyData[2] = (canlib_uint8_t)((IC_TripDistance >>16) & 0x000000FFul);
    CopyData[3] = (canlib_uint8_t)((IC_TripDistance >>24) & 0x000000FFul);
    
    CopyData[4] = (canlib_uint8_t)((IC_TotalVehicleDistance & 0x000000FFul));
    CopyData[5] = (canlib_uint8_t)((IC_TotalVehicleDistance >>8) & 0x000000FFul);
    CopyData[6] = (canlib_uint8_t)((IC_TotalVehicleDistance >>16) & 0x000000FFul);
    CopyData[7] = (canlib_uint8_t)((IC_TotalVehicleDistance >>24) & 0x000000FFul); 
}
uint32_t IC_ServiceMaintainInterval = 0u;
uint32_t Wsend = 0u;
void Can_Set_Buff_18FF6F17(canlib_uint8_t *CopyData)
{
        //仪表记录的保养公里程
    uint8_t IC_MaintanceWarningSts = 0u;         //IC发出保养提示报警信号
  

    CopyData[0] = 0xffu;
    CopyData[1] = 0xffu;
    CopyData[2] = 0xffu;
    CopyData[3] = 0xffu;
    CopyData[4] = 0xffu;

   
    IC_MaintanceWarningSts = Get_warningInterval();
   
    IC_ServiceMaintainInterval = Maintenance_Mileage_Count_Read()/10u;
    if(IC_ServiceMaintainInterval >= 0xffff)
    {
        IC_ServiceMaintainInterval = 0xffff;
    }
    Wsend = Maintenance_Mileage_Count_Read()/10u;
 
    CopyData[5] = IC_ServiceMaintainInterval & 0x00FFU;
    CopyData[6] = (IC_ServiceMaintainInterval >> 8u) & 0x00FFU;
    CopyData[7] = IC_MaintanceWarningSts & 0x03;
}



void Can_Set_Buff_18FEDA17(canlib_uint8_t *CopyData)
{
    uint32_T Service = 0;
    uint8_T WriteService = 0;
    uint32_T WriteService_Year = 0;
    uint8_T WriteService_Month = 0;
    uint8_T WriteService_Day = 0;
    uint8_T IC_HardwareMajorVer = 0u;           //IC硬件主版本
    uint8_T IC_HardwareMinorVer = 0u;           //IC硬件副版本
    uint8_T IC_SoftwareMajorVer = 0u;           //IC软件主版本
    uint8_T IC_SoftwareMinorVer = 0u;           //IC软件副版本
    uint8_T IC_SWCompileYear_H;
    uint8_T IC_SWCompileYear_L =  0; //IC软件编译完成日期（年）
    uint8_T IC_SWCompileMonth = 0; //IC软件编译完成日期（月）
    uint8_T IC_SWCompileDay = 0;   //IC软件编译完成日期（日）

    IC_HardwareMajorVer = DID_F193[4];
    IC_HardwareMinorVer = DID_F193[8];

    IC_SoftwareMajorVer = Ser22_DID_F195[4];
    IC_SoftwareMinorVer = Ser22_DID_F195[8];

    if((IC_HardwareMajorVer >= 0x30)&&(IC_HardwareMinorVer >= 0x30)&&(IC_SoftwareMajorVer >= 0x30)&&(IC_SoftwareMinorVer >= 0x30)) 
    {
        IC_HardwareMajorVer -= 0x30;//48 
        IC_HardwareMinorVer -= 0x30;//48
        IC_SoftwareMajorVer -= 0x30;//48
        IC_SoftwareMinorVer -= 0x30;//48
    }
    IC_SWCompileYear_H =  Ser22_DID_F18B[0];
    IC_SWCompileYear_L =  Ser22_DID_F18B[1];    
    IC_SWCompileMonth = Ser22_DID_F18B[2];    
    IC_SWCompileDay = Ser22_DID_F18B[3]; 

    Service += (((IC_SWCompileYear_H & 0xF0)>>4) * 1000); 
    Service += (((IC_SWCompileYear_H & 0x0F)>>0) * 100);
    Service += (((IC_SWCompileYear_L & 0xF0)>>4) * 10); 
    Service += (((IC_SWCompileYear_L & 0x0F)>>0) * 1) ;
    WriteService_Year = Service;

    Service = (IC_SWCompileMonth & 0xF0)>>4; 
    Service  =  Service*10 ;
    WriteService_Month = WriteService + Service ;
    Service  =  (IC_SWCompileMonth & 0x0F) ;
    Service = Service;
    WriteService_Month = WriteService_Month + Service ;

    Service = (IC_SWCompileDay & 0xF0)>>4; 
    Service  =  Service*10 ;
    WriteService_Day = WriteService + Service ;
    Service  =  (IC_SWCompileDay & 0x0F) ;
    Service = Service;
    WriteService_Day = WriteService_Day + Service ;

    CopyData[0] = IC_HardwareMajorVer;
    CopyData[1] = IC_HardwareMinorVer;
    CopyData[2] = IC_SoftwareMajorVer;
    CopyData[3] = IC_SoftwareMinorVer;
    if(WriteService_Year >= 2022)
    {
        CopyData[4] = WriteService_Year - 2022;
    }
    CopyData[5] = WriteService_Month;
    CopyData[6] = WriteService_Day;
    CopyData[7] = 0XFF;
      
}

const st_CANMsgAttribute CAN_MSG_CONST_ARRAY[ID_TOTAL_MAX] =
{
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FDA517ul,//
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF4117ul,//
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18F0010Bul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FA02EFul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FA09EFul,
        (( void * )0),
        Services_ODO_MCU_Read,
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FA40F4ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FA41F4ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FC03F4ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x18FA3EF4ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FA42F4ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FAB027ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FAB227ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FAB327ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FAA827ul,
        (( void * )0),
        Services_ODO_PMS_Read,
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF639Ful,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEE69Ful,
        (( void * )0),
        Can_Receive,
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEE017ul,//
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF6F17ul,//
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEDA17ul,//
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18DAF117ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        10000ul,
        0x18FECA10ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FEBF0Bul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FF5D27ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FA1727ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x0CFF1ADAul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
        {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FFFFD8ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x18FA7049ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },


};

uint8_t  Get_ID_18FDA517_Sig_ICEnergyReconverLel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FDA517_Msg_Count, 3u) >> 0u) & 0x07u));
}

uint8_t  Get_ID_18FDA517_Sig_ICDoor4EnableStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FDA517_Msg_Count, 2u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FDA517_Sig_ICDoor4AjarStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FDA517_Msg_Count, 2u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FDA517_Sig_IC_Door4LockStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FDA517_Msg_Count, 2u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FDA517_Sig_ICDoor3EnableStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FDA517_Msg_Count, 2u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FDA517_Sig_ICDoor3AjarStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FDA517_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FDA517_Sig_ICDoor3LockStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FDA517_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FDA517_Sig_ICDoor2EnableStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FDA517_Msg_Count, 1u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FDA517_Sig_ICDoor2AjarStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FDA517_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FDA517_Sig_ICDoor2LockStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FDA517_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FDA517_Sig_ICDoor1EnableStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FDA517_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FDA517_Sig_ICDoor1AjarStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FDA517_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FDA517_Sig_ICDoor1LockStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FDA517_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FF4117_Sig_ICOTADeclimerSelected(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FF4117_Msg_Count, 3u) >> 3u) & 0x03u));
}

uint8_t  Get_ID_18FF4117_Sig_ICOTAUpdateResultConfirm(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FF4117_Msg_Count, 3u) >> 2u) & 0x01u));
}

uint8_t  Get_ID_18FF4117_Sig_ICOTAUpdateSelected(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FF4117_Msg_Count, 3u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FF4117_Sig_ICOTADownloadSelected(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FF4117_Msg_Count, 2u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FF4117_Sig_ICOTAInfoShowStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FF4117_Msg_Count, 2u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18F0010B_Sig_ABSLife(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18F0010B_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18F0010B_Sig_ABSEBDActive(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18F0010B_Msg_Count, 5u) >> 7u) & 0x01u));
}

uint8_t  Get_ID_18F0010B_Sig_ABSEBDAmberWarningState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18F0010B_Msg_Count, 5u) >> 6u) & 0x01u));
}

uint8_t  Get_ID_18F0010B_Sig_ABSABSEBSAmberWarningState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18F0010B_Msg_Count, 5u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18F0010B_Sig_ABSBrakePedalPosition(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18F0010B_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18F0010B_Sig_ABSABSActive(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18F0010B_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorSN(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 7u) >> 4u) & 0x0Fu));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_ActiveShortCircuitState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 7u) >> 0u) & 0x01u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_DTC(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorTempSensorErr(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 5u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_McuTempSensorErr(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 5u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorLockRotErr(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 5u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_BusUndervolt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 5u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_HardwareCapOverVolt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 4u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_SoftwareCapOverVolt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 4u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_ActiveDischgFlt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 4u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorWCurrSensorFlt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorFltLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 3u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorVCurrSensorFlt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 3u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorUCurrSensorFlt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 3u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_DCHVCurrSensorFlt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 3u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_MCUMemoryFlt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 2u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_CANCommFlt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 2u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorSubFltLevell(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 2u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorSpdHighAlarm(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_MCUTempHighAlarm(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorTempHighAlarm(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 1u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_IGBTFlt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_RotateInverterFlt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_LV_VotagtFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_HVLoopFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorSysOverCurrtAlarm(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA02EF_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint16_t Get_ID_18FA09EF_Sig_MCU_Odometerbackup(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_MCU_OdometerInfo_Msg_Count, 1u) >> 0u) & 0x3Fu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(ID_MCU_OdometerInfo_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FA40F4_Sig_BMSActWorkSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA40F4_Msg_Count, 7u) >> 4u) & 0x0Fu));
}

uint8_t  Get_ID_18FA40F4_Sig_BMSHeatRelaySts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA40F4_Msg_Count, 7u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FA40F4_Sig_BMSNegRelaySts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA40F4_Msg_Count, 7u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FA40F4_Sig_BMSFaultLevelVCU_BMSFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA40F4_Msg_Count, 6u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FA40F4_Sig_BMSSelfChkState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA40F4_Msg_Count, 6u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FA40F4_Sig_BMSPmtCutoffLVFb(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA40F4_Msg_Count, 6u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FA40F4_Sig_BMSEmergCutoffHVReq(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA40F4_Msg_Count, 6u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FA40F4_Sig_BMSBattSOH(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA40F4_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FA40F4_Sig_BMSBattSOC(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA40F4_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_ID_18FA40F4_Sig_BMSBattCurr(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_can0x18FA40F4_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(ID_can0x18FA40F4_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint16_t Get_ID_18FA40F4_Sig_BMSBattVol(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_can0x18FA40F4_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(ID_can0x18FA40F4_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FA41F4_Sig_BMSHVIsolationInfo_AliveCnt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA41F4_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FA41F4_Sig_BMSTempOutofCtr(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA41F4_Msg_Count, 5u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FA41F4_Sig_BMSIsolationFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA41F4_Msg_Count, 4u) >> 3u) & 0x1Fu));
}

uint8_t  Get_ID_18FA41F4_Sig_BMSHVIsolationSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA41F4_Msg_Count, 4u) >> 0u) & 0x07u));
}

uint16_t Get_ID_18FA41F4_Sig_BMSNegIsolationRes(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_can0x18FA41F4_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(ID_can0x18FA41F4_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FA41F4_Sig_BMS_HVIsolationSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA41F4_Msg_Count, 4u) >> 0u) & 0x07u));
}

uint16_t Get_ID_18FC03F4_Sig_BMS_ChgTimeRemain(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_BMS_BattEnyInfo1_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(ID_BMS_BattEnyInfo1_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FA3EF4_Sig_BMSChgInfoAliveCnt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA3EF4_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FA3EF4_Sig_BMSDCChgReady(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA3EF4_Msg_Count, 6u) >> 7u) & 0x01u));
}

uint8_t  Get_ID_18FA3EF4_Sig_BMSDCChgStage(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA3EF4_Msg_Count, 6u) >> 4u) & 0x07u));
}

uint8_t  Get_ID_18FA3EF4_Sig_B2VST1ChgMode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA3EF4_Msg_Count, 6u) >> 0u) & 0x03u));
}

uint16_t Get_ID_18FA3EF4_Sig_BMSMaxChgVoltage(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_can0x18FA3EF4_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(ID_can0x18FA3EF4_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_ID_18FA3EF4_Sig_BMSMaxChgCurrent(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_can0x18FA3EF4_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(ID_can0x18FA3EF4_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FA3EF4_Sig_BMSDCChgPlugSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA3EF4_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FA3EF4_Sig_BMSChgStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA3EF4_Msg_Count, 0u) >> 4u) & 0x0Fu));
}

uint8_t  Get_ID_18FA3EF4_Sig_BMSElectroniclockSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA3EF4_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FA3EF4_Sig_BMSOBCChgContrlCmd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA3EF4_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_BattFaultInfo_AliveCnt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_SubFltLevell(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 6u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_NonPower_Flt_HVIL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 6u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_PowerActiveMode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 6u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_EnyRecoCurrHighFlt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 5u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_CellTempDiffFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 5u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_CellVolDiffFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 5u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_ST1_Flt_HVIL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 5u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_NegRelayFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 4u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_PosRelayFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 4u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_ST1_Flt_HW(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 4u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_OverChgFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_HeatNegRelayFault_Reserved(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 3u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_HeatPosRelayFault_Reserved(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 3u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_MSDFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 3u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_CurrSensorFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 3u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_BattConsistencyFlt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 2u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_BattPackMatchFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 2u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_CANComFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 2u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_BattIsolationSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 2u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_ChargeCurrFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_DischargeCurrFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_BattEqualizationSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 1u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_SOCJumpFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_BattSOCFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_BattTempFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_BattCellVolFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FA42F4_Sig_BMS_BattPackVolFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA42F4_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FAB027_Sig_VCUHVStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FAB027_Msg_Count, 7u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FAB027_Sig_VCUVehicleRunMode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FAB027_Msg_Count, 7u) >> 0u) & 0x0Fu));
}

uint8_t  Get_ID_18FAB027_Sig_VCUIgniteSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FAB027_Msg_Count, 6u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FAB027_Sig_VCUVehicleAbnormalSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FAB027_Msg_Count, 6u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FAB027_Sig_VCUBrkSysErr(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FAB027_Msg_Count, 5u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FAB027_Sig_VCUBMSFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FAB027_Msg_Count, 5u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FAB027_Sig_VCUMotorTempHighAlarm(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FAB027_Msg_Count, 5u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FAB027_Sig_VCUHandbrakeSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FAB027_Msg_Count, 5u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FAB027_Sig_VCUGearPositionInd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FAB027_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_ID_18FAB027_Sig_VCUPTSysElecPwrInd(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_can0x18FAB027_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(ID_can0x18FAB027_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FAB027_Sig_VCUVehicleSysErrorLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FAB027_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FAB027_Sig_VCUPTHVSysErrorLampStsInd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FAB027_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FAB027_Sig_VCUDCDCWorkSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FAB027_Msg_Count, 1u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FAB027_Sig_VCUTurtleLampReq(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FAB027_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FAB027_Sig_VCUDrivePwrCircuitInd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FAB027_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FAB027_Sig_VCUPTReadyInd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FAB027_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FAB027_Sig_VCUPTModeInd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FAB027_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FAB027_Sig_VCUDriveModeInd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FAB027_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint16_t Get_ID_18FAB227_Sig_PMS_EV_DTEodometer(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_PMS_EnyInfo_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(ID_PMS_EnyInfo_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_ID_18FAB327_Sig_VCU_PTResiduePwrInd(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_can0x18FAB327_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(ID_can0x18FAB327_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FAB327_Sig_VCU_AEC(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FAB327_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FAB327_Sig_VCU_Averagespeed(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FAB327_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint32_t Get_ID_18FAB327_Sig_VCU_Cruisingdistance(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(ID_can0x18FAB327_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(ID_can0x18FAB327_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(ID_can0x18FAB327_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(ID_can0x18FAB327_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint16_t Get_ID_18FAA827_Sig_PMS_Odometerbackup(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_PMS_OdometerInfo_Msg_Count, 1u) >> 0u) & 0x3Fu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(ID_PMS_OdometerInfo_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_DisclaimerWarning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_TBOX_OTAStatus_Msg_Count, 3u) >> 0u) & 0x01u));
}

uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_PreConditionDetect(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_TBOX_OTAStatus_Msg_Count, 2u) >> 7u) & 0x01u));
}

uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_FailedReason_ChgStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_TBOX_OTAStatus_Msg_Count, 2u) >> 5u) & 0x01u));
}

uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_FailedReason_HandBrake(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_TBOX_OTAStatus_Msg_Count, 2u) >> 4u) & 0x01u));
}

uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_FailedReason_BattVol(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_TBOX_OTAStatus_Msg_Count, 2u) >> 3u) & 0x01u));
}

uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_FailedReason_VehicleSpd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_TBOX_OTAStatus_Msg_Count, 2u) >> 2u) & 0x01u));
}

uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_FailedReason_GearPos(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_TBOX_OTAStatus_Msg_Count, 2u) >> 1u) & 0x01u));
}

uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_FailedReason_PowerMode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_TBOX_OTAStatus_Msg_Count, 2u) >> 0u) & 0x01u));
}

uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_DownloadProgress(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_TBOX_OTAStatus_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_Mode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_TBOX_OTAStatus_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_UpdateState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_TBOX_OTAStatus_Msg_Count, 0u) >> 4u) & 0x07u));
}

uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_UpdateRequest(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_TBOX_OTAStatus_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_DownloadState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_TBOX_OTAStatus_Msg_Count, 0u) >> 1u) & 0x03u));
}

uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_DownloadRequest(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_TBOX_OTAStatus_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint8_t  Get_ID_18FEE69F_Sig_TBOX_Year(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FEE69F_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FEE69F_Sig_TBOX_Day(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FEE69F_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FEE69F_Sig_TBOX_Month(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FEE69F_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FEE69F_Sig_TBOX_Hour(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FEE69F_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FEE69F_Sig_TBOX_Minute(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FEE69F_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FEE69F_Sig_TBOX_Second(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FEE69F_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint32_t Get_ID_18FEE017_Sig_ICTotalVehicleDistance(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(ID_wcan0x18FEE017_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(ID_wcan0x18FEE017_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(ID_wcan0x18FEE017_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(ID_wcan0x18FEE017_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint32_t Get_ID_18FEE017_Sig_ICTripDistance(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(ID_wcan0x18FEE017_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(ID_wcan0x18FEE017_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(ID_wcan0x18FEE017_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(ID_wcan0x18FEE017_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FF6F17_Sig_ICMaintanceWarningSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FF6F17_Msg_Count, 7u) >> 0u) & 0x03u));
}

uint16_t Get_ID_18FF6F17_Sig_ICServiceMaintainInterval(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_wcan0x18FF6F17_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(ID_wcan0x18FF6F17_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FEDA17_Sig_ICSWCompileDay(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FEDA17_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FEDA17_Sig_ICSWCompileMonth(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FEDA17_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FEDA17_Sig_ICSWCompileYear(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FEDA17_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FEDA17_Sig_ICSoftwareMinorVer(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FEDA17_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FEDA17_Sig_ICSoftwareMajorVer(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FEDA17_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FEDA17_Sig_ICHardwareMinorVer(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FEDA17_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FEDA17_Sig_ICHardwareMajorVer(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_wcan0x18FEDA17_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FECA10_Sig_EPSFaultInf(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FECA10_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FECA10_Sig_EPSMalfunctionIndicatorLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FECA10_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FECA10_Sig_EPSRedStopLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FECA10_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FECA10_Sig_EPSAmberWarningLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FECA10_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FECA10_Sig_EPSProtectLampStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FECA10_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FEBF0B_Sig_ABSRelativeSpd_RAxle2Rwheel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FEBF0B_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FEBF0B_Sig_ABSRelativeSpdRAxle2_LWheel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FEBF0B_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FEBF0B_Sig_ABSRelativeSpdRAxle1RWheel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FEBF0B_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FEBF0B_Sig_ABSRelativeSpdRAxle1Lwheel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FEBF0B_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FEBF0B_Sig_ABSRelativeSpdFAxleRWheel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FEBF0B_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FEBF0B_Sig_ABSRelativeSpdFAxleLWheel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FEBF0B_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint16_t Get_ID_18FEBF0B_Sig_ABSFrontAxleSpeed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_can0x18FEBF0B_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(ID_can0x18FEBF0B_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FF5D27_Sig_VCU_LockLimResult(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FF5D27_Msg_Count, 1u) >> 0u) & 0x07u));
}

uint8_t  Get_ID_18FF5D27_Sig_VCU_LockVehType(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FF5D27_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FF5D27_Sig_VCU_FunAnti_DismantleActive(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FF5D27_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FF5D27_Sig_VCU_FunLockVehActive(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FF5D27_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FF5D27_Sig_VCU_LockVehSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FF5D27_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FA1727_Sig_VCU_Life(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA1727_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FA1727_Sig_VCU_StartBattChgRes(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA1727_Msg_Count, 2u) >> 2u) & 0x01u));
}

uint8_t  Get_ID_18FA1727_Sig_VCU_InventorySpdLmtSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA1727_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FA1727_Sig_VCU_SpdLmtLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA1727_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FA1727_Sig_VCU_VersionConversionFlag(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA1727_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FA1727_Sig_VCU_LockVehPerFlag(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA1727_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_0CFF1ADA_Sig_PDC_Warning_Frq(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x0CFF1ADA_Msg_Count, 4u) >> 0u) & 0x07u));
}

uint8_t  Get_ID_0CFF1ADA_Sig_PDC_VirtualDisplaySts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x0CFF1ADA_Msg_Count, 0u) >> 6u) & 0x01u));
}

uint8_t  Get_ID_18FFFFD8_Sig_VCU_ClearOdo(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FFFFD8_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FFFFD8_Sig_VCU_ClearOdo1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FFFFD8_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FFFFD8_Sig_VCU_ClearOdo2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FFFFD8_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FFFFD8_Sig_VCU_ClearOdo3(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FFFFD8_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FFFFD8_Sig_VCU_ClearOdo4(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FFFFD8_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FFFFD8_Sig_VCU_ClearOdo5(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FFFFD8_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FFFFD8_Sig_VCU_ClearOdo6(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FFFFD8_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FFFFD8_Sig_VCU_ClearOdo7(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FFFFD8_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FA7049_Sig_OBC_ChgCCSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA7049_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FA7049_Sig_OBC_FaultInfo(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA7049_Msg_Count, 1u) >> 0u) & 0x07u));
}

uint8_t  Get_ID_18FA7049_Sig_OBC_FaultLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA7049_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FA7049_Sig_OBC_ActWorkSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_can0x18FA7049_Msg_Count, 0u) >> 0u) & 0x0Fu));
}

uint8_t  Co_Can_ConvertSubID(uint32_t MsgID)
{
    uint8_t u8Result = ID_TOTAL_MAX;
    switch (MsgID)
    {
    case ID_wcan0x18FDA517_Msg:
        u8Result = ID_wcan0x18FDA517_Msg_Count;
        break;
    case ID_wcan0x18FF4117_Msg:
        u8Result = ID_wcan0x18FF4117_Msg_Count;
        break;
    case ID_can0x18F0010B_Msg:
        u8Result = ID_can0x18F0010B_Msg_Count;
        break;
    case ID_can0x18FA02EF_Msg:
        u8Result = ID_can0x18FA02EF_Msg_Count;
        break;
    case ID_MCU_OdometerInfo_Msg:
        u8Result = ID_MCU_OdometerInfo_Msg_Count;
        break;
    case ID_can0x18FA40F4_Msg:
        u8Result = ID_can0x18FA40F4_Msg_Count;
        break;
    case ID_can0x18FA41F4_Msg:
        u8Result = ID_can0x18FA41F4_Msg_Count;
        break;
    case ID_BMS_BattEnyInfo1_Msg:
        u8Result = ID_BMS_BattEnyInfo1_Msg_Count;
        break;
    case ID_can0x18FA3EF4_Msg:
        u8Result = ID_can0x18FA3EF4_Msg_Count;
        break;
    case ID_can0x18FA42F4_Msg:
        u8Result = ID_can0x18FA42F4_Msg_Count;
        break;
    case ID_can0x18FAB027_Msg:
        u8Result = ID_can0x18FAB027_Msg_Count;
        break;
    case ID_PMS_EnyInfo_Msg:
        u8Result = ID_PMS_EnyInfo_Msg_Count;
        break;
    case ID_can0x18FAB327_Msg:
        u8Result = ID_can0x18FAB327_Msg_Count;
        break;
    case ID_PMS_OdometerInfo_Msg:
        u8Result = ID_PMS_OdometerInfo_Msg_Count;
        break;
    case ID_TBOX_OTAStatus_Msg:
        u8Result = ID_TBOX_OTAStatus_Msg_Count;
        break;
    case ID_can0x18FEE69F_Msg:
        u8Result = ID_can0x18FEE69F_Msg_Count;
        Received_18FEE69F_Calibration();
        break;
    case ID_wcan0x18FEE017_Msg:
        u8Result = ID_wcan0x18FEE017_Msg_Count;
        break;
    case ID_wcan0x18FF6F17_Msg:
        u8Result = ID_wcan0x18FF6F17_Msg_Count;
        break;
    case ID_wcan0x18FEDA17_Msg:
        u8Result = ID_wcan0x18FEDA17_Msg_Count;
        break;
    case ID_wcan0x18DAF117_Msg:
        u8Result = ID_wcan0x18DAF117_Msg_Count;
        break;
    case ID_can0x18FECA10_Msg:
        u8Result = ID_can0x18FECA10_Msg_Count;
        break;
    case ID_can0x18FEBF0B_Msg:
        u8Result = ID_can0x18FEBF0B_Msg_Count;
        break;
    case ID_can0x18FF5D27_Msg:
        u8Result = ID_can0x18FF5D27_Msg_Count;
        break;
    case ID_can0x18FA1727_Msg:
        u8Result = ID_can0x18FA1727_Msg_Count;
        break;
    case ID_can0x0CFF1ADA_Msg:
        u8Result = ID_can0x0CFF1ADA_Msg_Count;
        break;
    case ID_can0x18FFFFD8_Msg:
        u8Result = ID_can0x18FFFFD8_Msg_Count;
        break;
    case ID_can0x18FA7049_Msg:
        u8Result = ID_can0x18FA7049_Msg_Count;
        break;
    default :
        u8Result = ID_TOTAL_MAX;
        break;
    }
    return u8Result;
}

