#ifndef GAUGE_DISPLAY_H
#define GAUGE_DISPLAY_H


#include "stdint.h"


typedef struct 
{
    uint16_t value;
    uint8_t  segNum;
}PowerSegMap_st_t;

typedef struct 
{
    uint16_t value;
    uint8_t  segNum;
}BatterySegMap_st_t;

typedef struct 
{
    uint32_t Value;
    uint8_t  Symbol;
    uint8_t  Valid;
}BattCurr_st_t;


#define POSITIVE_POWER_SEG_MAP_MAX (sizeof(PositivePowerSegMap)/sizeof(PowerSegMap_st_t))
#define NEGATIVE_POWER_SEG_MAP_MAX (sizeof(NegativePowerSegMap)/sizeof(PowerSegMap_st_t))
#define BATTERY_SEG_MAP_MAX (sizeof(batterySegMap)/sizeof(BatterySegMap_st_t))

#define POWERON_SCAN_TIMER   3000ul

void Gauge_VSpeed_Display(void);
void Gauge_Power_Display(void);
void Gauge_Battery_Display(void);


void Gauge_Clock_Display(void);
void Gauge_DrivingRange_Display(void);
void Gauge_Trip_Display(void);
void Gauge_ODO_Display(void);
void Gauge_Gear_Display(void);
void Gauge_MaintenanceMileage_Display(void);
void Gauge_EnergyRecoveryLevel_Display(void);


void Gauge_KL30_Init(void);
void Gauge_KL15_Init(void);
void Gauge_Service(void);

void Temp_Calc_Init(void);
void Temp_Calc_Send(void);
uint32_t Get_Temp_Calc(void);
uint16_t Get_Over_Speed_Config(uint8_t Para0);


#endif
