#include "Line_In.h"
#include "Common_Interface.h"
_LINE_IN_TriggerLevel_  Line_In_Sts[LINE_MAX];
_LINE_IN_TriggerLevel_  Line_In_StsBackup[LINE_MAX];
uint32_t Line_In_Cnter[LINE_MAX];

uint8_t LineInEnable;
/*默认电平*/
const _LINE_IN_TriggerLevel_ Line_In_DEFAULT_Level[LINE_MAX] =
{
    LEVEL_LOW,
    LEVEL_HIGH,
    LEVEL_HIGH,
    LEVEL_HIGH,
    LEVEL_HIGH,
    LEVEL_LOW,
    LEVEL_LOW,
    LEVEL_HIGH,
    LEVEL_HIGH,
    LEVEL_LOW,
    LEVEL_LOW,
    LEVEL_LOW,
    LEVEL_HIGH,
    LEVEL_LOW,
    LEVEL_HIGH,
    LEVEL_LOW,//sh
    LEVEL_HIGH,
};
/*触发电平*/
const _LINE_IN_TriggerLevel_ Line_In_Trigger_Level[LINE_MAX] =
{
    LEVEL_HIGH,
    LEVEL_LOW,
    LEVEL_LOW,
    LEVEL_LOW,
    LEVEL_LOW,
    LEVEL_HIGH,
    LEVEL_HIGH,
    LEVEL_LOW,
    LEVEL_LOW,
    LEVEL_HIGH,
    LEVEL_HIGH,
    LEVEL_HIGH,
    LEVEL_LOW,
    LEVEL_HIGH,
    LEVEL_LOW,
    LEVEL_HIGH,//sh
    LEVEL_LOW,
};
/*清除电平*/
const _LINE_IN_TriggerLevel_ Line_In_Remove_Level[LINE_MAX] =
{
    LEVEL_LOW,
    LEVEL_HIGH,
    LEVEL_HIGH,
    LEVEL_HIGH,
    LEVEL_HIGH,
    LEVEL_LOW,
    LEVEL_LOW,
    LEVEL_HIGH,
    LEVEL_HIGH,
    LEVEL_LOW,
    LEVEL_LOW,
    LEVEL_LOW,
    LEVEL_HIGH,
    LEVEL_LOW,
    LEVEL_HIGH,
    LEVEL_LOW,//sh
    LEVEL_HIGH,
};
/*工作状态*/
const _LINE_IN_WorkSt_ Line_In_Work_Status[LINE_MAX] =
{
    LINE_IN_IG_ON,
    LINE_IN_IG_ON,
    LINE_IN_IG_ON,
    LINE_IN_IG_ON,
    LINE_IN_IG_ON,
    LINE_IN_IG_OFFON,
    LINE_IN_IG_OFFON,
    LINE_IN_IG_ON,
    LINE_IN_IG_ON,
    LINE_IN_IG_OFFON,
    LINE_IN_IG_ON,
    LINE_IN_IG_ON,
    LINE_IN_IG_OFFON,
    LINE_IN_IG_OFFON,
    LINE_IN_IG_OFFON,
    LINE_IN_IG_ON,//sh
    LINE_IN_IG_ON,
};
/*触发时间*/
const uint32_t Line_In_Trigger_Timer[LINE_MAX] =
{
    200ul,
    2000ul,
    100ul,
    3000ul,
    500ul,
    50ul,
    50ul,
    100ul,
    100ul,
    100ul,
    100ul,
    100ul,
    500ul,
    100ul,
    100ul,
    100ul,//sh
    100ul,
};
/*清除电平*/
const uint32_t Line_In_Remove_Timer[LINE_MAX] =
{
    80ul,
    80ul,
    80ul,
    80ul,
    80ul,
    30ul,
    30ul,
    50ul,
    50ul,
    50ul,
    50ul,
    50ul,
    50ul,
    50ul,
    50ul,
    80ul,//sh
    80ul,
};

/*使能*/
void Line_In_Enable(uint8_t Enable)
{
    if (Enable)
    {
        Enable = 1u;
    }
    if (LineInEnable != Enable)
    {
        Line_In_Status_Reset();
        LineInEnable = Enable;
    }
}
/*清除*/
void Line_In_Status_Reset(void)
{
    my_memset(Line_In_Sts, 0, sizeof(Line_In_Sts));
    my_memset(Line_In_StsBackup, 0, sizeof(Line_In_StsBackup));
    my_memset(Line_In_Cnter, 0, sizeof(Line_In_Cnter));
}
/*消抖*/
void Line_In_Debounce(_LINE_IN_NAME_ LINE_NAME, _LINE_IN_TriggerLevel_ m_Level)
{
    if (m_Level == Line_In_StsBackup[LINE_NAME])
    {
        Line_In_Cnter[LINE_NAME] += LINE_IN_DEBOUNCE_CYCLE;

        if (m_Level == Line_In_Trigger_Level[LINE_NAME]) //实际电平和触发电平相同
        {
            if (Line_In_Cnter[LINE_NAME] >= Line_In_Trigger_Timer[LINE_NAME])//触发时间够长
            {
                Line_In_Cnter[LINE_NAME] = 0u;
                Line_In_Sts[LINE_NAME] = LEVEL_HIGH;//硬线状态有效
            }
        }
        else//实际电平和触发电平不同
        {
            if (Line_In_Cnter[LINE_NAME] >= Line_In_Remove_Timer[LINE_NAME])//不触发时间够长
            {
                Line_In_Cnter[LINE_NAME] = 0u;
                Line_In_Sts[LINE_NAME] = LEVEL_LOW;//硬线状态无效
            }
        }
    }
    else
    {
        Line_In_Cnter[LINE_NAME] = 0u;
        Line_In_StsBackup[LINE_NAME] = m_Level;
    }
}
/*服务函数*/
void Line_In_Debounce_Service(void)
{
    if (LineInEnable != 0u)
    {
        Line_In_Debounce(   LINE_IN_MaintainWarning,    Get_Line_In_MaintainWarning());//没用
        Line_In_Debounce(  LINE_IN_BRAKEFLUID,   Get_Line_In_BrakeFluid());
        Line_In_Debounce(  LINE_IN_OTA_SWITCH,   Get_Line_In_OTA_Switch());//L0L1L2
        Line_In_Debounce( LINE_IN_TRIP_SWITCH,  Get_Line_In_TRIP_Switch());
        Line_In_Debounce( LINE_IN_SEATBELT_DR,  Get_Line_In_SEATBELT_DR());
        Line_In_Debounce(    LINE_IN_TURNLEFT,     Get_Line_In_TurnLeft());
        Line_In_Debounce(   LINE_IN_TURNRIGHT,    Get_Line_In_TurnRight());
        Line_In_Debounce(       LINE_IN_HBEAM,        Get_Line_In_Hbeam());
        Line_In_Debounce(       LINE_IN_LBEAM,        Get_Line_In_Lbeam());
        Line_In_Debounce(    LINE_IN_POSITION,     Get_Line_In_Position());
        Line_In_Debounce(     LINE_IN_REARFOG,      Get_Line_In_RearFog());
        Line_In_Debounce(    LINE_IN_DAYLIGHT,     Get_Line_In_Daylight());
        Line_In_Debounce(   LINE_IN_HANDBRAKE,    Get_Line_In_Handbrake());
        Line_In_Debounce(      LINE_IN_SOC_CC,       Get_Line_In_SOC_CC());
        Line_In_Debounce(    LINE_IN_DOOROPEN,     Get_Line_In_DoorOpen());
        Line_In_Debounce( LINE_IN_ENERGY_RECOVERY,     Get_Line_In_Energy_Recovery());//sh //前雾灯
        Line_In_Debounce( LINE_IN_ENERGY_RECOVERY0,     Get_Line_In_Energy_Recovery0());
    }
}
/*获取当前硬线状态*/
_LINE_IN_TriggerLevel_ Get_LINE_IN_Sts(_LINE_IN_NAME_ LINE_NAME)
{
    _LINE_IN_TriggerLevel_ Res;
    if (Common_Get_IG_Sts() == Line_In_Work_Status[LINE_NAME])
    {
        Res = Line_In_Sts[LINE_NAME];
    }
    else
    {
        if (Line_In_Work_Status[LINE_NAME] == LINE_IN_IG_OFFON)
        {
            Res = Line_In_Sts[LINE_NAME];
        }
        else
        {
            Res = LEVEL_LOW;
        }
    }
    return Res;
}