#include "UDS_2EService_Main.h"
#include "Services_Interval.h"
#include "Maintenance.h"

/**
 *2E服务函数入口
 *@param A_TA_type 收到数据的地址
 *@param A_Length 收到数据的长度
 *@param A_Data 收到数据的数据
 */
uint8_t UDS_FLAG = 0;
void    UDS_Service_2E_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data [])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2EService_NRC11( ); /*2E服务是否支持功能寻址*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2EService_NRC7F( ); /*2E服务会话是否支持验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2EService_NRC33( ); /*2E服务解锁等级验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2EService_NRC13_MinLengthCheck( ); /*2E服务最小长度验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2EService_NRC31( ); /*2E服务超出请求范围验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2EService_NRC13_TotalLengthCheck( ); /*2E服务总长度长度验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2EService_NRC22( ); /*2E服务条件验证*/
    }
    if ( NRC == positiveResponse )
    {
        UDS_2EService_DID( ); /*2E服务DID判断*/
    }
    clearDiagMSG( ); /*清除诊断信息*/
}

/**
 *2E服务子功能
 */
void UDS_2EService_DID(void)
{
    switch ( getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) ) /*2E服务DID判断*/
    {

        case 0xF199:
            UDS_2EService_DID_F199( ); /*ECU软件刷新日期*/
            break;
        case 0xF190:
            UDS_2EService_DID_F190( ); /*车辆VIN码*/
            break;

        case 0xF112:
            UDS_2EService_DID_F112( ); /*车辆名称*/
            break;
        case 0xF198:
            UDS_2EService_DID_F198( );
            break; /*诊断仪序列号*/
        case 0xF197:
            UDS_2EService_DID_F197( ); /*ECU控制器名称*/
            break;
        case 0xF19D:
            UDS_2EService_DID_F1A2( ); /*ECU装配日期*/
            break;
        case 0xDFEC:
            UDS_2EService_DID_DFEC( ); /*功能配置字备份数据4*/
            break;
        case 0xDFED:
            UDS_2EService_DID_DFED( ); /*功能配置字备份数据3*/
            break;
        case 0xDFEE:
            UDS_2EService_DID_DFEE( ); /*功能配置字备份数据2*/
            break;
        case 0xDFEF:
            UDS_2EService_DID_DFEF( ); /*功能配置字备份数据*/
            break;
        case 0xF101:
            UDS_2EService_DID_F101( ); /*功能配置字数据*/
            break;
        case 0xF110:
            UDS_2EService_DID_F110( ); /*网络拓扑配置*/
            break;
        case 0x7101:
            UDS_2EService_DID_7101( );
            UDS_FLAG = 1; /*首保里程*/
            break;
        case 0x7102:
            UDS_2EService_DID_7102( );
            UDS_FLAG = 2; /*非首保里程*/
            break;
        case 0x7103:
            UDS_2EService_DID_7103( );
            UDS_FLAG = 3; /*重置保养里程标志*/
            break;
        case 0xF1A2:
            UDS_2EService_DID_F1A2( );
            break;
        case 0xF102:
            UDS_2EService_DID_F102( );
            break;
        default:
            break;
    }
}

/**
 *2E服务DIDDFEC
 *功能配置字备份数据4
 */
void UDS_2EService_DID_DFEC(void)
{
    uint8_t enResult = WFLASH_RW_PASS;

    UDS_NRC78_Sand(0x2E);

    memcpy(Ser2EToDFlashInfo.DID_DFEC, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_DFEC));
    enResult = write2EData(Write2EData);
    UDS_Delay(500u);
    if ( enResult == WFLASH_RW_PASS )
    {
        UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
    }
}

/**
 *2E服务DIDDFED
 *功能配置字备份数据3
 */
void UDS_2EService_DID_DFED(void)
{
    uint8_t enResult = WFLASH_RW_PASS;
    UDS_NRC78_Sand(0x2E);
    memcpy(Ser2EToDFlashInfo.DID_DFED, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_DFED));
    enResult = write2EData(Write2EData);
    UDS_Delay(500u);
    if ( enResult == WFLASH_RW_PASS )
    {
        UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
    }
}

/**
 *2E服务DIDDFEE
 *功能配置字备份数据2
 */
void UDS_2EService_DID_DFEE(void)
{
    uint8_t enResult = WFLASH_RW_PASS;
    UDS_NRC78_Sand(0x2E);
    memcpy(Ser2EToDFlashInfo.DID_DFEE, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_DFEE));
    enResult = write2EData(Write2EData);
    UDS_Delay(500u);
    if ( enResult == WFLASH_RW_PASS )
    {
        UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
    }
}

/**
 *2E服务DIDDFEF
 *功能配置字备份数据
 */
void UDS_2EService_DID_DFEF(void)
{
    uint8_t enResult = WFLASH_RW_PASS;
    UDS_NRC78_Sand(0x2E);
    memcpy(Ser2EToDFlashInfo.DID_DFEF, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_DFEF));
    enResult = write2EData(Write2EData);
    UDS_Delay(500u);
    if ( enResult == WFLASH_RW_PASS )
    {
        UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
    }
}

/**
 *2E服务DIDF112
 *车辆名称
 */
void UDS_2EService_DID_F112(void)
{
    uint8_t enResult = WFLASH_RW_PASS;
    memcpy(Ser2EToDFlashInfo.DID_F112, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_F112));
    enResult = write2EData(Write2EData);
    if ( enResult == WFLASH_RW_PASS )
    {
        UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
    }
}

/**
 *2E服务DIDF190
 *车辆VIN码
 */
void UDS_2EService_DID_F190(void)
{
    uint8_t enResult = WFLASH_RW_PASS;
    memcpy(Ser2EToDFlashInfo.DID_F190, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_F190));
    enResult = write2EData(Write2EData);
    if ( enResult == WFLASH_RW_PASS )
    {
        UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
    }
}

/**
 *2E服务DIDF197
 *ECU控制器名称
 */
void UDS_2EService_DID_F197(void)
{
    uint8_t enResult = WFLASH_RW_PASS;
    memcpy(Ser2EToDFlashInfo.DID_F197, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_F197));
    enResult = write2EData(Write2EData);
    if ( enResult == WFLASH_RW_PASS )
    {
        UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
    }
}

/**
 *2E服务DIDF198
 *诊断仪序列号
 */
void UDS_2EService_DID_F198(void)
{
    uint8_t enResult = WFLASH_RW_PASS;
    memcpy(BootToDFlashInfo.DID_F198, DiagMSG.msgData.DidDetail.Data, sizeof(BootToDFlashInfo.DID_F198));
    enResult = write2EData(WriteBootData);
    if ( enResult == WFLASH_RW_PASS )
    {
        UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
    }
}

/**
 *2E服务DIDF199
 *ECU软件刷新日期
 */
void UDS_2EService_DID_F199(void)
{
    uint8_t enResult = WFLASH_RW_PASS;
    memcpy(BootToDFlashInfo.DID_F199, DiagMSG.msgData.DidDetail.Data, sizeof(BootToDFlashInfo.DID_F199));
    enResult = write2EData(WriteBootData);
    if ( enResult == WFLASH_RW_PASS )
    {
        UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
    }
}

/**
 *2E服务DIDF1A2
 *ECU装配日期
 */
void UDS_2EService_DID_F1A2(void)
{
    uint8_t enResult = WFLASH_RW_PASS;
    memcpy(Ser2EToDFlashInfo.DID_F1A2, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_F1A2));
    enResult = write2EData(Write2EData);
    if ( enResult == WFLASH_RW_PASS )
    {
        UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
    }
}

/**
 *2E服务DIDF110
 *网络拓扑配置
 */
void UDS_2EService_DID_F110(void)
{
    uint8_t enResult = WFLASH_RW_PASS;
    EOL_SetF110(DiagMSG.msgData.DidDetail.Data, 8u);
    memcpy(Ser2EToDFlashInfo.DID_F110, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_F110));
    enResult = write2EData(Write2EData);
    if ( enResult == WFLASH_RW_PASS )
    {
        UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
    }
}

/**
 *2E服务DIDF101
 *功能配置字数据
 */
void UDS_2EService_DID_F101(void)
{
    uint8_t enResult = WFLASH_RW_PASS;
    EOL_SetF101(DiagMSG.msgData.DidDetail.Data, 16u);
    memcpy(Ser2EToDFlashInfo.DID_F101, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_F101));
    enResult = write2EData(Write2EData);
    if ( enResult == WFLASH_RW_PASS )
    {
        UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
    }
}
/**
 *2E服务DIDF102
 *功能配置字数据
 */
void UDS_2EService_DID_F102(void)
{
    uint8_t enResult = WFLASH_RW_PASS;
    EOL_SetF102(DiagMSG.msgData.DidDetail.Data, 24u);
    memcpy(Ser2EToDFlashInfo.DID_F102, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_F102));
    enResult = write2EData(Write2EData);
    if ( enResult == WFLASH_RW_PASS )
    {
        UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
    }
}

void UDS_2EService_DID_7101(void)
{
    uint8_t enResult = WFLASH_RW_PASS;
    EOL_Set7101(DiagMSG.msgData.DidDetail.Data, 3u);
    memcpy(Ser2EToDFlashInfo.DID_7101, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_7101));
    enResult = write2EData(Write2EData);
    if ( enResult == WFLASH_RW_PASS )
    {
        Maintenance_First_Interval_Mileage_Set(Get_7101_hex_Value( ));
        UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data); 
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
    }
}

void UDS_2EService_DID_7102(void)
{
    uint8_t enResult = WFLASH_RW_PASS;
    EOL_SetF110(DiagMSG.msgData.DidDetail.Data, 3u);
    memcpy(Ser2EToDFlashInfo.DID_7102, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_7102));
    enResult = write2EData(Write2EData);
    
    if ( enResult == WFLASH_RW_PASS )
    {    
        Maintenance_Second_Interval_Mileage_Set(Get_7102_hex_Value( ));   
        UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
    }
}

void UDS_2EService_DID_7103(void)
{
    uint8_t enResult = WFLASH_RW_PASS;
    if ( DiagMSG.msgData.DidDetail.Data [ 0 ] > 0x01 )
    {
        enResult = requestOutOfRange;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
    }
    else
    {

        memcpy(Ser2EToDFlashInfo.DID_7103, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_7103));
        enResult = write2EData(Write2EData);
        if ( enResult == WFLASH_RW_PASS )
        {
            UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
        }
        else
        {
            enResult = generalProgrammingFailure;
            UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
        }
    }
}

void Clear7103_Cbk(void)
{
    Ser2EToDFlashInfo.DID_7103[0]=0;
    ( void )write2EData(Write2EData);
}
uint32_t Get_7101_Value(void)
{
    uint32_t temp;
    temp = (Ser2EToDFlashInfo.DID_7101 [ 0 ] << 16) + (Ser2EToDFlashInfo.DID_7101 [ 1 ] << 8) + (Ser2EToDFlashInfo.DID_7101 [ 2 ]);
    return temp;
}
uint32_t Get_7102_Value(void)
{
    uint32_t temp = 0ul;
    temp          = (Ser2EToDFlashInfo.DID_7102 [ 0 ] << 16) + (Ser2EToDFlashInfo.DID_7102 [ 1 ] << 8) + (Ser2EToDFlashInfo.DID_7102 [ 2 ]);
    return temp;
}
uint8_t Get_7103_Value(void)
{
    uint8_t temp = 0ul;
    temp         = Ser2EToDFlashInfo.DID_7103 [ 0 ];
    return temp;
}
