/**************************************************************************//**
  * \file      GPIO_Config.h
  * \brief     GPIO configurations
  * \attention
  *
  * This file is automatically generated by GPIO configuration tool.
  * Date         : 2024/6/25 17:26:52
  * Cfg Tool Ver : 1.0.0
  * (c) Heilongjiang TYW electronics co., LTD
  *
******************************************************************************/

#ifndef _GPIO_CONFIG_H_
#define _GPIO_CONFIG_H_

/* Includes -----------------------------------------------------------------*/
#include <stdint.h>
#include "s6j3360drv.h"

/* C binding of definitions if building with C++ compiler */
#ifdef __cplusplus
extern  {
#endif
/*! @{ */

/* Exported Types -----------------------------------------------------------*/

/**************************************************************************//**
\brief Port directon and default value srtuct
******************************************************************************/
typedef struct
{
  uint32_t  RunModeDir;
  uint32_t  RunModeDef;
  uint32_t  SleepModeDir;
  uint32_t  SleepModeDef;
}GPIO_Dir_Def_Cfg_t;

/**************************************************************************//**
\brief Pin configuration srtuct
******************************************************************************/
typedef struct
{
  uint16_t  Offset;
  uint16_t  RunModeCfg;
  uint16_t  SleepModeCfg;
}GPIO_Pin_Cfg_t;

/* GPIO Remap ---------------------------------------------------------------*/

#define     Sensor_5V_OUT                   GPIO_PODR0_POD6
#define     Line_In_Energy_Recovery0        GPIO_PIDR0_PID8
#define     Line_In_Energy_Recovery         GPIO_PIDR0_PID10
#define     Line_In_BrakeFluid              GPIO_PIDR0_PID11
#define     LightingInput_OUT               GPIO_PODR0_POD12
#define     Line_In_OTA_Switch              GPIO_PIDR0_PID13
#define     Line_In_TRIP_Switch             GPIO_PIDR0_PID14
#define     Line_In_SEATBELT_DR             GPIO_PIDR0_PID15
#define     Line_In_TurnRight               GPIO_PIDR0_PID18
#define     Line_In_Hbeam                   GPIO_PIDR0_PID19
#define     Line_In_Lbeam                   GPIO_PIDR0_PID20
#define     Line_In_Position                GPIO_PIDR0_PID21
#define     Line_In_RearFog                 GPIO_PIDR0_PID22
#define     Line_In_Daylight                GPIO_PIDR0_PID23
#define     Line_In_Handbrake               GPIO_PIDR0_PID24
/* #define  CAN0_RX                         GPIO_PIDR0_PID25 */
/* #define  CAN0_TX                         GPIO_PODR0_POD26 */
#define     DimmerSwitch_AD                 GPIO_PIDR0_PID28
#define     CAN0_STB                        GPIO_PODR0_POD29

#define     Line_In_SOC_CC                  GPIO_PIDR1_PID2
/* #define  NTC_IN                          GPIO_PIDR1_PID3 */
#define     LED_DRIVER_EN                   GPIO_PODR1_POD4
#define     SDA_LED_DRIVER                  GPIO_PODR1_POD5
#define     SCL_LED_DRIVER                  GPIO_PODR1_POD6
#define     Line_In_DoorOpen                GPIO_PIDR1_PID7
#define     MCU_EEPROM_SCL                  GPIO_PIDR1_PID8
#define     MCU_EEPROM_SDA                  GPIO_PODR1_POD9
#define     GPIO_KL15                       GPIO_PIDR1_PID10
#define     SD_MODE_MCU                     GPIO_PODR1_POD11
#define     FM_MODE_MCU                     GPIO_PODR1_POD12
/* #define  KL_30_AD                        GPIO_PIDR1_PID13 */
#define     PW_OUT                          GPIO_PODR1_POD15
#define     PW1_OUT                         GPIO_PODR1_POD16
/* #define  KL_15_AD                        GPIO_PIDR1_PID17 */
#define     Line_In_TurnLeft                GPIO_PIDR1_PID19
#define     CSB1_OUT                        GPIO_PODR1_POD23
#define     SCL1_OUT                        GPIO_PODR1_POD24
#define     SD1_OUT                         GPIO_PODR1_POD25
#define     CSB0_OUT                        GPIO_PODR1_POD26
#define     SCL0_OUT                        GPIO_PODR1_POD27
#define     SD0_OUT                         GPIO_PODR1_POD28
#define     CSB_OUT                         GPIO_PODR1_POD29
#define     SCL_OUT                         GPIO_PODR1_POD30
#define     SD_OUT                          GPIO_PODR1_POD31

#define     Power_5V_EN                     GPIO_PODR2_POD3
#define     RADA5V_EN                       GPIO_PODR2_POD22
#define     RADA_TX                         GPIO_PODR2_POD23
#define     RADA_RX                         GPIO_PIDR2_PID25

/* GPIO Config Data ---------------------------------------------------------*/

#define   GPIO_VALID_PORT_NUM               (4U)
#define   GPIO_VALID_PIN_NUM                (94U)

extern const GPIO_Dir_Def_Cfg_t GPIODirDefCfg[GPIO_VALID_PORT_NUM];
extern const GPIO_Pin_Cfg_t GPIOPinCfg[GPIO_VALID_PIN_NUM];

/*! @} */
#ifdef __cplusplus
}
#endif

#endif /* _GPIO_CONFIG_H_ */
