
/*  汾  REV 0.1  */

/*  ͷļ  */
#include "MFS_UART.h"
#include "GPIO.h"
#include "Radar_R3.h"

#if MFS_UART_PRINTF_EN
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#endif  /*  MFS_UART_PRINTF_EN  */
#include "WDT.h"

unsigned int recv_flag;
unsigned char recv_dat;

/*---------------------------------------------------------------------*/
/*  ˽к  */
static void MFS_UART_RecvData_OnHandle(unsigned int channel, unsigned char dat);
static void MFS_UART_CPU_SleepIdle(void);
static void MFS_UART_RICwrite(un_ric_resinn_t val, uint_io16_t* const preg_addr);
static void MFS_UART_ConfigureGPIO(unsigned int channel);
static void MFS_UART_ConfigError(void);
static __irq __arm  void MFS_UART_InterruptService_CH0_RX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH1_RX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH2_RX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH3_RX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH4_RX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH5_RX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH6_RX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH7_RX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH8_RX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH9_RX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH10_RX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH11_RX_IRQ(void);
static void MFS_UART_CH0_OnRecv(unsigned char dat);
static void MFS_UART_CH1_OnRecv(unsigned char dat);
static void MFS_UART_CH2_OnRecv(unsigned char dat);
static void MFS_UART_CH3_OnRecv(unsigned char dat);
static void MFS_UART_CH4_OnRecv(unsigned char dat);
static void MFS_UART_CH5_OnRecv(unsigned char dat);
static void MFS_UART_CH6_OnRecv(unsigned char dat);
static void MFS_UART_CH7_OnRecv(unsigned char dat);
static void MFS_UART_CH8_OnRecv(unsigned char dat);
static void MFS_UART_CH9_OnRecv(unsigned char dat);
static void MFS_UART_CH10_OnRecv(unsigned char dat);
static void MFS_UART_CH11_OnRecv(unsigned char dat);
static __irq __arm  void MFS_UART_InterruptService_CH0_TX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH1_TX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH2_TX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH3_TX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH4_TX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH5_TX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH6_TX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH7_TX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH8_TX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH9_TX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH10_TX_IRQ(void);
static __irq __arm  void MFS_UART_InterruptService_CH11_TX_IRQ(void);

/*---------------------------------------------------------------------*/
/*  ûص  */
/*  channelǵǰյݵͨ  */
/*  datǵǰյ  */
/*  յһֽڵ  */
static void MFS_UART_RecvData_OnHandle(unsigned int channel, unsigned char dat)
{
}

/*  ͷCPUصڽ͹  ϵͳ  */
/*  һڲдͷһϵͳĵȽ  */
static void MFS_UART_CPU_SleepIdle(void)
{
    WDT_Clear();   /*  ʱֹŹλ  */
}

/*  ûô  */
static void MFS_UART_ConfigError(void)
{
    while(1)
    {
        ;      /*  ѭ  */
    }
}

/*  ͨ0ûص  */
static void MFS_UART_CH0_OnRecv(unsigned char dat)
{
}

/*  ͨ1ûص  */
static void MFS_UART_CH1_OnRecv(unsigned char dat)
{
  Uart_Data_Get(dat);
}

/*  ͨ2ûص  */
static void MFS_UART_CH2_OnRecv(unsigned char dat)
{
}

/*  ͨ3ûص  */
static void MFS_UART_CH3_OnRecv(unsigned char dat)
{
}

/*  ͨ4ûص  */
static void MFS_UART_CH4_OnRecv(unsigned char dat)
{
}

/*  ͨ5ûص  */
static void MFS_UART_CH5_OnRecv(unsigned char dat)
{
}

/*  ͨ6ûص  */
static void MFS_UART_CH6_OnRecv(unsigned char dat)
{
}

/*  ͨ7ûص  */
static void MFS_UART_CH7_OnRecv(unsigned char dat)
{
}

/*  ͨ8ûص  */
static void MFS_UART_CH8_OnRecv(unsigned char dat)
{
}

/*  ͨ9ûص  */
static void MFS_UART_CH9_OnRecv(unsigned char dat)
{

}

/*  ͨ10ûص  */
static void MFS_UART_CH10_OnRecv(unsigned char dat)
{
}

/*  ͨ11ûص  */
static void MFS_UART_CH11_OnRecv(unsigned char dat)
{
}


/*---------------------------------------------------------------------*/
/*  װõĲ  */

/*  巢͵Ŀ״̬  */
typedef enum
{
    MFS_UART_SendCmd_NULL = 0,               /*  ǰ޷  */
    MFS_UART_SendCmd_BUSY,                   /*  ڷ  */
}E_MFS_UART_SendCmd;

/*  巢ͻݽṹ  */
typedef struct
{
    unsigned int len;            /*  Ҫ͵ĳ  */
    unsigned char* pdat;         /*  ڵ׵ַ  */
    E_MFS_UART_SendCmd flag;       /*  ͵Ŀ״̬  */
}S_MFS_UART_SendCtrl;

/*  ͨʹڵĶ  */
static S_MFS_UART_SendCtrl MFS_UART_SendCtrl[12];

/*  Ĵ鶨  οԴ[6]  */
volatile static stc_cpg_mfsn_uart_t* const pMFS_UART[12] =
{
    /*  ˴ַο s6j3360_MFS_UART.h ļ72  */
    (volatile stc_cpg_mfsn_uart_t*)(0xB4800000U),          /*  MFS ͨ0   */
    (volatile stc_cpg_mfsn_uart_t*)(0xB4800400U),          /*  MFS ͨ1   */
    (volatile stc_cpg_mfsn_uart_t*)(0xB4800800U),          /*  MFS ͨ2   */
    (volatile stc_cpg_mfsn_uart_t*)(0xB4800C00U),          /*  MFS ͨ3   */
    (volatile stc_cpg_mfsn_uart_t*)(0xB4801000U),          /*  MFS ͨ4   */
    (volatile stc_cpg_mfsn_uart_t*)(0xB4801400U),          /*  MFS ͨ5   */
    (volatile stc_cpg_mfsn_uart_t*)(0xB4801800U),          /*  MFS ͨ6   */
    (volatile stc_cpg_mfsn_uart_t*)(0xB4801C00U),          /*  MFS ͨ7   */
    (volatile stc_cpg_mfsn_uart_t*)(0xB4880000U),          /*  MFS ͨ8   */
    (volatile stc_cpg_mfsn_uart_t*)(0xB4880400U),          /*  MFS ͨ9   */
    (volatile stc_cpg_mfsn_uart_t*)(0xB4880800U),          /*  MFS ͨ10  */
    (volatile stc_cpg_mfsn_uart_t*)(0xB4880C00U)           /*  MFS ͨ11  */
};  

/*  һԴĴдһֵ  */
/*  valҪдֵ  */
/*  preg_addrҪдļĴַ  */
/*  ÷οԴ[1]P2790ҳ  */
static void MFS_UART_RICwrite(un_ric_resinn_t val, uint_io16_t* const preg_addr)
{
    /*  ʱ  */
    unsigned int tmp_val = 0u;                                     /*  Կ׼Ĵʱ  */
    unsigned int tmp_addr = (unsigned int)(preg_addr);   /*  ȡַ  */
    
    /*  ٽ磬ֹжϴдԿ  */
    /*  οԴ[1]P2790ҳ  */
    IRQ_DISABLE_LOCAL()
      
    /*  дԿ  */
    tmp_val = (0u << 30u) | (1u << 28u) | ( 0x07FFFu & tmp_addr);  RIC_KEYCDR = tmp_val;
    tmp_val = (1u << 30u) | (1u << 28u) | ( 0x07FFFu & tmp_addr);  RIC_KEYCDR = tmp_val;
    tmp_val = (2u << 30u) | (1u << 28u) | ( 0x07FFFu & tmp_addr);  RIC_KEYCDR = tmp_val;
    tmp_val = (3u << 30u) | (1u << 28u) | ( 0x07FFFu & tmp_addr);  RIC_KEYCDR = tmp_val;
    
    /*  д  */
    preg_addr[0] = val.u16Register;
    
    /*  ˳ٽ磬Կд  */
    IRQ_RESTORE()
}

/*  ָͨMFSGPIOΪģʽ  */
/*  ע⣺޸ԴƣԴGPIO_Config.xlsmļеģʽ  */
/*   channel Ϊͨţ0  11  */
static void MFS_UART_ConfigureGPIO(unsigned int channel)
{
    /*    */
    un_ric_resinn_t tmp_cfg;                    /*  Դʱ  */
    
    /*  ʼ  */
    tmp_cfg.u16Register = 0x0000u;              /*  ʼ  */
    
    /*  ͨѡ  */
    /*  ̲οԴ[7]4ҳ  */
    /*  οԴ[5]113ҳ  */
    switch(channel)
    {
        /*  ͨ0  */
        case 0:
        {
            /*  RXD  ׼  */
            tmp_cfg.u16Register = 0x0000u;                     /*  ʼ  */
            
            /*  RXD  0  */
            if(MFS_UART_CH0_SIN == 84u)
            {
                tmp_cfg.stcField.u4PORTSEL = 0u;               /*  P1_14  */
                MFS_UART_RICwrite(tmp_cfg, &RIC_RESIN0);
            }
            /*  RXD  1  */
            else if(MFS_UART_CH0_SIN == 143u)
            {
                tmp_cfg.stcField.u4PORTSEL = 1u;               /*  P2_29  */
                MFS_UART_RICwrite(tmp_cfg, &RIC_RESIN0);
            }
            /*    */
            else
            {
                MFS_UART_ConfigError();                        /*  ô  */
            }
            
        }break;
        
        /*  ͨ1  */
        case 1:
        {
            /*  RXD  ׼  */
            tmp_cfg.u16Register = 0x0000u;                     /*  ʼ  */
            
            /*  RXD  0  */
            if(MFS_UART_CH1_SIN == 139u)
            {
                tmp_cfg.stcField.u4PORTSEL = 0u;               /*  P2_25  */
                MFS_UART_RICwrite(tmp_cfg, &RIC_RESIN7);
            }
            /*  RXD  1  */
            else if(MFS_UART_CH1_SIN == 7u)
            {
                tmp_cfg.stcField.u4PORTSEL = 1u;               /*  P0_05  */
                MFS_UART_RICwrite(tmp_cfg, &RIC_RESIN7);
            }
            /*    */
            else
            {
                MFS_UART_ConfigError();                        /*  ô  */
            }
            
        }break;
        
        /*  ͨ2  */
        case 2:
        {
            /*  RXD  ׼  */
            tmp_cfg.u16Register = 0x0000u;                     /*  ʼ  */
            
            /*  RXD  0  */
            if(MFS_UART_CH2_SIN == 21u)
            {
                tmp_cfg.stcField.u4PORTSEL = 0u;               /*  P0_15  */
                MFS_UART_RICwrite(tmp_cfg, &RIC_RESIN14);
            }
            /*  RXD  1  */
            else if(MFS_UART_CH2_SIN == 116u)
            {
                tmp_cfg.stcField.u4PORTSEL = 1u;               /*  P2_06  */
                MFS_UART_RICwrite(tmp_cfg, &RIC_RESIN14);
            }
            /*    */
            else
            {
                MFS_UART_ConfigError();                        /*  ô  */
            }
            
        }break;
        
        /*  ͨ3  */
        case 3:
        {
            /*  RXD  ׼  */
            tmp_cfg.u16Register = 0x0000u;                     /*  ʼ  */
            
            /*  RXD  0  */
            if(MFS_UART_CH3_SIN == 31u)
            {
                tmp_cfg.stcField.u4PORTSEL = 0u;               /*  P0_22  */
                MFS_UART_RICwrite(tmp_cfg, &RIC_RESIN21);
            }
            /*  RXD  1  */
            else if(MFS_UART_CH3_SIN == 123u)
            {
                tmp_cfg.stcField.u4PORTSEL = 1u;               /*  P2_11  */
                MFS_UART_RICwrite(tmp_cfg, &RIC_RESIN21);
            }
            /*    */
            else
            {
                MFS_UART_ConfigError();                        /*  ô  */
            }
            
        }break;
        
        /*  ͨ4  */
        case 4:
        {
            /*  RXD  ׼  */
            tmp_cfg.u16Register = 0x0000u;                     /*  ʼ  */
            
            /*  RXD  0  */
            if(MFS_UART_CH4_SIN == 130u)
            {
                tmp_cfg.stcField.u4PORTSEL = 0u;               /*  P2_18  */
                MFS_UART_RICwrite(tmp_cfg, &RIC_RESIN28);
            }
            /*  RXD  1  */
            else if(MFS_UART_CH4_SIN == 13u)
            {
                tmp_cfg.stcField.u4PORTSEL = 1u;               /*  P0_09  */
                MFS_UART_RICwrite(tmp_cfg, &RIC_RESIN28);
            }
            /*    */
            else
            {
                MFS_UART_ConfigError();                        /*  ô  */
            }
            
        }break;
        
        /*  ͨ5  */
        case 5:
        {
            /*  RXD  ׼  */
            tmp_cfg.u16Register = 0x0000u;                     /*  ʼ  */
            
            /*  RXD  0  */
            if(MFS_UART_CH5_SIN == 106u)
            {
                tmp_cfg.stcField.u4PORTSEL = 0u;               /*  P2_00  */
                MFS_UART_RICwrite(tmp_cfg, &RIC_RESIN35);
            }
            /*    */
            else
            {
                MFS_UART_ConfigError();                        /*  ô  */
            }
            
        }break;
        
        /*  ͨ6  */
        case 6:
        {
            /*  RXD  ׼  */
            tmp_cfg.u16Register = 0x0000u;                     /*  ʼ  */
            
            /*  RXD  0  */
            if(MFS_UART_CH6_SIN == 64u)
            {
                tmp_cfg.stcField.u4PORTSEL = 0u;               /*  P1_04  */
                MFS_UART_RICwrite(tmp_cfg, &RIC_RESIN42);
            }
            /*    */
            else
            {
                MFS_UART_ConfigError();                        /*  ô  */
            }
            
        }break;
        
        /*  ͨ7  */
        case 7:
        {
            /*  RXD  ׼  */
            tmp_cfg.u16Register = 0x0000u;                     /*  ʼ  */
            
            /*  RXD  0  */
            if(MFS_UART_CH7_SIN == 67u)
            {
                tmp_cfg.stcField.u4PORTSEL = 0u;               /*  P1_07  */
                MFS_UART_RICwrite(tmp_cfg, &RIC_RESIN49);
            }
            /*  RXD  1  */
            else if(MFS_UART_CH7_SIN == 4u)
            {
                tmp_cfg.stcField.u4PORTSEL = 1u;               /*  P0_02  */
                MFS_UART_RICwrite(tmp_cfg, &RIC_RESIN49);
            }
            /*    */
            else
            {
                MFS_UART_ConfigError();                        /*  ô  */
            }
            
        }break;
        
        /*  ͨ8  */
        case 8:
        {
            /*  RXD  ׼  */
            tmp_cfg.u16Register = 0x0000u;                     /*  ʼ  */
            
            /*  RXD  0  */
            if(MFS_UART_CH8_SIN == 52u)
            {
                tmp_cfg.stcField.u4PORTSEL = 0u;               /*  P0_27  */
                MFS_UART_RICwrite(tmp_cfg, &RIC_RESIN56);
            }
            /*  RXD  2  */
            else if(MFS_UART_CH8_SIN == 30u)
            {
                tmp_cfg.stcField.u4PORTSEL = 2u;               /*  P0_21  */
                MFS_UART_RICwrite(tmp_cfg, &RIC_RESIN56);
            }
            /*    */
            else
            {
                MFS_UART_ConfigError();                        /*  ô  */
            }
            
        }break;
        
        /*  ͨ9  */
        case 9:
        {
            /*  RXD  ׼  */
            tmp_cfg.u16Register = 0x0000u;                     /*  ʼ  */
            
            /*  RXD  0  */
            if(MFS_UART_CH9_SIN == 92u)
            {
                tmp_cfg.stcField.u4PORTSEL = 0u;               /*  P1_20  */
                MFS_UART_RICwrite(tmp_cfg, &RIC_RESIN63);
            }
            /*  RXD  2  */
            else if(MFS_UART_CH9_SIN == 21u)
            {
                tmp_cfg.stcField.u4PORTSEL = 2u;               /*  P0_15  */
                MFS_UART_RICwrite(tmp_cfg, &RIC_RESIN63);
            }
            /*    */
            else
            {
                MFS_UART_ConfigError();                        /*  ô  */
            }
            
        }break;
        
        /*  ͨ10  */
        case 10:
        {
            /*  RXD  ׼  */
            tmp_cfg.u16Register = 0x0000u;                     /*  ʼ  */
            
            /*  RXD  0  */
            if(MFS_UART_CH10_SIN == 95u)
            {
                tmp_cfg.stcField.u4PORTSEL = 0u;               /*  P1_23  */
                MFS_UART_RICwrite(tmp_cfg, &RIC_RESIN70);
            }
            /*    */
            else
            {
                MFS_UART_ConfigError();                        /*  ô  */
            }
            
        }break;
        
        /*  ͨ11  */
        case 11:
        {
            /*  RXD  ׼  */
            tmp_cfg.u16Register = 0x0000u;                     /*  ʼ  */
            
            /*  RXD  1  */
            if(MFS_UART_CH11_SIN == 103u)
            {
                /*  ãоƬӲ̶  */                 /*  P1_29  */
            }
            /*    */
            else
            {
                MFS_UART_ConfigError();                        /*  ô  */
            }
            
        }break;
        
        /*  ͨ  */
        default:break;
    }
}


/*  ʼ  */
/*   channel Ϊͨţ0  11  */
/*   baud Ϊ  */
void MFS_UART_Init(unsigned int channel, unsigned int baud)
{
    /*  ͨ,ô */
    if(channel > 11u)
    {
        /*  ȫ  */
    }
    /*  ȷ  */
    else
    {
        /*  ʱ  */
        unsigned int tmp_value = 0u;
        
        /*  ʼͨķͿƶ  */
        MFS_UART_SendCtrl[channel].len = 0u;
        MFS_UART_SendCtrl[channel].pdat = 0u;
        MFS_UART_SendCtrl[channel].flag = MFS_UART_SendCmd_NULL;
        
        /*  öӦܽ  */
        MFS_UART_ConfigureGPIO(channel);
        
        /*  עжϺ  οԴ[5]P70ҳ  */
        switch(channel)
        {
            case 0:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_46, (uint32_t)MFS_UART_InterruptService_CH0_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH0_RX);   break;
            case 1:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_48, (uint32_t)MFS_UART_InterruptService_CH1_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH1_RX);   break;
            case 2:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_50, (uint32_t)MFS_UART_InterruptService_CH2_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH2_RX);   break;
            case 3:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_52, (uint32_t)MFS_UART_InterruptService_CH3_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH3_RX);   break;
            case 4:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_54, (uint32_t)MFS_UART_InterruptService_CH4_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH4_RX);   break;
            case 5:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_56, (uint32_t)MFS_UART_InterruptService_CH5_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH5_RX);   break;
            case 6:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_58, (uint32_t)MFS_UART_InterruptService_CH6_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH6_RX);   break;
            case 7:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_60, (uint32_t)MFS_UART_InterruptService_CH7_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH7_RX);   break;
            case 8:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_62, (uint32_t)MFS_UART_InterruptService_CH8_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH8_RX);   break;
            case 9:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_64, (uint32_t)MFS_UART_InterruptService_CH9_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH9_RX);   break;
            case 10: Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_66, (uint32_t)MFS_UART_InterruptService_CH10_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH10_RX); break; 
            case 11: Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_68, (uint32_t)MFS_UART_InterruptService_CH11_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH11_RX); break;
            default:break;
        }
        
        /*  עᷢжϺ  */
        switch(channel)
        {
            case 0:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_47, (uint32_t)MFS_UART_InterruptService_CH0_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH0_TX);   break;
            case 1:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_49, (uint32_t)MFS_UART_InterruptService_CH1_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH1_TX);   break;
            case 2:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_51, (uint32_t)MFS_UART_InterruptService_CH2_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH2_TX);   break;
            case 3:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_53, (uint32_t)MFS_UART_InterruptService_CH3_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH3_TX);   break;
            case 4:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_55, (uint32_t)MFS_UART_InterruptService_CH4_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH4_TX);   break;
            case 5:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_57, (uint32_t)MFS_UART_InterruptService_CH5_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH5_TX);   break;
            case 6:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_59, (uint32_t)MFS_UART_InterruptService_CH6_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH6_TX);   break;
            case 7:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_61, (uint32_t)MFS_UART_InterruptService_CH7_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH7_TX);   break;
            case 8:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_63, (uint32_t)MFS_UART_InterruptService_CH8_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH8_TX);   break;
            case 9:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_65, (uint32_t)MFS_UART_InterruptService_CH9_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH9_TX);   break;
            case 10: Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_67, (uint32_t)MFS_UART_InterruptService_CH10_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH10_TX); break;
            case 11: Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_69, (uint32_t)MFS_UART_InterruptService_CH11_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH11_TX); break;
            default:break;
        }
        
        /*  ̶MFSUARTģʽĳʼοԴ[2]mfs_uart.c491  */
        /*  ɱλ  */
        pMFS_UART[channel]->unSCR.stcField.u1UPCL = 1u;        /*  дĴ  */
        
        /*  ôģʽĴ  */        
        /*  MFSģʽ  */
        pMFS_UART[channel]->unSMR.stcField.u3MD = 0u;          /*  ģʽ0οԴ[1]P1875ҳ  */
        
        /*  ÷͵λз  */
        pMFS_UART[channel]->unSMR.stcField.u1BDS = 0u;        /*  λȷͣοԴ[3]ͼ1  */
        
        /*  ֹͣλ  */
        pMFS_UART[channel]->unSMR.stcField.u1SBL = 0u;        /*  1ֹͣλ滹һҲǾֹͣλ  */
        
        /*  ʹ  */
        pMFS_UART[channel]->unSMR.stcField.u1SOE = 1u;        /*  οԴ[1]P1876ҳ  */
                
        /*  ò  */
        tmp_value = (CLK_LCP0A_FREQ / baud) - 1u;             /*  㷨οԴ[2]mfs_uart.c534550  */
        pMFS_UART[channel]->unBGR.u16Register = (unsigned short)(tmp_value & 0x0FFFFu);    /*  дĴ  */
                
        /*  չͨſƼĴ  */
        /*  Ӳ  */
        pMFS_UART[channel]->unESCR.stcField.u1FLWEN = 0u;    /*  رӲ  */
        
        /*  ݸʽ  */
        pMFS_UART[channel]->unESCR.stcField.u1INV = 0u;      /*  NRZʽ  */
                                                             /*  οԴ[4]RS232-TTLΪNRZʽ  */
        
        /*  Уλ  */
        pMFS_UART[channel]->unESCR.stcField.u1PEN = 0u;      /*  رУλ  */
        pMFS_UART[channel]->unESCR.stcField.u1P = 0u;        /*  οԴ[2]mfs_uart.c643УȡУ鹦ʱУģʽΪEven  */
        
        /*  ֹͣλ  */
        pMFS_UART[channel]->unESCR.stcField.u1ESBL = 0u;     /*  1ֹͣλ滹һҲǾֹͣλ  */
        
        /*  λ  */
        pMFS_UART[channel]->unESCR.stcField.u3L = 0u;        /*  8λݳȣοԴ[3]ͼ1  */
                
        /*  ô״̬Ĵ  */
        pMFS_UART[channel]->unSSR.stcField.u1REC = 1u;       /*  մ־λ  */
        
        /*  ôпƼĴ  */
        /*    */
        pMFS_UART[channel]->unSCR.stcField.u1RXE = 1u;
        
        /*    */
        pMFS_UART[channel]->unSCR.stcField.u1TXE = 1u;
        
        /*  ж  */
        pMFS_UART[channel]->unSCR.stcField.u1RIE = 1u;
        
        /*  رշж  */
        pMFS_UART[channel]->unSCR.stcField.u1TIE = 0u;        /*  REV 0.2汾޸  */
    }  
    
}


/*  ʼ,У  */
/*   channel Ϊͨţ0  11  */
/*   baud Ϊ  */
/*   parity_type ΪУ  */
void MFS_UART_InitWithParity(unsigned int channel, unsigned int baud, EMFS_UART_ParityType parity_type)
{
    /*  ͨ,ô */
    if(channel > 11u)
    {
        /*  ȫ  */
    }
    /*  ȷ  */
    else
    {
        /*  ʱ  */
        unsigned int tmp_value = 0u;
        
        /*  ʼͨķͿƶ  */
        MFS_UART_SendCtrl[channel].len = 0u;
        MFS_UART_SendCtrl[channel].pdat = 0u;
        MFS_UART_SendCtrl[channel].flag = MFS_UART_SendCmd_NULL;
        
        /*  öӦܽ  */
        MFS_UART_ConfigureGPIO(channel);
        
        /*  עжϺ  οԴ[5]P70ҳ  */
        switch(channel)
        {
            case 0:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_46, (uint32_t)MFS_UART_InterruptService_CH0_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH0_RX);   break;
            case 1:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_48, (uint32_t)MFS_UART_InterruptService_CH1_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH1_RX);   break;
            case 2:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_50, (uint32_t)MFS_UART_InterruptService_CH2_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH2_RX);   break;
            case 3:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_52, (uint32_t)MFS_UART_InterruptService_CH3_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH3_RX);   break;
            case 4:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_54, (uint32_t)MFS_UART_InterruptService_CH4_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH4_RX);   break;
            case 5:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_56, (uint32_t)MFS_UART_InterruptService_CH5_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH5_RX);   break;
            case 6:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_58, (uint32_t)MFS_UART_InterruptService_CH6_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH6_RX);   break;
            case 7:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_60, (uint32_t)MFS_UART_InterruptService_CH7_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH7_RX);   break;
            case 8:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_62, (uint32_t)MFS_UART_InterruptService_CH8_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH8_RX);   break;
            case 9:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_64, (uint32_t)MFS_UART_InterruptService_CH9_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH9_RX);   break;
            case 10: Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_66, (uint32_t)MFS_UART_InterruptService_CH10_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH10_RX); break; 
            case 11: Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_68, (uint32_t)MFS_UART_InterruptService_CH11_RX_IRQ, MFS_UART_IRQ_PRIORITY__CH11_RX); break;
            default:break;
        }
        
        /*  עᷢжϺ  */
        switch(channel)
        {
            case 0:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_47, (uint32_t)MFS_UART_InterruptService_CH0_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH0_TX);   break;
            case 1:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_49, (uint32_t)MFS_UART_InterruptService_CH1_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH1_TX);   break;
            case 2:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_51, (uint32_t)MFS_UART_InterruptService_CH2_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH2_TX);   break;
            case 3:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_53, (uint32_t)MFS_UART_InterruptService_CH3_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH3_TX);   break;
            case 4:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_55, (uint32_t)MFS_UART_InterruptService_CH4_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH4_TX);   break;
            case 5:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_57, (uint32_t)MFS_UART_InterruptService_CH5_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH5_TX);   break;
            case 6:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_59, (uint32_t)MFS_UART_InterruptService_CH6_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH6_TX);   break;
            case 7:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_61, (uint32_t)MFS_UART_InterruptService_CH7_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH7_TX);   break;
            case 8:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_63, (uint32_t)MFS_UART_InterruptService_CH8_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH8_TX);   break;
            case 9:  Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_65, (uint32_t)MFS_UART_InterruptService_CH9_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH9_TX);   break;
            case 10: Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_67, (uint32_t)MFS_UART_InterruptService_CH10_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH10_TX); break;
            case 11: Interrupt_IRQ_ISR_Register(INTERRUPTS_IRQ_NUMBER_69, (uint32_t)MFS_UART_InterruptService_CH11_TX_IRQ, MFS_UART_IRQ_PRIORITY__CH11_TX); break;
            default:break;
        }
        
        /*  ̶MFSUARTģʽĳʼοԴ[2]mfs_uart.c491  */
        /*  ɱλ  */
        pMFS_UART[channel]->unSCR.stcField.u1UPCL = 1u;        /*  дĴ  */
        
        /*  ôģʽĴ  */        
        /*  MFSģʽ  */
        pMFS_UART[channel]->unSMR.stcField.u3MD = 0u;          /*  ģʽ0οԴ[1]P1875ҳ  */
        
        /*  ÷͵λз  */
        pMFS_UART[channel]->unSMR.stcField.u1BDS = 0u;        /*  λȷͣοԴ[3]ͼ1  */
        
        /*  ֹͣλ  */
        pMFS_UART[channel]->unSMR.stcField.u1SBL = 0u;        /*  1ֹͣλ滹һҲǾֹͣλ  */
        
        /*  ʹ  */
        pMFS_UART[channel]->unSMR.stcField.u1SOE = 1u;        /*  οԴ[1]P1876ҳ  */
                
        /*  ò  */
        tmp_value = (CLK_LCP0A_FREQ / baud) - 1u;             /*  㷨οԴ[2]mfs_uart.c534550  */
        pMFS_UART[channel]->unBGR.u16Register = (unsigned short)(tmp_value & 0x0FFFFu);    /*  дĴ  */
                
        /*  չͨſƼĴ  */
        /*  Ӳ  */
        pMFS_UART[channel]->unESCR.stcField.u1FLWEN = 0u;    /*  رӲ  */
        
        /*  ݸʽ  */
        pMFS_UART[channel]->unESCR.stcField.u1INV = 0u;      /*  NRZʽ  */
                                                             /*  οԴ[4]RS232-TTLΪNRZʽ  */
        
        /*  Уλ  */
        /*  У  */
        if(parity_type == MFS_UART_NoneParity)
        {
            pMFS_UART[channel]->unESCR.stcField.u1PEN = 0u;      /*  رУλ  */
            pMFS_UART[channel]->unESCR.stcField.u1P = 0u;        /*  οԴ[2]mfs_uart.c643УȡУ鹦ʱУģʽΪEven  */
        }
        /*  żУ  */
        else if(parity_type == MFS_UART_EvenParity)
        {
            pMFS_UART[channel]->unESCR.stcField.u1PEN = 1u;      /*  رУλ  */
            pMFS_UART[channel]->unESCR.stcField.u1P = 0u;        /*  οԴ[2]mfs_uart.c643УȡУ鹦ʱУģʽΪEven  */
        }
        /*  У  */
        else if(parity_type == MFS_UART_OddParity)
        {
            pMFS_UART[channel]->unESCR.stcField.u1PEN = 1u;      /*  رУλ  */
            pMFS_UART[channel]->unESCR.stcField.u1P = 1u;        /*  οԴ[2]mfs_uart.c643УȡУ鹦ʱУģʽΪEven  */
        }
        /*    */
        else
        {
            /*  ûôʱĬԶΪУ  */
            pMFS_UART[channel]->unESCR.stcField.u1PEN = 0u;      /*  رУλ  */
            pMFS_UART[channel]->unESCR.stcField.u1P = 0u;        /*  οԴ[2]mfs_uart.c643УȡУ鹦ʱУģʽΪEven  */
        }
        /*  ֹͣλ  */
        pMFS_UART[channel]->unESCR.stcField.u1ESBL = 0u;     /*  1ֹͣλ滹һҲǾֹͣλ  */
        
        /*  λ  */
        pMFS_UART[channel]->unESCR.stcField.u3L = 0u;        /*  8λݳȣοԴ[3]ͼ1  */
                
        /*  ô״̬Ĵ  */
        pMFS_UART[channel]->unSSR.stcField.u1REC = 1u;       /*  մ־λ  */
        
        /*  ôпƼĴ  */
        /*    */
        pMFS_UART[channel]->unSCR.stcField.u1RXE = 1u;
        
        /*    */
        pMFS_UART[channel]->unSCR.stcField.u1TXE = 1u;
        
        /*  ж  */
        pMFS_UART[channel]->unSCR.stcField.u1RIE = 1u;
        
        /*  رշж  */
        pMFS_UART[channel]->unSCR.stcField.u1TIE = 0u;        /*  REV 0.2汾޸  */
    }  

}

/*  һֽ  */
/*   channel Ϊͨţ0  11  */
/*  typeǷͣΪMFS_UART_SendType_BlockingΪMFS_UART_SendType_Interruptж  */
/*   in ΪҪ͵ֽ  */
/*  ֵMFS_UART_OptSt_OK=ͳɹ MFS_UART_OptSt_BUSY=æ*/
EMFS_UART_OptSt MFS_UART_SendOneByte(unsigned int channel, EMFS_UART_SendType type, unsigned char in)
{
    /*  巵ֵ  */
    EMFS_UART_OptSt re_value = MFS_UART_OptSt_BUSY;    
    
    /*  ȡǰæ״̬  */
    re_value = MFS_UART_IsSendBusy(channel);
    
    /*  æ  */
    if(re_value == MFS_UART_OptSt_BUSY)
    {
    }
    /*  æ  */
    else
    {      
        /*  رշж  */
        /*  Ϊ1ֽڵʱòж  */
        pMFS_UART[channel]->unSCR.stcField.u1TIE = 0u;    
        
        /*  鷢ͣΪ  */
        if(type == MFS_UART_SendType_Blocking)
        {
            /*  øͨĿ  */
            MFS_UART_SendCtrl[channel].len = 0u;
            MFS_UART_SendCtrl[channel].pdat = 0u;
            MFS_UART_SendCtrl[channel].flag = MFS_UART_SendCmd_NULL;      /*  ڶֽڵķ  */
            
            /*  ݼĴд  */
            /*  οԴ[1]1805ҳĴӳTDRRDRڴַͬ  */
            /*  οԴ[1]1882ҳԸõַȡʱΪRDRԸõַдʱΪTDR  */
            pMFS_UART[channel]->unRDR.u16Register = ((unsigned short)in) & 0x00FFu;  /*  ֻûݵĵ8λ  */
            
            /*  ǰֱͨ  */
            MFS_UART_WaitForSendReady(channel);
        }
        /*  ΪжϷ  */
        else
        {
            /*  øͨĿ  */
            MFS_UART_SendCtrl[channel].len = 0u;
            MFS_UART_SendCtrl[channel].pdat = 0u;
            MFS_UART_SendCtrl[channel].flag = MFS_UART_SendCmd_NULL;      /*  ڶֽڵķ  */
            
            /*  ݼĴд  */
            /*  οԴ[1]1805ҳĴӳTDRRDRڴַͬ  */
            /*  οԴ[1]1882ҳԸõַȡʱΪRDRԸõַдʱΪTDR  */
            pMFS_UART[channel]->unRDR.u16Register = ((unsigned short)in) & 0x00FFu;  /*  ֻûݵĵ8λ  */
        }
    }
    
    /*  ؽ  */
    return re_value;
}

/*  ȡ͵æ״̬æ  */
/*   channel Ϊͨţ0  11  */
/*  ֵMFS_UART_OptSt_OK=ͿУ MFS_UART_OptSt_BUSY=æ*/
EMFS_UART_OptSt MFS_UART_IsSendBusy(unsigned int channel)
{
    /*  巵ֵ  */
    EMFS_UART_OptSt re_value = MFS_UART_OptSt_BUSY;
    
    /*  ͨ,ô */
    if(channel > 11u)
    {
        /*  æ  */
        re_value = MFS_UART_OptSt_BUSY;
    }
    /*  ȷ  */
    else
    {
        /*  Ϳ̲οԴ[1]P1831ҳķͲ  */
        /*  鵱ǰͼĴǷææ  */
        if((pMFS_UART[channel]->unSSR.u8Register & (1u<<1u)) == 0u)
        {
            /*  æ  */
            re_value = MFS_UART_OptSt_BUSY;
        }
        /*  æ  */
        else
        {
            /*  鵱ǰǷжʽ񣬵  */
            if(MFS_UART_SendCtrl[channel].flag == MFS_UART_SendCmd_BUSY)
            {
                /*  æ  */
                re_value = MFS_UART_OptSt_BUSY;
            }
            /*    */
            else
            {
                /*  زæ  */
                re_value = MFS_UART_OptSt_OK;
            }
        }
    }  
    
    /*  ؽ  */
    return re_value;
}

/*  ȴæ꣬׼  */
/*   channel Ϊͨţ0  11  */
void MFS_UART_WaitForSendReady(unsigned int channel)
{    
    /*  ȴ  */
    while(MFS_UART_IsSendBusy(channel) == MFS_UART_OptSt_BUSY)
    {
        MFS_UART_CPU_SleepIdle();  /*  ͷCPU  */
    }
}

/*  Ͷֽ  */
/*   channel Ϊͨţ0  11  */
/*  typeǷͣΪMFS_UART_SendType_BlockingΪMFS_UART_SendType_Interruptж  */
/*  pdatûݵָ룬ע⣡ָΪжϷʱǿȫַʵģעûڣ  */
/*  lenҪ͵ĳ  */
/*  ֵMFS_UART_OptSt_OK=ͳɹ MFS_UART_OptSt_BUSY=æ*/
EMFS_UART_OptSt MFS_UART_SendMultiByte(unsigned int channel, EMFS_UART_SendType type, unsigned char* pdat, unsigned int len)
{
    /*  巵ֵ  */
    EMFS_UART_OptSt re_value = MFS_UART_OptSt_BUSY;
    
    /*  ȡǰæ״̬  */
    re_value = MFS_UART_IsSendBusy(channel);
    
    /*  æ  */
    if(re_value == MFS_UART_OptSt_BUSY)
    {
    }
    /*  æ  */
    else
    {
        /*  鷢ͣΪ  */
        if(type == MFS_UART_SendType_Blocking)
        {
            /*  ѭ  */
            unsigned int i = 0u;
            
            /*  رշж  */
            /*  ʱҪж  */
            pMFS_UART[channel]->unSCR.stcField.u1TIE = 0u;    
            
            /*  ÿҪ͵ֽ  */
            for(i=0u;i<len;i++)
            {
                /*  øͨĿ  */
                MFS_UART_SendCtrl[channel].len = 0u;
                MFS_UART_SendCtrl[channel].pdat = 0u;
                MFS_UART_SendCtrl[channel].flag = MFS_UART_SendCmd_NULL;      /*  ڶֽڵķ  */
                
                /*  ݼĴд  */
                /*  οԴ[1]1805ҳĴӳTDRRDRڴַͬ  */
                /*  οԴ[1]1882ҳԸõַȡʱΪRDRԸõַдʱΪTDR  */
                pMFS_UART[channel]->unRDR.u16Register = ((unsigned short)pdat[i]) & 0x00FFu;  /*  ֻûݵĵ8λ  */
                
                /*  ǰֱͨ  */
                MFS_UART_WaitForSendReady(channel);
            }
        }
        /*  ΪжϷ  */
        else
        {
            /*  øͨĿ  */
            MFS_UART_SendCtrl[channel].len = len;
            MFS_UART_SendCtrl[channel].pdat = pdat;
            MFS_UART_SendCtrl[channel].flag = MFS_UART_SendCmd_BUSY;      /*  ʼ  */
            
            /*  ж  */
            pMFS_UART[channel]->unSCR.stcField.u1TIE = 1u;    
            
            /*  ݼĴд  */
            /*  οԴ[1]1805ҳĴӳTDRRDRڴַͬ  */
            /*  οԴ[1]1882ҳԸõַȡʱΪRDRԸõַдʱΪTDR  */
            pMFS_UART[channel]->unRDR.u16Register = ((unsigned short)pdat[0]) & 0x00FFu;  /*  ֻûݵĵ8λ  */
        }
    }
    
    /*  ؽ  */
    return re_value;
}

#if MFS_UART_PRINTF_EN
/*  printfʽӡ  */
/*   channel Ϊͨţ0  11  */
/*  typeǷͣΪMFS_UART_SendType_BlockingΪMFS_UART_SendType_Interruptж  */
/*  ݱ׼ANSI Cprintfʹø㣡  */
void MFS_UART_printf(unsigned int channel, EMFS_UART_SendType type, char* str, ...)
{
    static char s[MFS_UART_PRINTF_BUF_SIZE];
    va_list arg_ptr;
    va_start(arg_ptr, str);

    memset(s,0x00,sizeof(s));

    vsprintf(s,str,arg_ptr);
    va_end(arg_ptr);

    MFS_UART_SendMultiByte(channel, type, (unsigned char*)s, strlen(s));
}
#endif  /*  MFS_UART_PRINTF_EN  */

/*  жϷ  ͨ0Ľ  */
static __irq __arm  void MFS_UART_InterruptService_CH0_RX_IRQ(void)
{
    /*  ̲οԴ[7]6ҳ  */
    /*  ȡǰ״̬Ĵ  */
    un_cpg_mfsn_uart_ssr_t cur_status = pMFS_UART[0]->unSSR;
    
    /*  ֡  */
    if(cur_status.stcField.u1FRE != 0u)
    {
    }
    /*  ޴  */
    else if(cur_status.stcField.u1ORE != 0u)
    {
    }
    /*    */
    else
    {
        /*  ûص  */
        MFS_UART_CH0_OnRecv((unsigned char)(pMFS_UART[0]->unRDR.u16Register & 0x0FFu));
        MFS_UART_RecvData_OnHandle(0u, (unsigned char)(pMFS_UART[0]->unRDR.u16Register & 0x0FFu));
        
    }
    
    /*  ǿȫ־  */
    pMFS_UART[0]->unSSR.u8Register = 0x0FFu;
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_46;
}

/*  жϷ  ͨ1Ľ  */
static __irq __arm  void MFS_UART_InterruptService_CH1_RX_IRQ(void)
{
    /*  ̲οԴ[7]6ҳ  */
    /*  ȡǰ״̬Ĵ  */
    un_cpg_mfsn_uart_ssr_t cur_status = pMFS_UART[1]->unSSR;
    
    /*  ֡  */
    if(cur_status.stcField.u1FRE != 0u)
    {
    }
    /*  ޴  */
    else if(cur_status.stcField.u1ORE != 0u)
    {
    }
    /*    */
    else
    {
        /*  ûص  */
        MFS_UART_CH1_OnRecv((unsigned char)(pMFS_UART[1]->unRDR.u16Register & 0x0FFu));
        MFS_UART_RecvData_OnHandle(1u, (unsigned char)(pMFS_UART[1]->unRDR.u16Register & 0x0FFu));
        
    }
    
    /*  ǿȫ־  */
    pMFS_UART[1]->unSSR.u8Register = 0x0FFu;
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_48;
}

/*  жϷ  ͨ2Ľ  */
static __irq __arm  void MFS_UART_InterruptService_CH2_RX_IRQ(void)
{
    /*  ̲οԴ[7]6ҳ  */
    /*  ȡǰ״̬Ĵ  */
    un_cpg_mfsn_uart_ssr_t cur_status = pMFS_UART[2]->unSSR;
    
    /*  ֡  */
    if(cur_status.stcField.u1FRE != 0u)
    {
    }
    /*  ޴  */
    else if(cur_status.stcField.u1ORE != 0u)
    {
    }
    /*    */
    else
    {
        /*  ûص  */
        MFS_UART_CH2_OnRecv((unsigned char)(pMFS_UART[2]->unRDR.u16Register & 0x0FFu));
        MFS_UART_RecvData_OnHandle(2u, (unsigned char)(pMFS_UART[2]->unRDR.u16Register & 0x0FFu));
        
    }
    
    /*  ǿȫ־  */
    pMFS_UART[2]->unSSR.u8Register = 0x0FFu;
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_50;
}

/*  жϷ  ͨ3Ľ  */
static __irq __arm  void MFS_UART_InterruptService_CH3_RX_IRQ(void)
{
    /*  ̲οԴ[7]6ҳ  */
    /*  ȡǰ״̬Ĵ  */
    un_cpg_mfsn_uart_ssr_t cur_status = pMFS_UART[3]->unSSR;
    
    /*  ֡  */
    if(cur_status.stcField.u1FRE != 0u)
    {
    }
    /*  ޴  */
    else if(cur_status.stcField.u1ORE != 0u)
    {
    }
    /*    */
    else
    {
        /*  ûص  */
        MFS_UART_CH3_OnRecv((unsigned char)(pMFS_UART[3]->unRDR.u16Register & 0x0FFu));
        MFS_UART_RecvData_OnHandle(3u, (unsigned char)(pMFS_UART[3]->unRDR.u16Register & 0x0FFu));
        
    }
    
    /*  ǿȫ־  */
    pMFS_UART[3]->unSSR.u8Register = 0x0FFu;
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_52;
}

/*  жϷ  ͨ4Ľ  */
static __irq __arm  void MFS_UART_InterruptService_CH4_RX_IRQ(void)
{
    /*  ̲οԴ[7]6ҳ  */
    /*  ȡǰ״̬Ĵ  */
    un_cpg_mfsn_uart_ssr_t cur_status = pMFS_UART[4]->unSSR;
    
    /*  ֡  */
    if(cur_status.stcField.u1FRE != 0u)
    {
    }
    /*  ޴  */
    else if(cur_status.stcField.u1ORE != 0u)
    {
    }
    /*    */
    else
    {
        /*  ûص  */
        MFS_UART_CH4_OnRecv((unsigned char)(pMFS_UART[4]->unRDR.u16Register & 0x0FFu));
        MFS_UART_RecvData_OnHandle(4u, (unsigned char)(pMFS_UART[4]->unRDR.u16Register & 0x0FFu));
        
    }
    
    /*  ǿȫ־  */
    pMFS_UART[4]->unSSR.u8Register = 0x0FFu;
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_54;
}

/*  жϷ  ͨ5Ľ  */
static __irq __arm  void MFS_UART_InterruptService_CH5_RX_IRQ(void)
{
    /*  ̲οԴ[7]6ҳ  */
    /*  ȡǰ״̬Ĵ  */
    un_cpg_mfsn_uart_ssr_t cur_status = pMFS_UART[5]->unSSR;
    
    /*  ֡  */
    if(cur_status.stcField.u1FRE != 0u)
    {
    }
    /*  ޴  */
    else if(cur_status.stcField.u1ORE != 0u)
    {
    }
    /*    */
    else
    {
        /*  ûص  */
        MFS_UART_CH5_OnRecv((unsigned char)(pMFS_UART[5]->unRDR.u16Register & 0x0FFu));
        MFS_UART_RecvData_OnHandle(5u, (unsigned char)(pMFS_UART[5]->unRDR.u16Register & 0x0FFu));
        
    }
    
    /*  ǿȫ־  */
    pMFS_UART[5]->unSSR.u8Register = 0x0FFu;
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_56;
}

/*  жϷ  ͨ6Ľ  */
static __irq __arm  void MFS_UART_InterruptService_CH6_RX_IRQ(void)
{
    /*  ̲οԴ[7]6ҳ  */
    /*  ȡǰ״̬Ĵ  */
    un_cpg_mfsn_uart_ssr_t cur_status = pMFS_UART[6]->unSSR;
    
    /*  ֡  */
    if(cur_status.stcField.u1FRE != 0u)
    {
    }
    /*  ޴  */
    else if(cur_status.stcField.u1ORE != 0u)
    {
    }
    /*    */
    else
    {
        /*  ûص  */
        MFS_UART_CH6_OnRecv((unsigned char)(pMFS_UART[6]->unRDR.u16Register & 0x0FFu));
        MFS_UART_RecvData_OnHandle(6u, (unsigned char)(pMFS_UART[6]->unRDR.u16Register & 0x0FFu));
        
    }
    
    /*  ǿȫ־  */
    pMFS_UART[6]->unSSR.u8Register = 0x0FFu;
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_58;
}

/*  жϷ  ͨ7Ľ  */
static __irq __arm  void MFS_UART_InterruptService_CH7_RX_IRQ(void)
{
    /*  ̲οԴ[7]6ҳ  */
    /*  ȡǰ״̬Ĵ  */
    un_cpg_mfsn_uart_ssr_t cur_status = pMFS_UART[7]->unSSR;
    
    /*  ֡  */
    if(cur_status.stcField.u1FRE != 0u)
    {
    }
    /*  ޴  */
    else if(cur_status.stcField.u1ORE != 0u)
    {
    }
    /*    */
    else
    {
        /*  ûص  */
        MFS_UART_CH7_OnRecv((unsigned char)(pMFS_UART[7]->unRDR.u16Register & 0x0FFu));
        MFS_UART_RecvData_OnHandle(7u, (unsigned char)(pMFS_UART[7]->unRDR.u16Register & 0x0FFu));
        
    }
    
    /*  ǿȫ־  */
    pMFS_UART[7]->unSSR.u8Register = 0x0FFu;
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_60;
}

/*  жϷ  ͨ8Ľ  */
static __irq __arm  void MFS_UART_InterruptService_CH8_RX_IRQ(void)
{
    /*  ̲οԴ[7]6ҳ  */
    /*  ȡǰ״̬Ĵ  */
    un_cpg_mfsn_uart_ssr_t cur_status = pMFS_UART[8]->unSSR;
    
    /*  ֡  */
    if(cur_status.stcField.u1FRE != 0u)
    {
    }
    /*  ޴  */
    else if(cur_status.stcField.u1ORE != 0u)
    {
    }
    /*    */
    else
    {
        /*  ûص  */
        MFS_UART_CH8_OnRecv((unsigned char)(pMFS_UART[8]->unRDR.u16Register & 0x0FFu));
        MFS_UART_RecvData_OnHandle(8u, (unsigned char)(pMFS_UART[8]->unRDR.u16Register & 0x0FFu));
        
    }
    
    /*  ǿȫ־  */
    pMFS_UART[8]->unSSR.u8Register = 0x0FFu;
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_62;
}

/*  жϷ  ͨ9Ľ  */
static __irq __arm  void MFS_UART_InterruptService_CH9_RX_IRQ(void)
{
    /*  ̲οԴ[7]6ҳ  */
    /*  ȡǰ״̬Ĵ  */
    un_cpg_mfsn_uart_ssr_t cur_status = pMFS_UART[9]->unSSR;
    
    /*  ֡  */
    if(cur_status.stcField.u1FRE != 0u)
    {
    }
    /*  ޴  */
    else if(cur_status.stcField.u1ORE != 0u)
    {
    }
    /*    */
    else
    {
        /*  ûص  */
        MFS_UART_CH9_OnRecv((unsigned char)(pMFS_UART[9]->unRDR.u16Register & 0x0FFu));
        MFS_UART_RecvData_OnHandle(9u, (unsigned char)(pMFS_UART[9]->unRDR.u16Register & 0x0FFu));
        
    }
    
    /*  ǿȫ־  */
    pMFS_UART[9]->unSSR.u8Register = 0x0FFu;
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_64;
}

/*  жϷ  ͨ10Ľ  */
static __irq __arm  void MFS_UART_InterruptService_CH10_RX_IRQ(void)
{
    /*  ̲οԴ[7]6ҳ  */
    /*  ȡǰ״̬Ĵ  */
    un_cpg_mfsn_uart_ssr_t cur_status = pMFS_UART[10]->unSSR;
    
    /*  ֡  */
    if(cur_status.stcField.u1FRE != 0u)
    {
    }
    /*  ޴  */
    else if(cur_status.stcField.u1ORE != 0u)
    {
    }
    /*    */
    else
    {
        /*  ûص  */
        MFS_UART_CH10_OnRecv((unsigned char)(pMFS_UART[10]->unRDR.u16Register & 0x0FFu));
        MFS_UART_RecvData_OnHandle(10u, (unsigned char)(pMFS_UART[10]->unRDR.u16Register & 0x0FFu));
        
    }
    
    /*  ǿȫ־  */
    pMFS_UART[10]->unSSR.u8Register = 0x0FFu;
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_66;
}

/*  жϷ  ͨ11Ľ  */
static __irq __arm  void MFS_UART_InterruptService_CH11_RX_IRQ(void)
{
    /*  ̲οԴ[7]6ҳ  */
    /*  ȡǰ״̬Ĵ  */
    un_cpg_mfsn_uart_ssr_t cur_status = pMFS_UART[11]->unSSR;
    
    /*  ֡  */
    if(cur_status.stcField.u1FRE != 0u)
    {
    }
    /*  ޴  */
    else if(cur_status.stcField.u1ORE != 0u)
    {
    }
    /*    */
    else
    {
        /*  ûص  */
        MFS_UART_CH11_OnRecv((unsigned char)(pMFS_UART[11]->unRDR.u16Register & 0x0FFu));
        MFS_UART_RecvData_OnHandle(11u, (unsigned char)(pMFS_UART[11]->unRDR.u16Register & 0x0FFu));
        
    }
    
    /*  ǿȫ־  */
    pMFS_UART[11]->unSSR.u8Register = 0x0FFu;
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_68;
}

/*  жϷ  ͨ0ķ  */
static __irq __arm  void MFS_UART_InterruptService_CH0_TX_IRQ(void)
{
    /*  ڷ  */
    if(MFS_UART_SendCtrl[0].flag == MFS_UART_SendCmd_BUSY)
    {
        /*  һʣûз  */
        if(MFS_UART_SendCtrl[0].len > 0u)
        {
            /*  ͳѾ͵ֽڸ  */
            MFS_UART_SendCtrl[0].len--;
            
            /*  ݼĴд  */
            /*  οԴ[1]1805ҳĴӳTDRRDRڴַͬ  */
            /*  οԴ[1]1882ҳԸõַȡʱΪRDRԸõַдʱΪTDR  */
            pMFS_UART[0]->unRDR.u16Register = MFS_UART_SendCtrl[0].pdat[0];
            
            /*  һ  */
            MFS_UART_SendCtrl[0].pdat++;
            
            /*  ȫ  */
            if(MFS_UART_SendCtrl[0].len == 0u)
            {
                MFS_UART_SendCtrl[0].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
                
               /*  رշж  */
               pMFS_UART[0]->unSCR.stcField.u1TIE = 0u;    
            }
        }
        /*  ÷  */
        else
        {
            MFS_UART_SendCtrl[0].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
        }
    }
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_47;
}

/*  жϷ  ͨ1ķ  */
static __irq __arm  void MFS_UART_InterruptService_CH1_TX_IRQ(void)
{
    /*  ڷ  */
    if(MFS_UART_SendCtrl[1].flag == MFS_UART_SendCmd_BUSY)
    {
        /*  һʣûз  */
        if(MFS_UART_SendCtrl[1].len > 0u)
        {
            /*  ͳѾ͵ֽڸ  */
            MFS_UART_SendCtrl[1].len--;
            
            /*  ݼĴд  */
            /*  οԴ[1]1805ҳĴӳTDRRDRڴַͬ  */
            /*  οԴ[1]1882ҳԸõַȡʱΪRDRԸõַдʱΪTDR  */
            pMFS_UART[1]->unRDR.u16Register = MFS_UART_SendCtrl[1].pdat[0];
            
            /*  һ  */
            MFS_UART_SendCtrl[1].pdat++;
            
            /*  ȫ  */
            if(MFS_UART_SendCtrl[1].len == 0u)
            {
                MFS_UART_SendCtrl[1].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
                
               /*  رշж  */
               pMFS_UART[1]->unSCR.stcField.u1TIE = 0u;    
            }
        }
        /*  ÷  */
        else
        {
            MFS_UART_SendCtrl[1].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
        }
    }
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_49;
}

/*  жϷ  ͨ2ķ  */
static __irq __arm  void MFS_UART_InterruptService_CH2_TX_IRQ(void)
{
    /*  ڷ  */
    if(MFS_UART_SendCtrl[2].flag == MFS_UART_SendCmd_BUSY)
    {
        /*  һʣûз  */
        if(MFS_UART_SendCtrl[2].len > 0u)
        {
            /*  ͳѾ͵ֽڸ  */
            MFS_UART_SendCtrl[2].len--;
            
            /*  ݼĴд  */
            /*  οԴ[1]1805ҳĴӳTDRRDRڴַͬ  */
            /*  οԴ[1]1882ҳԸõַȡʱΪRDRԸõַдʱΪTDR  */
            pMFS_UART[2]->unRDR.u16Register = MFS_UART_SendCtrl[2].pdat[0];
            
            /*  һ  */
            MFS_UART_SendCtrl[2].pdat++;
            
            /*  ȫ  */
            if(MFS_UART_SendCtrl[2].len == 0u)
            {
                MFS_UART_SendCtrl[2].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
                
               /*  رշж  */
               pMFS_UART[2]->unSCR.stcField.u1TIE = 0u;    
            }
        }
        /*  ÷  */
        else
        {
            MFS_UART_SendCtrl[2].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
        }
    }
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_51;
}

/*  жϷ  ͨ3ķ  */
static __irq __arm  void MFS_UART_InterruptService_CH3_TX_IRQ(void)
{
    /*  ڷ  */
    if(MFS_UART_SendCtrl[3].flag == MFS_UART_SendCmd_BUSY)
    {
        /*  һʣûз  */
        if(MFS_UART_SendCtrl[3].len > 0u)
        {
            /*  ͳѾ͵ֽڸ  */
            MFS_UART_SendCtrl[3].len--;
            
            /*  ݼĴд  */
            /*  οԴ[1]1805ҳĴӳTDRRDRڴַͬ  */
            /*  οԴ[1]1882ҳԸõַȡʱΪRDRԸõַдʱΪTDR  */
            pMFS_UART[3]->unRDR.u16Register = MFS_UART_SendCtrl[3].pdat[0];
            
            /*  һ  */
            MFS_UART_SendCtrl[3].pdat++;
            
            /*  ȫ  */
            if(MFS_UART_SendCtrl[3].len == 0u)
            {
                MFS_UART_SendCtrl[3].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
                
               /*  رշж  */
               pMFS_UART[3]->unSCR.stcField.u1TIE = 0u;    
            }
        }
        /*  ÷  */
        else
        {
            MFS_UART_SendCtrl[3].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
        }
    }
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_53;
}

/*  жϷ  ͨ4ķ  */
static __irq __arm  void MFS_UART_InterruptService_CH4_TX_IRQ(void)
{
    /*  ڷ  */
    if(MFS_UART_SendCtrl[4].flag == MFS_UART_SendCmd_BUSY)
    {
        /*  һʣûз  */
        if(MFS_UART_SendCtrl[4].len > 0u)
        {
            /*  ͳѾ͵ֽڸ  */
            MFS_UART_SendCtrl[4].len--;
            
            /*  ݼĴд  */
            /*  οԴ[1]1805ҳĴӳTDRRDRڴַͬ  */
            /*  οԴ[1]1882ҳԸõַȡʱΪRDRԸõַдʱΪTDR  */
            pMFS_UART[4]->unRDR.u16Register = MFS_UART_SendCtrl[4].pdat[0];
            
            /*  һ  */
            MFS_UART_SendCtrl[4].pdat++;
            
            /*  ȫ  */
            if(MFS_UART_SendCtrl[4].len == 0u)
            {
                MFS_UART_SendCtrl[4].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
                
               /*  رշж  */
               pMFS_UART[4]->unSCR.stcField.u1TIE = 0u;    
            }
        }
        /*  ÷  */
        else
        {
            MFS_UART_SendCtrl[4].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
        }
    }
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_55;
}

/*  жϷ  ͨ5ķ  */
static __irq __arm  void MFS_UART_InterruptService_CH5_TX_IRQ(void)
{
    /*  ڷ  */
    if(MFS_UART_SendCtrl[5].flag == MFS_UART_SendCmd_BUSY)
    {
        /*  һʣûз  */
        if(MFS_UART_SendCtrl[5].len > 0u)
        {
            /*  ͳѾ͵ֽڸ  */
            MFS_UART_SendCtrl[5].len--;
            
            /*  ݼĴд  */
            /*  οԴ[1]1805ҳĴӳTDRRDRڴַͬ  */
            /*  οԴ[1]1882ҳԸõַȡʱΪRDRԸõַдʱΪTDR  */
            pMFS_UART[5]->unRDR.u16Register = MFS_UART_SendCtrl[5].pdat[0];
            
            /*  һ  */
            MFS_UART_SendCtrl[5].pdat++;
            
            /*  ȫ  */
            if(MFS_UART_SendCtrl[5].len == 0u)
            {
                MFS_UART_SendCtrl[5].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
                
               /*  رշж  */
               pMFS_UART[5]->unSCR.stcField.u1TIE = 0u;    
            }
        }
        /*  ÷  */
        else
        {
            MFS_UART_SendCtrl[5].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
        }
    }
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_57;
}

/*  жϷ  ͨ6ķ  */
static __irq __arm  void MFS_UART_InterruptService_CH6_TX_IRQ(void)
{
    /*  ڷ  */
    if(MFS_UART_SendCtrl[6].flag == MFS_UART_SendCmd_BUSY)
    {
        /*  һʣûз  */
        if(MFS_UART_SendCtrl[6].len > 0u)
        {
            /*  ͳѾ͵ֽڸ  */
            MFS_UART_SendCtrl[6].len--;
            
            /*  ݼĴд  */
            /*  οԴ[1]1805ҳĴӳTDRRDRڴַͬ  */
            /*  οԴ[1]1882ҳԸõַȡʱΪRDRԸõַдʱΪTDR  */
            pMFS_UART[6]->unRDR.u16Register = MFS_UART_SendCtrl[6].pdat[0];
            
            /*  һ  */
            MFS_UART_SendCtrl[6].pdat++;
            
            /*  ȫ  */
            if(MFS_UART_SendCtrl[6].len == 0u)
            {
                MFS_UART_SendCtrl[6].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
                
               /*  رշж  */
               pMFS_UART[6]->unSCR.stcField.u1TIE = 0u;    
            }
        }
        /*  ÷  */
        else
        {
            MFS_UART_SendCtrl[6].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
        }
    }
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_59;
}

/*  жϷ  ͨ7ķ  */
static __irq __arm  void MFS_UART_InterruptService_CH7_TX_IRQ(void)
{
    /*  ڷ  */
    if(MFS_UART_SendCtrl[7].flag == MFS_UART_SendCmd_BUSY)
    {
        /*  һʣûз  */
        if(MFS_UART_SendCtrl[7].len > 0u)
        {
            /*  ͳѾ͵ֽڸ  */
            MFS_UART_SendCtrl[7].len--;
            
            /*  ݼĴд  */
            /*  οԴ[1]1805ҳĴӳTDRRDRڴַͬ  */
            /*  οԴ[1]1882ҳԸõַȡʱΪRDRԸõַдʱΪTDR  */
            pMFS_UART[7]->unRDR.u16Register = MFS_UART_SendCtrl[7].pdat[0];
            
            /*  һ  */
            MFS_UART_SendCtrl[7].pdat++;
            
            /*  ȫ  */
            if(MFS_UART_SendCtrl[7].len == 0u)
            {
                MFS_UART_SendCtrl[7].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
                
               /*  رշж  */
               pMFS_UART[7]->unSCR.stcField.u1TIE = 0u;    
            }
        }
        /*  ÷  */
        else
        {
            MFS_UART_SendCtrl[7].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
        }
    }
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_61;
}

/*  жϷ  ͨ8ķ  */
static __irq __arm  void MFS_UART_InterruptService_CH8_TX_IRQ(void)
{
    /*  ڷ  */
    if(MFS_UART_SendCtrl[8].flag == MFS_UART_SendCmd_BUSY)
    {
        /*  һʣûз  */
        if(MFS_UART_SendCtrl[8].len > 0u)
        {
            /*  ͳѾ͵ֽڸ  */
            MFS_UART_SendCtrl[8].len--;
            
            /*  ݼĴд  */
            /*  οԴ[1]1805ҳĴӳTDRRDRڴַͬ  */
            /*  οԴ[1]1882ҳԸõַȡʱΪRDRԸõַдʱΪTDR  */
            pMFS_UART[8]->unRDR.u16Register = MFS_UART_SendCtrl[8].pdat[0];
            
            /*  һ  */
            MFS_UART_SendCtrl[8].pdat++;
            
            /*  ȫ  */
            if(MFS_UART_SendCtrl[8].len == 0u)
            {
                MFS_UART_SendCtrl[8].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
                
               /*  رշж  */
               pMFS_UART[8]->unSCR.stcField.u1TIE = 0u;    
            }
        }
        /*  ÷  */
        else
        {
            MFS_UART_SendCtrl[8].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
        }
    }
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_63;
}

/*  жϷ  ͨ9ķ  */
static __irq __arm  void MFS_UART_InterruptService_CH9_TX_IRQ(void)
{
    /*  ڷ  */
    if(MFS_UART_SendCtrl[9].flag == MFS_UART_SendCmd_BUSY)
    {
        /*  һʣûз  */
        if(MFS_UART_SendCtrl[9].len > 0u)
        {
            /*  ͳѾ͵ֽڸ  */
            MFS_UART_SendCtrl[9].len--;
            
            /*  ݼĴд  */
            /*  οԴ[1]1805ҳĴӳTDRRDRڴַͬ  */
            /*  οԴ[1]1882ҳԸõַȡʱΪRDRԸõַдʱΪTDR  */
            pMFS_UART[9]->unRDR.u16Register = MFS_UART_SendCtrl[9].pdat[0];
            
            /*  һ  */
            MFS_UART_SendCtrl[9].pdat++;
            
            /*  ȫ  */
            if(MFS_UART_SendCtrl[9].len == 0u)
            {
                MFS_UART_SendCtrl[9].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
                
               /*  رշж  */
               pMFS_UART[9]->unSCR.stcField.u1TIE = 0u;    
            }
        }
        /*  ÷  */
        else
        {
            MFS_UART_SendCtrl[9].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
        }
    }
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_65;
}

/*  жϷ  ͨ10ķ  */
static __irq __arm  void MFS_UART_InterruptService_CH10_TX_IRQ(void)
{
    /*  ڷ  */
    if(MFS_UART_SendCtrl[10].flag == MFS_UART_SendCmd_BUSY)
    {
        /*  һʣûз  */
        if(MFS_UART_SendCtrl[10].len > 0u)
        {
            /*  ͳѾ͵ֽڸ  */
            MFS_UART_SendCtrl[10].len--;
            
            /*  ݼĴд  */
            /*  οԴ[1]1805ҳĴӳTDRRDRڴַͬ  */
            /*  οԴ[1]1882ҳԸõַȡʱΪRDRԸõַдʱΪTDR  */
            pMFS_UART[10]->unRDR.u16Register = MFS_UART_SendCtrl[10].pdat[0];
            
            /*  һ  */
            MFS_UART_SendCtrl[10].pdat++;
            
            /*  ȫ  */
            if(MFS_UART_SendCtrl[10].len == 0u)
            {
                MFS_UART_SendCtrl[10].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
                
               /*  رշж  */
               pMFS_UART[10]->unSCR.stcField.u1TIE = 0u;    
            }
        }
        /*  ÷  */
        else
        {
            MFS_UART_SendCtrl[10].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
        }
    }
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_67;
}

/*  жϷ  ͨ11ķ  */
static __irq __arm  void MFS_UART_InterruptService_CH11_TX_IRQ(void)
{
    /*  ڷ  */
    if(MFS_UART_SendCtrl[11].flag == MFS_UART_SendCmd_BUSY)
    {
        /*  һʣûз  */
        if(MFS_UART_SendCtrl[11].len > 0u)
        {
            /*  ͳѾ͵ֽڸ  */
            MFS_UART_SendCtrl[11].len--;
            
            /*  ݼĴд  */
            /*  οԴ[1]1805ҳĴӳTDRRDRڴַͬ  */
            /*  οԴ[1]1882ҳԸõַȡʱΪRDRԸõַдʱΪTDR  */
            pMFS_UART[11]->unRDR.u16Register = MFS_UART_SendCtrl[11].pdat[0];
            
            /*  һ  */
            MFS_UART_SendCtrl[11].pdat++;
            
            /*  ȫ  */
            if(MFS_UART_SendCtrl[11].len == 0u)
            {
                MFS_UART_SendCtrl[11].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
                
               /*  رշж  */
               pMFS_UART[11]->unSCR.stcField.u1TIE = 0u;    
            }
        }
        /*  ÷  */
        else
        {
            MFS_UART_SendCtrl[11].flag = MFS_UART_SendCmd_NULL;    /*  ò  */
        }
    }
    
    /*  жϱּĴ  */
    /*  οԴ[1]1230ҳ  */
    IRC0_IRQHC = INTERRUPTS_IRQ_NUMBER_69;
}

/*  ļ MFS_UART.c  */

