/**********************************************************************************************************
 * Copyright(C) 2017, HeiLongJiang TYW Co.,Ltd.
 *
 * @Filename:       BackLight.c
 *
 * @Description:        背光控制文件
 *
 * @Functions List:
 *
 *
 * @History:        Version:            V0.0.1
                    Date:               2020.02.28
                    Author:
                    Modification:
 **********************************************************************************************************/
#include "BackLight.h"
#include "System_Status_Monitor.h"
#include "Communication_Over_CAN.h"
#include "EOL_Para.h"
#include "Analog_Signals.h"
#include "RTE_PWM_OUT.h" 

#include "CAN_Communication_Matrix.h"
#include "GPIO_Config.h"
#include "Line_In.h"

/*背光控制结构体*/
#pragma location = "BACKUP_RAM_CONTENT"
ST_BackLightCtrlStruct BackLight_Ctrl;

void BackLight_LCD_Set_Brightness(uint16_t br);
void BackLight_Pointer_Set_Brightness(uint16_t br);
void BackLight_Pointer_OFF(void);
void BackLight_Pointer_ON(void);

static void BackLight_Panel_Set_Brightness(uint16_t br);
static void BackLight_Panel_ON(void);

/**********************************************************************************************************
 *@Function:        BackLight_Panel_ON
 *@Description:     打开Panel背光
 *@Input:       none.
 *@Output:      none.
 *@Calls:       none.
 *@Return:      none.
 *@Note:        none.
 **********************************************************************************************************/
static void BackLight_Panel_ON(void)
{
    RTE_PWM_Panel_Start( );
}
/**********************************************************************************************************
 *@Function:        BackLight_Pointer_ON
 *@Description:         打开指针背光
 *@Input:       none.
 *@Output:      none.
 *@Calls:       none.
 *@Return:      none.
 *@Note:        none.
 **********************************************************************************************************/
void BackLight_Pointer_ON(void)
{
    RTE_PWM_Point_Start( );
}

/**********************************************************************************************************
 *@Function:        IG_ON初始化
 *@Description: BackLight_IG_ON_Init
 *@Input:       none.
 *@Output:      none.
 *@Calls:       none.
 *@Return:      none.
 *@Note:        none.
 **********************************************************************************************************/
void BackLight_IG_ON_Init(void)
{
    BackLight_Ctrl.LCDPWMLast     = 0U;
    BackLight_Ctrl.PointerPWMLast = 0U;
    BackLight_Ctrl.PanelPWMLast   = 0U;
    BackLight_Pointer_ON( );
    BackLight_Panel_ON( );
}

/**********************************************************************************************************
 *@Function:        30初始化
 *@Description: BackLight_30_Init
 *@Input:       none.
 *@Output:      none.
 *@Calls:       none.
 *@Return:      none.
 *@Note:        none.
 **********************************************************************************************************/
void BackLight_30_Init(void)
{
    BackLight_Ctrl.LCDPWMLast     = 0U;
    BackLight_Ctrl.PointerPWMLast = 0U;
    BackLight_Ctrl.PanelPWMLast   = 0U;
    RTE_PWM_Start( );
}

/**********************************************************************************************************
 *@Function:        唤醒初始化
 *@Description: BackLight_Wakeup_Init
 *@Input:       none.
 *@Output:      none.
 *@Calls:       none.
 *@Return:      none.
 *@Note:        none.
 **********************************************************************************************************/
void BackLight_Wakeup_Init(void)
{
    BackLight_Ctrl.LCDPWMLast     = 0U;
    BackLight_Ctrl.PointerPWMLast = 0U;
    BackLight_Ctrl.PanelPWMLast   = 0U;
    RTE_PWM_Start( );
}

/**********************************************************************************************************
 *@Function:        睡眠初始化
 *@Description: BackLight_Sleep_Init
 *@Input:       none.
 *@Output:      none.
 *@Calls:       none.
 *@Return:      none.
 *@Note:        none.
 **********************************************************************************************************/
void BackLight_IG_OFF_Init(void)
{
    BackLight_Ctrl.LCDPWMLast     = 0U;
    BackLight_Ctrl.PointerPWMLast = 0U;
    BackLight_Ctrl.PanelPWMLast   = 0U;
    RTE_PWM_Stop( );
}
/**********************************************************************************************************
 *@Function:        睡眠初始化
 *@Description: BackLight_Sleep_Init
 *@Input:       none.
 *@Output:      none.
 *@Calls:       none.
 *@Return:      none.
 *@Note:        none.
 **********************************************************************************************************/
void BackLight_Sleep_Init(void)
{
    BackLight_Ctrl.LCDPWMLast     = 0U;
    BackLight_Ctrl.PointerPWMLast = 0U;
    BackLight_Ctrl.PanelPWMLast   = 0U;
    RTE_PWM_Stop( );
}

/**********************************************************************************************************
 *@Function:        BackLight_LCD_Set_Brightness
 *@Description:         设置LCD PWM值
 *@Input:       br ：PWM值 精度0.1.
 *@Output:      none.
 *@Calls:       none.
 *@Return:      none.
 *@Note:        none.
 **********************************************************************************************************/
void BackLight_LCD_Set_Brightness(uint16_t br)
{
    uint32_t brightness = 0U;

    if ( BackLight_Ctrl.LCDPWMLast != br )
    {
        BackLight_Ctrl.LCDPWMLast = br;
        brightness = (32008u * br) / 1000U;
        RTE_PWM_Set_LCD(32008u, ( uint16_t )brightness);
    }
}

/**********************************************************************************************************
 *@Function:        BackLight_Panel_Set_Brightness
 *@Description:         设置Panel PWM值
 *@Input:       br ：PWM值 精度0.1.
 *@Output:      none.
 *@Calls:       none.
 *@Return:      none.
 *@Note:        none.
 **********************************************************************************************************/
static void BackLight_Panel_Set_Brightness(uint16_t br)
{
    uint32_t brightness = 0U;

    if ( BackLight_Ctrl.PanelPWMLast != br )
    {
        BackLight_Ctrl.PanelPWMLast = br;
        brightness = (32008u * br) / 1000U;
        RTE_PWM_Set_Panel(32008u, ( uint16_t )brightness);
    }
}
/**********************************************************************************************************
 *@Function:        BackLight_Pointer_Set_Brightness
 *@Description:         设置指针 PWM值
 *@Input:       br ：PWM值 精度0.1.
 *@Output:      none.
 *@Calls:       none.
 *@Return:      none.
 *@Note:        none.
 **********************************************************************************************************/
void BackLight_Pointer_Set_Brightness(uint16_t br)
{
    uint32_t brightness = 0U;

    if ( BackLight_Ctrl.PointerPWMLast != br )
    {
        BackLight_Ctrl.PointerPWMLast = br;
        brightness = (32008u * br) / 1000U;
        RTE_PWM_Set_Point(32008u, ( uint16_t )brightness);
    }
}

/**********************************************************************************************************
 *@Function:        BackLight_Ctrl_Service
 *@Description:         背光控制服务
 *@Input:       none.
 *@Output:      none.
 *@Calls:       none.
 *@Return:      none.
 *@Note:        none.
 **********************************************************************************************************/
void BackLight_Ctrl_Service(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( Get_LINE_IN_Sts(LINE_IN_POSITION) != 1u )
        {
            BackLight_Pointer_Set_Brightness(1000u);
            BackLight_Panel_Set_Brightness(1000u);
        }
        else
        {
            BackLight_Pointer_Set_Brightness(500u);
            BackLight_Panel_Set_Brightness(500u);
        }
    }
}
