#include "CAN_APP.h"
#include "BackLight.h"
#include "CAN_Communication_Matrix.h"
#include "RTE_TIME.h"
#include "Services_ODO.h"
#include "Services_Interval.h"
#include "Line_In.h"
#include "System_Status_Monitor.h"
#include "MBD_Model.h"
#include "Service_OFF_Time.h"
#include "Common_Interface.h"
#include "Popups.h"
#include "Services_ODO.h"
#include "AirBagSelfChecking.h"
#include "Analog_Signals.h"
#include "Popup_Interface.h"
static MSCAN0BusoffMonitorStruct MSCAN0Busoff;
uint8_t                          BUS_OFF_FLAG;
uint8_t                          BusOffEvent;

/*
网络管理-0
诊断-1
应用ID-2...
*/

/******Higher******/

/*
26d 100ms   100*20*50
 3F6 200ms   200*20*50
 Base on 50us
*/

void Can_Abort_Confirm(uint32_t Identifier, uint8_t TransferStatus)
{
}

uint8_t CrcCheckSum(uint8_t data [], uint8_t len)
{
    uint8_t crc        = 0xffu;
    uint8_t CRC_POLY   = 0x2fu;
    uint8_t crcxor     = 0xffu;
    uint8_t bit_index  = 0u;
    uint8_t byte_index = 0u;
    uint8_t temp       = 0u;

    for ( byte_index = 0u; byte_index < len; ++byte_index )
    {
        crc ^= data [ byte_index ];
        for ( bit_index = 0u; bit_index < 8u; ++bit_index )
        {
            if ( (crc & 0x80u) != 0u )
            {
                temp = crc << 1u;
                crc  = temp ^ CRC_POLY;
            }
            else
            {
                crc = (crc << 1u);
            }
        }
    }

    crc = crc ^ crcxor;

    return crc;
}

void Can_BusOff_Fun(void)
{

    uint32_t cancel;
    if ( CANFD_ReadBus_Sts( ) != 0u )
    {
        cancel = CANFD_ReadTX_Buf( );
        CANFD_SetTX_Abort(cancel);
        BusOffEvent = 1U;
        if ( MSCAN0Busoff.Status == MSCAN0_BUS_STABLE )
        {
            MSCAN0Busoff.Status = MSCAN0_BUS_OFF_LV1;
        }

        if ( MSCAN0Busoff.Status == MSCAN0_BUS_OFF_LV1 )
        {
            MSCAN0Busoff.Timer++;
            if ( MSCAN0Busoff.Timer >= MSCAN0_BUS_OFF_LV1_RECOVERY_TIME / 10U )
            {
                MSCAN0Busoff.Timer = 0U;

                MSCAN0Busoff.Cnt++;
                if ( MSCAN0Busoff.Cnt >= 10U )
                {
                    BUS_OFF_FLAG     = 1U;
                    MSCAN0Busoff.Cnt = 0U;

                    MSCAN0Busoff.Status = MSCAN0_BUS_OFF_LV2;
                }
                CANFD_CH0_Bus_Off_Recover( );
            }
        }
        else if ( MSCAN0Busoff.Status == MSCAN0_BUS_OFF_LV2 )
        {
            MSCAN0Busoff.Timer++;

            if ( MSCAN0Busoff.Timer >= MSCAN0_BUS_OFF_LV2_RECOVERY_TIME / 10U )
            {
                MSCAN0Busoff.Timer = 0U;
                CANFD_CH0_Bus_Off_Recover( );
            }
        }
        else
        {
        }
    }
    else /* 总线正常,没有Bus-off发生 */
    {
    }
}

void Can_BusOffRecover(void)
{
    BusOffEvent = 0U;
    /*BUS_OFF_FLAG = 0U;*/
    MSCAN0Busoff.Status = MSCAN0_BUS_STABLE;
    MSCAN0Busoff.Timer  = 0U;
    MSCAN0Busoff.Cnt    = 0U;
}

/**
 *获取busoff状态
 *@return busoff状态 0正常,1异常
 */
uint8_t getBUS_OFF_Status(void)
{
    return BusOffEvent;
}

/**
 *获取busoff标志
 *@return busoff状态 0正常,1异常
 */
uint8_t getBUS_OFF_FLAG(void)
{
    uint8_t FLAG = BUS_OFF_FLAG;
    if ( ! getBUS_OFF_Status( ) )
    {
        BUS_OFF_FLAG = 0u;
    }
    return FLAG;
}
