#include "Services_UTC.h"



#define UTC_BASE_YEAR 1970u
#define MONTH_PER_YEAR 12u
#define DAY_PER_YEAR 365u
#define SEC_PER_DAY 86400u
#define SEC_PER_HOUR 3600u
#define SEC_PER_MIN 60u


const unsigned char g_day_per_mon[MONTH_PER_YEAR] = {31u, 28u, 31u, 30u, 31u, 30u, 31u, 31u, 30u, 31u, 30u, 31u};
/*一下为UTC时间戳转换代码实现逻辑*/



static unsigned char applib_dt_last_day_of_mon(unsigned char month, unsigned short year);
static unsigned char applib_dt_is_leap_year(unsigned short year);

unsigned long int mytime_2_utc_sec(_MYTIME_STRUCT *currTime)
{
    /*----------------------------------------------------------------*/
    /* Local Variables                                                */
    /*----------------------------------------------------------------*/
    unsigned short i;
    unsigned int no_of_days = 0u;
    unsigned int utc_time;
    /*----------------------------------------------------------------*/
    /* Code Body                                                      */
    /*----------------------------------------------------------------*/
    if (currTime->nYear < UTC_BASE_YEAR)
    {
        utc_time = 0u;
    }
    else
    {
        /* year */
        for (i = UTC_BASE_YEAR; i < currTime->nYear; i++)
        {
            no_of_days += (DAY_PER_YEAR + applib_dt_is_leap_year(i));
        }
        /* month */
        for (i = 1u; i < currTime->nMonth; i++)
        {
            no_of_days += applib_dt_last_day_of_mon((unsigned char) i, currTime->nYear);
        }
        /* day */
        no_of_days += (currTime->nDay - 1u);
        /* sec */
        utc_time = (unsigned int) no_of_days * SEC_PER_DAY +  (unsigned int)currTime->nHour * SEC_PER_HOUR + (unsigned int)currTime->nMin * SEC_PER_MIN + (unsigned int)currTime->nSec;

    }
    return utc_time;
}
static unsigned char applib_dt_last_day_of_mon(unsigned char month, unsigned short year)
{
    /*----------------------------------------------------------------*/
    /* Local Variables                                                */
    /*----------------------------------------------------------------*/
    unsigned char	m8 = 0u;
    /*----------------------------------------------------------------*/
    /* Code Body                                                      */
    /*----------------------------------------------------------------*/
    if ((month == 0u) || (month > 12u))
    {
        m8 = g_day_per_mon[1u] + applib_dt_is_leap_year(year);
    }
    if (month != 2u)
    {
        m8 = g_day_per_mon[month - 1u];
    }
    else
    {
        m8 = g_day_per_mon[1u] + applib_dt_is_leap_year(year);
    }
    return m8;
}


static unsigned char applib_dt_is_leap_year(unsigned short year)
{
    /*----------------------------------------------------------------*/
    /* Local Variables                                                */
    /*----------------------------------------------------------------*/
    unsigned char	m8 = 0u;
    /*----------------------------------------------------------------*/
    /* Code Body                                                      */
    /*----------------------------------------------------------------*/
    if ((year % 400u) == 0u)
    {
        m8 = 1u; /*return 1u;*/
    }
    else if ((year % 100u) == 0u)
    {
        m8 = 0u; /*return 0u;*/
    }
    else if ((year % 4u) == 0u)
    {
        m8 = 1u; /*return 1u;*/
    }
    else
    {
        m8 = 0u; /*return 0u;*/
    }
    return m8;
}
unsigned short Read_Version_UTC(void)
{
    return 0x0001u;
}