#include "Service_OFF_Time.h"
#include "Common_Interface.h"




#pragma location="BACKUP_RAM_CONTENT"
uint32_t Service_OFF_Timing;



void Service_OFF_Timing_KL30Init(void)
{
    Service_OFF_Timing = 0u;
}
void Service_OFF_Timing_KL15Init(void)
{
    Service_OFF_Timing = 0u;
}

void Service_OFF_Timing_WakeupInit(uint32_t m_Val)
{
    if (m_Val >= 864000ul)
    {
        m_Val = 864000ul;
    }
    Service_OFF_Timing += m_Val;
    if (Service_OFF_Timing >= 864000ul)
    {
        Service_OFF_Timing = 864000ul;
    }
}

/* 100ms调用一次 中断调用 */
void Service_OFF_Timing_Process(void)
{
    if (Common_Get_IG_Sts() == 1u)
    {
        /*Service_OFF_Timing = 0u;*/
    }
    else
    {
        if (Service_OFF_Timing < 864000ul)
        {
            Service_OFF_Timing++;
        }
        if (Service_OFF_Timing >= 864000ul)
        {
            Service_OFF_Timing = 864000ul;
        }
    }
}

uint16_t Service_ConvertMin(void)
{
    uint16_t m_Min;
    if (Service_OFF_Timing >= 864000ul)
    {
        Service_OFF_Timing = 864000ul;
    }
    m_Min = (uint16_t)(Service_OFF_Timing / 600u);
    if(m_Min>=0x5A0u)
    {
      m_Min=0x5A0u;
    }
    return m_Min;
}
