
#include "CRC.h"


void CRC_Init(CRC_Mode_en_t enMode, CRC_Endian_en_t enEndianIn, CRC_Endian_en_t enEndianOut)
{
  uint8_t  u8RegVal;
  
  if (enMode == CRC16)
  {
    /***
    * CRC16 configuration
    * [CCITT CRC16 Standard]
    * Generator polynomial 0x1021 (CRCCR.CRC32 = 0)
    * Initial value 0xFFFF
    * Final XOR value 0x0000 (CRCCR.FXOR = 0)
    * Bit order MSB First (CRCCR.LSBFST = 0)
    * Output bit order MSB First (CRCCR.CRCLSF = 0)
    ***/
    u8RegVal = 0x01U;
  }
  else
  {
    /***
    * CRC32 configuration
    * [IEEE-802.3 CRC32 Ethernet Standard]
    * Generator polynomial 0x04C11DB7 (CRCCR.CRC32 = 1)
    * Initial value 0xFFFFFFFF
    * Final XOR value 0xFFFFFFFF (CRCCR.FXOR = 1)
    * Bit order LSB First (CRCCR.LSBFST = 1)
    * Output bit order LSB First (CRCCR.CRCLSF = 1)
    ***/
    u8RegVal = 0x6BU;
  }
  
  if (enEndianIn  != CRC_Big_Endian)
  {
    u8RegVal |= 0x04U;
  }
  
  if (enEndianOut != CRC_Big_Endian)
  {
    u8RegVal |= 0x10U;
  }
    
  CRC00_CRCINIT   = 0xFFFFFFFFUL;
  CRC00_CRCCR     = u8RegVal;
}

void CRC_Write(uint32_t u32Data)
{
  CRC00_CRCIN = u32Data;
}

uint32_t CRC_Read(void)
{
  uint32_t  u32Data;
  
  u32Data = CRC00_CRCR;
  return u32Data;
}

