#include "PWM.h"



volatile static stc_btn_pwm_t* m_astcPwmInstanceDataLut[PwmInstanceIndexMax] =
{

    &BT00_PWM,
    &BT01_PWM,
    &BT02_PWM,
    &BT03_PWM,
    &BT04_PWM,
    &BT05_PWM,
    &BT06_PWM,
    &BT07_PWM,
    &BT08_PWM,
    &BT09_PWM,
    &BT10_PWM,
    &BT11_PWM,
    &BT12_PWM,
    &BT13_PWM,
    &BT14_PWM,
    &BT15_PWM,
    &BT16_PWM,
    &BT17_PWM,
    &BT18_PWM,
    &BT19_PWM,
    &BT20_PWM,
    &BT21_PWM,
    &BT22_PWM,
    &BT23_PWM,
    &BT24_PWM,
    &BT25_PWM,
    &BT26_PWM,
    &BT27_PWM,
    &BT28_PWM,
    &BT29_PWM,
    &BT30_PWM,
    &BT31_PWM,
};
/*
总线时钟源:LCP1A
总线时钟频率:33M
*/
void Bt_Pwm_Init( Pwm_instance_t Channel, en_pwm_clock_prescaler_t Prescaler, uint8_t m_Inverse )
{
    /* Local buffer to prepare the settings */
    un_btn_pwm_tmcr_t     unTMCR  = { 0 } ;
    un_btn_pwm_stc_t      unSTC   = { 0 } ;
    un_btn_pwm_tmcr2_t    unTMCR2 = { 0 } ;

    /*Writing "1" to the STCC:TGIRC bit clears this bit.*/
    m_astcPwmInstanceDataLut[Channel]->unSTCC.stcField.u1TGIRC = 0x01u;
    /*Writing "1" to the STCC:DTIRC bit clears this bit.*/
    m_astcPwmInstanceDataLut[Channel]->unSTCC.stcField.u1DTIRC = 0x01u;
    /*Writing "1" to the STCC:UDIRC bit clears this bit.*/
    m_astcPwmInstanceDataLut[Channel]->unSTCC.stcField.u1UDIRC = 0x01u;
    /* Set the timer function */
    unTMCR.stcField.u3FMD = 0x01u;
    /* Setup clock settings */
    unTMCR.stcField.u3CKS2_0 = (uint16_t)(((uint16_t)Prescaler & (uint16_t)PWM_TMCR_CKS2_0));
    unTMCR2.stcField.u1CKS3  = (Prescaler & PWM_TMCR2_CKS3) >> PWM_TMCR2_CKS3_SHIFT;

    /* Set the Trigger input edge selection */
    unTMCR.stcField.u2EGS = 0u;

    /* configure rest of PWM */
    unTMCR.stcField.u1RTGEN = 1u ;
    unTMCR.stcField.u1PMSK  = 0u;
    unTMCR.stcField.u1OSEL  = m_Inverse ;
    unTMCR.stcField.u1MDSE  = 0u ;

    /* Write back shadow registers to real HW */
    m_astcPwmInstanceDataLut[Channel]->unTMCR   = unTMCR;
    m_astcPwmInstanceDataLut[Channel]->unSTC     = unSTC;
    m_astcPwmInstanceDataLut[Channel]->unTMCR2  = unTMCR2;
} /* Bt_Pwm_Init */


/*
总线时钟源:LCP1A
总线时钟频率:33M
Cycle = 33M/m_Cycle
Duty= m_Duty/m_Cycle
*/
void Bt_Pwm_Start( Pwm_instance_t Channel, uint16_t m_Cycle, uint16_t m_Duty, uint16_t m_Delay )
{
    m_astcPwmInstanceDataLut[Channel]->unSTCS.stcField.u1TGIES = 0u;
    m_astcPwmInstanceDataLut[Channel]->unSTCS.stcField.u1DTIES = 0u;
    m_astcPwmInstanceDataLut[Channel]->unSTCS.stcField.u1UDIES = 0u;

    /* Set cycle */
    m_astcPwmInstanceDataLut[Channel]->unPCSR.u16Register = m_Cycle;
    /* Set duty */
    m_astcPwmInstanceDataLut[Channel]->unPDUT.u16Register = m_Duty;
    /* Set start delay */
    m_astcPwmInstanceDataLut[Channel]->unPSDR.u16Register = m_Delay;
    /* Set ADC trigger */
    m_astcPwmInstanceDataLut[Channel]->unADTR.u16Register = 0u;

    /* Enable timer and wait for trigger */
    m_astcPwmInstanceDataLut[Channel]->unTMCR.stcField.u1CTEN = 1u;
    m_astcPwmInstanceDataLut[Channel]->unTMCR.stcField.u1STRG = 1u;
} /* Bt_Pwm_Start */


void Bt_Pwm_Stop( Pwm_instance_t Channel )
{
    /* disable timer before anything else is done */
    m_astcPwmInstanceDataLut[Channel]->unTMCR.stcField.u1CTEN = 0u;

    /* disable interrupt */
    m_astcPwmInstanceDataLut[Channel]->unSTCC.stcField.u1TGIRC = 0x01u;
    /*Writing "1" to the STCC:DTIRC bit clears this bit.*/
    m_astcPwmInstanceDataLut[Channel]->unSTCC.stcField.u1DTIRC = 0x01u;
    /*Writing "1" to the STCC:UDIRC bit clears this bit.*/
    m_astcPwmInstanceDataLut[Channel]->unSTCC.stcField.u1UDIRC = 0x01u;
} /* Bt_Pwm_Stop */


void Bt_Pwm_Fast_Update( Pwm_instance_t Channel, uint16_t m_Cycle, uint16_t m_Duty )
{
    /* Set cycle */
    m_astcPwmInstanceDataLut[Channel]->unPCSR.u16Register = m_Cycle;
    /* Set duty */
    m_astcPwmInstanceDataLut[Channel]->unPDUT.u16Register = m_Duty;
}