#ifndef _SEATBELT_H_
#define _SEATBELT_H_

#include "stdint.h"

typedef struct
{
    uint16_t  Timer;
    uint16_t  ConsEnMileage;
    uint8_t   Poplevel ;

    uint8_t   LowSpeed300m ; /*低速300发生状态*/
    uint16_t  Chk60s ;
    struct
    {
        uint8_t   Duty;
        uint8_t   Cyc;
        uint8_t   En;
        uint8_t   Sync;
    } TelBlink;

} WarningSeatbeltStruct;



/*** 主驾安全带 ***/

extern volatile uint8_t  WarningSeatbeltDrTel;
extern volatile uint8_t  WarningSeatbeltDrPopup;
extern volatile WarningSeatbeltStruct WarningSeatbeltDr;

/*** 副驾安全带 ***/

extern volatile uint8_t  WarningSeatbeltPaTel;
extern volatile uint8_t  WarningSeatbeltPaPopup;
extern volatile WarningSeatbeltStruct WarningSeatbeltPa;

/*** 后排安全带 ***/
uint8_t Get_BackRowAlarmNUM(void);

extern volatile uint8_t WarningSeatbeltTel_2ndL;
extern volatile uint8_t WarningSeatbeltPos_2ndL;
extern volatile uint8_t WarningSeatbeltPopup_2ndL;
extern volatile WarningSeatbeltStruct WarningSeatbelt_2ndL;

extern volatile uint8_t WarningSeatbeltTel_2ndM;
extern volatile uint8_t WarningSeatbeltPos_2ndM;
extern volatile uint8_t WarningSeatbeltPopup_2ndM;
extern volatile WarningSeatbeltStruct WarningSeatbelt_2ndM;

extern volatile uint8_t WarningSeatbeltTel_2ndR;
extern volatile uint8_t WarningSeatbeltPos_2ndR;
extern volatile uint8_t WarningSeatbeltPopup_2ndR;
extern volatile WarningSeatbeltStruct WarningSeatbelt_2ndR;

extern   uint8_t setbeltsig_Dr;
extern   uint8_t setbeltsig_Pa;

extern   uint8_t setbeltsig_2ndL;
extern   uint8_t setbeltsig_2ndM;
extern   uint8_t setbeltsig_2ndR;

extern   uint8_t setbeltsig_2ndLBck;
extern   uint8_t setbeltsig_2ndMBck;
extern   uint8_t setbeltsig_2ndRBck;

/***************内部接口****************************/
void SeatbeltInit(void);
void sigInput(void);
void SeatbeltSelfCheck(void);
uint8_t Setbelt2ndLChk(void);
uint8_t Setbelt2ndMChk(void);
uint8_t Setbelt2ndRChk(void);

void Warning_Seatbelt_Dr_Processing(void);
void Warning_Seatbelt_Pa_Processing(void);
void Warning_Seatbelt_2ndL_Processing (void);
void Warning_Seatbelt_2ndM_Processing (void);
void Warning_Seatbelt_2ndR_Processing (void);

void SeatbeltTelltales(volatile WarningSeatbeltStruct * Seatbatile, volatile uint8_t *Popup, volatile uint8_t  *WarningTel);
void Seatbelt_logic(volatile WarningSeatbeltStruct * Seatbatile, volatile uint8_t *Popup , uint16_t Second);
void ResetSeatbeltWarning(volatile WarningSeatbeltStruct *Seatbatile, volatile uint8_t *Popup, uint8_t Clear) ;

/***************外部接口****************************/
extern uint32_t  GetMileageRollingCounter(void);/*里程滚动计数 m*/
extern uint8_t  Get_SND_SEATBELT_SYNC(void);    /*安全带报警声音播出时的标志*/
extern void ReSet_SND_SEATBELT_SYNC(void);        /*安全带报警声音播出标志清0*/

/***************对外接口****************************/
uint8_t Get_MainSetbeltTel(void); /*主报警灯状态返回  0，1 */
uint8_t Get_PassSetbeltTel(void); /*副报警灯状态返回  0，1 */
uint8_t  Get_SeatbeltPopupLevel(void);/*安全带报警等级信号 0，1，2，3*/
uint8_t  Get_Seatbelt2nd_CheckSt(void);/*返回后排安全带自检状态标志*/
void SeatbeltService_CB100ms(void); /*主服务调用100ms*/
void SeatbeltInit(void);          /*参数初始化，30电 ，或 on ，off 时初始化数据*/
#endif