#include "SEG_DISPLAY.h"
#include "Seg_Ref.h"
#include "AlarmGeneralFilie.h"
#include "EOL_Para.h"
#include "Telltales_user.h"
#include "PowerManagement.h"
#include "System_Status_Monitor.h"


/*数字显示数组*/	           /*0,     1     2    3      4    5     6      7    8     9  */
const uint8_t SEG_DISPLAY_NUMBER0[] = {0x3Fu, 0x06u, 0x5Bu, 0x4Fu, 0x66u, 0x6Du, 0x7Du, 0x07u, 0x7Fu, 0x6Fu};
const uint8_t SEG_UNDISPLAY_NUMBER0[] = {0x00u, 0x06u, 0x5Bu, 0x4Fu, 0x66u, 0x6Du, 0x7Du, 0x07u, 0x7Fu, 0x6Fu};



void SEG_IG_OFF_Init(void)
{
    BU98R10_Clear_Data_Buffer();
}

/**@brief 边框线显示函数
* @param[in]  m_Flag           是否显示     -1 显示 -0 不显示
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/

_Fun_Res SEG_SET_Frame(uint8_t m_Flag)
{
   _Fun_Res m_Res;
   if(m_Flag>=2u) 
   {
      m_Res = EX_ERR; 
   } 
   else 
   {
      if(m_Flag==0u) 
      {
        /*边框*/
        IC1_SEG026  = IC_SEG_OFF;
        IC2_SEG149  = IC_SEG_OFF;
        
      } 
      else 
      {
        /*边框*/
        IC1_SEG026  = IC_SEG_ON;
        IC2_SEG149  = IC_SEG_ON;
      }
      m_Res = EX_OK;
   }
   return m_Res;
  
}


/**@brief 指示灯显示函数
* @param[in]  m_Flag           是否显示     -1 显示 -0 不显示
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/

_Fun_Res SEG_SET_LED_STS(uint8_t LED_NUM , uint8_t m_Flag)
{
   _Fun_Res m_Res;
   uint8_t  Flag;
   uint8_t Num;
   if((m_Flag>7u)||(LED_NUM>=SEG_LED_MAX)) 
   {
      m_Res = EX_ERR; 
   } 
   else 
   {
      if(m_Flag==0u) 
      {
        Flag=IC_SEG_OFF_LED;
      } 
      else 
      {
        Flag=IC_SEG_ON;
      }
      Num=LED_NUM;
      switch(Num)
      {
      case 0u : IC1_SEG001   = Flag;  break;       /* SEG_LED_TurnLeft,          */
      case 1u : IC2_SEG063   = Flag;  break;       /* SEG_LED_TurnRight,         */
      case 2u : IC1_SEG002   = Flag;  break;       /* SEG_LED_Hbeam,          */
      case 3u : IC1_SEG003   = Flag;  break;       /* SEG_LED_Lbeam,           */
      case 4u : IC2_SEG062   = Flag;  break;       /* SEG_LED_Position*/ 
      case 5u : IC2_SEG060   = Flag;  break;       /* SEG_LED_RearFog*/ 
      case 6u : IC2_SEG061   = Flag;  break;       /* SEG_LED_Daylight*/ 
      case 7u : IC1_SEG006   = Flag;  break;       /* SEG_LED_ABS*/ 
      case 8u : IC1_SEG005   = Flag;  break;       /* SEG_LED_EBD_fault*/ 
      case 9u : IC1_SEG007   = Flag;  break;       /* SEG_LED_BrakeSystemFault*/ 
      case 10u: IC1_SEG101   = Flag;  break;       /* SEG_LED_EPB_Status*/ 
      case 11u: IC2_SEG065   = Flag;  break;       /* SEG_LED_EPS*/ 
      case 12u: IC2_SEG066   = Flag;  break;       /* SEG_LED_SEATBELT_DR*/ 
      case 13u: IC1_SEG009   = Flag;  break;       /* SEG_LED_SOC_CF*/ 
      case 14u: IC1_SEG098   = Flag;  break;       /* SEG_LED_SOC_CC*/ 
      case 15u: IC1_SEG100   = Flag;  break;       /* SEG_LED_SOC_CS*/ 
      case 16u: IC1_SEG012   = Flag;  break;       /* SEG_LED_SOC_LP*/ 
      case 17u: IC1_SEG010   = Flag;  break;       /* SEG_LED_SOC_Fault*/ 
      case 18u: IC1_SEG008   = Flag;  break;       /* SEG_LED_SOC_HT*/ 
      case 19u: IC2_SEG059   = Flag;  break;       /* SEG_LED_SystemFault*/ 
      case 20u: IC1_SEG004   = Flag;  break;       /* SEG_LED_READY*/ 
      case 21u: IC2_SEG121   = Flag;  break;       /* SEG_LED_MotorFault*/ 
      case 22u: IC2_SEG120   = Flag;  break;       /* SEG_LED_PowerLimit*/ 
      case 23u: IC2_SEG070   = Flag;  break;       /* SEG_LED_ECO*/ 
      case 24u: IC1_SEG097   = Flag;  break;       /* SEG_LED_InsulationFault*/ 
      case 25u: IC2_SEG072   = Flag;  break;       /* SEG_LED_Energy_Recovery*/ 
      case 26u: IC2_SEG119   = Flag;  break;       /* SEG_LED_WeightOverload*/ 
      case 27u: IC2_SEG068   = Flag;  break;       /* SEG_LED_DoorOpen*/ 
      case 28u: IC2_SEG123   = Flag;  break;       /* SEG_LED_OTA*/ //LED_FrontFog
      case 29u: IC2_SEG028   = Flag; IC2_SEG029 = Flag; break;       /* SEG_LED_RemoteLocking*/ 
      case 30u: IC2_SEG122   = Flag;  break;       /* SEG_LED_maintainWarning*/ 
      case 31u: IC2_SEG118   = Flag;  break;       /* SEG_LED_EWP*/ 
      case 32u: IC1_SEG011   = Flag;  break;       /* SEG_LED_SOC_DC*/ 
      
      default: break;
      }
      
      m_Res = EX_OK;
   }
   return m_Res;
  
}

/**@brief 挡位显示函数
* @param[in]  m_Gear_Flag     挡位符号是否显示     -1 显示 -0 不显示
* @param[in]  m_Gear          符号             Gear_P = 0,  //P
                                               Gear_R,      //R
                                               Gear_N,      //N
                                               Gear_D,      //D

* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/

_Fun_Res SEG_SET_GEAR(uint8_t m_Gear_Flag,uint8_t m_Gear)
{
   _Fun_Res m_Res ;
    if((m_Gear_Flag>=2u)||(m_Gear>4u)) 
   {
      m_Res = EX_ERR; 
   } 
   else 
   {
      /*挡位符号*/
      if(m_Gear_Flag==1u) 
      {
            if(m_Gear==Gear_P) 
            {
                IC2_SEG034 = IC_SEG_ON;
                IC2_SEG033 = IC_SEG_ON;
                IC2_SEG031 = IC_SEG_ON;
                IC2_SEG050 = IC_SEG_ON; 
                IC2_SEG036 = IC_SEG_ON;
                IC2_SEG035 = IC_SEG_OFF;
                IC2_SEG049 = IC_SEG_ON;
                IC2_SEG037 = IC_SEG_ON; 
                IC2_SEG041 = IC_SEG_ON;
                IC2_SEG032 = IC_SEG_ON;
                IC2_SEG030 = IC_SEG_ON;
                IC2_SEG048 = IC_SEG_ON; 
                IC2_SEG038 = IC_SEG_ON;
                IC2_SEG046 = IC_SEG_OFF;
                IC2_SEG047 = IC_SEG_OFF;
                IC2_SEG045 = IC_SEG_OFF;
                IC2_SEG039 = IC_SEG_ON;
                IC2_SEG040 = IC_SEG_ON;
                IC2_SEG042 = IC_SEG_OFF; 
                IC2_SEG043 = IC_SEG_OFF; 
                IC2_SEG044 = IC_SEG_OFF; 
            }
                else if(m_Gear==Gear_R) 
            {
                IC2_SEG034 = IC_SEG_ON;
                IC2_SEG033 = IC_SEG_ON;
                IC2_SEG031 = IC_SEG_ON;
                IC2_SEG050 = IC_SEG_ON; 
                IC2_SEG036 = IC_SEG_ON;
                IC2_SEG035 = IC_SEG_OFF;
                IC2_SEG049 = IC_SEG_ON;
                IC2_SEG037 = IC_SEG_ON; 
                IC2_SEG041 = IC_SEG_ON;
                IC2_SEG032 = IC_SEG_ON;
                IC2_SEG030 = IC_SEG_ON;
                IC2_SEG048 = IC_SEG_ON; 
                IC2_SEG038 = IC_SEG_ON;
                IC2_SEG046 = IC_SEG_ON;
                IC2_SEG047 = IC_SEG_OFF;
                IC2_SEG045 = IC_SEG_ON;
                IC2_SEG039 = IC_SEG_ON;
                IC2_SEG040 = IC_SEG_ON;
                IC2_SEG042 = IC_SEG_OFF; 
                IC2_SEG043 = IC_SEG_ON; 
                IC2_SEG044 = IC_SEG_ON; 
            }
                else if(m_Gear==Gear_N) 
            {
                IC2_SEG034 = IC_SEG_OFF;
                IC2_SEG033 = IC_SEG_ON;
                IC2_SEG031 = IC_SEG_OFF;
                IC2_SEG050 = IC_SEG_ON; 
                IC2_SEG036 = IC_SEG_ON;
                IC2_SEG035 = IC_SEG_ON;
                IC2_SEG049 = IC_SEG_ON;
                IC2_SEG037 = IC_SEG_ON;
                IC2_SEG041 = IC_SEG_OFF;
                IC2_SEG032 = IC_SEG_ON;
                IC2_SEG030 = IC_SEG_OFF;
                IC2_SEG048 = IC_SEG_ON;
                IC2_SEG038 = IC_SEG_ON;
                IC2_SEG046 = IC_SEG_ON;
                IC2_SEG047 = IC_SEG_ON;
                IC2_SEG045 = IC_SEG_ON;
                IC2_SEG039 = IC_SEG_OFF;
                IC2_SEG040 = IC_SEG_ON;
                IC2_SEG042 = IC_SEG_OFF; 
                IC2_SEG043 = IC_SEG_ON; 
                IC2_SEG044 = IC_SEG_ON;
            }
                else if(m_Gear==Gear_S) 
            {
                IC2_SEG034 = IC_SEG_OFF;
                IC2_SEG033 = IC_SEG_ON;
                IC2_SEG031 = IC_SEG_ON;
                IC2_SEG050 = IC_SEG_ON; 
                IC2_SEG036 = IC_SEG_ON;
                IC2_SEG035 = IC_SEG_OFF;
                IC2_SEG049 = IC_SEG_OFF;
                IC2_SEG037 = IC_SEG_ON;
                IC2_SEG041 = IC_SEG_ON;
                IC2_SEG032 = IC_SEG_ON;
                IC2_SEG030 = IC_SEG_ON;
                IC2_SEG048 = IC_SEG_ON;
                IC2_SEG038 = IC_SEG_OFF;
                IC2_SEG046 = IC_SEG_OFF;
                IC2_SEG047 = IC_SEG_ON;
                IC2_SEG045 = IC_SEG_ON;
                IC2_SEG039 = IC_SEG_OFF;
                IC2_SEG040 = IC_SEG_ON;
                IC2_SEG042 = IC_SEG_ON; 
                IC2_SEG043 = IC_SEG_ON; 
                IC2_SEG044 = IC_SEG_ON;
            }
                else 
            {
                IC2_SEG034 = IC_SEG_ON;
                IC2_SEG033 = IC_SEG_ON;
                IC2_SEG031 = IC_SEG_ON;
                IC2_SEG050 = IC_SEG_ON; 
                IC2_SEG036 = IC_SEG_ON;
                IC2_SEG035 = IC_SEG_OFF;
                IC2_SEG049 = IC_SEG_ON;
                IC2_SEG037 = IC_SEG_ON;
                IC2_SEG041 = IC_SEG_OFF;
                IC2_SEG032 = IC_SEG_OFF;
                IC2_SEG030 = IC_SEG_OFF;
                IC2_SEG048 = IC_SEG_ON;
                IC2_SEG038 = IC_SEG_ON;
                IC2_SEG046 = IC_SEG_OFF;
                IC2_SEG047 = IC_SEG_ON;
                IC2_SEG045 = IC_SEG_ON;
                IC2_SEG039 = IC_SEG_ON;
                IC2_SEG040 = IC_SEG_ON;
                IC2_SEG042 = IC_SEG_ON; 
                IC2_SEG043 = IC_SEG_ON; 
                IC2_SEG044 = IC_SEG_ON;
            }
      } 
      else
      {
          IC2_SEG034 = IC_SEG_OFF;
          IC2_SEG033 = IC_SEG_OFF;
          IC2_SEG031 = IC_SEG_OFF;
          IC2_SEG050 = IC_SEG_OFF; 
          IC2_SEG036 = IC_SEG_OFF;
          IC2_SEG035 = IC_SEG_OFF;
          IC2_SEG049 = IC_SEG_OFF;
          IC2_SEG037 = IC_SEG_OFF;
          IC2_SEG041 = IC_SEG_OFF;
          IC2_SEG032 = IC_SEG_OFF;
          IC2_SEG030 = IC_SEG_OFF;
          IC2_SEG048 = IC_SEG_OFF;
          IC2_SEG038 = IC_SEG_OFF;
          IC2_SEG046 = IC_SEG_OFF;
          IC2_SEG047 = IC_SEG_OFF;
          IC2_SEG045 = IC_SEG_OFF;
          IC2_SEG039 = IC_SEG_OFF;
          IC2_SEG040 = IC_SEG_OFF;
          IC2_SEG042 = IC_SEG_OFF; 
          IC2_SEG043 = IC_SEG_OFF; 
          IC2_SEG044 = IC_SEG_OFF;
      }
      
      m_Res = EX_OK;
   }

   return m_Res;

}

/**@brief 电量表盘显示函数
* @param[in]  m_Flag            段与数字是否显示     -1 显示 -0 不显示
* @param[in]  m_SEG             车速表盘段数0<=m_SEG<=10 
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/
_Fun_Res SEG_SET_EleDial(uint8_t m_Flag,uint8_t m_SEG,uint8_t m_NUM)
{

    _Fun_Res m_Res;
    uint8_t Num;
    uint8_t m8;

    if((m_Flag>=2u)||(m_SEG>10u)||(m_NUM>=200u)) 
    {
        m_Res = EX_ERR; 
    } 
    else 
    {
        if(m_Flag==1u) 
        {
            IC1_SEG022 = IC_SEG_GREY; 
            IC1_SEG021 = IC_SEG_GREY; 
            IC1_SEG020 = IC_SEG_GREY; 
            IC1_SEG019 = IC_SEG_GREY; 
            IC1_SEG018 = IC_SEG_GREY; 
            IC1_SEG017 = IC_SEG_GREY; 
            IC1_SEG016 = IC_SEG_GREY; 
            IC1_SEG015 = IC_SEG_GREY; 
            IC1_SEG014 = IC_SEG_GREY; 
            IC1_SEG013 = IC_SEG_GREY;
            switch (m_SEG) 
            {
            
            case 10u: IC1_SEG022 = IC_SEG_ON;
            case  9u: IC1_SEG021 = IC_SEG_ON;
            case  8u: IC1_SEG020 = IC_SEG_ON; 
            case  7u: IC1_SEG019 = IC_SEG_ON; 
            case  6u: IC1_SEG018 = IC_SEG_ON; 
            case  5u: IC1_SEG017 = IC_SEG_ON; 
            case  4u: IC1_SEG016 = IC_SEG_ON; 
            case  3u: IC1_SEG015 = IC_SEG_ON; 
            case  2u: IC1_SEG014 = IC_SEG_ON;
            case  1u: IC1_SEG013 = IC_SEG_ON;
            case  0u:break; 
            default:break;
            }
            
            IC1_SEG027 = IC_SEG_ON;
            IC1_SEG023 = IC_SEG_ON;


            
            /*单位*/
            IC1_SEG028 = IC_SEG_ON;
            /*百位*/
            Num = m_NUM / 100u;
            if(Num==1u) 
            {
                IC1_SEG043 = IC_SEG_ON;
            } 
            else 
            {
                IC1_SEG043 = IC_SEG_OFF;
            }
            /*十位*/
            Num = (m_NUM / 10u)%10u;
            if(m_NUM>=100u) 
            {
                m8 = SEG_DISPLAY_NUMBER0[Num];
            } 
            else 
            {
                m8 = SEG_UNDISPLAY_NUMBER0[Num];
            }

            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG040 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG040 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG039 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG039 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG037 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG037 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG036 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG036 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG042 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG042 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG041 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG041 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG038 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG038 = IC_SEG_OFF;
            }
            /*个位*/
            Num = m_NUM % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG033 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG033 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG032 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG032 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG030 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG030 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG029 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG029 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG035 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG035 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG034 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG034 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG031 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG031 = IC_SEG_OFF;
            }
        }   
        else 
        {
            IC1_SEG022 = IC_SEG_GREY; 
            IC1_SEG021 = IC_SEG_GREY; 
            IC1_SEG020 = IC_SEG_GREY; 
            IC1_SEG019 = IC_SEG_GREY; 
            IC1_SEG018 = IC_SEG_GREY; 
            IC1_SEG017 = IC_SEG_GREY; 
            IC1_SEG016 = IC_SEG_GREY; 
            IC1_SEG015 = IC_SEG_GREY; 
            IC1_SEG014 = IC_SEG_GREY; 
            IC1_SEG013 = IC_SEG_GREY; 

            IC1_SEG027 = IC_SEG_OFF;
            IC1_SEG023 = IC_SEG_OFF;

            IC1_SEG028 = IC_SEG_OFF;
            
            IC1_SEG043 = IC_SEG_OFF;
            IC1_SEG040 = IC_SEG_OFF;
            IC1_SEG039 = IC_SEG_OFF;
            IC1_SEG037 = IC_SEG_OFF;
            IC1_SEG036 = IC_SEG_OFF;
            IC1_SEG042 = IC_SEG_OFF;
            IC1_SEG041 = IC_SEG_OFF;
            IC1_SEG038 = IC_SEG_OFF;
            IC1_SEG033 = IC_SEG_OFF;
            IC1_SEG032 = IC_SEG_OFF;
            IC1_SEG030 = IC_SEG_OFF;
            IC1_SEG029 = IC_SEG_OFF;
            IC1_SEG035 = IC_SEG_OFF;
            IC1_SEG034 = IC_SEG_OFF;
            IC1_SEG031 = IC_SEG_OFF;
        }                 
        m_Res = EX_OK;    
    }
    return m_Res;
}

_Fun_Res SEG_Scan_SET_EleDial(uint8_t m_SEG)
{

    _Fun_Res m_Res=EX_OK;



    IC1_SEG022 = IC_SEG_GREY; 
    IC1_SEG021 = IC_SEG_GREY; 
    IC1_SEG020 = IC_SEG_GREY; 
    IC1_SEG019 = IC_SEG_GREY; 
    IC1_SEG018 = IC_SEG_GREY; 
    IC1_SEG017 = IC_SEG_GREY; 
    IC1_SEG016 = IC_SEG_GREY; 
    IC1_SEG015 = IC_SEG_GREY; 
    IC1_SEG014 = IC_SEG_GREY; 
    IC1_SEG013 = IC_SEG_GREY;
    switch (m_SEG) 
    {
    
    case 10u: IC1_SEG022 = IC_SEG_ON;
    case  9u: IC1_SEG021 = IC_SEG_ON;
    case  8u: IC1_SEG020 = IC_SEG_ON; 
    case  7u: IC1_SEG019 = IC_SEG_ON; 
    case  6u: IC1_SEG018 = IC_SEG_ON; 
    case  5u: IC1_SEG017 = IC_SEG_ON; 
    case  4u: IC1_SEG016 = IC_SEG_ON; 
    case  3u: IC1_SEG015 = IC_SEG_ON; 
    case  2u: IC1_SEG014 = IC_SEG_ON;
    case  1u: IC1_SEG013 = IC_SEG_ON;
    case  0u:break; 
    default:break;
    }


    IC1_SEG027 = IC_SEG_OFF;
    IC1_SEG023 = IC_SEG_OFF;

    IC1_SEG028 = IC_SEG_OFF;
    
    IC1_SEG043 = IC_SEG_OFF;
    IC1_SEG040 = IC_SEG_OFF;
    IC1_SEG039 = IC_SEG_OFF;
    IC1_SEG037 = IC_SEG_OFF;
    IC1_SEG036 = IC_SEG_OFF;
    IC1_SEG042 = IC_SEG_OFF;
    IC1_SEG041 = IC_SEG_OFF;
    IC1_SEG038 = IC_SEG_OFF;
    IC1_SEG033 = IC_SEG_OFF;
    IC1_SEG032 = IC_SEG_OFF;
    IC1_SEG030 = IC_SEG_OFF;
    IC1_SEG029 = IC_SEG_OFF;
    IC1_SEG035 = IC_SEG_OFF;
    IC1_SEG034 = IC_SEG_OFF;
    IC1_SEG031 = IC_SEG_OFF;

    return m_Res;
}


/**@brief 功率表盘显示函数
* @param[in]  m_Flag            段与数字是否显示     -1 显示 -0 不显示
* @param[in]  m_SEG             车速表盘段数0<=m_SEG<=12 
* @param[in]  m_Sign            显示功率值 负号
* @param[in]  m_NUM           显示功率值
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/
_Fun_Res SEG_SET_PowerDial(uint8_t m_Flag,uint8_t m_SEG,uint8_t m_Sign,uint8_t m_NUM)
{

   _Fun_Res m_Res;
    uint8_t Num;
    uint8_t m8;

   if((m_Flag>=2u)||(m_Sign>=2u)||((m_NUM>=200u)&&(m_NUM!=255u))) 
   {
      m_Res = EX_ERR; 
   } 
   else 
   {
      if(m_Flag==1u) 
      {
        IC2_SEG148  = IC_SEG_ON; 
        IC2_SEG145  = IC_SEG_ON; 
        IC2_SEG064  = IC_SEG_ON; 
        
        IC2_SEG067  = IC_SEG_GREY; 
        IC2_SEG069  = IC_SEG_GREY; 
        IC2_SEG071  = IC_SEG_GREY; 
        IC2_SEG073  = IC_SEG_GREY; 
        IC2_SEG141  = IC_SEG_GREY;  
        IC2_SEG142  = IC_SEG_GREY; 
        IC2_SEG143  = IC_SEG_GREY; 
        IC2_SEG144  = IC_SEG_GREY; 

        IC2_SEG147 = IC_SEG_GREY; 
        IC2_SEG146 = IC_SEG_GREY;
        
        if((m_SEG&0x80)==0x00u)
        {
            switch (m_SEG) 
            {
                case  8u:IC2_SEG067 = IC_SEG_ON; 
                case  7u:IC2_SEG069 = IC_SEG_ON; 
                case  6u:IC2_SEG071 = IC_SEG_ON;  
                case  5u:IC2_SEG073 = IC_SEG_ON; 
                case  4u:IC2_SEG141 = IC_SEG_ON; 
                case  3u:IC2_SEG142 = IC_SEG_ON; 
                case  2u:IC2_SEG143 = IC_SEG_ON;
                case  1u:IC2_SEG144 = IC_SEG_ON;
                case  0u:break; 
                default:break;
            }
        }
        else
        {
            switch (m_SEG) 
            {
                case  0x82u:IC2_SEG147  = IC_SEG_ON;
                case  0x81u:IC2_SEG146  = IC_SEG_ON;
                case  0x80u:break; 
                default:break;
            }
        }
        /*负号*/
        if(m_Sign == 1u)
        {
            IC2_SEG139 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG139 = IC_SEG_OFF;
        }
        /*单位*/
        IC2_SEG140 = IC_SEG_ON;
        /*百位*/
        if (m_NUM == 0xFF)
        {
            IC2_SEG133 = IC_SEG_ON;
            IC2_SEG126 = IC_SEG_ON;
            IC2_SEG138 = IC_SEG_OFF;
            IC2_SEG135 = IC_SEG_OFF;
            IC2_SEG134 = IC_SEG_OFF;
            IC2_SEG132 = IC_SEG_OFF;
            IC2_SEG131 = IC_SEG_OFF;
            IC2_SEG137 = IC_SEG_OFF;
            IC2_SEG136 = IC_SEG_OFF;
            IC2_SEG128 = IC_SEG_OFF;
            IC2_SEG127 = IC_SEG_OFF;
            IC2_SEG125 = IC_SEG_OFF;
            IC2_SEG124 = IC_SEG_OFF;
            IC2_SEG130 = IC_SEG_OFF;
            IC2_SEG129 = IC_SEG_OFF;
        }
        else
        {
            Num = m_NUM / 100u;
            if (Num == 1u)
            {
                IC2_SEG138 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG138 = IC_SEG_OFF;
            }
            /*十位*/
            Num = (m_NUM / 10u) % 10u;
            if (m_NUM >= 100u)
            {
                m8 = SEG_DISPLAY_NUMBER0[Num];
            }
            else
            {
                m8 = SEG_UNDISPLAY_NUMBER0[Num];
            }

            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG135 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG135 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG134 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG134 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG132 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG132 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG131 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG131 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG137 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG137 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG136 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG136 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG133 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG133 = IC_SEG_OFF;
            }
            /*个位*/
            Num = m_NUM % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG128 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG128 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG127 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG127 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG125 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG125 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG124 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG124 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG130 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG130 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG129 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG129 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG126 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG126 = IC_SEG_OFF;
            }
        }
      } 
      else 
      {
        IC2_SEG067  = IC_SEG_GREY; 
        IC2_SEG069  = IC_SEG_GREY; 
        IC2_SEG071  = IC_SEG_GREY; 
        IC2_SEG073  = IC_SEG_GREY; 
        IC2_SEG141  = IC_SEG_GREY; 
        IC2_SEG142  = IC_SEG_GREY; 
        IC2_SEG143  = IC_SEG_GREY; 
        IC2_SEG144  = IC_SEG_GREY; 
        IC2_SEG147  = IC_SEG_GREY; 
        IC2_SEG146  = IC_SEG_GREY;

        IC2_SEG148  = IC_SEG_OFF; 
        IC2_SEG145  = IC_SEG_OFF; 
        IC2_SEG064  = IC_SEG_OFF;  

        IC2_SEG139  = IC_SEG_OFF; 
        IC2_SEG140  = IC_SEG_OFF;  
        
        IC2_SEG138  = IC_SEG_OFF; 
        IC2_SEG135  = IC_SEG_OFF; 
        IC2_SEG134  = IC_SEG_OFF; 
        IC2_SEG132  = IC_SEG_OFF; 
        IC2_SEG131  = IC_SEG_OFF; 
        IC2_SEG137  = IC_SEG_OFF; 
        IC2_SEG136  = IC_SEG_OFF; 
        IC2_SEG133  = IC_SEG_OFF; 
        IC2_SEG128  = IC_SEG_OFF; 
        IC2_SEG127  = IC_SEG_OFF; 
        IC2_SEG125  = IC_SEG_OFF; 
        IC2_SEG124  = IC_SEG_OFF; 
        IC2_SEG130  = IC_SEG_OFF; 
        IC2_SEG129  = IC_SEG_OFF; 
        IC2_SEG126  = IC_SEG_OFF;             
      }                 
                        
      m_Res = EX_OK;    
   }
   return m_Res;
 
}

_Fun_Res SEG_Scan_SET_PowerDial(uint8_t m_SEG)
{

   _Fun_Res m_Res;


        IC2_SEG148  = IC_SEG_ON; 
        IC2_SEG145  = IC_SEG_ON; 
        IC2_SEG064  = IC_SEG_ON; 
        
        IC2_SEG067  = IC_SEG_GREY; 
        IC2_SEG069  = IC_SEG_GREY; 
        IC2_SEG071  = IC_SEG_GREY; 
        IC2_SEG073  = IC_SEG_GREY; 
        IC2_SEG141  = IC_SEG_GREY;  
        IC2_SEG142  = IC_SEG_GREY; 
        IC2_SEG143  = IC_SEG_GREY; 
        IC2_SEG144  = IC_SEG_GREY; 

        IC2_SEG147 = IC_SEG_GREY; 
        IC2_SEG146 = IC_SEG_GREY;

        switch (m_SEG) 
        { 
            case 10u:IC2_SEG067 = IC_SEG_ON; 
            case  9u:IC2_SEG069 = IC_SEG_ON; 
            case  8u:IC2_SEG071 = IC_SEG_ON; 
            case  7u:IC2_SEG073 = IC_SEG_ON; 
            case  6u:IC2_SEG141 = IC_SEG_ON;  
            case  5u:IC2_SEG142 = IC_SEG_ON; 
            case  4u:IC2_SEG143 = IC_SEG_ON; 
            case  3u:IC2_SEG144 = IC_SEG_ON; 
            case  2u:IC2_SEG146 = IC_SEG_ON;
            case  1u:IC2_SEG147 = IC_SEG_ON;
            case  0u:break; 
            default:break;
        }

        IC2_SEG148  = IC_SEG_OFF; 
        IC2_SEG145  = IC_SEG_OFF; 
        IC2_SEG064  = IC_SEG_OFF;  

        IC2_SEG139  = IC_SEG_OFF; 
        IC2_SEG140  = IC_SEG_OFF;  
        
        IC2_SEG138  = IC_SEG_OFF; 
        IC2_SEG135  = IC_SEG_OFF; 
        IC2_SEG134  = IC_SEG_OFF; 
        IC2_SEG132  = IC_SEG_OFF; 
        IC2_SEG131  = IC_SEG_OFF; 
        IC2_SEG137  = IC_SEG_OFF; 
        IC2_SEG136  = IC_SEG_OFF; 
        IC2_SEG133  = IC_SEG_OFF; 
        IC2_SEG128  = IC_SEG_OFF; 
        IC2_SEG127  = IC_SEG_OFF; 
        IC2_SEG125  = IC_SEG_OFF; 
        IC2_SEG124  = IC_SEG_OFF; 
        IC2_SEG130  = IC_SEG_OFF; 
        IC2_SEG129  = IC_SEG_OFF; 
        IC2_SEG126  = IC_SEG_OFF;             
               
                        
      m_Res = EX_OK;    

   return m_Res;
 
}

/**@brief 续航里程显示函数

* @param[in]  m_Flag           续航里程是否显示     -2 显示---km  -1 显示  -0 不显示
* @param[in]  m_NUM            续航里程数值   0<=m_NUM<=999
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/
_Fun_Res SEG_SET_DTE_NUM(uint8_t m_Flag, uint16_t m_NUM)
{
   _Fun_Res m_Res;
   uint16_t Num;
   uint8_t m8;
   if((m_Flag>2u)||(m_NUM>999u)) 
   {
      m_Res = EX_ERR; 
   } 
   else 
   {
      if (m_Flag == 1u)
        {
            IC1_SEG099 = IC_SEG_ON;
            IC1_SEG065 = IC_SEG_ON;
            /*百位*/
            Num = m_NUM / 100u;
            m8 = SEG_UNDISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG050 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG050 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG049 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG049 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG047 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG047 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG046 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG046 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG045 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG045 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG044 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG044 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG048 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG048 = IC_SEG_OFF;
            }
            /*十位*/
            Num = (m_NUM / 10u)%10u;
            if(m_NUM>=100u) 
            {
              m8 = SEG_DISPLAY_NUMBER0[Num];
            } 
            else 
            {
              m8 = SEG_UNDISPLAY_NUMBER0[Num];
            }
            
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG057 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG057 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG056 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG056 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG054 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG054 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG053 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG053 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG052 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG052 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG051 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG051 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG055 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG055 = IC_SEG_OFF;
            }
            /*个位*/
            Num = m_NUM % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG064 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG064 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG063 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG063 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG061 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG061 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG060 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG060 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG059 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG059 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG058 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG058 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG062 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG062 = IC_SEG_OFF;
            }
        }
        else if(m_Flag==2u)
        {
            IC1_SEG099 = IC_SEG_ON;
            IC1_SEG065 = IC_SEG_ON;

            IC1_SEG044    = IC_SEG_OFF;
            IC1_SEG045    = IC_SEG_OFF;
            IC1_SEG046    = IC_SEG_OFF;
            IC1_SEG047    = IC_SEG_OFF;
            IC1_SEG048    = IC_SEG_ON;
            IC1_SEG049    = IC_SEG_OFF;
            IC1_SEG050    = IC_SEG_OFF;
            IC1_SEG051    = IC_SEG_OFF;
            IC1_SEG052    = IC_SEG_OFF;
            IC1_SEG053    = IC_SEG_OFF;
            IC1_SEG054    = IC_SEG_OFF;
            IC1_SEG055    = IC_SEG_ON;
            IC1_SEG056    = IC_SEG_OFF;
            IC1_SEG057    = IC_SEG_OFF;
            IC1_SEG058    = IC_SEG_OFF;
            IC1_SEG059    = IC_SEG_OFF;
            IC1_SEG060    = IC_SEG_OFF;
            IC1_SEG061    = IC_SEG_OFF;
            IC1_SEG062    = IC_SEG_ON;
            IC1_SEG063    = IC_SEG_OFF;
            IC1_SEG064    = IC_SEG_OFF;
            
        }
        
        else
        {
            IC1_SEG099 = IC_SEG_OFF;
            IC1_SEG065 = IC_SEG_OFF;

            IC1_SEG044    = IC_SEG_OFF;
            IC1_SEG045    = IC_SEG_OFF;
            IC1_SEG046    = IC_SEG_OFF;
            IC1_SEG047    = IC_SEG_OFF;
            IC1_SEG048    = IC_SEG_OFF;
            IC1_SEG049    = IC_SEG_OFF;
            IC1_SEG050    = IC_SEG_OFF;
            IC1_SEG051    = IC_SEG_OFF;
            IC1_SEG052    = IC_SEG_OFF;
            IC1_SEG053    = IC_SEG_OFF;
            IC1_SEG054    = IC_SEG_OFF;
            IC1_SEG055    = IC_SEG_OFF;
            IC1_SEG056    = IC_SEG_OFF;
            IC1_SEG057    = IC_SEG_OFF;
            IC1_SEG058    = IC_SEG_OFF;
            IC1_SEG059    = IC_SEG_OFF;
            IC1_SEG060    = IC_SEG_OFF;
            IC1_SEG061    = IC_SEG_OFF;
            IC1_SEG062    = IC_SEG_OFF;
            IC1_SEG063    = IC_SEG_OFF;
            IC1_SEG064    = IC_SEG_OFF;
            
        }
   
      m_Res = EX_OK;
   }
   return m_Res;
 
}

/**@brief 车速8字段显示函数
* @param[in]  m_Flag            车速是否显示     -1 显示 -0 不显示
* @param[in]  m_NUM             车速数据      0<=m_NUM<=299
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/

_Fun_Res SEG_SET_VSpeed_NUM(uint8_t m_Flag , uint16_t m_NUM)
{
   _Fun_Res m_Res;
    uint16_t Num;
    uint8_t m8;
   if((m_Flag>2u)||(m_NUM>299u)) 
   {
      m_Res = EX_ERR; 
   } 
   else 
   {
      if (m_Flag == 1u)
        {
            IC1_SEG117 = IC_SEG_ON;
            /*百位*/
            Num = m_NUM / 100u;
            if(Num==1u) 
            {
              IC1_SEG102 = IC_SEG_ON;
            } 
            else 
            {
              IC1_SEG102 = IC_SEG_SPEED;
            }
            /*十位*/
            Num = (m_NUM / 10u)%10u;
            if(m_NUM>=100u) 
            {
              m8 = SEG_DISPLAY_NUMBER0[Num];
            } 
            else 
            {
              m8 = SEG_UNDISPLAY_NUMBER0[Num];
            }
            
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG109 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG109 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG108 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG108 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG106 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG106 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG105 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG105 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG104 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG104 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG103 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG103 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG107 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG107 = IC_SEG_SPEED;
            }
            /*个位*/
            Num = m_NUM % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG116 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG116 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG115 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG115 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG113 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG113 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG112 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG112 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG111 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG111 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG110 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG110 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG114 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG114 = IC_SEG_SPEED;
            }
        }
        else if(m_Flag == 2u)
        {
            IC1_SEG117     = IC_SEG_ON;

            IC1_SEG102     = IC_SEG_SPEED;
            IC1_SEG103     = IC_SEG_SPEED;
            IC1_SEG104     = IC_SEG_SPEED;
            IC1_SEG105     = IC_SEG_SPEED;
            IC1_SEG106     = IC_SEG_SPEED;
            IC1_SEG107     = IC_SEG_ON;
            IC1_SEG108     = IC_SEG_SPEED;
            IC1_SEG109     = IC_SEG_SPEED;
            IC1_SEG110     = IC_SEG_SPEED;
            IC1_SEG111     = IC_SEG_SPEED;
            IC1_SEG112     = IC_SEG_SPEED;
            IC1_SEG113     = IC_SEG_SPEED;
            IC1_SEG114     = IC_SEG_ON;
            IC1_SEG115     = IC_SEG_SPEED;
            IC1_SEG116     = IC_SEG_SPEED; 
        }
        else
        {
            IC1_SEG117     = IC_SEG_OFF;

            IC1_SEG102     = IC_SEG_SPEED;
            IC1_SEG103     = IC_SEG_SPEED;
            IC1_SEG104     = IC_SEG_SPEED;
            IC1_SEG105     = IC_SEG_SPEED;
            IC1_SEG106     = IC_SEG_SPEED;
            IC1_SEG107     = IC_SEG_SPEED;
            IC1_SEG108     = IC_SEG_SPEED;
            IC1_SEG109     = IC_SEG_SPEED;
            IC1_SEG110     = IC_SEG_SPEED;
            IC1_SEG111     = IC_SEG_SPEED;
            IC1_SEG112     = IC_SEG_SPEED;
            IC1_SEG113     = IC_SEG_SPEED;
            IC1_SEG114     = IC_SEG_SPEED;
            IC1_SEG115     = IC_SEG_SPEED;
            IC1_SEG116     = IC_SEG_SPEED;        
        }
      
   
      m_Res = EX_OK;
   }
   return m_Res;
 
}

/**@brief L8字段显示函数
* @param[in]  m_Flag            车速是否显示     -2 L-  -1 显示 -0 不显示
* @param[in]  m_NUM             车速数据      0<=m_NUM<=9
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/

_Fun_Res SEG_SET_L8_NUM(uint8_t m_Flag , uint8_t m_NUM)
{
   _Fun_Res m_Res;
    uint8_t Num;
    uint8_t m8;
   if((m_Flag>2u)||(m_NUM>9u)) 
   {
      m_Res = EX_ERR; 
   } 
   else 
   {
      if (m_Flag == 1u)
        {
            IC2_SEG051 = IC_SEG_ON;
            Num = m_NUM ;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG058 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG058 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG057 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG057 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG055 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG055 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG054 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG054 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG053 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG053 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG052 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG052 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG056 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG056 = IC_SEG_OFF;
            }
        }
        else if(m_Flag == 2u)
        {
            IC2_SEG051   = IC_SEG_ON;

            IC2_SEG052   = IC_SEG_OFF;
            IC2_SEG053   = IC_SEG_OFF;
            IC2_SEG054   = IC_SEG_OFF;
            IC2_SEG055   = IC_SEG_OFF;
            IC2_SEG056   = IC_SEG_ON;
            IC2_SEG057   = IC_SEG_OFF;
            IC2_SEG058   = IC_SEG_OFF;
        }  
        else
        {
            
            IC2_SEG051   = IC_SEG_OFF;

            IC2_SEG052   = IC_SEG_OFF;
            IC2_SEG053   = IC_SEG_OFF;
            IC2_SEG054   = IC_SEG_OFF;
            IC2_SEG055   = IC_SEG_OFF;
            IC2_SEG056   = IC_SEG_OFF;
            IC2_SEG057   = IC_SEG_OFF;
            IC2_SEG058   = IC_SEG_OFF;
        }
      
   
      m_Res = EX_OK;
   }
   return m_Res;
 
}

/**@brief 总计里程显示函数
* @param[in]  m_Flag            是否显示     -1 显示 -0 不显示
* @param[in]  m_NUM             显示数值  0<m_NUM<=999999
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/
_Fun_Res SEG_SET_ODO_NUM(uint8_t m_Flag,uint32_t m_NUM)
{

   _Fun_Res m_Res;
   uint32_t Num;
   uint8_t m8;
   if((m_Flag>2u)||(m_NUM>999999u)) 
   {
      m_Res = EX_ERR; 
   } 
   else 
   {
        if(m_Flag==1u) 
        {
            IC2_SEG074 = IC_SEG_ON;
            IC2_SEG117 = IC_SEG_ON;
            /*十万位*/
            Num = (m_NUM / 100000u);
            m8 = SEG_UNDISPLAY_NUMBER0[Num];
            
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG081 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG081 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG080 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG080 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG078 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG078 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG077 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG077 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG076 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG076 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG075 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG075 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG079 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG079 = IC_SEG_OFF;
            }
            /*万位*/
            Num = (m_NUM / 10000u)%10u;
            if(m_NUM>99999u) 
            {
               m8 = SEG_DISPLAY_NUMBER0[Num];
            } 
            else 
            {
               m8 = SEG_UNDISPLAY_NUMBER0[Num];
            }
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG088 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG088 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG087 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG087 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG085 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG085 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG084 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG084 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG083 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG083 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG082 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG082 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG086 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG086 = IC_SEG_OFF;
            }
            /*千位*/
            Num = (m_NUM / 1000u)%10u;
            if(m_NUM>9999u) 
            {
               m8 = SEG_DISPLAY_NUMBER0[Num];
            } 
            else 
            {
               m8 = SEG_UNDISPLAY_NUMBER0[Num];
            }
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG095 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG095 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG094 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG094 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG092 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG092 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG091 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG091 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG090 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG090 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG089 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG089 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG093 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG093 = IC_SEG_OFF;
            }
            /*百位*/
            Num = (m_NUM / 100u)%10u;
            if(m_NUM>999u) 
            {
               m8 = SEG_DISPLAY_NUMBER0[Num];
            } 
            else 
            {
               m8 = SEG_UNDISPLAY_NUMBER0[Num];
            }
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG102 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG102 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG101 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG101 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG099 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG099 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG098 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG098 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG097 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG097 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG096 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG096 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG100 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG100 = IC_SEG_OFF;
            }
            /*十位*/
            Num = (m_NUM / 10u)%10u;
            if(m_NUM>99u) 
            {
               m8 = SEG_DISPLAY_NUMBER0[Num];
            } 
            else 
            {
               m8 = SEG_UNDISPLAY_NUMBER0[Num];
            }
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG109 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG109 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG108 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG108 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG106 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG106 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG105 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG105 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG104 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG104 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG103 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG103 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG107 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG107 = IC_SEG_OFF;
            }
            /*个位*/
            Num = m_NUM % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG116 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG116 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG115 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG115 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG113 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG113 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG112 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG112 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG111 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG111 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG110 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG110 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG114 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG114 = IC_SEG_OFF;
            }
            
        
            
        }
        else 
        {
            IC2_SEG074   = IC_SEG_OFF;
            IC2_SEG117   = IC_SEG_OFF;

            IC2_SEG075   = IC_SEG_OFF;
            IC2_SEG076   = IC_SEG_OFF;
            IC2_SEG077   = IC_SEG_OFF;
            IC2_SEG078   = IC_SEG_OFF;
            IC2_SEG079   = IC_SEG_OFF;
            IC2_SEG080   = IC_SEG_OFF;
            IC2_SEG081   = IC_SEG_OFF;
            IC2_SEG082   = IC_SEG_OFF;
            IC2_SEG083   = IC_SEG_OFF;
            IC2_SEG084   = IC_SEG_OFF;
            IC2_SEG085   = IC_SEG_OFF;
            IC2_SEG086   = IC_SEG_OFF;
            IC2_SEG087   = IC_SEG_OFF;
            IC2_SEG088   = IC_SEG_OFF;
            IC2_SEG089   = IC_SEG_OFF;
            IC2_SEG090   = IC_SEG_OFF;
            IC2_SEG091   = IC_SEG_OFF;
            IC2_SEG092   = IC_SEG_OFF;
            IC2_SEG093   = IC_SEG_OFF;
            IC2_SEG094   = IC_SEG_OFF;
            IC2_SEG095   = IC_SEG_OFF;
            IC2_SEG096   = IC_SEG_OFF;
            IC2_SEG097   = IC_SEG_OFF;
            IC2_SEG098   = IC_SEG_OFF;
            IC2_SEG099   = IC_SEG_OFF;
            IC2_SEG100   = IC_SEG_OFF;
            IC2_SEG101   = IC_SEG_OFF;
            IC2_SEG102   = IC_SEG_OFF;
            IC2_SEG103   = IC_SEG_OFF;
            IC2_SEG104   = IC_SEG_OFF;
            IC2_SEG105   = IC_SEG_OFF;
            IC2_SEG106   = IC_SEG_OFF;
            IC2_SEG107   = IC_SEG_OFF;
            IC2_SEG108   = IC_SEG_OFF;
            IC2_SEG109   = IC_SEG_OFF;
            IC2_SEG110   = IC_SEG_OFF;
            IC2_SEG111   = IC_SEG_OFF;
            IC2_SEG112   = IC_SEG_OFF;
            IC2_SEG113   = IC_SEG_OFF;
            IC2_SEG114   = IC_SEG_OFF;
            IC2_SEG115   = IC_SEG_OFF;
            IC2_SEG116   = IC_SEG_OFF;
        }
            
   
      m_Res = EX_OK;
   }
   return m_Res;
 

}

/**@brief 小计里程显示函数
* @param[in]  m_Flag            是否显示     -1 显示 -0 不显示
* @param[in]  m_NUM             显示数值     0<m_NUM<=999.9
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/
_Fun_Res SEG_SET_TRIP_NUM(uint8_t m_Flag,uint16_t m_NUM)
{
   _Fun_Res m_Res;
   uint16_t Num;
   uint8_t m8;
   if((m_Flag>2u)||(m_NUM>9999u)) 
   {
      m_Res = EX_ERR; 
   } 
   else 
   {
        if(m_Flag==1u) 
        {
            IC1_SEG066 = IC_SEG_ON;
            IC1_SEG088 = IC_SEG_ON;
            IC1_SEG096 = IC_SEG_ON;
            
            /*千位*/
            Num = (m_NUM / 1000u)%10u;
            m8 = SEG_UNDISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG073 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG073 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG072 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG072 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG070 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG070 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG069 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG069 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG068 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG068 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG067 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG067 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG071 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG071 = IC_SEG_OFF;
            }
            /*百位*/
            Num = (m_NUM / 100u)%10u;
            if(m_NUM>999u) 
            {
               m8 = SEG_DISPLAY_NUMBER0[Num];
            } 
            else 
            {
               m8 = SEG_UNDISPLAY_NUMBER0[Num];
            }
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG080 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG080 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG079 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG079 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG077 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG077 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG076 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG076 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG075 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG075 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG074 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG074 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG078 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG078 = IC_SEG_OFF;
            }
            /*十位*/
            Num = (m_NUM / 10u)%10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG087 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG087 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG086 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG086 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG084 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG084 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG083 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG083 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG082 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG082 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG081 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG081 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG085 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG085 = IC_SEG_OFF;
            }
            /*个位*/
            Num = m_NUM%10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG095 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG095 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG094 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG094 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG092 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG092 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG091 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG091 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG090 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG090 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG089 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG089 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG093 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG093 = IC_SEG_OFF;
            }
            
        }
        else if(m_Flag == 2u)
        {
            IC1_SEG066    = IC_SEG_ON;
            IC1_SEG088    = IC_SEG_ON;
            IC1_SEG096    = IC_SEG_ON;

            IC1_SEG067    = IC_SEG_OFF;
            IC1_SEG068    = IC_SEG_OFF;
            IC1_SEG069    = IC_SEG_ON;
            IC1_SEG070    = IC_SEG_OFF;
            IC1_SEG071    = IC_SEG_OFF;
            IC1_SEG072    = IC_SEG_OFF;
            IC1_SEG073    = IC_SEG_OFF;
            IC1_SEG074    = IC_SEG_OFF;
            IC1_SEG075    = IC_SEG_OFF;
            IC1_SEG076    = IC_SEG_ON;
            IC1_SEG077    = IC_SEG_OFF;
            IC1_SEG078    = IC_SEG_OFF;
            IC1_SEG079    = IC_SEG_OFF;
            IC1_SEG080    = IC_SEG_OFF;
            IC1_SEG081    = IC_SEG_OFF;
            IC1_SEG082    = IC_SEG_OFF;
            IC1_SEG083    = IC_SEG_ON;
            IC1_SEG084    = IC_SEG_OFF;
            IC1_SEG085    = IC_SEG_OFF;
            IC1_SEG086    = IC_SEG_OFF;
            IC1_SEG087    = IC_SEG_OFF;
            IC1_SEG089    = IC_SEG_OFF;
            IC1_SEG090    = IC_SEG_OFF;
            IC1_SEG091    = IC_SEG_ON;
            IC1_SEG092    = IC_SEG_OFF;
            IC1_SEG093    = IC_SEG_OFF;
            IC1_SEG094    = IC_SEG_OFF;
            IC1_SEG095    = IC_SEG_OFF;
        }

        else 
        {
            
            IC1_SEG066    = IC_SEG_OFF;
            IC1_SEG088    = IC_SEG_OFF;
            IC1_SEG096    = IC_SEG_OFF;

            IC1_SEG067    = IC_SEG_OFF;
            IC1_SEG068    = IC_SEG_OFF;
            IC1_SEG069    = IC_SEG_OFF;
            IC1_SEG070    = IC_SEG_OFF;
            IC1_SEG071    = IC_SEG_OFF;
            IC1_SEG072    = IC_SEG_OFF;
            IC1_SEG073    = IC_SEG_OFF;
            IC1_SEG074    = IC_SEG_OFF;
            IC1_SEG075    = IC_SEG_OFF;
            IC1_SEG076    = IC_SEG_OFF;
            IC1_SEG077    = IC_SEG_OFF;
            IC1_SEG078    = IC_SEG_OFF;
            IC1_SEG079    = IC_SEG_OFF;
            IC1_SEG080    = IC_SEG_OFF;
            IC1_SEG081    = IC_SEG_OFF;
            IC1_SEG082    = IC_SEG_OFF;
            IC1_SEG083    = IC_SEG_OFF;
            IC1_SEG084    = IC_SEG_OFF;
            IC1_SEG085    = IC_SEG_OFF;
            IC1_SEG086    = IC_SEG_OFF;
            IC1_SEG087    = IC_SEG_OFF;
            IC1_SEG089    = IC_SEG_OFF;
            IC1_SEG090    = IC_SEG_OFF;
            IC1_SEG091    = IC_SEG_OFF;
            IC1_SEG092    = IC_SEG_OFF;
            IC1_SEG093    = IC_SEG_OFF;
            IC1_SEG094    = IC_SEG_OFF;
            IC1_SEG095    = IC_SEG_OFF;
        }
            
   
      m_Res = EX_OK;
   }
   return m_Res;
 
}

/**@brief 时间显示函数
* @param[in]  m_hour            小时
* @param[in]  m_minute          分钟
* @param[in]  m_icon            中间冒号是否显示 -1 显示 -0 不显示
* @param[in]  m_Flag1           小时是否显示     -1 显示 -0 不显示
* @param[in]  m_Flag2           分钟是否显示     -1 显示 -0 不显示
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/
_Fun_Res SEG_SET_Clock(uint8_t m_hour, uint8_t m_minute, uint8_t m_icon, uint8_t m_Flag1, uint8_t m_Flag2 )
{
    _Fun_Res m_Res;
    uint8_t Num;
    uint8_t m8;
    if ((m_hour >= 24u) || (m_minute >= 60u) || (m_icon > 1u) || (m_Flag1 > 1u) || (m_Flag2 > 1u))
    {
        m_Res = EX_ERR;
    }
    else
    {
        if (m_icon == 1u)
        {
            IC2_SEG166 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG166 = IC_SEG_OFF;
        }
        if (m_Flag1 == 1u)
        {
            Num = m_hour / 10u;/*86104-11*/
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG178 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG178 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG177 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG177 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG175 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG175 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG174 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG174 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG180 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG180 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG179 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG179 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG176 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG176 = IC_SEG_OFF;
            }
            Num = m_hour % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG171 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG171 = IC_SEG_OFF;
            }                   
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG170 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG170 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG168 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG168 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG167 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG167 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG173 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG173 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG172 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG172 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG169 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG169 = IC_SEG_OFF;
            }
        }
        else
        {
            IC2_SEG178 = IC_SEG_OFF;
            IC2_SEG177 = IC_SEG_OFF;
            IC2_SEG175 = IC_SEG_OFF;
            IC2_SEG174 = IC_SEG_OFF;
            IC2_SEG180 = IC_SEG_OFF;
            IC2_SEG179 = IC_SEG_OFF;
            IC2_SEG176 = IC_SEG_OFF;
            IC2_SEG171 = IC_SEG_OFF;
            IC2_SEG170 = IC_SEG_OFF;
            IC2_SEG168 = IC_SEG_OFF;
            IC2_SEG167 = IC_SEG_OFF;
            IC2_SEG173 = IC_SEG_OFF;
            IC2_SEG172 = IC_SEG_OFF;
            IC2_SEG169 = IC_SEG_OFF;
        }
        if (m_Flag2 == 1u)
        {
            Num = m_minute / 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG163 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG163 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG162 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG162 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG160 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG160 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG159 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG159 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG165 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG165 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG164 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG164 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG161 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG161 = IC_SEG_OFF;
            }
            Num = m_minute % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG156 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG156 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG155 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG155 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG153 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG153 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG152 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG152 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG158 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG158 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG157 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG157 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG154 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG154 = IC_SEG_OFF;
            }
        }
        else
        {
            IC2_SEG163   = IC_SEG_OFF;
            IC2_SEG162   = IC_SEG_OFF;
            IC2_SEG160   = IC_SEG_OFF;
            IC2_SEG159   = IC_SEG_OFF;
            IC2_SEG165   = IC_SEG_OFF;
            IC2_SEG164   = IC_SEG_OFF;
            IC2_SEG161   = IC_SEG_OFF;
            IC2_SEG156   = IC_SEG_OFF;
            IC2_SEG155   = IC_SEG_OFF;
            IC2_SEG153   = IC_SEG_OFF;
            IC2_SEG152   = IC_SEG_OFF;
            IC2_SEG158   = IC_SEG_OFF;
            IC2_SEG157   = IC_SEG_OFF;
            IC2_SEG154   = IC_SEG_OFF;
        }
        m_Res = EX_OK;
    }
    return m_Res;
}


//-------------------------------------------------------------------------------------------------------------
/**@brief 边框线显示函数
* @param[in]  m_Flag           是否显示     -1 显示 -0 不显示
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/

_Fun_Res SEG_SET_Frame1(uint8_t m_Flag)
{
   _Fun_Res m_Res;
   if(m_Flag>=2u) 
   {
      m_Res = EX_ERR; 
   } 
   else 
   {
      if(m_Flag==0u) 
      {
        /*边框*/
        IC1_SEG026  = IC_SEG_OFF;
        IC2_SEG149  = IC_SEG_OFF;
        
      } 
      else 
      {
        /*边框*/
        IC1_SEG026  = IC_SEG_ON;
        IC2_SEG149  = IC_SEG_ON;
      }
      m_Res = EX_OK;
   }
   return m_Res;
  
}


/**@brief 指示灯显示函数
* @param[in]  m_Flag           是否显示     -1 显示 -0 不显示
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/

_Fun_Res SEG_SET_LED_STS1(uint8_t LED_NUM , uint8_t m_Flag)
{
   _Fun_Res m_Res;
   uint8_t  Flag;
   uint8_t Num;
   if((m_Flag>7u)||(LED_NUM>=SEG_LED_MAX)) 
   {
      m_Res = EX_ERR; 
   } 
   else 
   {
      if(m_Flag==0u) 
      {
        Flag=IC_SEG_OFF;
      } 
      else 
      {
        Flag=IC_SEG_ON;
      }
      Num=LED_NUM;
      switch(Num)
      {
      case 0u : IC1_SEG001   = Flag;  break;       /* SEG_LED_TurnLeft,          */
      case 1u : IC2_SEG063   = Flag;  break;       /* SEG_LED_TurnRight,         */
      case 2u : IC1_SEG002   = Flag;  break;       /* SEG_LED_Hbeam,          */
      case 3u : IC1_SEG003   = Flag;  break;       /* SEG_LED_Lbeam,           */
      case 4u : IC2_SEG062   = Flag;  break;       /* SEG_LED_Position*/ 
      case 5u : IC2_SEG060   = Flag;  break;       /* SEG_LED_RearFog*/ 
      case 6u : IC2_SEG061   = Flag;  break;       /* SEG_LED_Daylight*/ 
      case 7u : IC1_SEG006   = Flag;  break;       /* SEG_LED_ABS*/ 
      case 8u : IC1_SEG005   = Flag;  break;       /* SEG_LED_EBD_fault*/ 
      case 9u : IC1_SEG007   = Flag;  break;       /* SEG_LED_BrakeSystemFault*/ 
      case 10u: IC1_SEG101   = Flag;  break;       /* SEG_LED_EPB_Status*/ 
      case 11u: IC2_SEG065   = Flag;  break;       /* SEG_LED_EPS*/ 
      case 12u: IC2_SEG066   = Flag;  break;       /* SEG_LED_SEATBELT_DR*/ 
      case 13u: IC1_SEG009   = Flag;  break;       /* SEG_LED_SOC_CF*/ 
      case 14u: IC1_SEG098   = Flag;  break;       /* SEG_LED_SOC_CC*/ 
      case 15u: IC1_SEG100   = Flag;  break;       /* SEG_LED_SOC_CS*/ 
      case 16u: IC1_SEG012   = Flag;  break;       /* SEG_LED_SOC_LP*/ 
      case 17u: IC1_SEG010   = Flag;  break;       /* SEG_LED_SOC_Fault*/ 
      case 18u: IC1_SEG008   = Flag;  break;       /* SEG_LED_SOC_HT*/ 
      case 19u: IC2_SEG059   = Flag;  break;       /* SEG_LED_SystemFault*/ 
      case 20u: IC1_SEG004   = Flag;  break;       /* SEG_LED_READY*/ 
      case 21u: IC2_SEG121   = Flag;  break;       /* SEG_LED_MotorFault*/ 
      case 22u: IC2_SEG120   = Flag;  break;       /* SEG_LED_PowerLimit*/ 
      case 23u: IC2_SEG070   = Flag;  break;       /* SEG_LED_ECO*/ 
      case 24u: IC1_SEG097   = Flag;  break;       /* SEG_LED_InsulationFault*/ 
      case 25u: IC2_SEG072   = Flag;  break;       /* SEG_LED_Energy_Recovery*/ 
      case 26u: IC2_SEG119   = Flag;  break;       /* SEG_LED_WeightOverload*/ 
      case 27u: IC2_SEG068   = Flag;  break;       /* SEG_LED_DoorOpen*/ 
      case 28u: IC2_SEG123   = Flag;  break;       /* SEG_LED_OTA*/ //LED_FrontFog
      case 29u: IC2_SEG028   = Flag; IC2_SEG029 = Flag; break;       /* SEG_LED_RemoteLocking*/ 
      case 30u: IC2_SEG122   = Flag;  break;       /* SEG_LED_maintainWarning*/ 
      case 31u: IC2_SEG118   = Flag;  break;       /* SEG_LED_EWP*/ 
      case 32u: IC1_SEG011   = Flag;  break;       /* SEG_LED_SOC_DC*/ 
      
      default: break;
      }
      
      m_Res = EX_OK;
   }
   return m_Res;
  
}

/**@brief 挡位显示函数
* @param[in]  m_Gear_Flag     挡位符号是否显示     -1 显示 -0 不显示
* @param[in]  m_Gear          符号             Gear_P = 0,  //P
                                               Gear_R,      //R
                                               Gear_N,      //N
                                               Gear_D,      //D

* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/

_Fun_Res SEG_SET_GEAR1(uint8_t m_Gear_Flag,uint8_t m_Gear)
{
   _Fun_Res m_Res ;
    if((m_Gear_Flag>=2u)||(m_Gear>3u)) 
   {
      m_Res = EX_ERR; 
   } 
   else 
   {
      /*挡位符号*/
      if(m_Gear_Flag==1u) 
      {
            if(m_Gear==Gear_P) 
            {
                IC2_SEG034 = IC_SEG_ON;
                IC2_SEG033 = IC_SEG_ON;
                IC2_SEG031 = IC_SEG_ON;
                IC2_SEG050 = IC_SEG_ON; 
                IC2_SEG036 = IC_SEG_ON;
                IC2_SEG035 = IC_SEG_OFF;
                IC2_SEG049 = IC_SEG_ON;
                IC2_SEG037 = IC_SEG_ON; 
                IC2_SEG041 = IC_SEG_ON;
                IC2_SEG032 = IC_SEG_ON;
                IC2_SEG030 = IC_SEG_ON;
                IC2_SEG048 = IC_SEG_ON; 
                IC2_SEG038 = IC_SEG_ON;
                IC2_SEG046 = IC_SEG_OFF;
                IC2_SEG047 = IC_SEG_OFF;
                IC2_SEG045 = IC_SEG_OFF;
                IC2_SEG039 = IC_SEG_ON;
                IC2_SEG040 = IC_SEG_ON;
                IC2_SEG042 = IC_SEG_OFF; 
                IC2_SEG043 = IC_SEG_OFF; 
                IC2_SEG044 = IC_SEG_OFF; 
            }
                else if(m_Gear==Gear_R) 
            {
                IC2_SEG034 = IC_SEG_ON;
                IC2_SEG033 = IC_SEG_ON;
                IC2_SEG031 = IC_SEG_ON;
                IC2_SEG050 = IC_SEG_ON; 
                IC2_SEG036 = IC_SEG_ON;
                IC2_SEG035 = IC_SEG_OFF;
                IC2_SEG049 = IC_SEG_ON;
                IC2_SEG037 = IC_SEG_ON; 
                IC2_SEG041 = IC_SEG_ON;
                IC2_SEG032 = IC_SEG_ON;
                IC2_SEG030 = IC_SEG_ON;
                IC2_SEG048 = IC_SEG_ON; 
                IC2_SEG038 = IC_SEG_ON;
                IC2_SEG046 = IC_SEG_ON;
                IC2_SEG047 = IC_SEG_OFF;
                IC2_SEG045 = IC_SEG_ON;
                IC2_SEG039 = IC_SEG_ON;
                IC2_SEG040 = IC_SEG_ON;
                IC2_SEG042 = IC_SEG_OFF; 
                IC2_SEG043 = IC_SEG_ON; 
                IC2_SEG044 = IC_SEG_ON; 
            }
                else if(m_Gear==Gear_N) 
            {
                IC2_SEG034 = IC_SEG_OFF;
                IC2_SEG033 = IC_SEG_ON;
                IC2_SEG031 = IC_SEG_OFF;
                IC2_SEG050 = IC_SEG_ON; 
                IC2_SEG036 = IC_SEG_ON;
                IC2_SEG035 = IC_SEG_ON;
                IC2_SEG049 = IC_SEG_ON;
                IC2_SEG037 = IC_SEG_ON;
                IC2_SEG041 = IC_SEG_OFF;
                IC2_SEG032 = IC_SEG_ON;
                IC2_SEG030 = IC_SEG_OFF;
                IC2_SEG048 = IC_SEG_ON;
                IC2_SEG038 = IC_SEG_ON;
                IC2_SEG046 = IC_SEG_ON;
                IC2_SEG047 = IC_SEG_ON;
                IC2_SEG045 = IC_SEG_ON;
                IC2_SEG039 = IC_SEG_OFF;
                IC2_SEG040 = IC_SEG_ON;
                IC2_SEG042 = IC_SEG_OFF; 
                IC2_SEG043 = IC_SEG_ON; 
                IC2_SEG044 = IC_SEG_ON;
            }
                else if(m_Gear==Gear_S) 
            {
                IC2_SEG034 = IC_SEG_OFF;
                IC2_SEG033 = IC_SEG_ON;
                IC2_SEG031 = IC_SEG_ON;
                IC2_SEG050 = IC_SEG_ON; 
                IC2_SEG036 = IC_SEG_ON;
                IC2_SEG035 = IC_SEG_OFF;
                IC2_SEG049 = IC_SEG_OFF;
                IC2_SEG037 = IC_SEG_ON;
                IC2_SEG041 = IC_SEG_ON;
                IC2_SEG032 = IC_SEG_ON;
                IC2_SEG030 = IC_SEG_ON;
                IC2_SEG048 = IC_SEG_ON;
                IC2_SEG038 = IC_SEG_OFF;
                IC2_SEG046 = IC_SEG_OFF;
                IC2_SEG047 = IC_SEG_ON;
                IC2_SEG045 = IC_SEG_ON;
                IC2_SEG039 = IC_SEG_OFF;
                IC2_SEG040 = IC_SEG_ON;
                IC2_SEG042 = IC_SEG_ON; 
                IC2_SEG043 = IC_SEG_ON; 
                IC2_SEG044 = IC_SEG_ON;
            }
                else 
            {
                IC2_SEG034 = IC_SEG_ON;
                IC2_SEG033 = IC_SEG_ON;
                IC2_SEG031 = IC_SEG_ON;
                IC2_SEG050 = IC_SEG_ON; 
                IC2_SEG036 = IC_SEG_ON;
                IC2_SEG035 = IC_SEG_OFF;
                IC2_SEG049 = IC_SEG_ON;
                IC2_SEG037 = IC_SEG_ON;
                IC2_SEG041 = IC_SEG_OFF;
                IC2_SEG032 = IC_SEG_OFF;
                IC2_SEG030 = IC_SEG_OFF;
                IC2_SEG048 = IC_SEG_ON;
                IC2_SEG038 = IC_SEG_ON;
                IC2_SEG046 = IC_SEG_OFF;
                IC2_SEG047 = IC_SEG_ON;
                IC2_SEG045 = IC_SEG_ON;
                IC2_SEG039 = IC_SEG_ON;
                IC2_SEG040 = IC_SEG_ON;
                IC2_SEG042 = IC_SEG_ON; 
                IC2_SEG043 = IC_SEG_ON; 
                IC2_SEG044 = IC_SEG_ON;
            }
      } 
      else
      {
          IC2_SEG034 = IC_SEG_OFF;
          IC2_SEG033 = IC_SEG_OFF;
          IC2_SEG031 = IC_SEG_OFF;
          IC2_SEG050 = IC_SEG_OFF; 
          IC2_SEG036 = IC_SEG_OFF;
          IC2_SEG035 = IC_SEG_OFF;
          IC2_SEG049 = IC_SEG_OFF;
          IC2_SEG037 = IC_SEG_OFF;
          IC2_SEG041 = IC_SEG_OFF;
          IC2_SEG032 = IC_SEG_OFF;
          IC2_SEG030 = IC_SEG_OFF;
          IC2_SEG048 = IC_SEG_OFF;
          IC2_SEG038 = IC_SEG_OFF;
          IC2_SEG046 = IC_SEG_OFF;
          IC2_SEG047 = IC_SEG_OFF;
          IC2_SEG045 = IC_SEG_OFF;
          IC2_SEG039 = IC_SEG_OFF;
          IC2_SEG040 = IC_SEG_OFF;
          IC2_SEG042 = IC_SEG_OFF; 
          IC2_SEG043 = IC_SEG_OFF; 
          IC2_SEG044 = IC_SEG_OFF;
      }
      
      m_Res = EX_OK;
   }

   return m_Res;

}

/**@brief 电量表盘显示函数
* @param[in]  m_Flag            段与数字是否显示     -1 显示 -0 不显示
* @param[in]  m_SEG             车速表盘段数0<=m_SEG<=10 
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/
_Fun_Res SEG_SET_EleDial1(uint8_t m_Flag,uint8_t m_SEG,uint32_t m_NUM)
{

    _Fun_Res m_Res;
    uint8_t Num;
    uint8_t m8;

    if((m_Flag>=2u)||(m_SEG>10u)||(m_NUM>999u)) 
    {
        m_Res = EX_ERR; 
    } 
    else 
    {
        if(m_Flag==1u) 
        {
            IC1_SEG022 = IC_SEG_GREY; 
            IC1_SEG021 = IC_SEG_GREY; 
            IC1_SEG020 = IC_SEG_GREY; 
            IC1_SEG019 = IC_SEG_GREY; 
            IC1_SEG018 = IC_SEG_GREY; 
            IC1_SEG017 = IC_SEG_GREY; 
            IC1_SEG016 = IC_SEG_GREY; 
            IC1_SEG015 = IC_SEG_GREY; 
            IC1_SEG014 = IC_SEG_GREY; 
            IC1_SEG013 = IC_SEG_GREY;
            
            
            IC1_SEG027 = IC_SEG_ON;
            IC1_SEG023 = IC_SEG_ON;


            
            /*单位*/
            IC1_SEG028 = IC_SEG_ON;
            /*百位*/
            Num = m_NUM / 100u;
            
                IC1_SEG043 = IC_SEG_ON;
            
            /*十位*/
            Num = (m_NUM / 10u)%10u;
            
                m8 = SEG_DISPLAY_NUMBER0[Num];
            

            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG040 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG040 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG039 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG039 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG037 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG037 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG036 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG036 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG042 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG042 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG041 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG041 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG038 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG038 = IC_SEG_OFF;
            }
            /*个位*/
            Num = m_NUM % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG033 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG033 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG032 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG032 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG030 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG030 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG029 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG029 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG035 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG035 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG034 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG034 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG031 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG031 = IC_SEG_OFF;
            }
        }   
        else 
        {
            IC1_SEG022 = IC_SEG_GREY; 
            IC1_SEG021 = IC_SEG_GREY; 
            IC1_SEG020 = IC_SEG_GREY; 
            IC1_SEG019 = IC_SEG_GREY; 
            IC1_SEG018 = IC_SEG_GREY; 
            IC1_SEG017 = IC_SEG_GREY; 
            IC1_SEG016 = IC_SEG_GREY; 
            IC1_SEG015 = IC_SEG_GREY; 
            IC1_SEG014 = IC_SEG_GREY; 
            IC1_SEG013 = IC_SEG_GREY; 

            IC1_SEG027 = IC_SEG_OFF;
            IC1_SEG023 = IC_SEG_OFF;

            IC1_SEG028 = IC_SEG_OFF;
            
            IC1_SEG043 = IC_SEG_OFF;
            IC1_SEG040 = IC_SEG_OFF;
            IC1_SEG039 = IC_SEG_OFF;
            IC1_SEG037 = IC_SEG_OFF;
            IC1_SEG036 = IC_SEG_OFF;
            IC1_SEG042 = IC_SEG_OFF;
            IC1_SEG041 = IC_SEG_OFF;
            IC1_SEG038 = IC_SEG_OFF;
            IC1_SEG033 = IC_SEG_OFF;
            IC1_SEG032 = IC_SEG_OFF;
            IC1_SEG030 = IC_SEG_OFF;
            IC1_SEG029 = IC_SEG_OFF;
            IC1_SEG035 = IC_SEG_OFF;
            IC1_SEG034 = IC_SEG_OFF;
            IC1_SEG031 = IC_SEG_OFF;
        }                 
        m_Res = EX_OK;    
    }
    return m_Res;
}

_Fun_Res SEG_Scan_SET_EleDial1(uint8_t m_SEG)
{

    _Fun_Res m_Res=EX_OK;



    IC1_SEG022 = IC_SEG_GREY; 
    IC1_SEG021 = IC_SEG_GREY; 
    IC1_SEG020 = IC_SEG_GREY; 
    IC1_SEG019 = IC_SEG_GREY; 
    IC1_SEG018 = IC_SEG_GREY; 
    IC1_SEG017 = IC_SEG_GREY; 
    IC1_SEG016 = IC_SEG_GREY; 
    IC1_SEG015 = IC_SEG_GREY; 
    IC1_SEG014 = IC_SEG_GREY; 
    IC1_SEG013 = IC_SEG_GREY;
    switch (m_SEG) 
    {
    
    case 10u: IC1_SEG022 = IC_SEG_ON;
    case  9u: IC1_SEG021 = IC_SEG_ON;
    case  8u: IC1_SEG020 = IC_SEG_ON; 
    case  7u: IC1_SEG019 = IC_SEG_ON; 
    case  6u: IC1_SEG018 = IC_SEG_ON; 
    case  5u: IC1_SEG017 = IC_SEG_ON; 
    case  4u: IC1_SEG016 = IC_SEG_ON; 
    case  3u: IC1_SEG015 = IC_SEG_ON; 
    case  2u: IC1_SEG014 = IC_SEG_ON;
    case  1u: IC1_SEG013 = IC_SEG_ON;
    case  0u:break; 
    default:break;
    }


    

    return m_Res;
}


/**@brief 功率表盘显示函数
* @param[in]  m_Flag            段与数字是否显示     -1 显示 -0 不显示
* @param[in]  m_SEG             车速表盘段数0<=m_SEG<=12 
* @param[in]  m_Sign            显示功率值 负号
* @param[in]  m_NUM           显示功率值
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/
_Fun_Res SEG_SET_PowerDial1(uint8_t m_Flag,uint8_t m_SEG,uint8_t m_Sign,uint32_t m_NUM)
{

   _Fun_Res m_Res;
    uint8_t Num;
    uint8_t m8;

   if((m_Flag>=2u)||(m_Sign>=2u)||((m_NUM>999u))) 
   {
      m_Res = EX_ERR; 
   } 
   else 
   {
      if(m_Flag==1u) 
      {
        IC2_SEG148  = IC_SEG_ON; 
        IC2_SEG145  = IC_SEG_ON; 
        IC2_SEG064  = IC_SEG_ON; 
        
       
        
        
        /*负号*/
        if(m_Sign == 1u)
        {
            IC2_SEG139 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG139 = IC_SEG_OFF;
        }
        /*单位*/
        IC2_SEG140 = IC_SEG_ON;
        /*百位*/
        
        {
            Num = m_NUM / 100u;
           
                IC2_SEG138 = IC_SEG_ON;
           
            /*十位*/
            Num = (m_NUM / 10u) % 10u;
            
                m8 = SEG_DISPLAY_NUMBER0[Num];
            

            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG135 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG135 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG134 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG134 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG132 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG132 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG131 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG131 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG137 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG137 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG136 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG136 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG133 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG133 = IC_SEG_OFF;
            }
            /*个位*/
            Num = m_NUM % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG128 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG128 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG127 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG127 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG125 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG125 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG124 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG124 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG130 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG130 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG129 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG129 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG126 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG126 = IC_SEG_OFF;
            }
        }
      } 
      else 
      {
        IC2_SEG067  = IC_SEG_GREY; 
        IC2_SEG069  = IC_SEG_GREY; 
        IC2_SEG071  = IC_SEG_GREY; 
        IC2_SEG073  = IC_SEG_GREY; 
        IC2_SEG141  = IC_SEG_GREY; 
        IC2_SEG142  = IC_SEG_GREY; 
        IC2_SEG143  = IC_SEG_GREY; 
        IC2_SEG144  = IC_SEG_GREY; 
        IC2_SEG147  = IC_SEG_GREY; 
        IC2_SEG146  = IC_SEG_GREY;

        IC2_SEG148  = IC_SEG_OFF; 
        IC2_SEG145  = IC_SEG_OFF; 
        IC2_SEG064  = IC_SEG_OFF;  

        IC2_SEG139  = IC_SEG_OFF; 
        IC2_SEG140  = IC_SEG_OFF;  
        
        IC2_SEG138  = IC_SEG_OFF; 
        IC2_SEG135  = IC_SEG_OFF; 
        IC2_SEG134  = IC_SEG_OFF; 
        IC2_SEG132  = IC_SEG_OFF; 
        IC2_SEG131  = IC_SEG_OFF; 
        IC2_SEG137  = IC_SEG_OFF; 
        IC2_SEG136  = IC_SEG_OFF; 
        IC2_SEG133  = IC_SEG_OFF; 
        IC2_SEG128  = IC_SEG_OFF; 
        IC2_SEG127  = IC_SEG_OFF; 
        IC2_SEG125  = IC_SEG_OFF; 
        IC2_SEG124  = IC_SEG_OFF; 
        IC2_SEG130  = IC_SEG_OFF; 
        IC2_SEG129  = IC_SEG_OFF; 
        IC2_SEG126  = IC_SEG_OFF;             
      }                 
                        
      m_Res = EX_OK;    
   }
   return m_Res;
 
}

_Fun_Res SEG_Scan_SET_PowerDial1(uint8_t m_SEG)
{

   _Fun_Res m_Res;


        IC2_SEG148  = IC_SEG_ON; 
        IC2_SEG145  = IC_SEG_ON; 
        IC2_SEG064  = IC_SEG_ON; 
        
        IC2_SEG067  = IC_SEG_GREY; 
        IC2_SEG069  = IC_SEG_GREY; 
        IC2_SEG071  = IC_SEG_GREY; 
        IC2_SEG073  = IC_SEG_GREY; 
        IC2_SEG141  = IC_SEG_GREY;  
        IC2_SEG142  = IC_SEG_GREY; 
        IC2_SEG143  = IC_SEG_GREY; 
        IC2_SEG144  = IC_SEG_GREY; 

        IC2_SEG147 = IC_SEG_GREY; 
        IC2_SEG146 = IC_SEG_GREY;

        switch (m_SEG) 
        { 
            case 10u:IC2_SEG067 = IC_SEG_ON; 
            case  9u:IC2_SEG069 = IC_SEG_ON; 
            case  8u:IC2_SEG071 = IC_SEG_ON; 
            case  7u:IC2_SEG073 = IC_SEG_ON; 
            case  6u:IC2_SEG141 = IC_SEG_ON;  
            case  5u:IC2_SEG142 = IC_SEG_ON; 
            case  4u:IC2_SEG143 = IC_SEG_ON; 
            case  3u:IC2_SEG144 = IC_SEG_ON; 
            case  2u:IC2_SEG146 = IC_SEG_ON;
            case  1u:IC2_SEG147 = IC_SEG_ON;
            case  0u:break; 
            default:break;
        }

                
               
                        
      m_Res = EX_OK;    

   return m_Res;
 
}

/**@brief 续航里程显示函数

* @param[in]  m_Flag           续航里程是否显示     -2 显示---km  -1 显示  -0 不显示
* @param[in]  m_NUM            续航里程数值   0<=m_NUM<=999
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/
_Fun_Res SEG_SET_DTE_NUM1(uint8_t m_Flag, uint16_t m_NUM)
{
   _Fun_Res m_Res;
   uint16_t Num;
   uint8_t m8;
   if((m_Flag>2u)||(m_NUM>999u)) 
   {
      m_Res = EX_ERR; 
   } 
   else 
   {
      if (m_Flag == 1u)
        {
            IC1_SEG099 = IC_SEG_ON;
            IC1_SEG065 = IC_SEG_ON;
            /*百位*/
            Num = m_NUM / 100u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG050 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG050 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG049 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG049 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG047 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG047 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG046 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG046 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG045 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG045 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG044 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG044 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG048 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG048 = IC_SEG_OFF;
            }
            /*十位*/
            Num = (m_NUM / 10u)%10u;
            
              m8 = SEG_DISPLAY_NUMBER0[Num];
            
            
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG057 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG057 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG056 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG056 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG054 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG054 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG053 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG053 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG052 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG052 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG051 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG051 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG055 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG055 = IC_SEG_OFF;
            }
            /*个位*/
            Num = m_NUM % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG064 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG064 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG063 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG063 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG061 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG061 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG060 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG060 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG059 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG059 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG058 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG058 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG062 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG062 = IC_SEG_OFF;
            }
        }
        else if(m_Flag==2u)
        {
            IC1_SEG099 = IC_SEG_ON;
            IC1_SEG065 = IC_SEG_ON;

            IC1_SEG044    = IC_SEG_OFF;
            IC1_SEG045    = IC_SEG_OFF;
            IC1_SEG046    = IC_SEG_OFF;
            IC1_SEG047    = IC_SEG_OFF;
            IC1_SEG048    = IC_SEG_ON;
            IC1_SEG049    = IC_SEG_OFF;
            IC1_SEG050    = IC_SEG_OFF;
            IC1_SEG051    = IC_SEG_OFF;
            IC1_SEG052    = IC_SEG_OFF;
            IC1_SEG053    = IC_SEG_OFF;
            IC1_SEG054    = IC_SEG_OFF;
            IC1_SEG055    = IC_SEG_ON;
            IC1_SEG056    = IC_SEG_OFF;
            IC1_SEG057    = IC_SEG_OFF;
            IC1_SEG058    = IC_SEG_OFF;
            IC1_SEG059    = IC_SEG_OFF;
            IC1_SEG060    = IC_SEG_OFF;
            IC1_SEG061    = IC_SEG_OFF;
            IC1_SEG062    = IC_SEG_ON;
            IC1_SEG063    = IC_SEG_OFF;
            IC1_SEG064    = IC_SEG_OFF;
            
        }
        
        else
        {
            IC1_SEG099 = IC_SEG_OFF;
            IC1_SEG065 = IC_SEG_OFF;

            IC1_SEG044    = IC_SEG_OFF;
            IC1_SEG045    = IC_SEG_OFF;
            IC1_SEG046    = IC_SEG_OFF;
            IC1_SEG047    = IC_SEG_OFF;
            IC1_SEG048    = IC_SEG_OFF;
            IC1_SEG049    = IC_SEG_OFF;
            IC1_SEG050    = IC_SEG_OFF;
            IC1_SEG051    = IC_SEG_OFF;
            IC1_SEG052    = IC_SEG_OFF;
            IC1_SEG053    = IC_SEG_OFF;
            IC1_SEG054    = IC_SEG_OFF;
            IC1_SEG055    = IC_SEG_OFF;
            IC1_SEG056    = IC_SEG_OFF;
            IC1_SEG057    = IC_SEG_OFF;
            IC1_SEG058    = IC_SEG_OFF;
            IC1_SEG059    = IC_SEG_OFF;
            IC1_SEG060    = IC_SEG_OFF;
            IC1_SEG061    = IC_SEG_OFF;
            IC1_SEG062    = IC_SEG_OFF;
            IC1_SEG063    = IC_SEG_OFF;
            IC1_SEG064    = IC_SEG_OFF;
            
        }
   
      m_Res = EX_OK;
   }
   return m_Res;
 
}

/**@brief 车速8字段显示函数
* @param[in]  m_Flag            车速是否显示     -1 显示 -0 不显示
* @param[in]  m_NUM             车速数据      0<=m_NUM<=299
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/

_Fun_Res SEG_SET_VSpeed_NUM1(uint8_t m_Flag , uint16_t m_NUM)
{
   _Fun_Res m_Res;
    uint16_t Num;
    uint8_t m8;
   if((m_Flag>2u)||(m_NUM>999u)) 
   {
      m_Res = EX_ERR; 
   } 
   else 
   {
      if (m_Flag == 1u)
        {
            IC1_SEG117 = IC_SEG_ON;
            /*百位*/
            Num = m_NUM / 100u;
            
            
            IC1_SEG102 = IC_SEG_ON;
            
           
            /*十位*/
            Num = (m_NUM / 10u)%10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            //if(m_NUM>=100u) 
            //{
            //  
            //} 
            //else 
            //{
            //  m8 = SEG_UNDISPLAY_NUMBER0[Num];
            //}
            
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG109 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG109 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG108 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG108 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG106 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG106 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG105 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG105 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG104 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG104 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG103 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG103 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG107 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG107 = IC_SEG_SPEED;
            }
            /*个位*/
            Num = m_NUM % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG116 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG116 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG115 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG115 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG113 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG113 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG112 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG112 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG111 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG111 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG110 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG110 = IC_SEG_SPEED;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG114 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG114 = IC_SEG_SPEED;
            }
        }
        else if(m_Flag == 2u)
        {
            IC1_SEG117     = IC_SEG_ON;

            IC1_SEG102     = IC_SEG_SPEED;
            IC1_SEG103     = IC_SEG_SPEED;
            IC1_SEG104     = IC_SEG_SPEED;
            IC1_SEG105     = IC_SEG_SPEED;
            IC1_SEG106     = IC_SEG_SPEED;
            IC1_SEG107     = IC_SEG_ON;
            IC1_SEG108     = IC_SEG_SPEED;
            IC1_SEG109     = IC_SEG_SPEED;
            IC1_SEG110     = IC_SEG_SPEED;
            IC1_SEG111     = IC_SEG_SPEED;
            IC1_SEG112     = IC_SEG_SPEED;
            IC1_SEG113     = IC_SEG_SPEED;
            IC1_SEG114     = IC_SEG_ON;
            IC1_SEG115     = IC_SEG_SPEED;
            IC1_SEG116     = IC_SEG_SPEED; 
        }
        else
        {
            IC1_SEG117     = IC_SEG_OFF;

            IC1_SEG102     = IC_SEG_SPEED;
            IC1_SEG103     = IC_SEG_SPEED;
            IC1_SEG104     = IC_SEG_SPEED;
            IC1_SEG105     = IC_SEG_SPEED;
            IC1_SEG106     = IC_SEG_SPEED;
            IC1_SEG107     = IC_SEG_SPEED;
            IC1_SEG108     = IC_SEG_SPEED;
            IC1_SEG109     = IC_SEG_SPEED;
            IC1_SEG110     = IC_SEG_SPEED;
            IC1_SEG111     = IC_SEG_SPEED;
            IC1_SEG112     = IC_SEG_SPEED;
            IC1_SEG113     = IC_SEG_SPEED;
            IC1_SEG114     = IC_SEG_SPEED;
            IC1_SEG115     = IC_SEG_SPEED;
            IC1_SEG116     = IC_SEG_SPEED;        
        }
      
   
      m_Res = EX_OK;
   }
   return m_Res;
 
}

/**@brief L8字段显示函数
* @param[in]  m_Flag            车速是否显示     -2 L-  -1 显示 -0 不显示
* @param[in]  m_NUM             车速数据      0<=m_NUM<=9
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/

_Fun_Res SEG_SET_L8_NUM1(uint8_t m_Flag , uint8_t m_NUM)
{
   _Fun_Res m_Res;
    uint8_t Num;
    uint8_t m8;
   if((m_Flag>2u)||(m_NUM>9u)) 
   {
      m_Res = EX_ERR; 
   } 
   else 
   {
      if (m_Flag == 1u)
        {
            IC2_SEG051 = IC_SEG_ON;
            Num = m_NUM ;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG058 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG058 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG057 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG057 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG055 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG055 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG054 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG054 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG053 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG053 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG052 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG052 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG056 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG056 = IC_SEG_OFF;
            }
        }
        else if(m_Flag == 2u)
        {
            IC2_SEG051   = IC_SEG_ON;

            IC2_SEG052   = IC_SEG_OFF;
            IC2_SEG053   = IC_SEG_OFF;
            IC2_SEG054   = IC_SEG_OFF;
            IC2_SEG055   = IC_SEG_OFF;
            IC2_SEG056   = IC_SEG_ON;
            IC2_SEG057   = IC_SEG_OFF;
            IC2_SEG058   = IC_SEG_OFF;
        }  
        else
        {
            
            IC2_SEG051   = IC_SEG_OFF;

            IC2_SEG052   = IC_SEG_OFF;
            IC2_SEG053   = IC_SEG_OFF;
            IC2_SEG054   = IC_SEG_OFF;
            IC2_SEG055   = IC_SEG_OFF;
            IC2_SEG056   = IC_SEG_OFF;
            IC2_SEG057   = IC_SEG_OFF;
            IC2_SEG058   = IC_SEG_OFF;
        }
      
   
      m_Res = EX_OK;
   }
   return m_Res;
 
}

/**@brief 总计里程显示函数
* @param[in]  m_Flag            是否显示     -1 显示 -0 不显示
* @param[in]  m_NUM             显示数值  0<m_NUM<=999999
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/
_Fun_Res SEG_SET_ODO_NUM1(uint8_t m_Flag,uint32_t m_NUM)
{

   _Fun_Res m_Res;
   uint32_t Num;
   uint8_t m8;
   if((m_Flag>2u)||(m_NUM>999999u)) 
   {
      m_Res = EX_ERR; 
   } 
   else 
   {
        if(m_Flag==1u) 
        {
            IC2_SEG074 = IC_SEG_ON;
            IC2_SEG117 = IC_SEG_ON;
            /*十万位*/
            Num = (m_NUM / 100000u);
            m8 = SEG_DISPLAY_NUMBER0[Num];
            
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG081 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG081 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG080 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG080 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG078 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG078 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG077 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG077 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG076 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG076 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG075 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG075 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG079 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG079 = IC_SEG_OFF;
            }
            /*万位*/
            Num = (m_NUM / 10000u)%10u;
           
               m8 = SEG_DISPLAY_NUMBER0[Num];
            
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG088 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG088 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG087 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG087 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG085 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG085 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG084 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG084 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG083 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG083 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG082 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG082 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG086 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG086 = IC_SEG_OFF;
            }
            /*千位*/
            Num = (m_NUM / 1000u)%10u;
            
               m8 = SEG_DISPLAY_NUMBER0[Num];
           
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG095 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG095 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG094 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG094 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG092 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG092 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG091 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG091 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG090 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG090 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG089 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG089 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG093 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG093 = IC_SEG_OFF;
            }
            /*百位*/
            Num = (m_NUM / 100u)%10u;
            
               m8 = SEG_DISPLAY_NUMBER0[Num];
            
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG102 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG102 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG101 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG101 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG099 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG099 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG098 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG098 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG097 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG097 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG096 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG096 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG100 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG100 = IC_SEG_OFF;
            }
            /*十位*/
            Num = (m_NUM / 10u)%10u;
            
               m8 = SEG_DISPLAY_NUMBER0[Num];
            
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG109 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG109 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG108 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG108 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG106 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG106 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG105 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG105 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG104 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG104 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG103 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG103 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG107 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG107 = IC_SEG_OFF;
            }
            /*个位*/
            Num = m_NUM % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG116 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG116 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG115 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG115 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG113 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG113 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG112 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG112 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG111 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG111 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG110 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG110 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG114 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG114 = IC_SEG_OFF;
            }
            
        
            
        }
        else 
        {
            IC2_SEG074   = IC_SEG_OFF;
            IC2_SEG117   = IC_SEG_OFF;

            IC2_SEG075   = IC_SEG_OFF;
            IC2_SEG076   = IC_SEG_OFF;
            IC2_SEG077   = IC_SEG_OFF;
            IC2_SEG078   = IC_SEG_OFF;
            IC2_SEG079   = IC_SEG_OFF;
            IC2_SEG080   = IC_SEG_OFF;
            IC2_SEG081   = IC_SEG_OFF;
            IC2_SEG082   = IC_SEG_OFF;
            IC2_SEG083   = IC_SEG_OFF;
            IC2_SEG084   = IC_SEG_OFF;
            IC2_SEG085   = IC_SEG_OFF;
            IC2_SEG086   = IC_SEG_OFF;
            IC2_SEG087   = IC_SEG_OFF;
            IC2_SEG088   = IC_SEG_OFF;
            IC2_SEG089   = IC_SEG_OFF;
            IC2_SEG090   = IC_SEG_OFF;
            IC2_SEG091   = IC_SEG_OFF;
            IC2_SEG092   = IC_SEG_OFF;
            IC2_SEG093   = IC_SEG_OFF;
            IC2_SEG094   = IC_SEG_OFF;
            IC2_SEG095   = IC_SEG_OFF;
            IC2_SEG096   = IC_SEG_OFF;
            IC2_SEG097   = IC_SEG_OFF;
            IC2_SEG098   = IC_SEG_OFF;
            IC2_SEG099   = IC_SEG_OFF;
            IC2_SEG100   = IC_SEG_OFF;
            IC2_SEG101   = IC_SEG_OFF;
            IC2_SEG102   = IC_SEG_OFF;
            IC2_SEG103   = IC_SEG_OFF;
            IC2_SEG104   = IC_SEG_OFF;
            IC2_SEG105   = IC_SEG_OFF;
            IC2_SEG106   = IC_SEG_OFF;
            IC2_SEG107   = IC_SEG_OFF;
            IC2_SEG108   = IC_SEG_OFF;
            IC2_SEG109   = IC_SEG_OFF;
            IC2_SEG110   = IC_SEG_OFF;
            IC2_SEG111   = IC_SEG_OFF;
            IC2_SEG112   = IC_SEG_OFF;
            IC2_SEG113   = IC_SEG_OFF;
            IC2_SEG114   = IC_SEG_OFF;
            IC2_SEG115   = IC_SEG_OFF;
            IC2_SEG116   = IC_SEG_OFF;
        }
            
   
      m_Res = EX_OK;
   }
   return m_Res;
 

}

/**@brief 小计里程显示函数
* @param[in]  m_Flag            是否显示     -1 显示 -0 不显示
* @param[in]  m_NUM             显示数值     0<m_NUM<=999.9
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/
_Fun_Res SEG_SET_TRIP_NUM1(uint8_t m_Flag,uint16_t m_NUM)
{
   _Fun_Res m_Res;
   uint16_t Num;
   uint8_t m8;
   if((m_Flag>2u)||(m_NUM>9999u)) 
   {
      m_Res = EX_ERR; 
   } 
   else 
   {
        if(m_Flag==1u) 
        {
            IC1_SEG066 = IC_SEG_ON;
            IC1_SEG088 = IC_SEG_ON;
            IC1_SEG096 = IC_SEG_ON;
            
            /*千位*/
            Num = (m_NUM / 1000u)%10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG073 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG073 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG072 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG072 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG070 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG070 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG069 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG069 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG068 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG068 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG067 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG067 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG071 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG071 = IC_SEG_OFF;
            }
            /*百位*/
            Num = (m_NUM / 100u)%10u;
            
            
             m8 = SEG_DISPLAY_NUMBER0[Num];
            
            
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG080 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG080 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG079 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG079 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG077 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG077 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG076 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG076 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG075 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG075 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG074 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG074 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG078 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG078 = IC_SEG_OFF;
            }
            /*十位*/
            Num = (m_NUM / 10u)%10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG087 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG087 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG086 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG086 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG084 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG084 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG083 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG083 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG082 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG082 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG081 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG081 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG085 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG085 = IC_SEG_OFF;
            }
            /*个位*/
            Num = m_NUM%10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG095 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG095 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG094 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG094 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG092 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG092 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG091 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG091 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG090 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG090 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG089 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG089 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG093 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG093 = IC_SEG_OFF;
            }
            
        }
        else if(m_Flag == 2u)
        {
            IC1_SEG066    = IC_SEG_ON;
            IC1_SEG088    = IC_SEG_ON;
            IC1_SEG096    = IC_SEG_ON;

            IC1_SEG067    = IC_SEG_OFF;
            IC1_SEG068    = IC_SEG_OFF;
            IC1_SEG069    = IC_SEG_ON;
            IC1_SEG070    = IC_SEG_OFF;
            IC1_SEG071    = IC_SEG_OFF;
            IC1_SEG072    = IC_SEG_OFF;
            IC1_SEG073    = IC_SEG_OFF;
            IC1_SEG074    = IC_SEG_OFF;
            IC1_SEG075    = IC_SEG_OFF;
            IC1_SEG076    = IC_SEG_ON;
            IC1_SEG077    = IC_SEG_OFF;
            IC1_SEG078    = IC_SEG_OFF;
            IC1_SEG079    = IC_SEG_OFF;
            IC1_SEG080    = IC_SEG_OFF;
            IC1_SEG081    = IC_SEG_OFF;
            IC1_SEG082    = IC_SEG_OFF;
            IC1_SEG083    = IC_SEG_ON;
            IC1_SEG084    = IC_SEG_OFF;
            IC1_SEG085    = IC_SEG_OFF;
            IC1_SEG086    = IC_SEG_OFF;
            IC1_SEG087    = IC_SEG_OFF;
            IC1_SEG089    = IC_SEG_OFF;
            IC1_SEG090    = IC_SEG_OFF;
            IC1_SEG091    = IC_SEG_ON;
            IC1_SEG092    = IC_SEG_OFF;
            IC1_SEG093    = IC_SEG_OFF;
            IC1_SEG094    = IC_SEG_OFF;
            IC1_SEG095    = IC_SEG_OFF;
        }

        else 
        {
            
            IC1_SEG066    = IC_SEG_OFF;
            IC1_SEG088    = IC_SEG_OFF;
            IC1_SEG096    = IC_SEG_OFF;

            IC1_SEG067    = IC_SEG_OFF;
            IC1_SEG068    = IC_SEG_OFF;
            IC1_SEG069    = IC_SEG_OFF;
            IC1_SEG070    = IC_SEG_OFF;
            IC1_SEG071    = IC_SEG_OFF;
            IC1_SEG072    = IC_SEG_OFF;
            IC1_SEG073    = IC_SEG_OFF;
            IC1_SEG074    = IC_SEG_OFF;
            IC1_SEG075    = IC_SEG_OFF;
            IC1_SEG076    = IC_SEG_OFF;
            IC1_SEG077    = IC_SEG_OFF;
            IC1_SEG078    = IC_SEG_OFF;
            IC1_SEG079    = IC_SEG_OFF;
            IC1_SEG080    = IC_SEG_OFF;
            IC1_SEG081    = IC_SEG_OFF;
            IC1_SEG082    = IC_SEG_OFF;
            IC1_SEG083    = IC_SEG_OFF;
            IC1_SEG084    = IC_SEG_OFF;
            IC1_SEG085    = IC_SEG_OFF;
            IC1_SEG086    = IC_SEG_OFF;
            IC1_SEG087    = IC_SEG_OFF;
            IC1_SEG089    = IC_SEG_OFF;
            IC1_SEG090    = IC_SEG_OFF;
            IC1_SEG091    = IC_SEG_OFF;
            IC1_SEG092    = IC_SEG_OFF;
            IC1_SEG093    = IC_SEG_OFF;
            IC1_SEG094    = IC_SEG_OFF;
            IC1_SEG095    = IC_SEG_OFF;
        }
            
   
      m_Res = EX_OK;
   }
   return m_Res;
 
}

/**@brief 时间显示函数
* @param[in]  m_hour            小时
* @param[in]  m_minute          分钟
* @param[in]  m_icon            中间冒号是否显示 -1 显示 -0 不显示
* @param[in]  m_Flag1           小时是否显示     -1 显示 -0 不显示
* @param[in]  m_Flag2           分钟是否显示     -1 显示 -0 不显示
* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/
_Fun_Res SEG_SET_Clock1(uint8_t m_hour, uint8_t m_minute, uint8_t m_icon, uint8_t m_Flag1, uint8_t m_Flag2 )
{
    _Fun_Res m_Res;
    uint8_t Num;
    uint8_t m8;
    if ((m_hour > 99u) || (m_minute > 99u) || (m_icon > 1u) || (m_Flag1 > 1u) || (m_Flag2 > 1u))
    {
        m_Res = EX_ERR;
    }
    else
    {
        if (m_icon == 1u)
        {
            IC2_SEG166 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG166 = IC_SEG_OFF;
        }
        if (m_Flag1 == 1u)
        {
            Num = m_hour / 10u;/*86104-11*/
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG178 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG178 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG177 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG177 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG175 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG175 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG174 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG174 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG180 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG180 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG179 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG179 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG176 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG176 = IC_SEG_OFF;
            }
            Num = m_hour % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG171 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG171 = IC_SEG_OFF;
            }                   
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG170 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG170 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG168 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG168 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG167 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG167 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG173 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG173 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG172 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG172 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG169 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG169 = IC_SEG_OFF;
            }
        }
        else
        {
            IC2_SEG178 = IC_SEG_OFF;
            IC2_SEG177 = IC_SEG_OFF;
            IC2_SEG175 = IC_SEG_OFF;
            IC2_SEG174 = IC_SEG_OFF;
            IC2_SEG180 = IC_SEG_OFF;
            IC2_SEG179 = IC_SEG_OFF;
            IC2_SEG176 = IC_SEG_OFF;
            IC2_SEG171 = IC_SEG_OFF;
            IC2_SEG170 = IC_SEG_OFF;
            IC2_SEG168 = IC_SEG_OFF;
            IC2_SEG167 = IC_SEG_OFF;
            IC2_SEG173 = IC_SEG_OFF;
            IC2_SEG172 = IC_SEG_OFF;
            IC2_SEG169 = IC_SEG_OFF;
        }
        if (m_Flag2 == 1u)
        {
            Num = m_minute / 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG163 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG163 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG162 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG162 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG160 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG160 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG159 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG159 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG165 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG165 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG164 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG164 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG161 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG161 = IC_SEG_OFF;
            }
            Num = m_minute % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG156 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG156 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG155 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG155 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG153 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG153 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG152 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG152 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG158 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG158 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG157 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG157 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG154 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG154 = IC_SEG_OFF;
            }
        }
        else
        {
            IC2_SEG163   = IC_SEG_OFF;
            IC2_SEG162   = IC_SEG_OFF;
            IC2_SEG160   = IC_SEG_OFF;
            IC2_SEG159   = IC_SEG_OFF;
            IC2_SEG165   = IC_SEG_OFF;
            IC2_SEG164   = IC_SEG_OFF;
            IC2_SEG161   = IC_SEG_OFF;
            IC2_SEG156   = IC_SEG_OFF;
            IC2_SEG155   = IC_SEG_OFF;
            IC2_SEG153   = IC_SEG_OFF;
            IC2_SEG152   = IC_SEG_OFF;
            IC2_SEG158   = IC_SEG_OFF;
            IC2_SEG157   = IC_SEG_OFF;
            IC2_SEG154   = IC_SEG_OFF;
        }
        m_Res = EX_OK;
    }
    return m_Res;
}
