
#ifndef _CANFD_H_
#define _CANFD_H_

#include "s6j3360drv.h"


typedef void (*CAN_Data_Ind_Func)(uint32_t Identifier, uint8_t DLC, uint8_t Data[]);
typedef void (*CAN_Data_Cfm_Func)(uint32_t Identifier, uint8_t TransferStatus);
typedef void (*CAN_Data_Abort_Func)(uint32_t Identifier, uint8_t TransferStatus);

typedef enum
{
    CANFD_FILTER_N_A = 0,
    CANFD_FILTER_ID_LIST,
    CANFD_FILTER_ID_RANGE,
} CANFD_Filter_Cfg_Type_en_t;


/******************************************************************************
CfgType = CANFD_FILTER_N_A      : Filter not not available
                                  IDNum : Any value has no effect
                                  pIDs  : Any value has no effect

CfgType = CANFD_FILTER_ID_LIST  : A list type filter
                                  IDNum : Number of IDs in the ID list
                                  pIDs  : Pointer point to the ID list

CfgType = CANFD_FILTER_ID_RANGE : A range type filter
                                  IDNum : Any value has no effect
                                  pIDs  : Pointer point to the ID range
                                          pIDs[0] = Start of the ID range
                                          pIDs[1] = End of the ID range
******************************************************************************/

typedef struct
{
    CANFD_Filter_Cfg_Type_en_t   CfgType;
    uint16_t                     IDNum;
    uint32_t                    *pIDs;
} CANFD_Filter_Cfg_st_t;


typedef struct
{
    CANFD_Filter_Cfg_st_t  NMStdFilter;
    CANFD_Filter_Cfg_st_t  DiagStdFilter;
    CANFD_Filter_Cfg_st_t  MsgStdFilter;

    CANFD_Filter_Cfg_st_t  NMExtFilter;
    CANFD_Filter_Cfg_st_t  DiagExtFilter;
    CANFD_Filter_Cfg_st_t  MsgExtFilter;

    CAN_Data_Ind_Func     pfCANDataIndCb;
    CAN_Data_Cfm_Func     pfCANDataCfmCb;
    CAN_Data_Abort_Func     pfCANDataAbortCb;
} CANFD_Filter_Init_st_t;


typedef struct
{
    uint8_t  Status;
    uint8_t  Timer;
    uint8_t  Cnt;
} MSCAN0BusoffMonitorStruct;


#define   CANFD_TX_STD_ID                   0U
#define   CANFD_TX_EXT_ID                   1U

#define   CANFD_COMPLETE                    0U
#define   CANFD_NOT_COMPLETE                1U


#ifndef   CANFD_CH0_ENABLE

#define   CANFD_CH0_ENABLE                  1U

#define   CANFD_CH0_BAUD_RATE               250U     /* 波特率,单位kbps */   /*50303*/
#define   CANFD_CH0_RX_FIFO_DEPTH           16U      /* Rx FIFO 深度(0-64) 用于接收范围型的ID的报文 */
#define   CANFD_CH0_TX_FIFO_DEPTH           32U      /* Tx FIFO 深度(0-32) 用于发送所有报文         */
#define   CANFD_CH0_TX_ID_TYPE              CANFD_TX_EXT_ID





#define   CANFD_CH0_DATA_INDICATION_FUNC    CAN_LLC_Ch5_Data_Indication
#define   CANFD_CH0_DATA_CONFIRM_FUNC       CAN_LLC_Ch5_Data_Confirm

#endif
/*
void NM_Clr_AliveCnt(void);
void NM_Node_Timer_Send ( uint8_t Ctl );
void NM_Init_Timer ( void );


*/
uint8_t Can_Read_Bus(void);
void Can_Set_Bus(uint8_t exist);
extern void CANFD_Clk_Init ( void );
extern void CANFD_CH0_Init (CANFD_Filter_Init_st_t *pFilterInit);
extern void CANFD_CH0_L_Data_Request ( uint32_t Identifier,uint16_t Idx, uint8_t DLC, uint8_t *Data );
extern void CANFD_CH0_Bus_Off_Monitoring_Service(void);
extern void CANFD_CH0_Bus_Off_Recover( void );
extern void CANFD_CH0_Sleep( void );
extern uint32_t CANFD_ReadBus_Sts(void);
extern uint32_t CANFD_ReadTX_Buf(void);
extern uint32_t CANFD_ReadTX_Status(void);
extern void CANFD_SetTX_Abort(uint32_t BufIdx);
extern uint32_t CANFD_ReadNOACK_Sts(void);
#endif /* _CANFD_H_ */













