/**************************************************************************//**
  * \file     Memory.h
  * \brief    Internal memory driver header file
  * \details
  * \author   Zhang Xuan
  * \version  V1.0.0
  * \date     20-Jul-2018
  * \par      History:
  *           V1.0.0 Initial release
  * \par      Copyright:
  *           (c) Heilongjiang TYW Electronics co., LTD
******************************************************************************/

#ifndef _MEMORY_H_
#define _MEMORY_H_

/* Includes ------------------------------------------------------------------*/

#include "s6j3360drv.h"

/* C binding of definitions if building with C++ compiler */
#ifdef __cplusplus
extern  {
#endif

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/

/* ---------------------------------------------------------------------------
   Memory specification
   ---------------------------------------------------------------------------*/

/* TCFLASH maximum operate frequency */
#define   MEM_TCFLASH_SIZE_BYTE             (2UL * 1024UL * 1024UL + 8UL * 8UL * 1024UL)
#define   MEM_TCFLASH_MAXIMUM_FREQUENCY     (80000000UL)

/* WORKFLASH maximum operate frequency */
#define   MCU_WORKFLASH_SIZE_BYTE           (112UL * 1024UL)
#define   MEM_WORKFLASH_MAXIMUM_FREQUENCY   (12500000UL)

/* TCMRAM(TCMRAM AXI slave interface - no DMA access via TCM port) */
#define   MEM_TCMRAM_AXI_START_ADDRESS      (0x04000000UL)
#define   MEM_TCMRAM_SIZE_BYTE              (128UL * 1024UL)

/* System RAM */
#define   MEM_SYSRAM_START_ADDRESS          (0x02000000UL)
#define   MEM_SYSRAM_SIZE_BYTE              (128UL * 1024UL)

/* Backup RAM (Included in system RAM) */
#define   MEM_BURAM_START_ADDRESS           (0x02000000UL)
#define   MEM_BURAM_SIZE_BYTE               (24UL * 1024UL)

/* ---------------------------------------------------------------------------
   Memory settings
   ---------------------------------------------------------------------------*/

/* ECC memory settings */
#define   MEM_TCFLASH_ECC_ENABLE            1U
#define   MEM_SYSRAM_ECC_ENABLE             0U

/* Startup RAM clear */
#define   MEM_TCMRAM_CLEAR_SIZE_BYTE        MEM_TCMRAM_SIZE_BYTE
#define   MEM_SYSRAM_CLEAR_SIZE_BYTE        (MEM_SYSRAM_SIZE_BYTE - MEM_BURAM_SIZE_BYTE)
#define   MEM_CLEAR_BURAM                   0U

/* ---------------------------------------------------------------------------
   DMA settings
   ---------------------------------------------------------------------------*/
   
/* DMA block size in byte (valid range: 1...16) */
#define   MEM_DMA_BLOCK_SIZE                16UL

/* DMA transfer width setting  */
#define   MEM_DMA_TRANS_WIDTH_32BIT         2U
#define   MEM_DMA_TRANS_WIDTH_64BIT         3U

/* Maximal supported access width */
#define   MEM_TCMRAM_MAX_ACCESS_WIDTH       MEM_DMA_TRANS_WIDTH_64BIT
#define   MEM_SYSRAM_MAX_ACCESS_WIDTH       MEM_DMA_TRANS_WIDTH_64BIT
#define   MEM_BURAM_MAX_ACCESS_WIDTH        MEM_DMA_TRANS_WIDTH_32BIT
#define   MEM_VRAM_MAX_ACCESS_WIDTH         MEM_DMA_TRANS_WIDTH_64BIT

/* Exported functions ------------------------------------------------------- */

extern void Mem_Init(void);
extern void Mem_Clear(void);
extern void MEM_Wait_Clear_Complete(void);

#ifdef __cplusplus
}
#endif

#endif /* _MEMORY_H_ */