# FE-7B

## Git开发流程

---

### 主分支master

    代码库应该有且只有一个主分支。所有提供给用户使用的正式版本，都在这个主分支上发布。

### 开发分支Develop

    主分支只用来分布重大版本，日常开发应该在另一条分支上完成。我们把开发用的分支，叫做Develop。
    #Git创建Develop分支的命令
    git checkout -b develop master
    #将Develop分支发布到Master分支的命令
    git checkout master
    git merge --no-ff develop
    
    --no-ff参数：默认情况下，Git执行"快进式合并"，会直接将Master分支指向Develop分支。
    强推,不允许使用

### 临时性分支

    前面讲到版本库的两条主要分支：Master和Develop。前者用于正式发布，后者用于日常开发。其实，常设分支只需要这两条就够了，不需要其他了。
    
    但是，除了常设分支以外，还有一些临时性分支，用于应对一些特定目的的版本开发。临时性分支主要有三种：
    
    * 功能分支 （feature）
    
    * 预发布分支 (release)
    
    * 修补bug分支 (fixbug)
    
    这三种分支都属于临时性需要，使用完以后，应该删除，使得代码库的常设分支始终只有Master和Develop。

### 功能分支 feature branches

    为了开发某种特定功能，从Develop分支上面分出来的。开发完成后，要再并入Develop。
    功能分支的名字，可以采用feature-*的形式命名。
    #创建一个功能分支
    git checkout -b feature-x develop
    #合并到develop分支
    git checkout develop
    git merge --no--ff feature-x
    #删除feature分支
    git branch -d feature-x

### 预发布分支 release branches

    指发布正式版本之前（即合并到Master分支之前），我们可能需要有一个预发布的版本进行测试。
    
    预发布分支是从Develop分支上面分出来的，预发布结束以后，必须合并进Develop和Master分支。它的命名，可以采用release-*的形式。
    
     
    #创建一个预发布分支：
    git checkout -b release-x develop
    #确认没有问题后，合并到master分支：
    git checkout master
    git merge --no-ff release-x
    # 对合并生成的新节点，做一个标签
    git tag -a x
    #再合并到develop分支：
    git checkout develop
    git merge --no-ff release-x
    #最后记得删除预发布分支：
    git branch -d release-x

### 修补bug分支 hotfixes

    软件正式发布以后，难免会出现bug。这时就需要创建一个分支，进行bug修补。
    修补bug分支是从Master分支上面分出来的。修补结束以后，再合并进Master和Develop分支。它的命名，可以采用fixbug-*的形式。
    #创建一个修补bug分支：
    git checkout -b fixbug-xx master
    #修补结束后，合并到master分支：
    git checkout master
    git merge --no-ff fixbug-xx
    git tag -a xx
    #再合并到develop分支：
    git checkout develop
    git merge --no--ff fixbug-xx
    #最后，删除"修补bug分支"：
    git branch -d fixbug-xx
---

### 多人协作流程

    首先，可以试图用git push origin <branch-name>推送自己的修改；
    如果推送失败，则因为远程分支比你的本地更新，需要先用git pull试图合并；
    如果合并有冲突，则解决冲突，并在本地提交；
    没有冲突或者解决掉冲突后，再用git push origin <branch-name>推送就能成功！
    如果git pull提示no tracking information，则说明本地分支和远程分支的链接关系没有创建，
    用命令git branch --set-upstream-to <branch-name> origin/<branch-name>。
---

#### 实际操作流程

##### 方案一

    拉取Dev分支
    基于Dev分支开辟自己本地功能分支进行修改
    修改结束后再次拉取Dev分支,保证Dev分支最新
    将修改后的本地功能分支合并到Dev分支
    申请将Dev分支进行推送

##### 方案二

    拉取Dev分支
    基于Dev分支开辟自己本地功能分支进行修改
    修改结束后再次拉取Dev分支,保证Dev分支最新
    将Dev分支合并到修改后的本地功能分支
    申请将本地功能分支进行推送

## __人员任务划分__

- 底层驱动(张暄+孙学刚)--2.5(first)----2020-02-10结束

```
    时钟------------------张暄/孙学刚
    IO口------------------张暄/孙学刚
    Uart------------------张暄/孙学刚
    Can/FD----------------张暄/孙学刚
    电机------------------张暄/孙学刚
    PWM-------------------张暄/孙学刚
    ADC-------------------张暄/孙学刚
    频率捕获--------------张暄/孙学刚
    休眠.唤醒-------------张暄/孙学刚
    存储------------------张暄/孙学刚
    RTC(有精度要求)-------张暄/孙学刚
    BD8379----------------张暄/孙学刚
    HT1629----------------张暄/孙学刚
    I2S-------------------张暄/孙学刚
    外部flash-------------张暄/孙学刚
    软件框架--------------张暄/孙学刚
```

- 应用软件-2020-2-01-----2020-02-10可以出一版-2020-02-12可以集成完--2020.2.20结束

```
    文字和声音报警-------赵建智---李茂军
    电源管理-------------赵林源
    指示灯---------------胡松
    段码屏---------------胡松
    can数据处理----------赵建智
    燃油(燃油格,续航,平均油耗,瞬时油耗-matlab)--(张暄,于金凤,胡志松,王晨,史明泉)-10天--先期需要流程图
    车速.转速.水温-------于金风,姜凯文
    行车电脑(ODO,TRIP.保养.时间,温度,档位)---赵建智/李林泽
    背光策略------------赵林源
    巡航(定速,限速)-----李茂军
    按键处理(UE)--------李茂军
    安全带报警----------李茂军
    门开报警------------李林泽  
    胎压(直接,间接)-----李林泽
```

- 诊断,网络,刷写-吕伟阳/滕敬轩-2020.2.15

```
    诊断
    网络
    刷写
```
