#ifndef _HW_Key_H_
#define _HW_Key_H_


#include "stdint.h"
#include "string.h"
#include "RTE_LINE_IN.h"
typedef enum
{
    PRESS_DOWN = 0,
    PRESS_CLICK,/*单击*/
    PRESS_LONG_UP,/*长按后抬起*/
    PRESS_LONG_HOLD,/*按住不抬起*/
    PRESS_MAX,
    PRESS_NONE,
} button_event_t;

typedef enum
{
    Res_OK= 0,
    Res_Error,
} Config_Res_t;


typedef enum
{
    HW_Key_0,
    HW_Key_1,
    HW_Key_2,
    HW_Key_3,
    HW_Key_4,
    HW_Key_5,
    HW_Key_6,
    HW_Key_7,
    HW_Key_8,
    HW_Key_9,
    HW_Key_10,
    HW_Key_11,
    HW_Key_12,
    HW_Key_13,
    HW_Key_14,
    HW_Key_15,
    HW_Key_Max,
} button_num_t;

typedef void (*button_callback)(button_event_t KeyEvent);

typedef struct
{
    uint8_t Pressed_logic_level;/* need user to init */
    uint16_t scan_cnt;

    uint16_t short_press_start_tick;
    uint16_t long_press_start_tick;
    uint16_t long_hold_start_tick;

    button_event_t event;
    uint8_t status;
    uint8_t (*usr_button_read)(void);
    button_callback  cb;

} _flex_button;

typedef struct
{
    uint8_t Pressed_logic_level;/* need user to init */

    uint16_t short_press_start_tick;
    uint16_t long_press_start_tick;
    uint16_t long_hold_start_tick;

    _LINE_IN_TriggerLevel_ (*usr_button_read)(void);
    button_callback  cb;
} _button_para;


void HW_Key_Scan(void);
Config_Res_t HW_Key_InitKey(uint8_t ch, _button_para *para);
void HW_Key_Init(void);
uint16_t Read_HW_Key_Version(void);
#endif