/**************************************************************************//**
  * \file     Sys_Tick.h
  * \brief    System tick timer header file
  * \details
  * \author   Zhang Xuan
  * \version  V1.0.0
  * \date     19-Jul-2018
  * \par      History:
  *           V1.0.0 Initial release
  * \par      Copyright:
  *           (c) Heilongjiang TYW Electronics co., LTD
******************************************************************************/

#ifndef _SYS_TICK_H_
#define _SYS_TICK_H_

/* Includes ------------------------------------------------------------------*/

#include "s6j3360drv.h"

/* C binding of definitions if building with C++ compiler */
#ifdef __cplusplus
extern  {
#endif

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/

/*** Periodic routine of exact 50us ***/
#define   SYS_EXACT_50us_PERIODIC_ROUTINE   SYS_EXACT_50us_TASK_HANDLER

/*** Periodic routine of exact 1ms ***/
#define   SYS_EXACT_1ms_PERIODIC_ROUTINE    SYS_INIT_MODE_TASK_HANDLER

/*** Periodic routine of exact 100ms ***/
#define   SYS_EXACT_100ms_PERIODIC_ROUTINE  SYS_EXACT_100ms_TASK_HANDLER

/* Exported functions ------------------------------------------------------- */
extern void Sys_Tick_Timer_Start(void);
extern void Sys_Tick_Timer_Stop(void);
extern uint16_t Sys_Get_ms_Rolling_Counter(void);

#ifdef __cplusplus
}
#endif

#endif /* _GPIO_H_ */