
#ifndef _SOUND_PLAYER_H_
#define _SOUND_PLAYER_H_

#include "stdint.h"
#include "Sound_Source.h"

extern volatile uint8_t SoundPlaySeatbeltSync;
#define SND_SEATBELT_SYNC SoundPlaySeatbeltSync

#define SND_PLAYER_IDLE     0x00u
#define SND_PLAYER_PLAY_REQ 0x01u
#define SND_PLAYER_PLAYING  0x02u
#define SND_PLAYER_STOP_REQ 0x03u

#define SND_VOLUME_HI  8
#define SND_VOLUME_MID 4
#define SND_VOLUME_LOW 1

typedef struct
{
    uint8_t  Status;
    uint8_t  Playing;
    uint16_t Timer;
    uint8_t  Cycle;
    uint8_t  VolInit;
} SoundPlayCtrlStruct;

void    Sound_Player_Init(void);
uint8_t Sound_Play(uint8_t SoundID);
uint8_t Sound_Stop(uint8_t SoundID);
void    Sound_Clear(void);
uint8_t Sound_Priority_Query(uint8_t SoundID);

void Sound_Play_Service(void);
void DIAG_SoundPlay(void);
void DIAG_SoundStop(void);

uint8_t GetCurSndSrcIndx(void); /*获取正在播放报警音源号*/
/* 播放指定声音，在某个通道 0~3*/
/* 参数  TrackID 音源ID, channel 为通道号码,  cycles 播放周期*/
void    I2S_MAX98357_Play(uint8_t TrackID, uint8_t Channel, unsigned int cycles);
void    BuzzerForceCtrlRequest(void);
void    BuzzerForceCtrlRelease(void);
uint8_t GetBuzzerForceCtrlSta(void);
void    BuzzerCtrlPlayBack(void);
void    BuzzerCtrlStopPlaying(void);

void    Sound_PWM_Service(void);
void    Sound_PWM_Play(uint8_t soundName, uint8_t playAgain_Flag);
void    Sound_PWM_Stop(void);
uint8_t Get_Sound_PWM_Status(void);

extern SoundPlayCtrlStruct SoundPlay;

#endif