#ifndef _Key_H_
#define _Key_H_

#include "stdint.h"

#define   MMI_KEY_CONFIRM                   MMIKey.Confirm
#define   MMI_KEY_LEFT                      MMIKey.Left
#define   MMI_KEY_RIGHT                     MMIKey.Right
#define   MMI_KEY_UP                        MMIKey.Up
#define   MMI_KEY_DOWN                      MMIKey.Down

#define   OTA_KEY                          OTA_Key

#define   MMI_KEY_IDLE                      0x00u       /*No_press*/
#define   MMI_KEY_PRESS                     0x01u       /*Short_Press*/
#define   MMI_KEY_HOLD                      0x02u       /*Long_Press*/
#define   MMI_KEY_KEEP                      0x03u       /*LongPressNotRelease*/

typedef struct
{
    uint8_t WorkMode;

    uint8_t RightSw;
    uint8_t LeftSw;
    uint8_t UpSw;
    uint8_t DownSw;
    uint8_t ConfirmSw;

    uint8_t RightBck;
    uint8_t LeftBck;
    uint8_t UpBck;
    uint8_t DownBck;
    uint8_t ConfirmBck;

    uint8_t Right;
    uint8_t Left;
    uint8_t Up;
    uint8_t Down;
    uint8_t Confirm;

} MMIKeyStruct ;

extern MMIKeyStruct MMIKey;
extern uint8_t OTA_Key;
extern uint8_t EnergyRecovery_Level;
void MMI_Key_DetectHadnleCb10ms(void);
void MMIKeyVarInit(void);
void OTA_Key_Detect(void);
void HW_Key_KL30_Wakeup_Init(void);
void ClearNOuseButton(void);    /*清理按键*/
void EnergyRecovery_Key_Status(void);
void EnergyRecovery0_Key_Status(void);
void OTA_Key_Status(void);
void EnergyRecovery_Key_Detect(void);
void EnergyRecovery0_Key_Detect(void);
uint8_t EnergyRecovery_Key_val(void);
uint8_t EnergyRecovery0_Key_val(void);
void EnergyRecovery_KL30_Init(void);

#endif