/**************************************************************************//**
  * \file     Tasks.c
  * \brief    Task list
  * \details
  * \author   Zhang Xuan
  * \version  V1.0.0
  * \date     07-Sep-2018
  * \par      History:
  *           V1.0.0 Initial release
  * \par      Copyright:
  *           (c) Heilongjiang TYW Electronics co., LTD
******************************************************************************/
#include "include.h"

#include "PowerManagement.h"
#include "System_Status_Monitor.h"
#include "Communication_Over_CAN.h"
#include "Common_Interface.h"
/*电机表头MBD模型部分*/
#include "MBD_Model.h"
#include "LED_Driver.h"
/*背光函数*/
#include "BackLight.h"
/*硬线指示灯部分数据包含*/
#include "Flash_synchronizer.h"
#include "Line_In.h"
/*CAN 网络诊断部分数据包含*/
#include "CAN_APP.h"
#include "CAN_Communication_Matrix.h"
#include "DoCAN_ISO15765.h"
#include "UDS_ISO14229_Server.h"
#include "UDS_Common.h"
/*数据处理部分文件包含*/
#include "Services_Interval.h"
#include "Services_ODO.h"
#include "Services_ODO_Internal.h"
#include "Services_TripA.h" 
#include "Service_Time.h"
#include "RTE_TIME.h"
#include "Service_OFF_Time.h"
/*GUI显示部分*/
#include "Telltales_user.h"
#include "Telltales_Lib.h"
#include "Seatbelt.h"
#include "Key.h"
#include "HW_Key.h"
#include "Gauge_Display.h"
/*报警调度部分*/
#include "Sound_Scheduler.h"
#include "Popup_Scheduler.h"
#include "Popups.h"
#include "Sound_Player.h"
/*出厂清大计*/
#include "ODOReset.h"
#include "BU98R10.h"

#include "RTE_CAN.h"
#include "Radar_R3.h"
#include "Buzzer.h"
#include "GenDelay.h"
#include "EEPROM_24Cxx.h"
#include "Non_volatile_Memorys.h"
extern uint32_t i;
extern uint32_t j;
extern uint32_t Frame;
extern uint32_t GEAR;
extern uint32_t Factory_ClearOdo_Display_Flag;

/*******************************************************************************
*                                                                              *
*   系统常规运行模式(SYS_MODE_OFF / SYS_MODE_ON / SYS_MODE_STANDBY )任务列表   *
*                                                                              *
*******************************************************************************/

/*==============================================================================
伪实时任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_Pseudo_Real_Time_Tasks(void)
{
    Power_Management_Service( );
    DoCAN_Communication_Service( );
    UDS_Server_Application_Service( );
    BU98R10_Update_Service( );
    LED_Driver_Service( );
    EEPROM_RW_Service( );
//    CAN_TX_SetEnable(0x55);
}
/*============================================================================*/



/*==============================================================================
2ms周期执行任务 第0组
------------------------------------------------------------------------------*/
void Sys_Run_Mode_2ms_Tasks_Group0(void)
{
    UDS_KL15_init( );
    Analog_Signal_Conv_Service( );
    Sys_Status_Update_Service( );
    Common_Input_Para( );
    
    UDS_10ms_Service( );
    CanMSg_XMS_Analysis(2u);
    LED_PowerTimer_Service(2u);
    Radar_R3_Receiving_Service( );
    if ( SYS_OPR_STAT_IGN_OFF )
    {
        if ( SleepTime_Timing < 25000u )
        {
            SleepTime_Timing += 2u;
        }
    }
    else
    {
        SleepTime_Timing = 0u;
    }
}

/*==============================================================================
10ms周期执行任务 第0组
------------------------------------------------------------------------------*/
void Sys_Run_Mode_10ms_Tasks_Group0(void)
{
    Can_BusOff_Fun( );
    
    Telltales_Management( );          //指示灯处理
    
    
    BackLight_Ctrl_Service( );        //背光控制
    MMI_Key_DetectHadnleCb10ms( );    //按键处理
    Sound_Play_Service( );            //声音播放服务
    if(Factory_ClearOdo_Display_Flag == 0)
    {
        Telltales_Left_Right_Management_Service( );
    }
    
    NVM_Data_Update_Service( );
    EEPROM_Access_Service( );
}

/*==============================================================================
20ms周期执行任务 第0组
------------------------------------------------------------------------------*/
void Sys_Run_Mode_20ms_Tasks_Group0(void)
{    
    Gauge_Service();                    //量表显示服务
    Line_In_Debounce_Service();         //硬线处理
    Temp_Calc_Send();
}



/*==============================================================================
50ms周期执行任务 第0组
------------------------------------------------------------------------------*/
void Sys_Run_Mode_50ms_Tasks_Group0(void)
{
    Sound_Scheduling_Service();         //声音调度服务
    BU98R10_Update_Request();           //段码硬件更新请求
    Flash_Sync_Signal_Generation_Service(); //闪烁同步信号发生服务
    LED_Driver_Scan_Refresh();          //LED_Driver库调用
    
}


/*==============================================================================
100ms周期执行任务 第0组
------------------------------------------------------------------------------*/
//uint8_t Delay_200ms = 0;
void Sys_Run_Mode_100ms_Tasks_Group0(void)
{
    
    
    
    //SERVICE_Time_Calibration_Service(); //时钟更新服务
    //RTE_RTC_Services_100Ms_Cbk();   //时钟服务函数
    Services_ODO_100MS_Cbk();
    // Services_ODO_100MS_Cbk1();/*程序内部使用,里程备份增加专用里程,非显示里程*/
    Services_TripA_100MS_Cbk();
    Data_Interval_100MS_Cbk();      //保养里程
    Popups_Management_Service();    //报警服务函数
    Popup_Scheduling_Service(); /*报警调度*/
    MBD_AvgVSpeed_Data_100ms();         //平均车速
    //Services_ODO_Sync();            //ODO同步服务
    Factory_ClearOdo(); /*出厂清里程*/
    LED_Driver_Work_Check();//1s  检测异常恢复 
    Three_ClearOdo();
    Maintenance_Current_ODO_Set(NVM_ODO_VALUE );
    Maintenance_Service();
    TYW_check();
    i++;
    j++;
    Frame++;
    GEAR++;
}
/*=================================================================*/

/*******************************************************************************
*                                                                              *
*                     系统休眠模式(SYS_MODE_SLEEP)任务列表                     *
*                                                                              *
*******************************************************************************/
/*==============================================================================
休眠模式下执行的后台任务
------------------------------------------------------------------------------*/
void Sys_Sleep_Mode_Tasks(void)
{

}
/*============================================================================*/

/*******************************************************************************
*                                                                              *
*                           精确的50us计时任务列表                             *
*                                                                              *
*******************************************************************************/
/*==============================================================================
精确的50us计时任务 禁止添加修改列表中的任务
------------------------------------------------------------------------------*/
void Sys_Exact_50us_Tasks(void)
{  
    static uint32_t IG_Off_count=0;
    Buzzer_Play_ISR();
    Common_RollingCounterAdd();
    DoCAN_Timer_Update(50u);
    if ( SYS_OPR_STAT_IGN_OFF )
    {
        if(IG_Off_count<=100000)
        {
            IG_Off_count++;
        }
    }
    else
    {
        IG_Off_count=0u;
    }
    if ( IG_Off_count <= 95000 )
    {
        if(Can_ReadTx_St() == CAN_Y_TX)
        {
            Can_Write_Fun(50);
        }
    }
    UDS_50us_Service();
    
    
    GenDelay_Tick( );
}
/*============================================================================*/

/*******************************************************************************
*                                                                              *
*                           精确的100ms计时任务列表                            *
*                                                                              *
*******************************************************************************/
/*==============================================================================
精确的100ms计时任务 禁止添加修改列表中的任务
------------------------------------------------------------------------------*/
void Sys_Exact_100ms_Tasks(void)
{
    Services_ODO_ISR();
    // Services_ODO_ISR1();/*程序内部使用,里程备份增加专用里程,非显示里程*/
    Power_Sleep_100ms_ISR();
    Data_Interval_TimerISR();
    AvgVSpeedTimeCounter_100ms();   //平均车速
    Service_OFF_Timing_Process();
}
/*============================================================================*/

