#ifndef _POPUP_SCHEDULER_H_
#define _POPUP_SCHEDULER_H_

#include "stdint.h"
#include "stdlib.h"
#include "Popup_List.h"


/******************************************************************************
报警类型定义
******************************************************************************/
#define   POPUP_MODE_PEPS                   0x00u  /* PEPS类型  */
#define   POPUP_MODE_LONG_WARNING           0x01u  /* 长时报警 （可循环的）*/
#define   POPUP_MODE_SHORT_HINT             0x02u  /* 短时提示 （只播一次）*/
#define   POPUP_MODE_LONG_HINT              0x03u  /* 长时提示 （持续播放）*/
#define   POPUP_MODE_ONCE                   0x04u  /*(短时报警) */

/******************************************************************************
显示/声音模式
******************************************************************************/
#define   POPUP_MODE_MULTI                  0x00u  /*可多次触发*/
#define   POPUP_MODE_SINGLE                 0x01u  /*只触发一次*/
/******************************************************************************
报警属性结构
******************************************************************************/
typedef struct
{

uint8_t        Priority;
uint8_t        Class;
const uint8_t  *pMbrList;
uint8_t        MbrCnt;
uint8_t        DispMode;
uint8_t        Snd;
uint8_t        SndMode;
uint16_t        DispTimer_Max;
uint16_t        DispTimer_Min;
} PopupAttributeStruct;

/*报警属性表extern const PopupAttributeStruct PopupAttributeTable[POPUP_NUMBER_TOTAL] */

extern const PopupAttributeStruct *PopupAttributeTable;

/******************************************************************************
报警属性表统计信息
******************************************************************************/
#define   POPUP_NONE                        0xFFu   /*无报警 */
#define   POPUP_PRIORITY_NUMBER_WARNING     50u      /*报警优先级数量*/
#define   POPUP_DISP_TIME_NORMAL            PopupAttributeTable[PopupScheduling.Current].DispTimer_Max /*正常显示时间*/
#define   POPUP_DISP_TIME_MIN               PopupAttributeTable[PopupScheduling.Current].DispTimer_Min /*最小显示时间*/
 

/******************************************************************************
报警状态定义
******************************************************************************/
#define   POPUP_STATUS_OFF                  0x00u   /*未报警*/
#define   POPUP_STATUS_NEW                  0x01u   /*新的报警*/
#define   POPUP_STATUS_FIRST                0x02u   /*首次显示的报警*/
#define   POPUP_STATUS_LOOP                 0x03u   /*循环显示的报警*/
#define   POPUP_STATUS_MASKED               0x04u   /*被屏蔽的报警*/
#define   POPUP_STATUS_DELETE               0x05u   /*被删除的报警*/
#define   POPUP_STATUS_CLEAR                0x06u   /*强制删除*/

/******************************************************************************
查询模式定义
******************************************************************************/
#define   POPUP_POLLING_FORWARD             0x00u
#define   POPUP_POLLING_REVERSE             0x01u

/******************************************************************************
最大优先级数
******************************************************************************/
#define   POPUP_PRIORITY_NUMBER_MAX     POPUP_PRIORITY_NUMBER_WARNING

/******************************************************************************
链表名称
******************************************************************************/

#define   POPUP_LINK_LIST_NEW_WARNING       0u    /*新触发的报警链表*/
#define   POPUP_LINK_LIST_WARNING           1u    /*循环播放的链表*/
#define   POPUP_LINK_LIST_MASKED_WARNING    2u    /*隐藏的报警链表*/

#define   POPUP_LINK_LIST_NONE              255u

/******************************************************************************
弹出信息状态结构
******************************************************************************/
typedef struct
{
    uint8_t   Status;     /*弹出信息状态        */
    uint8_t   LinkList;   /*弹出信息所在链表    */
    uint8_t   Prev;       /*前一个被使能的报警  */
    uint8_t   Next;       /*后一个被使能的报警  */
    uint8_t   SndReqCode; /*声音请求码          */
} PopupStatusStruct;

/******************************************************************************
弹出信息优先级管理结构
******************************************************************************/
typedef struct
{
    uint8_t   First;      /*当前优先级下的第一个弹出信息*/
    uint8_t   Last;       /*当前优先级下的最后一个弹出信息*/
} PopupPrioCtrlStruct;

/******************************************************************************
弹出信息优先级管理结构
******************************************************************************/
typedef struct
{
    uint8_t               Cnt;
    uint8_t               Cur;
    uint8_t               PrioNum;
    PopupPrioCtrlStruct   Prio[POPUP_PRIORITY_NUMBER_MAX];
} PopupLinkListCtrlStruct;

extern PopupLinkListCtrlStruct   PopupLinkList[3];
/******************************************************************************
弹出信息调度结构
******************************************************************************/
typedef struct
{
    uint16_t   Timer;
    uint8_t   Current;
    uint8_t   Message;
    uint8_t   NewSnd;
    uint8_t   WarningExist;
    uint8_t   MaskReq;
    uint8_t   LastMasked;
    uint8_t   MaskedPolling;
} PopupSchedulingStruct;
extern PopupSchedulingStruct     PopupScheduling;
/******************************************************************************
函数声明
******************************************************************************/
void Popup_Scheduler_Init(void);
void Popup_Scheduling_Service(void);        
void PopupAndSound_Delete(uint8_t PopupID);

void Popup_Request(uint8_t PopupID);
void Popup_Delete(uint8_t PopupID);
void Popup_Clear(uint8_t PopupID);
void Popup_Mask_Request(void);
void Popup_Hint_Mask_Request(uint8_t PopupID);

uint8_t Popup_Get_Status(uint8_t PopupID);


uint8_t Popup_Get_Current_Type(void);
uint8_t Popup_Get_Current_Message(void);
uint8_t Popup_Get_Current_Sound(void);
uint8_t Popup_Get_Current_Sound_Req_Code(void);


uint8_t Popup_Get_Warning_Status(void);

uint8_t Popup_Get_First_Masked_Warning(void);
uint8_t Popup_Get_Last_Masked_Warning(void);
uint8_t Popup_Get_Masked_Warning_Msg(void);
void Popup_Masked_Warning_Polling_Reset(uint8_t Mode);
void Popup_Masked_Warning_Polling(uint8_t Mode);
void Popup_Link_List_Init(uint8_t LinkListID, uint8_t PrioNum);
void Popup_Link_List_Insert(uint8_t LinkListID, uint8_t PopupID);
void Popup_Link_List_Remove(uint8_t PopupID);

#endif
