#include "Seatbelt.h"
#include "Communication_Over_CAN.h"
#include "Common_Interface.h"
#include "EOL_Para.h"
#include "Popup_Interface.h"
#include "Services_ODO.h"
#include "Sound_List.h"
#include "Flash_synchronizer.h"
//#include "Telltales_user.h"

#define STOP_THTRSHOLD 0u 

static uint8_t  CurIGSt(void);          /*电源状态  0 off 1 on*/
static uint8_t  Get_Gear_R(void);       /*R挡  1R挡 0非R挡*/
static uint8_t  SelectSeatbeltPopupLevel(void);
uint8_t setbeltsig_Dr = 0u;
uint8_t setbeltsig_Pa = 0u;

uint8_t setbeltsig_2ndL = 0u;
uint8_t setbeltsig_2ndM = 0u;
uint8_t setbeltsig_2ndR = 0u;

uint8_t setbeltsig_2ndLBck = 0u;
uint8_t setbeltsig_2ndMBck = 0u;
uint8_t setbeltsig_2ndRBck = 0u;

uint8_t setbeltsig_2ndL_Not_fasten = 0u;
uint8_t setbeltsig_2ndM_Not_fasten = 0u;
uint8_t setbeltsig_2ndR_Not_fasten = 0u;


/*** 主驾安全带 ***/

volatile uint8_t  WarningSeatbeltDrTel;
volatile uint8_t  WarningSeatbeltDrPopup;
volatile WarningSeatbeltStruct WarningSeatbeltDr;

/*** 副驾安全带 ***/

volatile uint8_t  WarningSeatbeltPaTel;
volatile uint8_t  WarningSeatbeltPaPopup;
volatile WarningSeatbeltStruct WarningSeatbeltPa;

/*** 后排安全带左 ***/

volatile uint8_t WarningSeatbeltTel_2ndL = 0u;
volatile uint8_t WarningSeatbeltPos_2ndL = 0u;
volatile uint8_t WarningSeatbeltPopup_2ndL = 0u;
volatile WarningSeatbeltStruct WarningSeatbelt_2ndL;

/*** 后排安全带中 ***/

volatile uint8_t WarningSeatbeltTel_2ndM = 0u;
volatile uint8_t WarningSeatbeltPos_2ndM = 0u;
volatile uint8_t WarningSeatbeltPopup_2ndM;
volatile WarningSeatbeltStruct WarningSeatbelt_2ndM;

/*** 后排安全带右 ***/

volatile uint8_t WarningSeatbeltTel_2ndR = 0u;
volatile uint8_t WarningSeatbeltPos_2ndR = 0u;
volatile uint8_t WarningSeatbeltPopup_2ndR = 0u;
volatile WarningSeatbeltStruct WarningSeatbelt_2ndR;
/*指示灯间的闪烁协调*/
static uint8_t Blink_Timer;
static uint8_t Blink_Sync;
static  void Blink_Sync_Process(void);


#define   WARNING_OFF       0x00u  /*无报警*/
#define   WARNING_Lv1       0x01u  /*一级报警*/
#define   WARNING_Lv2       0x02u  /*二级报警*/
#define   WARNING_Lv3       0x03u  /*三级报警*/
#define   WARNING_Lv4       0x04u  /*无效的报警请求，用于静音*/


static   uint8_t   IGstatus;      /*电源状态*/
static   uint16_t  GoingMileageRoc ;  /*里程滚动计数*/
static   uint16_t  DispVspeed;    /*显示车速*/
static   uint16_t  ActSpeed;    /*实际车速*/

static   uint8_t   ReverseGear;   /*倒挡信号*/

uint8_t   SeatbeltSelf4sTime;/*自检时间控制*/

static uint8_t  CurIGSt(void)
{
  uint8_t temp;
    
    if(Common_Get_IG_Sts_Valid()==1u)
    {
      temp= Common_Get_IG_Sts();
    }
    else
    {
      temp= 0u;
    }
  return temp ;
}

static uint8_t  Get_Gear_R(void)
{
   uint8_t RGear=0u;
    if(Val_EOL_F110_TCU()==0u)/*手动*/
    {
      if(Get_SigBCM_ReverseGearInfo()==1u)
      {
        RGear =1u;
      }
      else
      {
       RGear =0u;
      }
    }
    else
    { 
      if(Get_SigTCU_ModeGearDisplaySts()==2u)
      {
        RGear =1u;
      }
      else
      {
       RGear =0u;
      }
    }
      
  /*因为Get_Gear_Display返回的值没有手动挡，需要自行处理*/
    
  return RGear;
}

 /*831906-1  831906-2 831906-3 831906-4*/
void SeatbeltSelfCheck(void)
{  

//  if(CurIGSt())   
//  {
//    if(GET_SystemVal_CheckFinishBool()==0u)/*SeatbeltSelf4sTime<40u*/
//    {
//      SeatbeltSelf4sTime=0u;/*SeatbeltSelf4sTime++*/
//    } 
//    else
//    {
//      SeatbeltSelf4sTime=40u;/* 空*/
//    }
//  }
//  else
//  {
//    SeatbeltSelf4sTime=0u;   
//  }
       
}

void SeatbeltInit(void)
{
    /*自检控制时间*/
    SeatbeltSelf4sTime=0u;
    
    /*主驾安全带 Dr*/
    WarningSeatbeltDrTel             = 0u;
    WarningSeatbeltDrPopup           = 0u;

    WarningSeatbeltDr.Poplevel       = 0u;
    WarningSeatbeltDr.LowSpeed300m   = 0u;
    WarningSeatbeltDr.Chk60s         = 0u;
    WarningSeatbeltDr.ConsEnMileage  = Data_MileageRollingCounter_Read();
    WarningSeatbeltDr.Timer          = 0u;
    WarningSeatbeltDr.TelBlink.Duty  = 0u;
    WarningSeatbeltDr.TelBlink.En    = 0u;
    WarningSeatbeltDr.TelBlink.Sync  = 1u;


    /*副驾安全带 Pa*/
    WarningSeatbeltPaTel             = 0u;
    WarningSeatbeltPaPopup           = 0u;

    WarningSeatbeltPa.Poplevel       = 0u;
    WarningSeatbeltPa.LowSpeed300m   = 0u;
    WarningSeatbeltPa.Chk60s         = 0u;
    WarningSeatbeltPa.ConsEnMileage  = Data_MileageRollingCounter_Read();
    WarningSeatbeltPa.Timer          = 0u;
    WarningSeatbeltPa.TelBlink.Duty  = 0u;
    WarningSeatbeltPa.TelBlink.En    = 0u;
    WarningSeatbeltPa.TelBlink.Sync  = 1u;

    /*后排安全带2ndL*/

    WarningSeatbeltTel_2ndL     = 0u;
    WarningSeatbeltPos_2ndL     = 0u;
    WarningSeatbeltPopup_2ndL   = 0u;

    WarningSeatbelt_2ndL.Poplevel       = 0u;
    WarningSeatbelt_2ndL.LowSpeed300m   = 0u;
    WarningSeatbelt_2ndL.Chk60s         = 0u;
    WarningSeatbelt_2ndL.ConsEnMileage  = Data_MileageRollingCounter_Read();
    WarningSeatbelt_2ndL.Timer         = 0u;
    WarningSeatbelt_2ndL.TelBlink.Duty = 0u;
    WarningSeatbelt_2ndL.TelBlink.En   = 0u;
    WarningSeatbelt_2ndL.TelBlink.Sync = 1u;


    /*后排安全带2ndM*/

    WarningSeatbeltTel_2ndM     = 0u;
    WarningSeatbeltPos_2ndM     = 0u;
    WarningSeatbeltPopup_2ndM   = 0u;

    WarningSeatbelt_2ndM.Poplevel       = 0u;
    WarningSeatbelt_2ndM.LowSpeed300m   = 0u;
    WarningSeatbelt_2ndM.Chk60s         = 0u;
    WarningSeatbelt_2ndM.ConsEnMileage  = Data_MileageRollingCounter_Read();
    WarningSeatbelt_2ndM.Timer         = 0u;
    WarningSeatbelt_2ndM.TelBlink.Duty = 0u;
    WarningSeatbelt_2ndM.TelBlink.En   = 0u;
    WarningSeatbelt_2ndM.TelBlink.Sync = 1u;


    /*后排安全带2ndR*/

    WarningSeatbeltTel_2ndR     = 0u;
    WarningSeatbeltPos_2ndR     = 0u;
    WarningSeatbeltPopup_2ndR   = 0u;

    WarningSeatbelt_2ndR.Poplevel       = 0u;
    WarningSeatbelt_2ndR.LowSpeed300m   = 0u;
    WarningSeatbelt_2ndR.Chk60s         = 0u;
    WarningSeatbelt_2ndR.ConsEnMileage  = Data_MileageRollingCounter_Read();
    WarningSeatbelt_2ndR.Timer         = 0u;
    WarningSeatbelt_2ndR.TelBlink.Duty = 0u;
    WarningSeatbelt_2ndR.TelBlink.En   = 0u;
    WarningSeatbelt_2ndR.TelBlink.Sync = 1u;

    setbeltsig_2ndLBck = setbeltsig_2ndL;
    setbeltsig_2ndMBck = setbeltsig_2ndM;
    setbeltsig_2ndRBck = setbeltsig_2ndR;
    
    /*SyncCtrl.Duty=0u;
    SyncCtrl.Sync=0u;不用*/

}


void sigInput(void)
{
//
//    uint8_t temp1, temp2, temp3;
//
//    IGstatus    = CurIGSt();  /*电源状态*/
//    GoingMileageRoc = Data_MileageRollingCounter_Read();/*里程滚动计数器,单位m*/
//    DispVspeed = Common_Get_Disp_V_Speed();/*显示车速*/
//    if(Common_Get_Act_V_Speed_Valid())
//    {
//      ActSpeed = Get_SigESC_VehicleSpeed();
//    }
//    else
//    {
//       ActSpeed=0u;
//    }
//    /*报警声音发声的触发同步信号*/
//    ReverseGear = Get_Gear_R();/*R-挡位 */
//
//    if(IGstatus == 0u)
//    {
//      setbeltsig_Dr = 0u;  
//      setbeltsig_Pa = 0u;  
//      setbeltsig_2ndL =0u;  
//      setbeltsig_2ndM =0u;  
//      setbeltsig_2ndR =0u;
//    }
//    else 
//    {  
//      if(Get_CANMsg380_Sts()!=0x55u) /*仪表连续5帧消息无法收到ACU发送的包含该指示灯状态的信号帧后，仪表按照最后值显示。*/
//      {   
//        /*主安全带报警信号*/                          /*831907-1 */
//        temp1 = Get_SigACU_DrvSeatbeltBucklestatus(); /*831909-1 */
//        temp2 = Get_SigACU_DrvSeatbeltBuckleInvalid();/*831909-2 */
//
//        if ((temp1==1u) && (temp2==0u))
//        {
//            setbeltsig_Dr = 1u;
//        }
//        else
//        {
//            setbeltsig_Dr = 0u;
//        }    
//
//
//
//        /*副安全带报警信号*/
//        temp1 = Get_SigACU_PassSeatbeltWarning();      /*831909-3*/
//        temp2 = Get_SigACU_PassSeatbeltBuckleInvalid();/*831909-4*/
//        temp3 = Get_SigACU_PassSeatOccupantSensorStat();/*831909-5  831910-13*/
//
//        if ((temp1==1u) && (temp2==0u) && (temp3==1u))
//        {
//            setbeltsig_Pa = 1u;
//        }
//        else
//        {
//            setbeltsig_Pa = 0u;
//        }    
//   
//        /*后排安全带报警信号，不超时*/ /*823008-9*/
//        setbeltsig_2ndL = Get_SigACU_2nd_LSeatbeltBucklestatus();/*823008-2*/
//        setbeltsig_2ndM = Get_SigACU_2nd_MSeatbeltBucklestatus();/*823008-3*/
//        setbeltsig_2ndR = Get_SigACU_2nd_RSeatbeltBucklestatus();/*823008-1*/     
//      }
//    }
//
// 
}
/********************************************************************
安全带报警重置
参数：安全带报警结构数据 
      报警位置 
      重置条件（0无条件,1挂入倒挡,2车速转速）
********************************************************************/

void ResetSeatbeltWarning(volatile WarningSeatbeltStruct *Seatbatile, volatile uint8_t *Popup, uint8_t Clear)
{
    
  switch(Clear)
  {
    case    0:{  /*无条件重置*/          
                *Popup = 0u;
                Seatbatile->Timer = 0u;
                Seatbatile->ConsEnMileage = GoingMileageRoc;
                Seatbatile->Poplevel = 0u;
                Seatbatile->LowSpeed300m = 0u;/*每个点火循环清一次*/
                Seatbatile->TelBlink.En = 0u;               
                Seatbatile->TelBlink.Duty = 0u;                
                Seatbatile->TelBlink.Sync = 1u; 
                
              }  break; 
    
    
    case    1:{     
               /*=========================================================
                倒挡：具体看配置MT/AT/DCT/CVT   重置条件车速=0    
                831910-6 831910-14 831910-5 832007-7  823009-14 823009-1
               =========================================================*/     
                if ( (ReverseGear == 1u) ||(DispVspeed == STOP_THTRSHOLD))
                {
                  *Popup = 0u; 
                  Seatbatile->Timer = 0u;      
                  Seatbatile->ConsEnMileage = GoingMileageRoc;
                  Seatbatile->Poplevel = 0u;
                  Seatbatile->LowSpeed300m = 0u;/*清一次*/
                  Seatbatile->TelBlink.En = 0u;
                  Seatbatile->TelBlink.Duty = 0u;
                  Seatbatile->TelBlink.Sync = 1u;
                }
              }break;
    
    default  : break;
           
  }

}



/********************************************************************
安全带报警策略
参数：安全带报警结构数据，报警位置
********************************************************************/


void Seatbelt_logic(volatile WarningSeatbeltStruct * Seatbatile, volatile uint8_t *Popup , uint16_t Second)
{

    uint16_t RollingCounterTemp;
    uint16_t DevMileage; /*里程累积*/
    uint8_t Trigger300mFlag;/*300m条件触发标志*/
    uint8_t TempLv;
    uint8_t CurPopupSnd;


    RollingCounterTemp = GoingMileageRoc;
    Trigger300mFlag = Seatbatile->LowSpeed300m ;
    TempLv = Seatbatile->Poplevel;
    CurPopupSnd = Get_SoundScheduling_Current();
    /*计算行驶里程*/
    if(RollingCounterTemp >= Seatbatile->ConsEnMileage)
    {
      DevMileage= RollingCounterTemp- Seatbatile->ConsEnMileage;
    }
    else
    {
      DevMileage= (0xFFFFu- Seatbatile->ConsEnMileage)+RollingCounterTemp;
    }
     
    /*======================车速>10km/h||行驶距离>300m因为此时还有车速所以写">="=========================*/
    /*831910-2 823009-2 823009-3 823009-11 */
    if (   (  (  (DevMileage >= 300u ) && ( Trigger300mFlag < 1u ) )

              || (( DispVspeed > 100u)&&(ActSpeed>0xACu)) )  )/*平台化取消【&&  (DispESpeed > 400u)】*/
    {
        /*831908-1 831908-2 831908-8 832007-1 832007-2 823009-8 823009-9*/
        if (Seatbatile->Timer < Second)     /*报警计时*/
        {
//            if((CurPopupSnd==SND_FASTEN_SEATBELT_Level_1)||
//               (CurPopupSnd==SND_FASTEN_SEATBELT_Level_2) ||
//                 (CurPopupSnd==SND_FASTEN_SEATBELT_Level_3))
//            {
//              Seatbatile->Timer++;
//            }
//            

    /*===============================声音等级只增不减==========================*/
            if ((DispVspeed > 250u) &&
                   /* (DispVspeed <= 400u) && */
                    (TempLv < WARNING_Lv2))
            {
                *Popup = (uint8_t)WARNING_Lv2;/*二级*/ /*831910-7 831910-8 831910-9 831910-10 831910-11  831908-5  832007-5 823009-4 */
                Seatbatile->Timer = 0u;       /*重置报警时长 (1,2级共用时屏蔽)*//*831908-1*/
            }
           /* else if ((DispVspeed > 400u) &&   三级*//*831908-6 832007-6 823009-5 
                     (TempLv < WARNING_Lv3) )*/
            /* {
                *Popup = WARNING_Lv3;         
                Seatbatile->Timer = 0u;      重置报警时长
            }             */
            else if (TempLv < WARNING_Lv1 )  
            {
                if((SelectSeatbeltPopupLevel())<WARNING_Lv1)
                {
                  *Popup = WARNING_Lv1;         /*一级0.5Hz*//*831908-4  831908-4 831910-2 823009-2  823009-3 823009-11 */
                }
                else
                {
                  *Popup = SelectSeatbeltPopupLevel();  
                }
                
            }
            else
            {}

            Seatbatile->Poplevel = *Popup;    /*记录此时的报警等级*/

            /*连续向前300m一旦达到，不再作为安全带报警的触发条件*/
            if ((DevMileage) >= 300u)
            {
                Seatbatile->LowSpeed300m = 1u;
            }
            else
            {}

        }
        else /*计时已满*/
        {

            if ( (DispVspeed > 250u) &&
                    /*(DispVspeed <= 400u) &&*/
                    (TempLv <= WARNING_Lv2) )
            {
                if (TempLv == WARNING_Lv1)
                {
                    Seatbatile->Timer = 0u;
                }
                else
                {}

                *Popup = (uint8_t)WARNING_Lv4;  /*(1级或二级响完 不响)*/
            }
           /* else if ((DispVspeed > 400u) &&
                     (TempLv <= WARNING_Lv2))

            {
                *Popup = (uint8_t)WARNING_Lv3;
                Seatbatile->Timer = 0u;        重置报警时长
            }*/
            else
            {
                *Popup = (uint8_t)WARNING_Lv4; /*只停声音,保留报警*/
            }
        }

    }
    /*========================================================================
    判断有车速但是不到10km,此时已经触发过报警,如果报警计时不满120s持续计时,
    如果计时满120s报警声音停止【平台化取消((DispVspeed < 100u) && (DispVspeed >= 25u)】
    ========================================================================*/
    else 
    {
        if (TempLv != 0u)
        {
            if (Seatbatile->Timer < Second) /*831910-6  831910-7 831910-8*/ 
            {
//               if((CurPopupSnd==SND_FASTEN_SEATBELT_Level_1)||
//                   (CurPopupSnd==SND_FASTEN_SEATBELT_Level_2) ||
//                    (CurPopupSnd==SND_FASTEN_SEATBELT_Level_3))
//                {
//                  Seatbatile->Timer++;
//                }
            }
            else
            {
                *Popup = (uint8_t)WARNING_Lv4;
            }
        }

    }

    /*===========================有条件停止报警 ====================================*/
     ResetSeatbeltWarning(Seatbatile, Popup, 1u); /*R挡 车速为 0*/

}

/*安全带指示灯*/
void SeatbeltTelltales(volatile WarningSeatbeltStruct * Seatbatile, volatile uint8_t *Popup, volatile uint8_t  *WarningTel)
{
    uint8_t temp;
    uint8_t Temp1, Temp2;
    uint8_t UseSyncSig;/*使用的同步信号*/
    uint8_t CurPopupSnd;/*当前播放的声音*/
    switch (*Popup)
    {
    case 1u: temp = 1u; break;
    case 2u: temp = 1u; break;
    case 3u: temp = 1u; break;
    default:  temp = 0u; break;
    }
    
    CurPopupSnd = Get_SoundScheduling_Current();
//    if((CurPopupSnd==SND_FASTEN_SEATBELT_Level_1)||
//       (CurPopupSnd==SND_FASTEN_SEATBELT_Level_2) ||
//        (CurPopupSnd==SND_FASTEN_SEATBELT_Level_3))
//    {
//      UseSyncSig = Get_SND_SEATBELT_SYNC();
//    }
//    else
//    {
//      UseSyncSig = Blink_Sync;   
//    }
    
    if (temp)       /*有1,2,3级报警提示音时指示灯闪烁同步*/
    {
        if (Seatbatile->Poplevel > 0u)
        {
            Seatbatile->TelBlink.En = 1u;     /*闪烁状态使能：1用于指示灯状态指示 2.控制闪烁走时的标志位*/

            if (Seatbatile->Poplevel == 1u)
            {
                Seatbatile->TelBlink.Cyc = 20u;/*0.5HZ*/  /*831910-2*/
            }
            else
            {
                Seatbatile->TelBlink.Cyc = 10u;/*1HZ*/
            }

            if (UseSyncSig)      /*报警声音发声触发的同步信号Get_SND_SEATBELT_SYNC()*/
            {
                Seatbatile->TelBlink.Duty   = 0u;
                Seatbatile->TelBlink.Sync   = 1u;
            }


            if (Seatbatile->TelBlink.Sync)/*执行闪烁控制*/
            {
                *WarningTel = 1u;
            }
            else
            {
                *WarningTel = 0u;
            }

        }
        else
        {
            Seatbatile->TelBlink.En = 0u;
            Seatbatile->TelBlink.Duty   = 0u;
            Seatbatile->TelBlink.Sync    = 1u;
            *WarningTel = 1u;   /*声音结束后使指示灯点亮*/ /*831910-3 ,831910-4  823009-6  823009-7*/
        }


    }
    else                            /*没触发报警音的处理*/
    {
        Seatbatile->TelBlink.En = 0u;
        Seatbatile->TelBlink.Duty   = 0u;
        Seatbatile->TelBlink.Sync   = 1u;
        *WarningTel = 1u;  /*831910-1  */
    }

    /*=======================指示灯闪烁占空比==============================*/
    Temp1 = Seatbatile->TelBlink.Duty;
    Temp2 = Seatbatile->TelBlink.Cyc;


    if (Seatbatile->TelBlink.En == 1u)
    {
        if (Seatbatile->TelBlink.Duty < 4u)
        {
            Seatbatile->TelBlink.Sync = 1u;
        }
        else
        {
            Seatbatile->TelBlink.Sync = 0u;
        }

        if (Temp1  >= Temp2)
        {
            Seatbatile->TelBlink.Duty = 0u;
        }
        else
        {
            Seatbatile->TelBlink.Duty ++;
        }
    }

}

/*主驾安全带*/
void Warning_Seatbelt_Dr_Processing ( void )
{
  if (IGstatus == 0u)
  {
    WarningSeatbeltDrTel   = 0u;  /*831905-2*/
    ResetSeatbeltWarning(&WarningSeatbeltDr, &WarningSeatbeltDrPopup, 0u); /*无条件复位*/
  }
  else  /*831905-1*/
  {
    if(SeatbeltSelf4sTime<40u) 
    {
       WarningSeatbeltDrTel=1u;  /*831910-12*/
    }
    else  /*831905-4*/
    {
      if (setbeltsig_Dr == 1u) 
      {

          SeatbeltTelltales(&WarningSeatbeltDr, &WarningSeatbeltDrPopup, &WarningSeatbeltDrTel);

          Seatbelt_logic(&WarningSeatbeltDr, &WarningSeatbeltDrPopup, 1200u);/*90801-1*/

      }
      else 
      {
          WarningSeatbeltDrTel   = 0u;
          ResetSeatbeltWarning(&WarningSeatbeltDr, &WarningSeatbeltDrPopup, 0u); /*无条件复位*/
      }
    }
  }

}
/*副驾安全带 */
void Warning_Seatbelt_Pa_Processing ( void )
{

  if (IGstatus == 0u)
  {
    WarningSeatbeltPaTel   = 0u; /*831905-2*/
    ResetSeatbeltWarning(&WarningSeatbeltPa, &WarningSeatbeltPaPopup, 0u); /*无条件复位*/
  }
  else
  {
    if(SeatbeltSelf4sTime<40u)    
    {
       WarningSeatbeltPaTel=1u;
    }
    else
    {

        if (setbeltsig_Pa == 1u)
        {

            SeatbeltTelltales(&WarningSeatbeltPa, &WarningSeatbeltPaPopup, &WarningSeatbeltPaTel);


            Seatbelt_logic(&WarningSeatbeltPa, &WarningSeatbeltPaPopup, 1200u);
        }
        else
        {
            WarningSeatbeltPaTel = 0u;
            ResetSeatbeltWarning(&WarningSeatbeltPa, &WarningSeatbeltPaPopup, 0u); /*无条件复位*/
        }
    }    
  }
}

uint8_t  Setbelt2ndLChk(void)
{
//  uint8_t m8a, m8b ;
//  uint16_t m8c;
//  
//    m8a= ((Get_CANMsg286_Sts() == 0x55u))?0u:Get_SigBCM_RearRightDoorAjarStatus();
//    m8b =((Get_CANMsg285_Sts() == 0x55u))?0u:Get_SigBCM_RearLeftDoorAjarStatus(); 
//    m8c = DispVspeed;
//      
//    if (  (IGstatus == 0u) || (SeatbeltSelf4sTime<40u) ||      /*电源OFF档 或 指示灯自检时 或   */
//                                                               
//          (((m8a == 1u)|| (m8b == 1u))&&(m8c==0u))             /*任意后门开且显示车速为0(<2km/h)*//*823009-13*/
//       )
//    {   
//        setbeltsig_2ndLBck = setbeltsig_2ndL; /*信号初始化*/
//        setbeltsig_2ndL_Not_fasten = 0u;      /*认为后排不再有成员 */ 
//    }
//    else  
//    {
//      if((m8a == 0u)&& (m8b == 0u))/*触发条件必须为门关状态*/
//      {
//        if (setbeltsig_2ndLBck != setbeltsig_2ndL) /*锁扣信号变化*/
//        {   
//          setbeltsig_2ndLBck = setbeltsig_2ndL; 
//            if (setbeltsig_2ndL == 1u)
//            {
//                setbeltsig_2ndL_Not_fasten = 1u;
//            }
//            else
//            {
//                setbeltsig_2ndL_Not_fasten = 0u;
//            }
//        }      
//      }
//
//
//    }
//    return  setbeltsig_2ndL_Not_fasten;
}

uint8_t  Setbelt2ndMChk(void)
{
//    uint8_t m8a, m8b;
//    uint16_t m8c;
//
//    m8a= ((Get_CANMsg286_Sts() == 0x55u))?0u:Get_SigBCM_RearRightDoorAjarStatus();
//    m8b =((Get_CANMsg285_Sts() == 0x55u))?0u:Get_SigBCM_RearLeftDoorAjarStatus(); 
//    m8c = DispVspeed;
//    
//    if (  (IGstatus == 0u)  || (SeatbeltSelf4sTime<40u) ||        /*电源OFF档 或 指示灯自检时 或   */
//                                                                  
//          (((m8a == 1u)|| (m8b == 1u))&&(m8c==0u))                /*任意后门开且显示车速为0(<2km/h)*/
//
//       )
//    {
//        setbeltsig_2ndMBck = setbeltsig_2ndM; /*信号初始化*/
//        setbeltsig_2ndM_Not_fasten = 0u;      /*认为后排不再有成员 */
//    }
//    else
//    {
//      if((m8a == 0u)&& (m8b == 0u))/*触发条件必须为门关状态*/
//      {
//        if (setbeltsig_2ndMBck != setbeltsig_2ndM)/*锁扣信号变化*/
//        {
//          setbeltsig_2ndMBck = setbeltsig_2ndM; 
//            if (setbeltsig_2ndM == 1u)
//            {
//                setbeltsig_2ndM_Not_fasten = 1u;
//            }
//            else
//            {
//                setbeltsig_2ndM_Not_fasten = 0u;
//            }
//
//        }      
//      }
//
//    }
//    return  setbeltsig_2ndM_Not_fasten;
}

uint8_t  Setbelt2ndRChk(void)
{
//
//    uint8_t m8a, m8b;
//    uint16_t m8c;
//    
//    m8a= ((Get_CANMsg286_Sts() == 0x55u))?0u:Get_SigBCM_RearRightDoorAjarStatus();
//    m8b =((Get_CANMsg285_Sts() == 0x55u))?0u:Get_SigBCM_RearLeftDoorAjarStatus(); 
//    m8c = DispVspeed;
//
//    if (  (IGstatus == 0u)  || (SeatbeltSelf4sTime<40u) ||       /*电源OFF档 或 指示灯自检时 或   */
//                                                                 
//          (((m8a == 1u)|| (m8b == 1u))&&(m8c==0u))               /*任意后门开且显示车速为0(<2km/h)*/
//
//       )
//    {
//        setbeltsig_2ndRBck = setbeltsig_2ndR; /*信号初始化*/
//        setbeltsig_2ndR_Not_fasten = 0u;      /*认为后排不再有成员 */
//    }
//    else
//    {
//        if((m8a == 0u)&& (m8b == 0u))/*触发条件必须为门关状态*/
//        {
//          if (setbeltsig_2ndRBck != setbeltsig_2ndR)/*锁扣信号变化*/
//          {
//            
//            setbeltsig_2ndRBck = setbeltsig_2ndR;
//              if (setbeltsig_2ndR == 1u)
//              {
//                  setbeltsig_2ndR_Not_fasten = 1u;
//              }
//              else
//              {
//                  setbeltsig_2ndR_Not_fasten = 0u;
//              }
//            
//          }        
//        }
//
//    }
//    return  setbeltsig_2ndR_Not_fasten;
}

void Warning_Seatbelt_2ndL_Processing ( void )
{
  (void)Setbelt2ndLChk();
  if (IGstatus == 0u) /* 831905-2 831905-3 832004-2  832004-3*/
  {
      WarningSeatbeltPos_2ndL = 0u;/*占位符*/
      WarningSeatbeltTel_2ndL = 0u;/*指示灯*/
      WarningSeatbelt_2ndL.Chk60s = 0u;
      ResetSeatbeltWarning(&WarningSeatbelt_2ndL, &WarningSeatbeltPopup_2ndL, 0u); /*无条件复位*/       
  }
  else  
  {
    if(SeatbeltSelf4sTime<40u)
    {
      WarningSeatbeltTel_2ndL = 1u;  /*832005-1*/
      WarningSeatbeltPos_2ndL = 0u;  /*832005-2*/
    }
    else /*832004-1*/
    {
        if (setbeltsig_2ndL_Not_fasten)/*后左安全带触发条件*/
        {
            SeatbeltTelltales(&WarningSeatbelt_2ndL, &WarningSeatbeltPopup_2ndL, &WarningSeatbeltTel_2ndL); /*823008-8 823009-6 823009-7*/
            Seatbelt_logic(&WarningSeatbelt_2ndL, &WarningSeatbeltPopup_2ndL, 320u);/*823008-8*/
            WarningSeatbelt_2ndL.Chk60s = 600u;   /*初始化结束*/
            WarningSeatbeltPos_2ndL = 1u; /*指示灯状态同步WarningSeatbeltTel_2ndL*/

        }
        else
        {
            if(Get_BackRowAlarmNUM()>0u)
            {
              WarningSeatbelt_2ndL.Chk60s = 600u; 
            }
           
            if ((WarningSeatbelt_2ndL.Chk60s < 600u)) /*初始化60s*/
            {
              WarningSeatbelt_2ndL.Chk60s++;
              if(setbeltsig_2ndL==1u)
              {
                WarningSeatbeltPos_2ndL = 1u ; /*823008-6*/
                WarningSeatbeltTel_2ndL = 1u;              
              }
              else
              {
                WarningSeatbeltPos_2ndL = 0u ; /*823008-6*/
                WarningSeatbeltTel_2ndL = 0u;                   
              }

            }
            else   /*初始化结束*/
            {
              WarningSeatbeltPos_2ndL = 0u;   /*占位符熄灭*//*823008-7*/
              WarningSeatbeltTel_2ndL = 0u;   /*报警灯熄灭*/
            }            
          
            ResetSeatbeltWarning(&WarningSeatbelt_2ndL, &WarningSeatbeltPopup_2ndL, 0u); /*无条件复位*/
        }
    }    
  }

}

void Warning_Seatbelt_2ndM_Processing ( void )
{
  (void)Setbelt2ndMChk();  
  if (IGstatus == 0u)/* 831905-2 831905-3 832004-2  832004-3*/
  {
      WarningSeatbeltPos_2ndM = 0u;/*占位符*/
      WarningSeatbeltTel_2ndM = 0u;/*指示灯*/
      WarningSeatbelt_2ndM.Chk60s = 0u;
      ResetSeatbeltWarning(&WarningSeatbelt_2ndM, &WarningSeatbeltPopup_2ndM, 0u); /*无条件复位*/
  }
  else/*832004-1*/
  { 
    if(SeatbeltSelf4sTime<40u)
    {
      WarningSeatbeltTel_2ndM = 1u;/*832005-1*/
      WarningSeatbeltPos_2ndM = 0u;/*832005-2*/
    }
    else
    {
        if (setbeltsig_2ndM_Not_fasten)
        {
            SeatbeltTelltales(&WarningSeatbelt_2ndM, &WarningSeatbeltPopup_2ndM, &WarningSeatbeltTel_2ndM);/*823008-8 823009-6 823009-7*/
            Seatbelt_logic(&WarningSeatbelt_2ndM, &WarningSeatbeltPopup_2ndM, 320u);/*823008-8*/
            WarningSeatbelt_2ndM.Chk60s = 600u;   /*初始化结束*/
            WarningSeatbeltPos_2ndM = 1u; /*指示灯状态同步WarningSeatbeltTel_2ndM*/

        }
        else
        {
            if(Get_BackRowAlarmNUM()>0u)
            {
              WarningSeatbelt_2ndM.Chk60s = 600u; 
            }
           
            if ((WarningSeatbelt_2ndM.Chk60s < 600u) ) /*初始化60s*/
            {
              WarningSeatbelt_2ndM.Chk60s++;
              if(setbeltsig_2ndM==1u)
              {
                WarningSeatbeltPos_2ndM = 1u ; /*823008-4*/ 
                WarningSeatbeltTel_2ndM = 1u;              
              }
              else
              {
                WarningSeatbeltPos_2ndM = 0u ; /*823008-4*/ 
                WarningSeatbeltTel_2ndM = 0u;   
              }
            }
            else   /*初始化结束*/
            {
              WarningSeatbeltPos_2ndM = 0u;   /*占位符熄灭*//*823008-7*/
              WarningSeatbeltTel_2ndM = 0u;   /*报警灯熄灭*/
            }

            ResetSeatbeltWarning(&WarningSeatbelt_2ndM, &WarningSeatbeltPopup_2ndM, 0u); /*无条件复位*/
        }
    }    
  }

}

void Warning_Seatbelt_2ndR_Processing ( void )
{
  (void)Setbelt2ndRChk();  
  if (IGstatus == 0u)/* 831905-2 831905-3 832004-2  832004-3*/
  {
      WarningSeatbeltPos_2ndR = 0u;/*占位符*/
      WarningSeatbeltTel_2ndR = 0u;/*指示灯*/
      WarningSeatbelt_2ndR.Chk60s = 0u;
      ResetSeatbeltWarning(&WarningSeatbelt_2ndR, &WarningSeatbeltPopup_2ndR, 0u); /*无条件复位*/
  }
  else/* 832004-1*/
  {
    if(SeatbeltSelf4sTime<40u)
    {
      WarningSeatbeltTel_2ndR = 1u;/*832005-1*/
      WarningSeatbeltPos_2ndR = 0u;/*832005-2*/
    }
    else
    {
        if (setbeltsig_2ndR_Not_fasten)
        {
            SeatbeltTelltales(&WarningSeatbelt_2ndR, &WarningSeatbeltPopup_2ndR, &WarningSeatbeltTel_2ndR);/*823008-8 823009-6 823009-7*/
            Seatbelt_logic(&WarningSeatbelt_2ndR, &WarningSeatbeltPopup_2ndR, 320u);/*823008-8*/
            WarningSeatbelt_2ndR.Chk60s = 600u;   /*初始化结束*/
            WarningSeatbeltPos_2ndR = 1u; /*指示灯状态同步WarningSeatbeltTel_2ndR*/
        }
        else
        {
            if(Get_BackRowAlarmNUM()>0u) /*后排有报警自检过程体检终止*/
            {
              WarningSeatbelt_2ndR.Chk60s = 600u; 
            }
            
            if ((WarningSeatbelt_2ndR.Chk60s < 600u)) /*初始化60s*/
            {
              WarningSeatbelt_2ndR.Chk60s++;
              if(setbeltsig_2ndR==1u) 
              {
                WarningSeatbeltPos_2ndR = 1u ; /*823008-5*/
                WarningSeatbeltTel_2ndR = 1u;  /*832005-1*/              
              }
              else
              {
                WarningSeatbeltPos_2ndR = 0u ; /*823008-5*/
                WarningSeatbeltTel_2ndR = 0u;  /*832005-1*/      
              }

            }
            else   /*初始化结束*/
            {
              WarningSeatbeltPos_2ndR = 0u;   /*占位符熄灭*//*823008-7*/
              WarningSeatbeltTel_2ndR = 0u;   /*报警灯熄灭*/
            }

            ResetSeatbeltWarning(&WarningSeatbelt_2ndR, &WarningSeatbeltPopup_2ndR, 0u); /*无条件复位*/        
        }

       
    }
  
  }
}

/*========================================================
  返回值：返回主报警灯的状态 0灭 1亮
  策略：1.四个信号值有任意闪烁时，状态跟随闪烁
        2.状态有一个亮时主报警灯就亮，全都不亮时熄灭
=========================================================*/

uint8_t Get_MainSetbeltTel(void)
{
    uint8_t u8;

    if (WarningSeatbeltDr.TelBlink.En) /*主驾位*/
    {
        u8 = WarningSeatbeltDrTel;
    }
    else if (WarningSeatbeltPa.TelBlink.En) /*副驾位*/
    {
        u8 = WarningSeatbeltPaTel;
    }
    else if (WarningSeatbelt_2ndL.TelBlink.En) /*二排左位*/
    {
        u8 = WarningSeatbeltTel_2ndL;
    }
    else if (WarningSeatbelt_2ndM.TelBlink.En) /*二排中位*/
    {
        u8 = WarningSeatbeltTel_2ndM;
    }
    else if (WarningSeatbelt_2ndR.TelBlink.En) /*二排右位*/
    {
        u8 = WarningSeatbeltTel_2ndR;
    }
    else
    {
        if (WarningSeatbeltDrTel == 1u) 
        {
            u8 = 1u;  
        }
        else if(WarningSeatbeltPaTel ==1u)
        {
            u8 = 1u;
        }
        else if ( WarningSeatbeltTel_2ndL == 1u)
        {
            u8 = 1u;
        }
        else if (WarningSeatbeltTel_2ndM == 1u )
        {
            u8 = 1u;
        }
        else if (WarningSeatbeltTel_2ndR == 1u )
        {
            u8 = 1u;
        }
        else
        {
            u8 = 0u; /*无报警熄灭*/
        }

    }

    return u8;
}
/*返回值： 副驾驶安全带指示灯状态 0灭 1亮 */
uint8_t Get_PassSetbeltTel(void)
{
    return WarningSeatbeltPaTel;
}

/*返回值：安全带报警声音等级 1，2，3  共三个等级  0为无声音报警请求 */
uint8_t  Get_SeatbeltPopupLevel(void)
{
   uint8_t u8;
                                                                              
    if (WarningSeatbeltDr.TelBlink.En)          /*主驾位                       */ 
    {                                           /*                             */ 
        u8 = WarningSeatbeltDr.Poplevel ;       /*WarningSeatbeltDrPopup;      */ 
    }                                           /*                             */ 
    else if (WarningSeatbeltPa.TelBlink.En)     /*副驾驶位                     */
    {                                           /*                             */ 
        u8 = WarningSeatbeltPa.Poplevel;        /*WarningSeatbeltPaPopup;      */ 
    }                                           /*                             */
    else if (WarningSeatbelt_2ndL.TelBlink.En)  /*二排左位                     */
    {                                           /*                             */
        u8 = WarningSeatbelt_2ndL.Poplevel;     /*WarningSeatbeltPopup_2ndL;   */
    }                                           /*                             */
    else if (WarningSeatbelt_2ndM.TelBlink.En)  /*二排中位                     */
    {                                           /*                             */
        u8 = WarningSeatbelt_2ndM.Poplevel;     /*WarningSeatbeltPopup_2ndM;   */
    }                                           /*                             */
    else if (WarningSeatbelt_2ndR.TelBlink.En)  /*二排右位                     */
    {                                           /*                             */
        u8 = WarningSeatbelt_2ndR.Poplevel;     /*WarningSeatbeltPopup_2ndR;   */
    }
    else
    {
        u8 = 0u;/*无报警*/
    }

    return  u8;
}

/*
三级声音报警＞二级声音报警＞一级声音报警警
831908-3
832007-3
823009-11
*/
static uint8_t  SelectSeatbeltPopupLevel(void)
{
    uint8_t Lv[5u],num=0u; /*用于报警等级比较缓存，报警数量做大数目*/
    uint8_t i=0u,max=0u; /*排序*/
    
    Lv[0u] = (WarningSeatbeltDr.TelBlink.En)?WarningSeatbeltDr.Poplevel :0u ;        
    Lv[1u] = (WarningSeatbeltPa.TelBlink.En)?WarningSeatbeltPa.Poplevel :0u ;       
    num=1u;
    
    if(Val_EOL_F101_Seat_O()==0x02u)/*有后排安全带配置*/
    {
      Lv[2u] = (WarningSeatbelt_2ndL.TelBlink.En)?WarningSeatbelt_2ndL.Poplevel :0u;  
      Lv[3u] = (WarningSeatbelt_2ndM.TelBlink.En)?WarningSeatbelt_2ndM.Poplevel :0u;  
      Lv[4u] = (WarningSeatbelt_2ndR.TelBlink.En)?WarningSeatbelt_2ndR.Poplevel :0u;  
      num=4u;
    }
 
  
    for(i=0u; i<num ; i++)
    {
      if(Lv[i]>Lv[i+1u])
      {
        max = Lv[i];
        Lv[i] = Lv[i+1u];
        Lv[i+1u] = max; 
      }
    }
    
    return  Lv[num];
}

uint8_t Get_BackRowAlarmNUM(void)
{
  uint8_t u8=0u;
  if(WarningSeatbelt_2ndL.TelBlink.En)
  {
   u8++;
  }
  if(WarningSeatbelt_2ndM.TelBlink.En)
  {
   u8++;
  }
  if(WarningSeatbelt_2ndR.TelBlink.En)
  {
   u8++;
  }   
  return u8;
}

uint8_t  Get_Seatbelt2nd_CheckSt(void)
{
  uint8_t u8=0u;  
  uint8_t temp3=0u,temp4=0u,temp5=0u;

  if(WarningSeatbelt_2ndL.Chk60s>0u)
  {
     if(WarningSeatbelt_2ndL.Chk60s<600u)
     {
       temp3=1u;
     }
     else
     {
       temp3=0u;
     }
  }
  
  if(WarningSeatbelt_2ndM.Chk60s>0u)
  {  
     if(WarningSeatbelt_2ndM.Chk60s<600u)
     {
       temp4=1u;
     }
     else
     {
       temp4=0u;
     }
  }
  
  if(WarningSeatbelt_2ndR.Chk60s>0u)
  {
     if(WarningSeatbelt_2ndR.Chk60s<600u)
     {
      temp5=1u;
     }
     else
     {
      temp5=0u;
     }  
  }

   
  if((temp3>0u)||(temp4>0u)||(temp5>0u))
  {
    u8=1u;
  }
  else
  {
    u8=0u;
  }
  return u8;
}


static  void Blink_Sync_Process(void)
{
  
  if (SelectSeatbeltPopupLevel()==1u)
  {
    if(Blink_Timer>20u)
    {
      Blink_Sync = 1u;
      Blink_Timer = 0u;
    }
    else
    {
      Blink_Timer++;
    }
  }
  else
  {
    if(Blink_Timer>10u)
    {
      Blink_Sync = 1u;
      Blink_Timer = 0u;
    }
    else
    {
      Blink_Timer++;
    }
  }
}
/***************安全带主服务回调，周期100ms***************/
void SeatbeltService_CB100ms(void)
{
   
    uint8_t Popup; 
   
    sigInput(); /*信号输入*/ 
   
    SeatbeltSelfCheck();  /*自检时间控制*/
   
    Warning_Seatbelt_Dr_Processing();
    Warning_Seatbelt_Pa_Processing();
    if(Val_EOL_F101_Seat_O()==0x02u)/*832001*/
    {
      Warning_Seatbelt_2ndL_Processing();
      Warning_Seatbelt_2ndM_Processing();
      Warning_Seatbelt_2ndR_Processing();    
    }
    else
    {
      WarningSeatbeltPos_2ndL = 0u;/*占位符*/
      WarningSeatbeltTel_2ndL = 0u;/*指示灯*/
      ResetSeatbeltWarning(&WarningSeatbelt_2ndL, &WarningSeatbeltPopup_2ndL, 0u); /*无条件复位*/ 
      
      WarningSeatbeltPos_2ndM = 0u;/*占位符*/
      WarningSeatbeltTel_2ndM = 0u;/*指示灯*/
      ResetSeatbeltWarning(&WarningSeatbelt_2ndM, &WarningSeatbeltPopup_2ndM, 0u); /*无条件复位*/  
      
      WarningSeatbeltPos_2ndR = 0u;/*占位符*/
      WarningSeatbeltTel_2ndR = 0u;/*指示灯*/
      ResetSeatbeltWarning(&WarningSeatbelt_2ndR, &WarningSeatbeltPopup_2ndR, 0u); /*无条件复位*/  
    }

    ReSet_SND_SEATBELT_SYNC();/*重置同步信号*/
    Blink_Sync=0u;
    Blink_Sync_Process();
    
    Popup= SelectSeatbeltPopupLevel();
    if(Popup==1u)
    {
      PopupAndSound_Delete(POPUP_SEATBELT_LV2); 
      PopupAndSound_Delete(POPUP_SEATBELT_LV3); 
      Popup_Request(POPUP_SEATBELT_LV1); 
    }
    else if(Popup==2u)
    {
      PopupAndSound_Delete(POPUP_SEATBELT_LV1); 
      PopupAndSound_Delete(POPUP_SEATBELT_LV3); 
      Popup_Request(POPUP_SEATBELT_LV2);   

    }
    else if(Popup==3u)
    {
      PopupAndSound_Delete(POPUP_SEATBELT_LV1); 
      PopupAndSound_Delete(POPUP_SEATBELT_LV2);
      Popup_Request(POPUP_SEATBELT_LV3);     
    }
    else 
    {
      PopupAndSound_Delete(POPUP_SEATBELT_LV1); 
      PopupAndSound_Delete(POPUP_SEATBELT_LV2); 
      PopupAndSound_Delete(POPUP_SEATBELT_LV3); 
    }
}