#ifndef CAN_COMMUNICATION_MATRIX_H_
#define CAN_COMMUNICATION_MATRIX_H_

#include "TYW_stdint.h"
#include "CAN_Lib.h"

typedef enum
{
    ID_wcan0x18FDA517_Msg_Count,
    ID_wcan0x18FF4117_Msg_Count,
    ID_can0x18F0010B_Msg_Count,
    ID_can0x18FA02EF_Msg_Count,
    ID_MCU_OdometerInfo_Msg_Count,
    ID_can0x18FA40F4_Msg_Count,
    ID_can0x18FA41F4_Msg_Count,
    ID_BMS_BattEnyInfo1_Msg_Count,
    ID_can0x18FA3EF4_Msg_Count,
    ID_can0x18FA42F4_Msg_Count,
    ID_can0x18FAB027_Msg_Count,
    ID_PMS_EnyInfo_Msg_Count,
    ID_can0x18FAB327_Msg_Count,
    ID_PMS_OdometerInfo_Msg_Count,
    ID_TBOX_OTAStatus_Msg_Count,
    ID_can0x18FEE69F_Msg_Count,
    ID_wcan0x18FEE017_Msg_Count,
    ID_wcan0x18FF6F17_Msg_Count,
    ID_wcan0x18FEDA17_Msg_Count,
    ID_wcan0x18DAF117_Msg_Count,
    ID_can0x18FECA10_Msg_Count,
    ID_can0x18FEBF0B_Msg_Count,
    ID_can0x18FF5D27_Msg_Count,
    ID_can0x18FA1727_Msg_Count,
    ID_can0x0CFF1ADA_Msg_Count,
    ID_can0x18FFFFD8_Msg_Count,
    ID_can0x18FA7049_Msg_Count,
    ID_TOTAL_MAX,
} CAN_MSG_ID_t;

typedef enum
{
    MSGID_18FDA517,
   // MSGID_18FF4117,
    MSGID_18FEE017,
    MSGID_18FF6F17,
    MSGID_18FEDA17,
    
    ID_SEND_TOTAL,
} CAN_MSG_SEND_ID_t;

extern const st_CANMsgAttribute CAN_MSG_CONST_ARRAY[ID_TOTAL_MAX] ;
extern const st_CAN_SendAttribute    st_CANSendAttr[ID_SEND_TOTAL] ;

#define  ID_wcan0x18FDA517_Msg      0x18FDA517u
#define  ID_wcan0x18FF4117_Msg      0x18FF4117u
#define  ID_can0x18F0010B_Msg       0x18F0010Bu
#define  ID_can0x18FA02EF_Msg       0x18FA02EFu
#define  ID_MCU_OdometerInfo_Msg    0x18FA09EFu
#define  ID_can0x18FA40F4_Msg       0x18FA40F4u
#define  ID_can0x18FA41F4_Msg       0x18FA41F4u
#define  ID_BMS_BattEnyInfo1_Msg    0x18FC03F4u
#define  ID_can0x18FA3EF4_Msg       0x18FA3EF4u
#define  ID_can0x18FA42F4_Msg       0x18FA42F4u
#define  ID_can0x18FAB027_Msg       0x18FAB027u
#define  ID_PMS_EnyInfo_Msg         0x18FAB227u
#define  ID_can0x18FAB327_Msg       0x18FAB327u
#define  ID_PMS_OdometerInfo_Msg    0x18FAA827u
#define  ID_TBOX_OTAStatus_Msg      0x18FF639Fu
#define  ID_can0x18FEE69F_Msg       0x18FEE69Fu
#define  ID_wcan0x18FEE017_Msg      0x18FEE017u
#define  ID_wcan0x18FF6F17_Msg      0x18FF6F17u
#define  ID_wcan0x18FEDA17_Msg      0x18FEDA17u
#define  ID_wcan0x18DAF117_Msg      0x18DAF117u
#define  ID_can0x18FECA10_Msg       0x18FECA10u
#define  ID_can0x18FEBF0B_Msg       0x18FEBF0Bu
#define  ID_can0x18FF5D27_Msg       0x18FF5D27u
#define  ID_can0x18FA1727_Msg       0x18FA1727u
#define  ID_can0x0CFF1ADA_Msg       0x0CFF1ADAu
#define  ID_can0x18FFFFD8_Msg       0x18FFFFD8u
#define  ID_can0x18FA7049_Msg       0x18FA7049u

extern uint8_t  Get_ID_18FDA517_Sig_ICEnergyReconverLel(void);
extern uint8_t  Get_ID_18FDA517_Sig_ICDoor4EnableStatus(void);
extern uint8_t  Get_ID_18FDA517_Sig_ICDoor4AjarStatus(void);
extern uint8_t  Get_ID_18FDA517_Sig_IC_Door4LockStatus(void);
extern uint8_t  Get_ID_18FDA517_Sig_ICDoor3EnableStatus(void);
extern uint8_t  Get_ID_18FDA517_Sig_ICDoor3AjarStatus(void);
extern uint8_t  Get_ID_18FDA517_Sig_ICDoor3LockStatus(void);
extern uint8_t  Get_ID_18FDA517_Sig_ICDoor2EnableStatus(void);
extern uint8_t  Get_ID_18FDA517_Sig_ICDoor2AjarStatus(void);
extern uint8_t  Get_ID_18FDA517_Sig_ICDoor2LockStatus(void);
extern uint8_t  Get_ID_18FDA517_Sig_ICDoor1EnableStatus(void);
extern uint8_t  Get_ID_18FDA517_Sig_ICDoor1AjarStatus(void);
extern uint8_t  Get_ID_18FDA517_Sig_ICDoor1LockStatus(void);
extern uint8_t  Get_ID_18FF4117_Sig_ICOTADeclimerSelected(void);
extern uint8_t  Get_ID_18FF4117_Sig_ICOTAUpdateResultConfirm(void);
extern uint8_t  Get_ID_18FF4117_Sig_ICOTAUpdateSelected(void);
extern uint8_t  Get_ID_18FF4117_Sig_ICOTADownloadSelected(void);
extern uint8_t  Get_ID_18FF4117_Sig_ICOTAInfoShowStatus(void);
extern uint8_t  Get_ID_18F0010B_Sig_ABSLife(void);
extern uint8_t  Get_ID_18F0010B_Sig_ABSEBDActive(void);
extern uint8_t  Get_ID_18F0010B_Sig_ABSEBDAmberWarningState(void);
extern uint8_t  Get_ID_18F0010B_Sig_ABSABSEBSAmberWarningState(void);
extern uint8_t  Get_ID_18F0010B_Sig_ABSBrakePedalPosition(void);
extern uint8_t  Get_ID_18F0010B_Sig_ABSABSActive(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorSN(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_ActiveShortCircuitState(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_DTC(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorTempSensorErr(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_McuTempSensorErr(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorLockRotErr(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_BusUndervolt(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_HardwareCapOverVolt(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_SoftwareCapOverVolt(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_ActiveDischgFlt(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorWCurrSensorFlt(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorFltLevel(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorVCurrSensorFlt(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorUCurrSensorFlt(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_DCHVCurrSensorFlt(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_MCUMemoryFlt(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_CANCommFlt(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorSubFltLevell(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorSpdHighAlarm(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_MCUTempHighAlarm(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorTempHighAlarm(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_IGBTFlt(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_RotateInverterFlt(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_LV_VotagtFault(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_HVLoopFault(void);
extern uint8_t  Get_ID_18FA02EF_Sig_MCU_MotorSysOverCurrtAlarm(void);
extern uint16_t Get_ID_18FA09EF_Sig_MCU_Odometerbackup(void);
extern uint8_t  Get_ID_18FA40F4_Sig_BMSActWorkSts(void);
extern uint8_t  Get_ID_18FA40F4_Sig_BMSHeatRelaySts(void);
extern uint8_t  Get_ID_18FA40F4_Sig_BMSNegRelaySts(void);
extern uint8_t  Get_ID_18FA40F4_Sig_BMSFaultLevelVCU_BMSFault(void);
extern uint8_t  Get_ID_18FA40F4_Sig_BMSSelfChkState(void);
extern uint8_t  Get_ID_18FA40F4_Sig_BMSPmtCutoffLVFb(void);
extern uint8_t  Get_ID_18FA40F4_Sig_BMSEmergCutoffHVReq(void);
extern uint8_t  Get_ID_18FA40F4_Sig_BMSBattSOH(void);
extern uint8_t  Get_ID_18FA40F4_Sig_BMSBattSOC(void);
extern uint16_t Get_ID_18FA40F4_Sig_BMSBattCurr(void);
extern uint16_t Get_ID_18FA40F4_Sig_BMSBattVol(void);
extern uint8_t  Get_ID_18FA41F4_Sig_BMSHVIsolationInfo_AliveCnt(void);
extern uint8_t  Get_ID_18FA41F4_Sig_BMSTempOutofCtr(void);
extern uint8_t  Get_ID_18FA41F4_Sig_BMSIsolationFault(void);
extern uint8_t  Get_ID_18FA41F4_Sig_BMSHVIsolationSts(void);
extern uint16_t Get_ID_18FA41F4_Sig_BMSNegIsolationRes(void);
extern uint8_t  Get_ID_18FA41F4_Sig_BMS_HVIsolationSts(void);
extern uint16_t Get_ID_18FC03F4_Sig_BMS_ChgTimeRemain(void);
extern uint8_t  Get_ID_18FA3EF4_Sig_BMSChgInfoAliveCnt(void);
extern uint8_t  Get_ID_18FA3EF4_Sig_BMSDCChgReady(void);
extern uint8_t  Get_ID_18FA3EF4_Sig_BMSDCChgStage(void);
extern uint8_t  Get_ID_18FA3EF4_Sig_B2VST1ChgMode(void);
extern uint16_t Get_ID_18FA3EF4_Sig_BMSMaxChgVoltage(void);
extern uint16_t Get_ID_18FA3EF4_Sig_BMSMaxChgCurrent(void);
extern uint8_t  Get_ID_18FA3EF4_Sig_BMSDCChgPlugSts(void);
extern uint8_t  Get_ID_18FA3EF4_Sig_BMSChgStatus(void);
extern uint8_t  Get_ID_18FA3EF4_Sig_BMSElectroniclockSts(void);
extern uint8_t  Get_ID_18FA3EF4_Sig_BMSOBCChgContrlCmd(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_BattFaultInfo_AliveCnt(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_SubFltLevell(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_NonPower_Flt_HVIL(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_PowerActiveMode(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_EnyRecoCurrHighFlt(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_CellTempDiffFault(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_CellVolDiffFault(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_ST1_Flt_HVIL(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_NegRelayFault(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_PosRelayFault(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_ST1_Flt_HW(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_OverChgFault(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_HeatNegRelayFault_Reserved(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_HeatPosRelayFault_Reserved(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_MSDFault(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_CurrSensorFault(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_BattConsistencyFlt(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_BattPackMatchFault(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_CANComFault(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_BattIsolationSts(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_ChargeCurrFault(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_DischargeCurrFault(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_BattEqualizationSts(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_SOCJumpFault(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_BattSOCFault(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_BattTempFault(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_BattCellVolFault(void);
extern uint8_t  Get_ID_18FA42F4_Sig_BMS_BattPackVolFault(void);
extern uint8_t  Get_ID_18FAB027_Sig_VCUHVStatus(void);
extern uint8_t  Get_ID_18FAB027_Sig_VCUVehicleRunMode(void);
extern uint8_t  Get_ID_18FAB027_Sig_VCUIgniteSts(void);
extern uint8_t  Get_ID_18FAB027_Sig_VCUVehicleAbnormalSts(void);
extern uint8_t  Get_ID_18FAB027_Sig_VCUBrkSysErr(void);
extern uint8_t  Get_ID_18FAB027_Sig_VCUBMSFault(void);
extern uint8_t  Get_ID_18FAB027_Sig_VCUMotorTempHighAlarm(void);
extern uint8_t  Get_ID_18FAB027_Sig_VCUHandbrakeSts(void);
extern uint8_t  Get_ID_18FAB027_Sig_VCUGearPositionInd(void);
extern uint16_t Get_ID_18FAB027_Sig_VCUPTSysElecPwrInd(void);
extern uint8_t  Get_ID_18FAB027_Sig_VCUVehicleSysErrorLevel(void);
extern uint8_t  Get_ID_18FAB027_Sig_VCUPTHVSysErrorLampStsInd(void);
extern uint8_t  Get_ID_18FAB027_Sig_VCUDCDCWorkSts(void);
extern uint8_t  Get_ID_18FAB027_Sig_VCUTurtleLampReq(void);
extern uint8_t  Get_ID_18FAB027_Sig_VCUDrivePwrCircuitInd(void);
extern uint8_t  Get_ID_18FAB027_Sig_VCUPTReadyInd(void);
extern uint8_t  Get_ID_18FAB027_Sig_VCUPTModeInd(void);
extern uint8_t  Get_ID_18FAB027_Sig_VCUDriveModeInd(void);
extern uint16_t Get_ID_18FAB227_Sig_PMS_EV_DTEodometer(void);
extern uint16_t Get_ID_18FAB327_Sig_VCU_PTResiduePwrInd(void);
extern uint8_t  Get_ID_18FAB327_Sig_VCU_AEC(void);
extern uint8_t  Get_ID_18FAB327_Sig_VCU_Averagespeed(void);
extern uint32_t Get_ID_18FAB327_Sig_VCU_Cruisingdistance(void);
extern uint16_t Get_ID_18FAA827_Sig_PMS_Odometerbackup(void);
extern uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_DisclaimerWarning(void);
extern uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_PreConditionDetect(void);
extern uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_FailedReason_ChgStatus(void);
extern uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_FailedReason_HandBrake(void);
extern uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_FailedReason_BattVol(void);
extern uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_FailedReason_VehicleSpd(void);
extern uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_FailedReason_GearPos(void);
extern uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_FailedReason_PowerMode(void);
extern uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_DownloadProgress(void);
extern uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_Mode(void);
extern uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_UpdateState(void);
extern uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_UpdateRequest(void);
extern uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_DownloadState(void);
extern uint8_t  Get_ID_18FF639F_Sig_TBOX_OTA_DownloadRequest(void);
extern uint8_t  Get_ID_18FEE69F_Sig_TBOX_Year(void);
extern uint8_t  Get_ID_18FEE69F_Sig_TBOX_Day(void);
extern uint8_t  Get_ID_18FEE69F_Sig_TBOX_Month(void);
extern uint8_t  Get_ID_18FEE69F_Sig_TBOX_Hour(void);
extern uint8_t  Get_ID_18FEE69F_Sig_TBOX_Minute(void);
extern uint8_t  Get_ID_18FEE69F_Sig_TBOX_Second(void);
extern uint32_t Get_ID_18FEE017_Sig_ICTotalVehicleDistance(void);
extern uint32_t Get_ID_18FEE017_Sig_ICTripDistance(void);
extern uint8_t  Get_ID_18FF6F17_Sig_ICMaintanceWarningSts(void);
extern uint16_t Get_ID_18FF6F17_Sig_ICServiceMaintainInterval(void);
extern uint8_t  Get_ID_18FEDA17_Sig_ICSWCompileDay(void);
extern uint8_t  Get_ID_18FEDA17_Sig_ICSWCompileMonth(void);
extern uint8_t  Get_ID_18FEDA17_Sig_ICSWCompileYear(void);
extern uint8_t  Get_ID_18FEDA17_Sig_ICSoftwareMinorVer(void);
extern uint8_t  Get_ID_18FEDA17_Sig_ICSoftwareMajorVer(void);
extern uint8_t  Get_ID_18FEDA17_Sig_ICHardwareMinorVer(void);
extern uint8_t  Get_ID_18FEDA17_Sig_ICHardwareMajorVer(void);
extern uint8_t  Get_ID_18FECA10_Sig_EPSFaultInf(void);
extern uint8_t  Get_ID_18FECA10_Sig_EPSMalfunctionIndicatorLamp(void);
extern uint8_t  Get_ID_18FECA10_Sig_EPSRedStopLamp(void);
extern uint8_t  Get_ID_18FECA10_Sig_EPSAmberWarningLamp(void);
extern uint8_t  Get_ID_18FECA10_Sig_EPSProtectLampStatus(void);
extern uint8_t  Get_ID_18FEBF0B_Sig_ABSRelativeSpd_RAxle2Rwheel(void);
extern uint8_t  Get_ID_18FEBF0B_Sig_ABSRelativeSpdRAxle2_LWheel(void);
extern uint8_t  Get_ID_18FEBF0B_Sig_ABSRelativeSpdRAxle1RWheel(void);
extern uint8_t  Get_ID_18FEBF0B_Sig_ABSRelativeSpdRAxle1Lwheel(void);
extern uint8_t  Get_ID_18FEBF0B_Sig_ABSRelativeSpdFAxleRWheel(void);
extern uint8_t  Get_ID_18FEBF0B_Sig_ABSRelativeSpdFAxleLWheel(void);
extern uint16_t Get_ID_18FEBF0B_Sig_ABSFrontAxleSpeed(void);
extern uint8_t  Get_ID_18FF5D27_Sig_VCU_LockLimResult(void);
extern uint8_t  Get_ID_18FF5D27_Sig_VCU_LockVehType(void);
extern uint8_t  Get_ID_18FF5D27_Sig_VCU_FunAnti_DismantleActive(void);
extern uint8_t  Get_ID_18FF5D27_Sig_VCU_FunLockVehActive(void);
extern uint8_t  Get_ID_18FF5D27_Sig_VCU_LockVehSts(void);
extern uint8_t  Get_ID_18FA1727_Sig_VCU_Life(void);
extern uint8_t  Get_ID_18FA1727_Sig_VCU_StartBattChgRes(void);
extern uint8_t  Get_ID_18FA1727_Sig_VCU_InventorySpdLmtSts(void);
extern uint8_t  Get_ID_18FA1727_Sig_VCU_SpdLmtLevel(void);
extern uint8_t  Get_ID_18FA1727_Sig_VCU_VersionConversionFlag(void);
extern uint8_t  Get_ID_18FA1727_Sig_VCU_LockVehPerFlag(void);
extern uint8_t  Get_ID_0CFF1ADA_Sig_PDC_Warning_Frq(void);
extern uint8_t  Get_ID_0CFF1ADA_Sig_PDC_VirtualDisplaySts(void);
extern uint8_t  Get_ID_18FFFFD8_Sig_VCU_ClearOdo(void);
extern uint8_t  Get_ID_18FFFFD8_Sig_VCU_ClearOdo1(void);
extern uint8_t  Get_ID_18FFFFD8_Sig_VCU_ClearOdo2(void);
extern uint8_t  Get_ID_18FFFFD8_Sig_VCU_ClearOdo3(void);
extern uint8_t  Get_ID_18FFFFD8_Sig_VCU_ClearOdo4(void);
extern uint8_t  Get_ID_18FFFFD8_Sig_VCU_ClearOdo5(void);
extern uint8_t  Get_ID_18FFFFD8_Sig_VCU_ClearOdo6(void);
extern uint8_t  Get_ID_18FFFFD8_Sig_VCU_ClearOdo7(void);
extern uint8_t  Get_ID_18FA7049_Sig_OBC_ChgCCSts(void);
extern uint8_t  Get_ID_18FA7049_Sig_OBC_FaultInfo(void);
extern uint8_t  Get_ID_18FA7049_Sig_OBC_FaultLevel(void);
extern uint8_t  Get_ID_18FA7049_Sig_OBC_ActWorkSts(void);


extern uint8_t  Co_Can_ConvertSubID(uint32_t MsgID);

void Can_Set_Buff_18FDA517(canlib_uint8_t *CopyData);
void Can_Set_Buff_18FF6F17(canlib_uint8_t *CopyData);
//void Can_Set_Buff_18FF4117(canlib_uint8_t *CopyData);
void Can_Set_Buff_18FEDA17(canlib_uint8_t *CopyData);
void Can_Set_Buff_18FEE017(canlib_uint8_t *CopyData);
void Can_Receive(uint8_t val []);
#endif
