#include "CommonFun.h"


#define NULL                   ((void *) 0)

void * my_memcpy(void *dest, void *src, unsigned count )
{
	if (dest == NULL || src == NULL)
	{
		return NULL;
	}
	char* pdest = (char*) dest;
	char* psrc = (char*)src;
	while (count--)
	{
		*pdest++ = *psrc++;
	}
	return dest;
}


void *my_memset(void *dest, int set, unsigned len)
{
	if (dest == NULL || len < 0)
	{
		return NULL;
	}
	char *pdest = (char *)dest;
	while (len-- > 0)
	{
		*pdest++ = set;
	}
	return dest;
}