#include "Services_Interval.h"
#include "EOL_Para.h"
#include "Telltales_user.h"
#include "UDS_2EService_Main.h"
#include "Common_Interface.h"
#include "Maintenance.h"


/* 保养里程服务之前调用 */
void Data_Interval_KMSet(uint32_t CurTotalODO, uint8_t m_IG)
{
    //Data_Interval_Para.Sig.Servicekm = CurTotalODO;
    Data_Input_InterVal.PowerSts = m_IG;
}
/* 100ms中断调用 */
void Data_Interval_TimerISR(void)
{
    //if(Val_EOL_F101_MaintainTimeDispiay()==0u)/*配置为显示保养天数*/
    //{
    //  if (Data_Interval_Para.Sig.ServiceTimer <= 0x1FFFFFFFul)
    //  {
    //      Data_Interval_Para.Sig.ServiceTimer++;
    //  }    
    //}
}
/* Sleep之后停止计时  唤醒后 把这一阶段的时间差补正回来 */
void Data_Interval_TimerSleepFix(uint32_t FixTimer)
{
    if(Val_EOL_F101_MaintainTimeDispiay()==0u)/*配置为显示保养天数*/
    {
      if (Data_Interval_Para.Sig.ServiceTimer <= 0x1FFFFFFFul)
      {
          Data_Interval_Para.Sig.ServiceTimer += FixTimer;
      }    
    }
}

/******************************************************************************
函数名：Data_Service_Interval_Processing
功  能: 剩余保养里程处理
参  数: 无
返回值：无
******************************************************************************/
uint32_t Service_Warning = 0;
uint32_t Maintenance = 0;
void Data_Service_Interval_Processing(void)
{
    if (Common_Get_IG_Sts() == 1)
    {
        Maintenance = Maintenance_Remaining_Mileage_Read();
        if(Maintenance_Remaining_Mileage_Read() == 0)
        {
            Service_Warning =  1;
        }
        else
        {
            Service_Warning =  0;
        }      
    }
}





uint32_t Get_warningInterval(void)
{
    return Service_Warning;
}





/******************************************************************************
函数名：Get_IntervalKM
功  能: 获得保养里程
******************************************************************************/
uint32_t Get_IntervalKM(void)
{
    return Servicekm;/*87606-3*/
}
/******************************************************************************
函数名：Get_IntervalTime
功  能: 获得保养里程
******************************************************************************/
uint32_t Get_IntervalTime(void)
{
    return ServiceTimer;
}

/*
修改保养里程逻辑,内部不再判断报警信号
重置里程参数全靠外部传入
*/

uint16_t Read_Interval_Version(void)
{
    return 0x0003u;
}



uint32_t Get_7101_hex_Value(void)
{
    uint32_t WriteService = 0;
    uint32_t Service = 0;

    Service = (Ser2EToDFlashInfo.DID_7101[0] & 0xF0)>>4; 
    Service  =  Service*100000 ;
    WriteService = WriteService +Service ;
    
    Service  =  (Ser2EToDFlashInfo.DID_7101[0] & 0x0F) ;
    Service = Service*10000;
    WriteService = WriteService +Service ;
    
    Service = (Ser2EToDFlashInfo.DID_7101[1] & 0xF0)>>4; 
    Service  =  Service*1000 ;
    WriteService = WriteService +Service ;
    
    Service  =  (Ser2EToDFlashInfo.DID_7101[1] & 0x0F) ;
    Service = Service*100;
    WriteService = WriteService +Service ;
    
    Service = (Ser2EToDFlashInfo.DID_7101[2] & 0xF0)>>4; 
    Service  =  Service*10 ;
    WriteService = WriteService +Service ;
    
    Service  =  (Ser2EToDFlashInfo.DID_7101[2] & 0x0F) ;
    Service = Service;
    WriteService = WriteService +Service ;
    return WriteService*10;
}

uint32_t Get_7102_hex_Value(void)
{
    uint32_t WriteService = 0;
    uint32_t Service = 0;
    Service = (Ser2EToDFlashInfo.DID_7102[0] & 0xF0)>>4; 
    Service  =  Service*100000 ;
    WriteService = WriteService +Service ;
    
    Service  =  (Ser2EToDFlashInfo.DID_7102[0] & 0x0F) ;
    Service = Service*10000;
    WriteService = WriteService +Service ;
    
    Service = (Ser2EToDFlashInfo.DID_7102[1] & 0xF0)>>4; 
    Service  =  Service*1000 ;
    WriteService = WriteService +Service ;
    
    Service  =  (Ser2EToDFlashInfo.DID_7102[1] & 0x0F) ;
    Service = Service*100;
    WriteService = WriteService +Service ;
    
    Service = (Ser2EToDFlashInfo.DID_7102[2] & 0xF0)>>4; 
    Service  =  Service*10 ;
    WriteService = WriteService +Service ;
    
    Service  =  (Ser2EToDFlashInfo.DID_7102[2] & 0x0F) ;
    Service = Service;
    WriteService = WriteService +Service ;
   
    return WriteService*10;
}

