#ifndef _SERVICE_ODO_H_
#define _SERVICE_ODO_H_

#include "stdint.h"

typedef struct
{
    uint8_t  PowerSts;
    uint8_t  V_Speed_Valid;
    uint8_t  E_Speed_Valid;
    uint16_t Act_V_Speed;
    uint16_t Act_E_Speed;
    uint16_t TireSize;
} _DataODOInputStruct;


typedef struct
{
    uint8_t  UpdateDisable;
} _DataOperationStruct;

typedef struct
{
    uint16_t  mmRollingCounter;
    uint16_t  mmRoCBackup;
} DataMileageCalcStruct;
/*** 控制结构 ***/
typedef struct
{
    uint8_t  UpdateDisable;
    uint8_t  Rsvd;
    uint16_t RoCBackup;
    uint32_t LastSaved;
} DataODOStruct;

#define DataValid       1u
#define DataInValid     0u


#define DataPowerOn       1u
#define DataPowerOFF      0u


extern _DataODOInputStruct Input_ODO_Para;
/*** 里程滚动计数器 ***/
extern uint16_t                DataMileageRollingCounter;
extern DataMileageCalcStruct   DataMileage;

/*** 总计里程 ***/
extern DataODOStruct           DataODOCalc;
extern uint32_t   Data_ODO_Val;
extern uint8_t                 DataODOValid;
extern uint8_t  EEPROM_St;


/*读取里程库版本*/
uint16_t Services_ODO_Version(void);
/*里程清零*/
/*
0-OK
1-500KM
2-3次
 */
uint8_t Services_ODO_Clear(void);
/*里程滚动计数器,单位是m*/
uint16_t Data_MileageRollingCounter_Read(void);
/*读取里程总计*/
uint32_t Data_ODO_Read(void);
/*读取里程有效性 0无效 1有效*/
uint8_t Valid_ODO_Read(void);

void Services_ODO_PulseCbk(uint16_t m_Inc);

/*修改里程总计接口*/
void Data_ODO_Modify ( uint32_t Val_ODO );
/*外部存储调用接口*/
void Services_ODO_SaveCall(uint32_t Val_ODO);
/*禁止更新里程,清零函数调用*/
void Data_ODO_Update_Disable ( void );
/*调用Data_Mileage_Rolling_Counter_Update_ISR  /Data_ODO_Processing 之前 调用,把当前参数穿进去*/
void Data_Mileage_Set_Para(_DataODOInputStruct *m_Para);
/*100ms中断调用*/
void Data_Mileage_Rolling_Counter_Update_ISR ( void );
/*100ms任务调用*/
void Data_ODO_Processing ( void );
/*放在EEPROM初始化之后,只调用一次*/
void Data_ODO_KL30Init ( uint32_t Val_ODO , uint8_t Valid_ODO);
/*KL15初始化,每次上电调用*/
void Data_ODO_KL15Init ( void );
void Services_ODO_ISR(void);
void Services_ODO_100MS_Cbk(void);
void Services_ODO_KL30Init(void);
void Services_ODO_ClearFactory(void);
uint32_t Services_Read_ODO_ClearCnt(void);
uint16_t Services_ODO_mmRollingCounter(void);
/*里程同步功能*/
void Services_ODO_Sync(void);
void Services_ODO_EMS_Set(uint32_t m_EMS_ODO);
void Services_ODO_VCU_Set(uint32_t m_EMS_ODO);
void Services_ODOSync_KL15Init(void);
uint8_t Services_ODO_Read_DelayTimer(void);
void Services_EMS_CounterAdd(void);
void Services_VCU_CounterAdd(void);
uint8_t Services_ODO_Read_DelayTimer(void);
uint8_t Services_ODO_SyncValid(void);
uint8_t Services_ODO_Enable(void);
void Services_ODO_PMS_Read(uint8_t val []);
void Services_ODO_MCU_Read(uint8_t val []);

#endif