#ifndef _SERVICE_ODO_INTERNAL_H_
#define _SERVICE_ODO_INTERNAL_H_

#include "stdint.h"

typedef struct
{
    uint8_t  PowerSts1;
    uint8_t  V_Speed_Valid1;
    uint8_t  E_Speed_Valid1;
    uint16_t Act_V_Speed1;
    uint16_t Act_E_Speed1;
    uint16_t TireSize1;
} _DataODOInputStruct1;


typedef struct
{
    uint8_t  UpdateDisable1;
} _DataOperationStruct1;

typedef struct
{
    uint16_t  mmRollingCounter1;
    uint16_t  mmRoCBackup1;
} DataMileageCalcStruct1;
/*** 控制结构 ***/
typedef struct
{
    uint8_t  UpdateDisable1;
    uint8_t  Rsvd1;
    uint16_t RoCBackup1;
    uint32_t LastSaved1;
} DataODOStruct1;

#define DataValid1       1u
#define DataInValid1     0u


#define DataPowerOn1       1u
#define DataPowerOFF1      0u


extern _DataODOInputStruct1 Input_ODO_Para1;
/*** 里程滚动计数器 ***/
extern uint16_t                DataMileageRollingCounter1;
extern DataMileageCalcStruct1   DataMileage1;

/*** 总计里程 ***/
extern DataODOStruct1           DataODOCalc1;
extern uint32_t   Data_ODO_Val1;
extern uint8_t                 DataODOValid1;
extern uint8_t  EEPROM_St1;


/*读取里程库版本*/
uint16_t Services_ODO_Version1(void);

/*里程滚动计数器,单位是m*/
uint16_t Data_MileageRollingCounter_Read1(void);
/*读取里程总计*/
uint32_t Data_ODO_Read1(void);
/*读取里程有效性 0无效 1有效*/
uint8_t Valid_ODO_Read1(void);
uint32_t Services_Read_ACT_ODO(void);
void Services_ODO_PulseCbk1(uint16_t m_Inc);
void Services_ODO_Modify_Sync(uint32_t m_SyncReason);/*里程备份快照*/
uint32_t Services_Read_ODO_SyncReason(void);/*读取里程快照原因*/
/*修改里程总计接口*/
void Data_ODO_Modify1 ( uint32_t Val_ODO );
/*外部存储调用接口*/
void Services_ODO_SaveCall1(uint32_t Val_ODO);
/*禁止更新里程,清零函数调用*/
void Data_ODO_Update_Disable1 ( void );
/*调用Data_Mileage_Rolling_Counter_Update_ISR  /Data_ODO_Processing 之前 调用,把当前参数穿进去*/
void Data_Mileage_Set_Para1(_DataODOInputStruct1 *m_Para);
/*100ms中断调用*/
void Data_Mileage_Rolling_Counter_Update_ISR1 ( void );
/*100ms任务调用*/
void Data_ODO_Processing1 ( void );
/*放在EEPROM初始化之后,只调用一次*/
void Data_ODO_KL30Init1 ( uint32_t Val_ODO , uint8_t Valid_ODO);
/*KL15初始化,每次上电调用*/
void Data_ODO_KL15Init1 ( void );
void Services_ODO_ISR1(void);
void Services_ODO_100MS_Cbk1(void);
void Services_ODO_KL30Init1(void);
void Services_ODO_ClearFactory1(void);
uint32_t Services_Read_ODO_ClearCnt1(void);
uint16_t Services_ODO_mmRollingCounter1(void);

#endif