#include "Services_TripA.h"
#include "System_Status_Monitor.h"
#include "Line_In.h"
#include "Common_Interface.h"
#include "CAN_Communication_Matrix.h"
#include "ODOReset.h"

void Data_InputTripA_KL15Init(void)
{
    Input_TripA_Para.V_Speed_Valid     = 0u;
    Input_TripA_Para.Act_V_Speed       = 0u;
    Input_TripA_Para.MileageRollingCnt = 0u;
}
/*小计里程的初值,如果车厂不要求掉电存储,默认传0*/
void Data_TripA_KL30Init(uint16_t Base_TripA)
{
    DataTripA                          = Base_TripA;
    DataTripAValid                     = 1u;
    DataTripACalc.Mileage100m          = 0u;
    DataTripACalc.RoCBackup            = 0u;
    Input_TripA_Para.V_Speed_Valid     = 0u;
    Input_TripA_Para.Act_V_Speed       = 0u;
    Input_TripA_Para.MileageRollingCnt = 0u;
}

/*保证在服务函数上方调用*/
void Data_TripA_Set_Para(_DataTripAInputStruct *m_Para)
{
    Input_TripA_Para.V_Speed_Valid     = m_Para->V_Speed_Valid;
    Input_TripA_Para.Act_V_Speed       = m_Para->Act_V_Speed;
    Input_TripA_Para.MileageRollingCnt = m_Para->MileageRollingCnt;
}

/******************************************************************************
函数名：Data_Trip_Processing
功  能: 小计里程数据处理
参  数: 无
返回值：无
******************************************************************************/
void Data_TripA_Processing(void)
{
    uint16_t RollingCounter;
    uint16_t Inc;
    uint16_t m_diff = 0u;

    if ( Input_TripA_Para.V_Speed_Valid )
    {
        RollingCounter = Input_TripA_Para.MileageRollingCnt;

        if ( DataTripAValid == 0u )
        {
            /* DataTripACalc.RoCBackup = RollingCounter;*/
            /*这个位置在每次IG后会重新同步里程，导致1~99m没进位的里程地丢失，吉利要求更正20210317*/
            DataTripAValid = 1u;
        }

        if ( RollingCounter >= DataTripACalc.RoCBackup )
        {
            m_diff = RollingCounter - DataTripACalc.RoCBackup;
        }
        else
        {
            m_diff = 65535u - DataTripACalc.RoCBackup + RollingCounter + 1u;
        }
        if ( m_diff >= 100u )
        {
            Inc = (m_diff) / 100u;
            DataTripACalc.RoCBackup += Inc * 100u;
            DataTripACalc.Mileage100m += Inc;
            if ( DataTripACalc.Mileage100m > 9999u )
            {
                DataTripACalc.Mileage100m -= 10000u;
            }
            DataTripA = DataTripACalc.Mileage100m;
            Services_TripA_SaveCall(DataTripA);
        }
    }
    else
    {
        DataTripAValid = 0u;
    }

    //小计清零判断
    if ( (SYS_OPR_STAT_IGN_ON) && (Get_LINE_IN_Sts(LINE_IN_TRIP_SWITCH) == 1u)
         && (Common_Get_Disp_V_Speed( ) <= 20u) )
    {
        Data_Clear_TripA( );
    }
}

/******************************************************************************
函数名：Data_Clear_Trip
功  能: 小计里程清零
参  数: 无
返回值：无
******************************************************************************/
void Data_Clear_TripA(void)
{
    DataTripA                 = 0u;
    DataTripACalc.Mileage100m = 0u;
    DataTripACalc.RoCBackup   = Input_TripA_Para.MileageRollingCnt;
}

uint16_t Data_Read_TripA(void)
{
    return DataTripA;
}
uint8_t Data_Read_TripAValid(void)
{
    return DataTripAValid;
}

uint16_t Services_TripA_Version(void)
{
    return 0x0001u;
}

//10秒3次清大计
void Three_ClearOdo(void) 
{
    if (Common_Get_Act_V_Speed( ) == 0u)
    {
        if(CAN_MSG_Status(ID_can0x18FFFFD8_Msg_Count) == 0u)
        {
            if(        
                (Get_ID_18FFFFD8_Sig_VCU_ClearOdo() == 0XA3)  &&
                (Get_ID_18FFFFD8_Sig_VCU_ClearOdo1() == 0XB3) &&
                (Get_ID_18FFFFD8_Sig_VCU_ClearOdo2() == 0X00) &&
                (Get_ID_18FFFFD8_Sig_VCU_ClearOdo3() == 0X00) &&
                (Get_ID_18FFFFD8_Sig_VCU_ClearOdo4() == 0X00) &&
                (Get_ID_18FFFFD8_Sig_VCU_ClearOdo5() == 0X00) &&
                (Get_ID_18FFFFD8_Sig_VCU_ClearOdo6() == 0X00) &&
                (Get_ID_18FFFFD8_Sig_VCU_ClearOdo7() == 0X00))

            {
                GeelyReset();
            }

        }
    }
}