/******************************************************************************
�� �� ����Simulated_IIC_Master.c
����������IO�˿�ģ���IIC(I2C)�����������ļ�
��    �ߣ�����
��    ����V1.0
��    �ڣ�2016.12.21
******************************************************************************/

#include "Simulated_IIC_2_Master.h"
 

#include "GPIO.h"
#include "s6j3360_GPIO.h"
uint8_t u8SimulatedIIC2ReceivedACK;


/*I2C  SCL-GPIO��������*/
void SIMULATED_IIC_2_SCL_DIR ( uint8_t x )
{
    if ( x == 1 )
    {
       GPIO_Set_Pin_Direction ( 1, 6, GPIO_DIR_OUT );
    }
    else
    {
       GPIO_Set_Pin_Direction ( 1, 6, GPIO_DIR_IN );
    }
}
/*I2C  SDA-GPIO��������*/
void SIMULATED_IIC_2_SDA_DIR ( uint8_t x )
{

    if ( x == 1 )
    {
        GPIO_Set_Pin_Direction ( 1, 5, GPIO_DIR_OUT );
    }
    else
    {
        GPIO_Set_Pin_Direction ( 1, 5, GPIO_DIR_IN );
    }
}


#define GPIO_IN   0
#define GPIO_OUT  1

void SIMULATED_IIC_2_SCL ( uint8_t x )
{
  GPIO_PODR1_POD6 = x; 
}

void SIMULATED_IIC_2_OUT_SDA ( uint8_t x )
{
  GPIO_PODR1_POD5 = x;
}

uint8_t  SIMULATED_IIC_2_IN_SDA(void)
{
  uint8_t value=0;
  value = GPIO_PIDR1_PID5;
  return value;
}
/******************************************************************************
��������IIC_Init
��  �ܣ���ʼ��IIC����
��  ������
����ֵ����
******************************************************************************/
void Simulated_IIC_2_Init(void)
{

    SIMULATED_IIC_2_SCL_DIR(0); //SCL������Ϊ����,IO��Ϊ����״̬,������SCL�ź���������������,��ʱSCL = 1
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    SIMULATED_IIC_2_SDA_DIR(0); //SDA������Ϊ����,IO��Ϊ����״̬,������SDA�ź���������������,��ʱSDA = 1
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    u8SimulatedIIC2ReceivedACK = SIMULATED_IIC_2_INVALID_ACK;
}

/******************************************************************************
��������IIC_Start
��  �ܣ���IIC�����Ϸ�����ʼ�ź�,����һ��IICͨ��
��  ������
����ֵ����
******************************************************************************/
void Simulated_IIC_2_Start(void)
{
    u8SimulatedIIC2ReceivedACK = SIMULATED_IIC_2_INVALID_ACK;

    SIMULATED_IIC_2_SDA_DIR(0); //SDA������Ϊ����,IO��Ϊ����״̬,������SDA�ź���������������,��ʱSDA = 1
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    SIMULATED_IIC_2_SCL_DIR(0); //SCL������Ϊ����,IO��Ϊ����״̬,������SCL�ź���������������,��ʱSCL = 1
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    SIMULATED_IIC_2_SDA_DIR(1); //SDA���0,��ʱSDA = 0
    SIMULATED_IIC_2_OUT_SDA(0);
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    SIMULATED_IIC_2_SCL_DIR(1); //SCL���0,��ʱSCL = 0
    SIMULATED_IIC_2_SCL (0);
    Simulated_IIC_2_Delay();
}

/******************************************************************************
��������IIC_Stop
��  �ܣ���IIC�����Ϸ���ֹͣ�ź�,��ֹ��ǰIICͨ��
��  ������
����ֵ����
******************************************************************************/
void Simulated_IIC_2_Stop(void)
{
    u8SimulatedIIC2ReceivedACK = SIMULATED_IIC_2_INVALID_ACK;

    SIMULATED_IIC_2_SDA_DIR(1); //SDA���0,��ʱSDA = 0
    SIMULATED_IIC_2_OUT_SDA(0);
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    SIMULATED_IIC_2_SCL_DIR(0); //SCL������Ϊ����,IO��Ϊ����״̬,������SCL�ź���������������,��ʱSCL = 1
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    SIMULATED_IIC_2_SDA_DIR(0); //SDA������Ϊ����,IO��Ϊ����״̬,������SDA�ź���������������,��ʱSDA = 1
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();
}

/******************************************************************************
��������IIC_Transmit_Data
��  �ܣ���IIC�����Ϸ���1�ֽ�����
��  ����Data�����͵�����
����ֵ��������������ȷ��(ACK)  0 - ACK  1 - NAK
******************************************************************************/
void Simulated_IIC_2_Transmit_Data(uint8_t Data)
{
    uint8_t i;

    u8SimulatedIIC2ReceivedACK = SIMULATED_IIC_2_INVALID_ACK;

    for (i = 0; i < 8; i++)
    {
        if (Data & 0x80)
            SIMULATED_IIC_2_SDA_DIR(0); //SDA������Ϊ����,IO��Ϊ����״̬,������SDA�ź���������������,��ʱSDA = 1
        else
        {
            SIMULATED_IIC_2_SDA_DIR (1); //SDA���0,��ʱSDA = 0
            SIMULATED_IIC_2_OUT_SDA(0);
        }
        Simulated_IIC_2_Delay();
        Simulated_IIC_2_Delay();

        SIMULATED_IIC_2_SCL_DIR(0); //SCL������Ϊ����,IO��Ϊ����״̬,������SCL�ź���������������,��ʱSCL = 1
        Simulated_IIC_2_Delay();
        Simulated_IIC_2_Delay();

        SIMULATED_IIC_2_SCL_DIR(1); //SCL���0,��ʱSCL = 0
        SIMULATED_IIC_2_SCL (0);
        Simulated_IIC_2_Delay();

        Data <<= 1;
    }

    SIMULATED_IIC_2_SDA_DIR(0); //����SDAΪ����״̬
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    SIMULATED_IIC_2_SCL_DIR(0); //SCL������Ϊ����,IO��Ϊ����״̬,������SCL�ź���������������,��ʱSCL = 1
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    u8SimulatedIIC2ReceivedACK = SIMULATED_IIC_2_IN_SDA();

    SIMULATED_IIC_2_SCL_DIR (1); //SCL���0,��ʱSCL = 0
    SIMULATED_IIC_2_SCL(0);
    Simulated_IIC_2_Delay();
}

/******************************************************************************
��������IIC_Receive_Data
��  �ܣ���IIC�����Ͻ���1�ֽ�����
��  ������
����ֵ�����յ�������
******************************************************************************/
uint8_t Simulated_IIC_2_Receive_Data(void)
{
    uint8_t i;
    uint8_t Data;

    Data = 0;

    SIMULATED_IIC_2_SDA_DIR(0); //����SDAΪ����״̬
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    for (i = 0; i < 8; i++)
    {
        Data <<= 1;

        SIMULATED_IIC_2_SCL_DIR(0); //SCL������Ϊ����,IO��Ϊ����״̬,������SCL�ź���������������,��ʱSCL = 1
        Simulated_IIC_2_Delay();
        Simulated_IIC_2_Delay();
        Simulated_IIC_2_Delay();

        Data |= SIMULATED_IIC_2_IN_SDA();

        SIMULATED_IIC_2_SCL_DIR(1); //SCL���0,��ʱSCL = 0
        SIMULATED_IIC_2_SCL(0);
        Simulated_IIC_2_Delay();
        Simulated_IIC_2_Delay();
    }

    return Data;
}

/******************************************************************************
��������IIC_Transmit_ACK
��  �ܣ���IIC�����Ϸ���ȷ���ź�
��  ����ACK��ȷ���źŵ����ͣ� SIMULATED_IIC_2_ACK  �϶�Ӧ��
                              IIC_NAK  ��Ӧ��
����ֵ����
******************************************************************************/
void Simulated_IIC_2_Transmit_ACK(uint8_t ACK)
{
    u8SimulatedIIC2ReceivedACK = SIMULATED_IIC_2_INVALID_ACK;

    if (ACK > SIMULATED_IIC_2_NAK)
        return;

    if (ACK)
        SIMULATED_IIC_2_SDA_DIR(0); //SDA������Ϊ����,IO��Ϊ����״̬,������SDA�ź���������������,��ʱSDA = 1
    else
    {
        SIMULATED_IIC_2_SDA_DIR(1); //SDA���0,��ʱSDA = 0
        SIMULATED_IIC_2_OUT_SDA(0);
    }
    Simulated_IIC_2_Delay();

    SIMULATED_IIC_2_SCL_DIR(0); //SCL������Ϊ����,IO��Ϊ����״̬,������SCL�ź���������������,��ʱSCL = 1
    Simulated_IIC_2_Delay();
    Simulated_IIC_2_Delay();

    SIMULATED_IIC_2_SCL_DIR(1); //SCL���0,��ʱSCL = 0
    SIMULATED_IIC_2_SCL(0);
    Simulated_IIC_2_Delay();
}

/******************************************************************************
��������IIC_Receive_ACK
��  �ܣ���ȡ�������Ͻ��յ���ȷ���ź�
��  ������
����ֵ��������������ȷ���ź����ͣ�Simulated_IIC_ACK        �϶�Ӧ��
                                  SIMULATED_IIC_2_NAK         ��Ӧ��
                                  IIC_INVALID_ACK ��Ч��Ӧ���ź�(Ӧ���źŻ�δ�յ�)
******************************************************************************/
uint8_t Simulated_IIC_2_Receive_ACK(void)
{
    uint8_t ACK;

    ACK = u8SimulatedIIC2ReceivedACK;
    u8SimulatedIIC2ReceivedACK = SIMULATED_IIC_2_INVALID_ACK;

    return ACK;
}

/******************************************************************************
��������IIC_Delay
��  �ܣ���ʱ5us,�����շ������е�ʱ�����
        ע�⣺�������IIC_5us_DELAY_CALIBRATION����У׼��ʱʱ����5us����
��  ����ACK��ȷ���źŵ�����  0 - ACK  1 - NAK
����ֵ����
******************************************************************************/
void Simulated_IIC_2_Delay(void)
{
    uint8_t i;

    for (i = 0; i < SIMULATED_IIC_2_FREQ_CALIBRATION; i++)
          asm("nop");
}
