#ifndef _SEG_DISPLAY_H_
#define _SEG_DISPLAY_H_
#include "CommonFun.h"
#include "Seg_Ref.h"
#include "BU98R10.h"

typedef enum
{
    SEG_LED_TurnLeft = 0u,        
    SEG_LED_TurnRight,
    SEG_LED_Hbeam,
    SEG_LED_Lbeam,
    SEG_LED_Position,
    SEG_LED_RearFog,
    SEG_LED_Daylight,
    SEG_LED_ABS,
    SEG_LED_EBD_fault,
    SEG_LED_BrakeSystemFault,
    SEG_LED_EPB_Status,
    SEG_LED_EPS,
    SEG_LED_SEATBELT_DR,
    SEG_LED_SOC_CF,
    SEG_LED_SOC_CC,
    SEG_LED_SOC_CS,
    SEG_LED_SOC_LP,
    SEG_LED_SOC_Fault,
    SEG_LED_SOC_HT,
    SEG_LED_SystemFault,
    SEG_LED_READY,
    SEG_LED_MotorFault,
    SEG_LED_PowerLimit,
    SEG_LED_ECO,
    SEG_LED_InsulationFault,
    SEG_LED_Energy_Recovery,
    SEG_LED_HighPressureInterlock,
    SEG_LED_DoorOpen,
    SEG_LED_FrontFog,
    SEG_LED_RemoteLocking,
    SEG_LED_MaintainWarning,
    SEG_LED_MotorOverheating,
    SEG_LED_SOC_DC,

    SEG_LED_MAX
} SEG_LED_Idx_t;

enum
{
  Gear_P = 0,  //P
  Gear_R,      //R
  Gear_N,      //N
  Gear_D,      //D
  Gear_S,      //S
}; 

/**@brief �߿�����ʾ����*/
_Fun_Res SEG_SET_Frame(uint8_t m_Flag);

/**@brief ��λ��ʾ����*/
_Fun_Res SEG_SET_GEAR(uint8_t m_Gear_Flag,uint8_t m_Gear);

/**@brief ����������ʾ����*/
_Fun_Res SEG_SET_EleDial(uint8_t m_Flag,uint8_t m_SEG,uint8_t m_NUM);

/**@brief ���ʱ�����ʾ����*/
_Fun_Res SEG_SET_PowerDial(uint8_t m_Flag,uint8_t m_SEG,uint8_t m_Sign,uint8_t m_NUM);

/**@brief ���������ʾ����*/
_Fun_Res SEG_SET_DTE_NUM(uint8_t m_Flag, uint16_t m_NUM);

/**@brief ����8�ֶ���ʾ����*/
_Fun_Res SEG_SET_VSpeed_NUM(uint8_t m_Flag , uint16_t m_NUM);

/**@brief L8�ֶ���ʾ����*/
_Fun_Res SEG_SET_L8_NUM(uint8_t m_Flag , uint8_t m_NUM);

/**@brief �ܼ������ʾ����*/
_Fun_Res SEG_SET_ODO_NUM(uint8_t m_Flag,uint32_t m_NUM);

/**@brief С�������ʾ����*/
_Fun_Res SEG_SET_TRIP_NUM(uint8_t m_Flag,uint16_t m_NUM);

/**@brief ʱ����ʾ����*/
_Fun_Res SEG_SET_Clock(uint8_t m_hour, uint8_t m_minute, uint8_t m_icon, uint8_t m_Flag1, uint8_t m_Flag2 );


#define IC_SEG_OFF_LED   0x00u
#define IC_SEG_OFF   0x00u
#define IC_SEG_ON    0x07u
#define IC_SEG_GREY  0x01u 
#define IC_SEG_SPEED  0x01u 
/**@brief ָʾ����ʾ����*/
_Fun_Res SEG_SET_LED_STS(uint8_t LED_NUM , uint8_t m_Flag);

//ɨ����
_Fun_Res SEG_Scan_SET_EleDial(uint8_t m_SEG);
_Fun_Res SEG_Scan_SET_PowerDial(uint8_t m_SEG);

void SEG_IG_OFF_Init(void);

//----------------------------------------------------------------------------------------------------
/**@brief �߿�����ʾ����*/
_Fun_Res SEG_SET_Frame1(uint8_t m_Flag);

/**@brief ��λ��ʾ����*/
_Fun_Res SEG_SET_GEAR1(uint8_t m_Gear_Flag,uint8_t m_Gear);

/**@brief ����������ʾ����*/
_Fun_Res SEG_SET_EleDial1(uint8_t m_Flag,uint8_t m_SEG,uint32_t m_NUM);

/**@brief ���ʱ�����ʾ����*/
_Fun_Res SEG_SET_PowerDial1(uint8_t m_Flag,uint8_t m_SEG,uint8_t m_Sign,uint32_t m_NUM);

/**@brief ���������ʾ����*/
_Fun_Res SEG_SET_DTE_NUM1(uint8_t m_Flag, uint16_t m_NUM);

/**@brief ����8�ֶ���ʾ����*/
_Fun_Res SEG_SET_VSpeed_NUM1(uint8_t m_Flag , uint16_t m_NUM);

/**@brief L8�ֶ���ʾ����*/
_Fun_Res SEG_SET_L8_NUM1(uint8_t m_Flag , uint8_t m_NUM);

/**@brief �ܼ������ʾ����*/
_Fun_Res SEG_SET_ODO_NUM1(uint8_t m_Flag,uint32_t m_NUM);

/**@brief С�������ʾ����*/
_Fun_Res SEG_SET_TRIP_NUM1(uint8_t m_Flag,uint16_t m_NUM);

/**@brief ʱ����ʾ����*/
_Fun_Res SEG_SET_Clock1(uint8_t m_hour, uint8_t m_minute, uint8_t m_icon, uint8_t m_Flag1, uint8_t m_Flag2 );

_Fun_Res SEG_Scan_SET_EleDial1(uint8_t m_SEG);
_Fun_Res SEG_Scan_SET_PowerDial1(uint8_t m_SEG);
_Fun_Res SEG_SET_LED_STS1(uint8_t LED_NUM , uint8_t m_Flag);

#endif
