

#ifndef _NON_VOLATILE_MEMORYS_H_
#define _NON_VOLATILE_MEMORYS_H_

#include "EEPROM_24Cxx_Remap.h"
#include "Maintenance.h"
#include "Maintenance_user.h"

/******************************************************************************
����ʧ�����ݴ洢������
******************************************************************************/
#define   NVM_USE_EEPROM                    1           //0���Ͽ�EEPROM,ǿ��ʹ������Ĭ��ֵ
//1��ʹ��EEPROM�������ʧ������

extern uint8_t NVMEEPROMFault;
#define   NVM_EEPROM_FAULT                  NVMEEPROMFault

/******************************************************************************
��ʼ����ʶ

���������ƣ� NVM_INIT_DATA
  �źų�Ա�� -- NVM_INIT_FLAG
******************************************************************************/
/*** �ṹ���� ***/
typedef union
{
    struct
    {
        uint8_t Flag[4];
    } Sig;

    uint8_t Data[4];
} NVMInitUnion;

/*** �źŶ��� ***/
extern NVMInitUnion                         NVMInit;

#define   NVM_INIT_FLAG                     NVMInit.Sig.Flag

/*** �ź�Ĭ��ֵ ***/
static  NVMInitUnion NVMDefaultInit =
{
    /* Flag[]                       = */      "TYW",//"TYW",   3.9���� ��T2W
};

/******************************************************************************
����ܼ�

���������ƣ� NVM_ODO_DATA
  �źų�Ա�� -- NVM_ODO_VALUE
******************************************************************************/
/*** �ṹ���� ***/
typedef union
{
    struct
    {
        uint32_t  Value;
        uint8_t   ClrCnt;
        uint8_t   Rsvd;
        uint16_t  Cleared;
    } Sig;
    uint8_t Data[8];
} NVMODOUnion;

/*** �źŶ��� ***/
extern NVMODOUnion                          NVMODO;

#define   NVM_ODO_VALUE                     NVMODO.Sig.Value
#define   NVM_ODO_CLEAR_COUNT               NVMODO.Sig.ClrCnt
#define   NVM_ODO_CLEARED                   NVMODO.Sig.Cleared

/*** �źŶ��� ***/
extern NVMODOUnion                          NVMODO_back;

#define   NVM_ODO_back_VALUE                     NVMODO_back.Sig.Value
#define   NVM_ODO_back_CLEAR_COUNT               NVMODO_back.Sig.ClrCnt
#define   NVM_ODO_back_CLEARED                   NVMODO_back.Sig.Cleared

/*** �ź�Ĭ��ֵ ***/
static  NVMODOUnion NVMDefaultODO =
{
    /* Value                        = */      0,
    /* ClrCnt                       = */      3,
    /* Rsvd                         = */      0,
    /* Cleared                      = */      0,
};

static  uint8_t  u8NVMDefaultZero[16] =
{
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};

/******************************************************************************
�洢�������Ա�
******************************************************************************/
/*** �ṹ���� ***/
typedef struct
{
    uint8_t   *pData;
    uint8_t   *pDefaultValue;
    uint8_t   Len;
    uint8_t   DataType;
    uint16_t  Addr;
} NVMDataAttributeTableStruct;

/*** �洢�����б� ***/
#define   NVM_INIT_DATA                     0
#define   NVM_ODO_DATA                      1
#define   NVM_ODO_back_DATA                 2
#define   NVM_MAINTENANCE                 3

/*** �洢�������Ա� ***/
static  NVMDataAttributeTableStruct NVMDataAttributeTable[] =
{
    /*===================================================================================================================================================================
                              |            RAM��           |                                    |                        |        ����ʧ����        | ����ʧ���ݴ洢��
             ��������         |        ���ݴ洢λ��        |               Ĭ��ֵ               |        ���ݳ���        |         �洢����         |    �д洢��ַ
    -------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
    {/* NVM_INIT_DATA        */                NVMInit.Data,                 NVMDefaultInit.Data,         sizeof ( NVMInit ),    0,           0x0000 },
    {/* NVM_ODO_DATA         */                NVMODO.Data,                  NVMDefaultODO.Data,          sizeof ( NVMODO ),     0,           0x0001 },
    {/* NVM_ODO_DATA         */                NVMODO_back.Data,             NVMDefaultODO.Data,          sizeof ( NVMODO_back ),     0,      0x0002 },
    {/* NVM_MAINTENANCE      */                u8MaintData     ,        u8NVMDefaultZero,          16,     2,      0x0000 },
    /*=================================================================================================================================================================*/
};

/*** �洢�������� ***/
#define   NVM_TOTAL_DATA_NUM                (sizeof(NVMDataAttributeTable) / sizeof(NVMDataAttributeTableStruct))

/******************************************************************************
���ݸ��¿��ƽṹ
******************************************************************************/
typedef struct
{
    uint8_t Enable;
    uint8_t Req[NVM_TOTAL_DATA_NUM];
    uint8_t Current;
} NVMUpdateCtrlStruct;

/******************************************************************************
��������
******************************************************************************/
void NVM_Init ( void );
void NVM_Data_Update ( uint8_t DataName );
void NVM_Data_Update_Service ( void );

#endif