#include "AirBagSelfChecking.h"
#include "Common_Interface.h"
#pragma location ="BACKUP_RAM_CONTENT"
AirBagFeedbackStructure AirBagFeedback;
/*安全带指示灯自检反馈*/
void Air_Bag_LED_Testing_CB100ms(void)
{
#if 0
    /*IGON状态检测*/
    if (Common_Get_IG_Sts() == 1u)
    {
        /*获取期望值*/
        AirBagFeedback.ExpectStatus = Get_AirBag_Expected_Status();

        /*跳变滤波延时300ms*/
        if (AirBagFeedback.ExpectStatusBack != AirBagFeedback.ExpectStatus)
        {
            AirBagFeedback.ExpectStatusBack = AirBagFeedback.ExpectStatus;
            AirBagFeedback.RollbackTimer = 2u;
        }

        else
        {
            if (AirBagFeedback.RollbackTimer > 0u)
            {
                AirBagFeedback.RollbackTimer--; /*延时采样*/
            }
        }

        if (AirBagFeedback.RollbackTimer == 0u) /*滤波时间到*/
        {
            AirBagFeedback.SampleValue = ADC_Read_Signal(ADC_CH_AIRBAG_LED_V); /*获取采样结果*/

            if (AirBagFeedback.ExpectStatusBack > 0u) /*硬件驱动指示灯点亮 app:0x1/2F:0x81*/
            {
                if ((AirBagFeedback.SampleValue > 1000u) && (AirBagFeedback.SampleValue < 3000u)) /*正常驱动电压范围*/
                {
                    AirBagFeedback.ActualStatus = (Get_AirBagLogicStatus() == 2u) ? 2u : 1u; /*逻辑控制指示灯闪烁 2u / 点亮 1u*//*831609-3*//*831609-4*/
                }
                else
                {
                    AirBagFeedback.ActualStatus = 3u; /*短路或开路*/  /*831609-5*/
                }

            }
            else
            {
                if (Get_AirBagLogicStatus() != 2u)
                {
                    AirBagFeedback.ActualStatus = 0u;/*831609-2*/
                }
            }
        }
    }
    else
    {
        AirBagFeedback.ExpectStatus = 0u;
        AirBagFeedback.ActualStatus = 0u;
        AirBagFeedback.ExpectStatusBack = 0u;
        AirBagFeedback.RollbackTimer = 2u;
    }
#endif
}
void Air_Bag_LED_Testing_Init(void)
{
    AirBagFeedback.ExpectStatus = 0u;
    AirBagFeedback.ActualStatus = 0u;
    AirBagFeedback.ExpectStatusBack = 0u;
    AirBagFeedback.RollbackTimer = 2u;
}
uint8_t Get_AirBagActualStatus(void)
{
    return AirBagFeedback.ActualStatus;
}
