#ifndef _AIRBAG_SELF_CHECKING_H_
#define _AIRBAG_SELF_CHECKING_H_

#include "stdint.h"

typedef struct
{
    uint16_t SampleValue;     /*采样电压*/
    uint8_t  ExpectStatus;    /*预期输出状态 1点亮 0熄灭*/
    uint8_t  ActualStatus;    /*实际输出状态 1点亮 0熄灭*/
    uint8_t  ExpectStatusBack;/*预期输出状态备份值，用于检测状态反转*/
    uint8_t  RollbackTimer;   /*状态反转后需要进行延时采样100ms+200ms*/
} AirBagFeedbackStructure;

extern AirBagFeedbackStructure AirBagFeedback;

void Air_Bag_LED_Testing_CB100ms(void);
void Air_Bag_LED_Testing_Init(void);
uint8_t Get_AirBagActualStatus(void);
#endif