/************************************************ ******************************
文 件 名：Flash_synchronizer.h
功能描述：闪烁同步信号发生器库文件
作    者：张暄
版    本：V1.0
日    期：2017.04.02
******************************************************************************/

#include "Flash_synchronizer.h"

volatile uint8_t FlashSync1Hz;
volatile uint8_t FlashSync2Hz;
volatile uint8_t FlashSync4Hz;
volatile uint8_t FlashSync5Hz;
volatile uint8_t FlashSync05Hz;

const uint8_t FlashSync05HzTable[]= {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u,
                                     0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u,
                                     1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u,
                                     1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u,
                                    };
const uint8_t FlashSync1HzTable[] = {0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u,
                                     1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u,
                                     0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u, 0u,
                                     1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u, 1u,
                                    };
const uint8_t FlashSync2HzTable[] = {0u, 0u, 0u, 0u, 0u, 1u, 1u, 1u, 1u, 1u,
                                     0u, 0u, 0u, 0u, 0u, 1u, 1u, 1u, 1u, 1u,
                                     0u, 0u, 0u, 0u, 0u, 1u, 1u, 1u, 1u, 1u,
                                     0u, 0u, 0u, 0u, 0u, 1u, 1u, 1u, 1u, 1u,
                                    };
const uint8_t FlashSync4HzTable[] = {1u, 1u, 1u, 0u, 0u, 1u, 1u, 1u, 0u, 0u,
                                     1u, 1u, 1u, 0u, 0u, 1u, 1u, 1u, 0u, 0u,
                                     1u, 1u, 1u, 0u, 0u, 1u, 1u, 1u, 0u, 0u,
                                     1u, 1u, 1u, 0u, 0u, 1u, 1u, 1u, 0u, 0u,
                                    };
const uint8_t FlashSync5HzTable[] = {0u, 0u, 1u, 1u, 0u, 0u, 1u, 1u, 0u, 0u,
                                     1u, 1u, 0u, 0u, 1u, 1u, 0u, 0u, 1u, 1u,
                                     0u, 0u, 1u, 1u, 0u, 0u, 1u, 1u, 0u, 0u,
                                     1u, 1u, 0u, 0u, 1u, 1u, 0u, 0u, 1u, 1u,
                                    };


uint8_t FlashTimer;

/******************************************************************************
函数名：Flash_Sync_Signal_Generation_Service
功  能：闪烁同步信号发生服务
参  数：无
返回值：无
*******************************************************************************
注  意：该服务函数必须每50ms被调用一次
******************************************************************************/
void Flash_Sync_Signal_Generation_Service ( void )
{
    FlashTimer++;       /*50ms一次 加  1*/
    if ( FlashTimer >= 40u )
    {
        FlashTimer = 0u;
    }
    FLASH_SYNC_05Hz = FlashSync05HzTable[FlashTimer]; /*1000ms*/
    FLASH_SYNC_1Hz = FlashSync1HzTable[FlashTimer]; /*500ms*/
    FLASH_SYNC_2Hz = FlashSync2HzTable[FlashTimer]; /*250ms*/
    FLASH_SYNC_4Hz = FlashSync4HzTable[FlashTimer]; /*150ms - 100ms*/
    FLASH_SYNC_5Hz = FlashSync5HzTable[FlashTimer]; /*100ms*/

}