#ifndef _MBD_MODEL_H
#define  _MBD_MODEL_H

#include "rtwtypes.h"
#if 0
#pragma location ="BACKUP_RAM_CONTENT"
extern uint32_T FuelLevelDIM;          /* '<S7>/FuelWorkMode' */
#pragma location ="BACKUP_RAM_CONTENT"
extern uint32_T ReferenceFuelRawVolume;/* '<S7>/FuelWorkMode' */
#pragma location ="BACKUP_RAM_CONTENT"
extern uint32_T FuelLevelIndicatedSaved;/* '<S7>/FuelWorkMode' */
#pragma location ="BACKUP_RAM_CONTENT"
extern uint32_T ConsumeFuel;           /* '<S7>/FuelWorkMode' */
#pragma location ="BACKUP_RAM_CONTENT"
extern uint32_T EstimatedFuelLevel;    /* '<S7>/FuelWorkMode' */
#pragma location ="BACKUP_RAM_CONTENT"
extern uint16_T Km33Cons[16];          /* '<S7>/FuelWorkMode' */
#pragma location ="BACKUP_RAM_CONTENT"
extern uint8_T AfterKL30;              /* '<S4>/Chart' */
#pragma location ="BACKUP_RAM_CONTENT"
extern uint8_T FuelLevelEstimationActive;/* '<S7>/FuelWorkMode' */
#pragma location ="BACKUP_RAM_CONTENT"
extern uint8_T OngoingFuelFilling;     /* '<S7>/FuelWorkMode' */
#pragma location ="BACKUP_RAM_CONTENT"
extern uint16_T DTEDisplay;
#pragma location ="BACKUP_RAM_CONTENT"
extern uint16_T CFCold;                /* '<S1>/FuelWorkMode' */
#pragma location ="BACKUP_RAM_CONTENT"
extern uint16_T CFCnew;                /* '<S1>/FuelWorkMode' */
#pragma location ="BACKUP_RAM_CONTENT"
extern uint32_T EstimationFuel;        /* '<S1>/FuelWorkMode' */
#pragma location ="BACKUP_RAM_CONTENT"
extern uint8_T DrvStep;                /* '<S1>/FuelWorkMode' */
#pragma location ="BACKUP_RAM_CONTENT"
extern uint8_T RangeStep;              /* '<S1>/FuelWorkMode' */
#pragma location ="BACKUP_RAM_CONTENT"
extern uint8_T FuelSeg;
#pragma location ="BACKUP_RAM_CONTENT"
extern uint8_T RefVolValid;
#pragma location ="BACKUP_RAM_CONTENT"
extern uint32_T mLRollingCounter;
#pragma location ="BACKUP_RAM_CONTENT"
extern uint16_T FuelRefillDelayTimer;
#pragma location ="BACKUP_RAM_CONTENT"
extern uint32_T RangeVolume; 
#pragma location ="BACKUP_RAM_CONTENT"
extern uint32_T FuelLevelIndicated;
#pragma location ="BACKUP_RAM_CONTENT"
extern real32_T CFColdFloat;
#pragma location ="BACKUP_RAM_CONTENT"
extern uint16_T ActRes[12];
#pragma location ="BACKUP_RAM_CONTENT"
extern uint16_T ActVolume[12];                                          
#pragma location ="BACKUP_RAM_CONTENT"
extern FuelBackRam_Bus FuelBackRam;
#pragma location ="BACKUP_RAM_CONTENT"
extern uint8_T DTEValid;
#pragma location ="BACKUP_RAM_CONTENT"
extern uint8_T FuActStatus;

#endif
extern void MBD_Model_Init(void);

/********TachoMeter 转速表***************/
extern uint8_T Get_EngineValid(void);
extern uint16_T Get_DispEngineSpeed(void);
extern uint16_T Get_ActualEngineSpeed(void);
extern uint16_T Get_EngineSpeedMicrosteps(void);
extern uint16_T Get_UDSTachoMicrosteps(void);
extern void UDSTachoRequest(uint8_T en,uint16_T value);

extern void MBD_TachoMeter_Data_10ms(void);
extern void MBD_TachoMeter_Gauge_20ms(void);
extern uint8_T Get_UDSTachoEn(void);
extern uint16_T Get_UDSTachoValue(void);

/********SpeedoMeter 车速表***************/
extern uint8_T Get_VechileSpeedValid(void);
extern uint16_T Get_ActualVechileSpeed(void);
extern uint16_T Get_DispVechileSpeed(void);
extern uint16_T Get_DispVSpeed_NoInteger(void);
extern uint16_T Get_VechileSpeedMicrosteps(void);
extern uint16_T Get_IPK_vSpeed(void);
extern uint16_T Get_UDSSpeedoMicrosteps(void);
extern void UDSSpeedoRequest(uint8_T en,uint16_T value);


extern void MBD_SpeedoMeter_Data_20ms(void);
extern void MBD_SpeedoMeter_Gauge_20ms(void);
extern uint8_T Get_UDSSpeedoEn(void);
extern uint16_T Get_UDSSpeedoValue(void);


/********CoolantMeter 水温表***************/
extern uint8_T Get_CoolantSelfStatus(void);
extern uint8_T Get_Coolant_HighTemprature(void);
extern uint8_T Get_Coolant_Valid(void);
extern uint16_T Get_CoolantTemprature(void);
extern uint8_T Get_CoolantDispSeg(void);
extern uint8_T Get_UDSCoolantSeg(void);
extern void UDSCoolantRequest(uint8_T en,uint16_T value);

extern uint8_T Get_CoolantDataInvalid60S(void);
extern uint8_T Get_CoolantCanTimeOut60S(void);
extern void MBD_CoolantMeter_Data_20ms(void);
extern uint8_T Get_UDSCoolantEn(void);
extern uint16_T Get_UDSCoolantValue(void);

/********FuelMeter 油表***************/
extern uint8_T Get_FuelMeter_DIM_Integer(void);
extern uint16_T Get_FuelLevelIndicated_Integer(void) ;
extern uint16_T Get_FuelMeter_1S_Resister(void);
extern uint8_T Get_FuelMeter_Filling(void);
extern uint8_T Get_FuelMeter_DIMValid(void);
extern uint8_T Get_FuelMeterDispSeg(void);
extern uint8_T Get_LowFuelWarning(void);
extern uint8_T Get_FuelEmpty(void);
extern uint8_T Get_FuelStatus(void);
extern uint16_T Get_FuelResister(void);
extern uint16_T Get_FuelMeter_DTEDisplay(void);
extern uint8_T Get_FuelMeter_DTEValid(void);
extern uint16_T Get_FuelMeter_IPK_DTEodometer(void);
extern void UDSFuelMeterRequest(uint8_T en,uint16_T value);
extern uint8_T Get_UDSFuelMeterEn(void);
extern uint16_T Get_UDSFuelMeterValue(void);
extern uint8_T Get_UDSFuelMeterSeg(void);
extern uint8_T Get_UDS_FuelLevelDIMSaved(void);
extern uint8_T Get_UDS_FuelLevelDIMDamped(void);
extern uint8_T Get_UDS_EstimatedFuelLevel(void);
extern uint8_T Get_UDS_FuelLevelEstimationActive(void);
extern uint8_T Get_UDS_FuelDecreaseFactor(void);
extern uint32_T Get_UDS_ConsumeFuel(void);
extern uint8_T Get_IPK_FuelLevelSts(void);
extern uint8_T Get_IPK_FuelSensorShortGND(void);
extern uint8_T Get_IPK_FuelSensorShortOrOpenBatt(void);
extern uint8_T Get_IPK_FuelSensorUpperLimit(void);
extern uint8_T IPK_FuelLowLevelWarning(void);
extern uint8_T Get_FuelWorkMode(void);
extern uint16_T Get_FuelLevelIndicated(void);  /*精度是0.1L*/
extern uint8_T Get_RefVolumeComplete(void);
extern uint8_T Get_FuelMeterAlarmSeg(void);


extern void MBD_FuelMeter_Data_10ms(void);
extern void MBD_FuelMeter_KL30Init(void);
extern void MBD_FuelMeter_KL15Init(void);
extern void MBD_FuelMeter_WakeupInit(void);
/********平均车速***************************/
extern uint16_T Get_IPK_AverageVehicleSpeed(void);
extern uint8_T Get_AverageVehicleSpeed_Valid(void);
extern void AvgVSpeedTimeCounter_100ms(void);


extern void MBD_AvgVSpeed_KL30Init(void);
extern void MBD_AvgVSpeed_Data_100ms(void);

#endif
