
#ifndef _SYSTEM_STATUS_MONITOR_H_
#define _SYSTEM_STATUS_MONITOR_H_

/******************************************************************************
头文件
******************************************************************************/
#include "stdint.h"


typedef struct
{
    uint8_t SumCnt;
    uint16_t DebounceTimer;
    uint32_t ActVoltage;
    uint8_t FinalSts;
    uint8_t ActSts;
} MonitorStruct;



enum IG_Sts
{
    Power_OFF,
    Power_ON,
    Power_MAX_RANGE,
};

enum Status_Range
{
    LOW_NO_WORK,
    LOW_YES_WORK,

    NORMAL_WORK,


    HIGH_YES_WORK,
    HIGH_NO_WORK,

    MAX_RANGE,
};


/*
     0 ----1st-------6500   不可运行   1
  6500 ----2st-------7000   回差段     2

  7000 ----3st-------9000   低压段     3
  9000 ----4st-------9500   回差段     4
  9500-----5st------16000   正常段     5
  16000----6st------16500   回差段     6

  16500----7st------18000   高压段     7
  18000----8st------18500   回差段     8
  18500----9st------65535   高压段     9

    0-----6.5   不可运行--ALL----------限制
  6.5-----9     除电机外均可运行--------正常
    9-----16.5  均可运行---------------正常
 16.5-----18.5  只有CAN可运行----------限制
 18.8-----65535 不可运行--ALL----------限制

6.5-18.5  CAN 可运行区间



*/
extern MonitorStruct SysFun_KL30Monitor;
extern MonitorStruct SysFun_KL15Monitor;

extern MonitorStruct SysNM_KL30Monitor;
extern MonitorStruct SysNM_KL15Monitor;


#define t_KL15_Debounce 40u

#define Base_Vol 0u

#define ENTER_LOW_N_RANGE 6500U

#define EXIT_LOW_N_RANGE  7000U

#define ENTER_LOW_Y_RANGE 9000U

#define EXIT_LOW_Y_RANGE  9500U

#define EXIT_HIGH_Y_RANGE  16000U

#define ENTER_HIGH_Y_RANGE 18000U

#define EXIT_HIGH_N_RANGE  18500U

#define ENTER_HIGH_N_RANGE 19000U

#define Top_Vol 0xffffu

/*电源运行状态*/
#define   SYS_OPR_STAT_RUN           ((SysFun_KL30Monitor.FinalSts > 1u)&&(SysFun_KL30Monitor.FinalSts < 7u ))
#define   SYS_OPR_STAT_HALT          ((SysFun_KL30Monitor.FinalSts == 1u) || (SysFun_KL30Monitor.FinalSts >= 7u))

#define   SYS_OPR_STAT_LIM_LVP       (SysFun_KL30Monitor.FinalSts == 1U)
#define   SYS_OPR_STAT_LIM_OVP       (SysFun_KL30Monitor.FinalSts >= 7u)

/*仪表工作状态*/
#define   SYS_OPR_STAT_IGN_ON        (SysFun_KL15Monitor.FinalSts == 1U)
#define   SYS_OPR_STAT_IGN_OFF       (SysFun_KL15Monitor.FinalSts == 0U)


/*网络管理电源工作状态*/
#define   SYS_OPR_STAT_IGN_ON_NM     (SysNM_KL15Monitor.FinalSts == 1U)
#define   SYS_OPR_STAT_IGN_OFF_NM    (SysNM_KL15Monitor.FinalSts == 0U)

/*网络管理电源运行状态*/
#define   SYS_OPR_STAT_RUN_NM        ((SysNM_KL30Monitor.FinalSts > 1u) && (SysNM_KL30Monitor.FinalSts < 9u ))
#define   SYS_OPR_STAT_HALT_NM       ((SysNM_KL30Monitor.FinalSts == 9u) || (SysNM_KL30Monitor.FinalSts == 1u))

uint8_t System_KL30_Status_Get(void);

static void System_Monitor_KL30Init(void);
static void System_Monitor_KL15Init(void);
static void System_Fun_Process(void);
static void System_NM_WakeUp(void);
static void Sys_NM_Mode_Dec ( void );
static void System_NM_Process(void);

static uint8_t System_calc_range(uint16_t vol);

uint8_t Read_KL30_ConvertFinish(void);
void Sys_KL30_Init ( void);
void Sys_Status_Update_Service ( void );

void System_CalcKL30(uint16_t Voltage);


uint16_t System_Get_KL30Voltage(void);
void Analog_Voltage_KL30_Filter(void);

#endif

