#include "Common_Interface.h"
#include "Communication_Over_CAN.h"
#include "MBD_Model.h"
#include "System_Status_Monitor.h"
#include "WDT.h"
uint8_t PowerSts;/*1 ON ;  0 OFF*/
uint16_t Act_V_Speed;/*实际值,十倍的*/
uint16_t Act_E_Speed;/*实际值*/
uint16_t Disp_V_Speed;/*显示值,十倍的*/
uint16_t Disp_E_Speed;/*显示值*/

uint32_t Delay_Speed = 0;
uint32_t ActualVechileSpeed = 0;
/*数据有效 1 ;数据无效 0 /0xff */
uint8_t PowerSts_Valid;
uint8_t Act_V_Speed_Valid;
uint8_t Act_E_Speed_Valid;
uint8_t Disp_V_Speed_Valid;
uint8_t Disp_E_Speed_Valid;


uint16_t SysRollingCounter;

/*每次唤醒调用*/
void Common_DataInit(void)
{
    PowerSts = 0xffu;
    Act_V_Speed = 0xffffu;
    Act_E_Speed = 0xffffu;
    Disp_V_Speed = 0xffffu;
    Disp_E_Speed = 0xffffu;

    PowerSts_Valid = 0xffu;
    Act_V_Speed_Valid = 0xffu;
    Act_E_Speed_Valid = 0xffu;
    Disp_V_Speed_Valid = 0xffu;
    Disp_E_Speed_Valid = 0xffu;
}

/*以下由各个处理模块按需调用*/
/*使用数据之前,需要先判断数据是否有效,如果无效,则不可以使用*/

uint8_t Common_Get_IG_Sts(void)
{
    return PowerSts;
}

uint16_t Common_Get_Act_V_Speed(void)
{
    return Act_V_Speed;
}
uint16_t Common_Get_Act_E_Speed(void)
{
    return Act_E_Speed;
}
uint16_t Common_Get_Disp_V_Speed(void)
{
    return Disp_V_Speed;
}
uint16_t Common_Get_Disp_E_Speed(void)
{
    return Disp_E_Speed;
}



void Common_Set_IG_Sts(uint8_t Val)
{
    PowerSts = Val;
}
void Common_Set_Act_V_Speed(uint16_t Val)
{
    Act_V_Speed = Val;
}
void Common_Set_Act_E_Speed(uint16_t Val)
{
    Act_E_Speed = Val;
}
void Common_Set_Disp_V_Speed(uint16_t Val)
{
    Disp_V_Speed = Val;
}
void Common_Set_Disp_E_Speed(uint16_t Val)
{
    Disp_E_Speed = Val;
}


uint8_t Common_Get_IG_Sts_Valid(void)
{
    return PowerSts_Valid;
}
uint8_t Common_Get_Act_V_Speed_Valid(void)
{
    return  Act_V_Speed_Valid;
}
uint8_t Common_Get_Act_E_Speed_Valid(void)
{
    return  Act_E_Speed_Valid;
}
uint8_t Common_Get_Disp_V_Speed_Valid(void)
{
    return Disp_V_Speed_Valid;
}
uint8_t Common_Get_Disp_E_Speed_Valid(void)
{
    return Disp_E_Speed_Valid;
}



void Common_Set_IG_Sts_Valid(uint8_t Val)
{
    PowerSts_Valid = Val;
}
void Common_Set_Act_V_Speed_Valid(uint8_t Val)
{
    Act_V_Speed_Valid = Val;
}
void Common_Set_Act_E_Speed_Valid(uint8_t Val)
{
    Act_E_Speed_Valid = Val;
}
void Common_Set_Disp_V_Speed_Valid(uint8_t Val)
{
    Disp_V_Speed_Valid = Val;
}
void Common_Set_Disp_E_Speed_Valid(uint8_t Val)
{
    Disp_E_Speed_Valid = Val;
}

uint16_t Common_Get_DispSpeed(void)
{
    uint16_t m_Res;
    if (Disp_V_Speed_Valid)
    {
        m_Res = (((Disp_V_Speed / 10u) * 16u) / 9u);
    }
    else
    {
        m_Res = 0x1fffu;
    }
    return m_Res;
}




void Common_Input_Para(void)
{
    if (SYS_OPR_STAT_IGN_ON)
    {
        Common_Set_IG_Sts(1u);
        Common_Set_IG_Sts_Valid(1u);
    }
    else
    {
        Common_Set_IG_Sts(0u);
        Common_Set_IG_Sts_Valid(0u);        
    }

    if(Delay_Speed >= 100)
    {
        Delay_Speed = 0;
        ActualVechileSpeed = Get_ActualVechileSpeed();
    } 
    else
    {
        Delay_Speed++;
    }
    Common_Set_Act_V_Speed(ActualVechileSpeed);
    Common_Set_Act_E_Speed(Get_ActualEngineSpeed());
    Common_Set_Disp_V_Speed(Get_DispVechileSpeed());//
    Common_Set_Disp_E_Speed(Get_DispEngineSpeed());
    
    
    if (Get_VechileSpeedValid() == 1u)
    {
        Common_Set_Act_V_Speed_Valid(1u);
        Common_Set_Disp_V_Speed_Valid(1u);
    }
    else
    {
        Delay_Speed = 100;//防止掉线再上线后,车速显示0,有200ms延时
        Common_Set_Act_V_Speed_Valid(0u);
        Common_Set_Disp_V_Speed_Valid(0u);
    }
    if (Get_EngineValid() == 1u)
    {
        Common_Set_Act_E_Speed_Valid(1u);
        Common_Set_Disp_E_Speed_Valid(1u);
    }
    else
    {
        Common_Set_Act_E_Speed_Valid(0u);
        Common_Set_Disp_E_Speed_Valid(0u);
    }
    
    
}

//void Common_Speed(void)
//{
//    Common_Set_Act_V_Speed(Get_ActualVechileSpeed());
//    Common_Set_Act_E_Speed(Get_ActualEngineSpeed());
//    Common_Set_Disp_V_Speed(Get_DispVechileSpeed());//
//    Common_Set_Disp_E_Speed(Get_DispEngineSpeed());
//    if (Get_VechileSpeedValid() == 1u)
//    {
//        Common_Set_Act_V_Speed_Valid(1u);
//        Common_Set_Disp_V_Speed_Valid(1u);
//    }
//    else
//    {
//        Common_Set_Act_V_Speed_Valid(0u);
//        Common_Set_Disp_V_Speed_Valid(0u);
//    }
//    if (Get_EngineValid() == 1u)
//    {
//        Common_Set_Act_E_Speed_Valid(1u);
//        Common_Set_Disp_E_Speed_Valid(1u);
//    }
//    else
//    {
//        Common_Set_Act_E_Speed_Valid(0u);
//        Common_Set_Disp_E_Speed_Valid(0u);
//    }
//}




void Common_RollingCounterAdd(void)
{
    SysRollingCounter++;
}

void Common_RollingCounterClear(void)
{
    SysRollingCounter = 0u;
}

uint16_t Common_ReadRollingCounter(void)
{
    return SysRollingCounter;
}

void Common_BlockDelay(uint16_t m_MS)
{
    uint16_t RocBackup;
    uint16_t Counter;
    uint16_t DIMCounter;

    DIMCounter = m_MS * 20u;
    Common_RollingCounterClear();
    RocBackup = Common_ReadRollingCounter();
    do
    {
        Counter = Common_ReadRollingCounter();

        if (Counter >= RocBackup)
        {
            Counter -= RocBackup;
        }
        else
        {
            Counter = 65535u - RocBackup + Counter + 1u;
        }

        WDT_Clear();
    }
    while (Counter < DIMCounter);
}

