#ifndef _RTE_CAN_H_
#define _RTE_CAN_H_

#include "CANFD.h"
#include "Communication_Over_CAN.h"

typedef enum
{
	CAN_OK,
	CAN_NOT_OK,
	CAN_BUSY,
} Can_ReturnType;

typedef enum
{
	CAN_N_TX = 0u,
	CAN_Y_TX = 1u,
	CAN_N_F_TX = 0x81u,
} Can_SendType;

typedef enum
{
	CAN_N_RX = 0u,
	CAN_Y_RX = 1u,
	CAN_N_F_RX = 0x81u,
} Can_ReceiveType;


typedef struct
{
	uint32_t MsgID;
	uint8_t  MsgStd;
	uint8_t  MsgRTR;
	uint8_t  MsgDLC;
	uint8_t  MsgPro;
	uint8_t  Msg[8];
} _CAN_Msg;




void Can_Lock_Clr(void);
//void gpio_Port1_pin20(void);
void Can_Init(void);
void Can_DeInit(void);
void Can_Write(_CAN_Msg *Msg);
void Can_Read_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg[]);
void Can_Abort_Confirm(uint32_t Identifier, uint8_t TransferStatus);
void Can_Sleep_Fun(void);
void Can_SleepController_Fun(void);
void Can_Wakeup_Fun(void);
void Can_Confirm(uint32_t Identifier, uint8_t TransferStatus);
Can_ReceiveType Can_ReadRx_St(void);
Can_SendType Can_ReadTx_St(void);
void Can_SetTx_St(Can_SendType Status);
void Can_SetRx_St(Can_ReceiveType Status);
void Can_Abort_All(void);
void Can_Uds_Abort(void);

canlib_uint8_t Can_Write_0(st_CAN_Msg *Msg);
#endif
