#ifndef __UDS_DTC_H
#define __UDS_DTC_H

#include "stdint.h"
#include "UDS_Common.h"

#define   U300616          0xF00616
#define   U300617          0xF00617
#define   U007300          0xC07300
#define   U012187          0xC12187
#define   U013187          0xC13187
#define   U011087          0xC11087
#define   U011287          0xC11287
#define   U111587          0xD11587
#define   U029300          0xC29300
#define   U019887          0xC19887
#define   B13AE96          0x93AE96
#define   B13AF96          0x93AF96
#define   B13B196          0x93B196
#define   U015987          0xC15987

#define   cnU300616        0u
#define   cnU300617        1u
#define   cnU007300        2u
#define   cnU012187        3u
#define   cnU013187        4u
#define   cnU011087        5u
#define   cnU011287        6u
#define   cnU111587        7u
#define   cnU029300        8u
#define   cnU019887        9u
#define   cnB13AE96        10u
#define   cnB13AF96        11u
#define   cnB13B196        12u
#define   cnU015987        13u

#define   cnMSG18F0120B    0u
#define   cnMSG0CFABA13    1u
#define   cnMSG18FA02EF    2u
#define   cnMSG18FA40F4    3u
#define   cnMSG18FA7049    4u
#define   cnMSG0CFAB127    5u
#define   cnMSG18FF639F    6u

extern uint8_t HVoltageStatus;
extern uint8_t LVoltageStatus;
extern uint32_t msgList[7u][4u];
extern uint32_t DTCTimerList[14u];
extern const uint32_t DTCList[14][2];

void TestDTC(uint16_t timer);
void TestDTC_U007300(void);
void TestDTC_U300616(uint16_t timer);
void TestDTC_U300617(uint16_t timer);
void TestDTC_U012187(void);
void TestDTC_U013187(void);
void TestDTC_U011087(void);
void TestDTC_U011287(void);
void TestDTC_U111587(void);
void TestDTC_U029300(void);
void TestDTC_U019887(void);
void TestDTC_U016487(void);
void TestDTC_U021487(void);
void TestDTC_U023587(void);
void TestDTC_U120387(void);
void TestDTC_U017087(void);
void TestDTC_U011287(void);
void TestDTC_U016087(void);
void TestDTC_U111487(void);
void TestDTC_U111587(void);
void TestDTC_U011087(void);
void TestDTC_U015687(void);
void TestDTC_U010387(void);
void TestDTC_U020887(void);
void TestDTC_B11001E(void);
void TestDTC_B110144(void);
void TestDTC_U111A87(void);
void TestDTC_U023687(void);
void TestDTC_B13AE96(void);
void TestDTC_B13AF96(void);
void TestDTC_B13B196(void);
void TestDTC_U015987(void);
uint8_t getPowerStatus(void);
uint8_t getBusoffStatus(void);
uint8_t getEngStatus(void);
uint8_t getMSGStatus(uint8_t cnMsgID);
void ChangeDTCData(uint8_t DTCNum, uint8_t DTCStatus);
void SaveDTCData(void);

#endif