#include "UDS_11Service_Filter.h"

/**
  *11服务是否支持功能寻址
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_11Service_NRC11(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *11服务会话是否支持验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_11Service_NRC7F(void)
{
    uint8_t NRC = positiveResponse;
    if(getSessionType() == DefaultSession)
    {
        NRC = serviceNotSupportedInActiveSession;
        if(DiagMSG.msgID == DIAG_ID_Rx_PHY)
        {
            UDS_Service_Response(0x11u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *11服务解锁等级验证
  *@return 负反馈编号
  */
uint8_t UDS_11Service_NRC33(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *11服务最小长度验证
  *@return 负反馈编号
  */
uint8_t UDS_11Service_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgDLC < 1u)
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x11u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *11服务超出请求范围验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_11Service_NRC31(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *11服务总长度长度验证
  *@return 负反馈编号
  */
uint8_t UDS_11Service_NRC13_TotalLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgDLC != 1u)
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x11u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *11服务条件验证
  *@return 负反馈编号
  */
uint8_t UDS_11Service_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    if(getSpeed() >= 3u)
    {
        NRC = conditionsNotCorrect;
        UDS_Service_Response(0x11u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else if(getESpeed() > 400u)
    {
        NRC = conditionsNotCorrect;
        UDS_Service_Response(0x11u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *11服务子功能最小长度验证
  *@return 负反馈编号
  */
uint8_t UDS_11Service_Sub_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgData.SidDetail.SubID == HardReset)
    {
        if(DiagMSG.msgDLC < 1u)
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x11u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    if(DiagMSG.msgData.SidDetail.SubID == SoftReset)
    {
        if(DiagMSG.msgDLC < 1u)
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x11u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    return NRC;
}

/**
  *11服务子功能是否支持验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_11Service_Sub_NRC12(void)
{
    uint8_t NRC = positiveResponse;
    if((DiagMSG.msgData.SidDetail.SubID == HardReset) || (DiagMSG.msgData.SidDetail.SubID == SoftReset))
    {
        NRC = positiveResponse;
    }
    else
    {
        NRC = subFunctionNotSupported;
        if(DiagMSG.msgID == DIAG_ID_Rx_PHY)
        {
            UDS_Service_Response(0x11u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
    }
    return NRC;
}

/**
  *11服务子功能会话是否支持验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_11Service_Sub_NRC7E(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *11服务子功能超出请求范围验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_11Service_Sub_NRC31(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *11服务子功能总长度长度验证
  *@return 负反馈编号
  */
uint8_t UDS_11Service_Sub_NRC13_TotalLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgData.SidDetail.SubID == HardReset)
    {
        if(DiagMSG.msgDLC != 1u)
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x11u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    if(DiagMSG.msgData.SidDetail.SubID == SoftReset)
    {
        if(DiagMSG.msgDLC != 1u)
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x11u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    return NRC;
}

/**
  *11服务子功能请求顺序验证
  *@return 负反馈编号
  */
uint8_t UDS_11Service_Sub_NRC24(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *11服务子功能条件验证
  *@return 负反馈编号
  */
uint8_t UDS_11Service_Sub_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}
