#include "UDS_2FService_Internal.h"
#include "Telltales_user.h"
#include "Telltales_Lib.h"

/**
  *蜂鸣器测试
  *@param ControlStatus 控制状态：0关闭解除控制，3强制控制
  *@param BuzzerStatus 蜂鸣器状态：0关闭蜂鸣器，FF开启蜂鸣器
  */
void BuzzerTest(uint8_t ControlStatus, uint8_t BuzzerStatus)
{
    if(ControlStatus == 0x00u)
    {
        BuzzerForceCtrlRelease();
    }
    if(ControlStatus == 0x03u)
    {
        BuzzerForceCtrlRequest();
        if(BuzzerStatus == 0x00u)
        {
            BuzzerCtrlStopPlaying();
        }
        if(BuzzerStatus == 0xFFu)
        {
            BuzzerCtrlPlayBack();
        }
    }
}

/**
  *指针测试
  *@param ControlStatus 控制状态：0关闭解除控制，3强制控制
  *@param GaugeType 控制的指针类型：1车速，2转速，3燃油，4水温
  *@param GaugeStatus 控制的指针类型：0零刻度，1半刻度，2满刻度
  */
void GaugeTest(uint8_t ControlStatus, uint8_t GaugeType, uint8_t GaugeStatus)
{
    
}

/**
  *报警灯测试
  *@param ControlStatus 控制状态：0关闭解除控制，3强制控制
  *@param LampWarningStatus 报警灯状态：0关闭报警灯，FF开启报警灯
  */
void LampWarningTest(uint8_t ControlStatus, uint8_t LampWarningStatus)
{
    uint32_t i = 0u;
    if(ControlStatus == 0x00u)
    {
        for(i = 0u; i < LED_Max; ++i)
        {
            Telltales_DiagRelease(i);
        }
    }
    if(ControlStatus == 0x03u)
    {
        for(i = 0u; i < LED_Max; ++i)
        {
            if(LampWarningStatus == 0x00u)
            {
                Telltales_DiagCtrl(i, 0u);
            }
            if(LampWarningStatus == 0xFFu)
            {
                Telltales_DiagCtrl(i, 1u);
            }
        }
    }
}