/**************************************************************************//**
  * \file     ADC.h
  * \brief    ADC driver header file
  * \details
  * \author   Zhang Xuan
  * \version  V1.0.0
  * \date     18-Sep-2018
  * \par      History:
  *           V1.0.0 Initial release
  * \par      Copyright:
  *           (c) Heilongjiang TYW Electronics co., LTD
******************************************************************************/
#ifndef _ADC_H_
#define _ADC_H_

/* Includes ------------------------------------------------------------------*/
#include "s6j3360drv.h"

/* C binding of definitions if building with C++ compiler */
#ifdef __cplusplus
extern  {
#endif

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
#define   ADC_RESOLUTION                    (4096U)              /* 12bit ADC */

/* Exported functions ------------------------------------------------------- */
extern void    ADC_Init(const uint8_t* pu8ChList, uint8_t u8ChNum);
extern void    ADC_DeInit(void);
extern void    ADC_Start_Conversion(void);
extern void    ADC_Stop_Conversion(void);
extern uint8_t ADC_Get_Conversion_Status(void);
extern void    ADC_Get_Conversion_Result(uint16_t* pu16Data, uint8_t u8ChNum);

#ifdef __cplusplus
}
#endif

#endif /* _ADC_H_ */
