/**************************************************************************//**
  * \file     Clock.h
  * \brief    Clock and power control driver header file
  * \details
  * \author   Zhang Xuan
  * \version  V1.0.0
  * \date     20-Jul-2018
  * \par      History:
  *           V1.0.0 Initial release
  * \par      Copyright:
  *           (c) Heilongjiang TYW Electronics co., LTD
******************************************************************************/
#ifndef _CLOCK_H_
#define _CLOCK_H_

/* Includes ------------------------------------------------------------------*/
#include "s6j3360drv.h"
#include "Clock_Config.h"

/* C binding of definitions if building with C++ compiler */
#ifdef __cplusplus
extern  {
#endif

/* Exported types ------------------------------------------------------------*/
typedef enum
{
  CLK_STARTUP_PWR_ON = 0,
  CLK_STARTUP_WAKE_UP,
  CLK_STARTUP_SLEEP_FAIL,
}Clk_Startup_Mode_en_t;

/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */

extern void Clock_Init(void);
extern void Clock_Enter_Sleep_Mode(void);
extern Clk_Startup_Mode_en_t Clock_Get_Startup_Mode(void);
extern void Set_LED_Flag(uint32_t m32);
extern uint32_t Read_LED_Flag(void);

#ifdef __cplusplus
}
#endif

#endif /* _CLOCK_H_ */