#ifndef _PWM_H_
#define _PWM_H_

#include "s6j3360_BT_PWM.h"

#define PWM_TMCR_CKS2_0       0x07u   /* Bit mask for the CKS2-0 Bit */
#define PWM_TMCR2_CKS3        0x08u   /* Bit mask for the CKS3 Bit */

#define PWM_TMCR_CKS2_0_SHIFT 0x00u   /* Shift value for the CKS2-0 Bit */
#define PWM_TMCR2_CKS3_SHIFT  0x03u   /* Shift value for the CKS3 Bit */

#define PWM_INSTANCE_COUNT (uint32_t)(sizeof(m_astcPwmInstanceDataLut) / sizeof(m_astcPwmInstanceDataLut[0]))



typedef enum en_pwm_clock_prescaler
{
    PwmDiv1     = 0x00u, /*!< Internal clock                      */
    PwmDiv4     = 0x01u, /*!< Internal clock divided by 4         */
    PwmDiv16    = 0x02u, /*!< Internal clock divided by 16        */
    PwmDiv128   = 0x03u, /*!< Internal clock divided by 128       */
    PwmDiv256   = 0x04u, /*!< Internal clock divided by 256       */
    PwmExClkRis = 0x05u, /*!< External clock (rising-edge event)  */
    PwmExClkfal = 0x06u, /*!< External clock (falling-edge event) */
    PwmExClkbot = 0x07u, /*!< External clock (both-edges event)   */
    PwmDiv512   = 0x08u, /*!< Internal clock divided by 512       */
    PwmDiv1024  = 0x09u, /*!< Internal clock divided by 1024      */
    PwmDiv2048  = 0x0au, /*!< Internal clock divided by 2048      */
    PwmDiv2     = 0x0bu, /*!< Internal clock divided by 2         */
    PwmDiv8     = 0x0cu, /*!< Internal clock divided by 8         */
    PwmDiv32    = 0x0du, /*!< Internal clock divided by 32        */
    PwmDiv64    = 0x0eu  /*!< Internal clock divided by 64        */
} en_pwm_clock_prescaler_t;



typedef enum en_pwm_instance_index
{
    PwmIndexPwm0,
    PwmIndexPwm1,
    PwmIndexPwm2,
    PwmIndexPwm3,
    PwmIndexPwm4,
    PwmIndexPwm5,
    PwmIndexPwm6,
    PwmIndexPwm7,
    PwmIndexPwm8,
    PwmIndexPwm9,
    PwmIndexPwm10,
    PwmIndexPwm11,
    PwmIndexPwm12,
    PwmIndexPwm13,
    PwmIndexPwm14,
    PwmIndexPwm15,
    PwmIndexPwm16,
    PwmIndexPwm17,
    PwmIndexPwm18,
    PwmIndexPwm19,
    PwmIndexPwm20,
    PwmIndexPwm21,
    PwmIndexPwm22,
    PwmIndexPwm23,
    PwmIndexPwm24,
    PwmIndexPwm25,
    PwmIndexPwm26,
    PwmIndexPwm27,
    PwmIndexPwm28,
    PwmIndexPwm29,
    PwmIndexPwm30,
    PwmIndexPwm31,
    PwmInstanceIndexMax
} Pwm_instance_t;


/*
Channel-写通道号
Prescaler-写分频系数
m_Inverse-输出 0 1 是否需要反过来
 */
void Bt_Pwm_Init( Pwm_instance_t Channel, en_pwm_clock_prescaler_t Prescaler, uint8_t m_Inverse );
/*
总线时钟源:LCP1A
总线时钟频率:33M
Cycle = 33M/m_Cycle
Duty= m_Duty/m_Cycle
Channel-写通道号
m_Delay-一般用于MOS的死区控制,配合61194写0
 */
void Bt_Pwm_Start( Pwm_instance_t Channel, uint16_t m_Cycle, uint16_t m_Duty, uint16_t m_Delay );
/*
Channel-写通道号
*/
void Bt_Pwm_Stop( Pwm_instance_t Channel );

/*
总线时钟源:LCP1A
总线时钟频率:33M
Cycle = 33M/m_Cycle
Duty= m_Duty/m_Cycle
Channel-写通道号
*/
void Bt_Pwm_Fast_Update( Pwm_instance_t Channel, uint16_t m_Cycle, uint16_t m_Duty );


#endif
