/**************************************************************************//**
  * \file     RTC.h
  * \brief    Real time clock driver header file
  * \details
  * \author   Zhang Xuan
  * \version  V1.0.0
  * \date     21-Nov-2018
  * \par      History:
  *           V1.0.0 Initial release
  * \par      Copyright:
  *           (c) Heilongjiang TYW Electronics co., LTD
******************************************************************************/
#ifndef _RTC_H_
#define _RTC_H_

/* Includes ------------------------------------------------------------------*/
#include "s6j3360drv.h"

/* Exported types ------------------------------------------------------------*/
/**************************************************************************//**
  * \brief RTC time struct.
  * This structure is used to define RTC parameter organization.
******************************************************************************/
typedef struct
{
    uint16_t  Year;
    uint8_t   Month;
    uint8_t   Date;
    uint8_t   Hour;
    uint8_t   Minute;
    uint8_t   Second;
    uint8_t   LeapYear;
} RTC_Time_st_t;

/**************************************************************************//**
  * \brief RTC time setting struct.
  * This structure is used to define RTC setting parameter organization.
******************************************************************************/
typedef struct
{
    uint16_t  Year;
    uint8_t   Month;
    uint8_t   Date;
    uint8_t   Hour;
    uint8_t   Minute;
    uint8_t   Second;
    uint8_t   Rsvd;
} RTC_Time_Setting_st_t;

/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* RTC default time setting */
#ifndef   RTC_DEFAULT_TIME
#define RTC_DEFAULT_TIME                  1U/*86104-13*/
#define RTC_DEFAULT_YEAR                  2000U/*86104-13*/
#define RTC_DEFAULT_MONTH                 1U/*86104-13*/
#define RTC_DEFAULT_DATE                  1U/*86104-13*/
#define RTC_DEFAULT_HOUR                  0U/*86104-11*/  /*86104-13*/
#define RTC_DEFAULT_MINUTE                0U/*86104-11*/  /*86104-13*/
#define RTC_DEFAULT_SECOND                0U/*86104-11*/  /*86104-13*/
#endif

/* RTC exported time register */
extern volatile RTC_Time_st_t RTCTime;

extern volatile uint16_t RTCRollingCounter;
#define   RTC_ROLLING_COUNTER               RTCRollingCounter
#define   RTC_YEAR                          RTCTime.Year
#define   RTC_MONTH                         RTCTime.Month
#define   RTC_DATE                          RTCTime.Date
#define   RTC_HOUR                          RTCTime.Hour
#define   RTC_MINUTE                        RTCTime.Minute
#define   RTC_SECOND                        RTCTime.Second
#define   RTC_LEAP_YEAR                     RTCTime.LeapYear

/* Exported functions ------------------------------------------------------- */
extern void RTC_Pre_Init(void);
extern void RTC_Init(void);
extern void RTC_Set_Time(RTC_Time_Setting_st_t *pTime);
extern void RTC_Timing_Service(void);

#endif /* _RTC_H_ */