/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_CANFD_H
#define __S6J3360_CANFD_H

#include "s6j3360io_basetypes.h"

/* CPG_CANFD[0-3] base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define CPG_CANFD0	stcCPG_CANFD[0]
#define CPG_CANFD1	stcCPG_CANFD[1]
#define CPG_CANFD2	stcCPG_CANFD[2]
#define CPG_CANFD3	stcCPG_CANFD[3]
#else /* __IO_DEFINE */
#define CPG_CANFD0	(*((volatile stc_cpg_canfdn_t*)0xB4900000UL))
#define CPG_CANFD1	(*((volatile stc_cpg_canfdn_t*)0xB4910000UL))
#define CPG_CANFD2	(*((volatile stc_cpg_canfdn_t*)0xB4920000UL))
#define CPG_CANFD3	(*((volatile stc_cpg_canfdn_t*)0xB4930000UL))
#endif /* __IO_DEFINE */

/* CREL */
#define CPG_CANFD0_CREL	(CPG_CANFD0.unCREL.u32Register)  /*@rg@*/
#define CPG_CANFD0_CREL_DAY	(CPG_CANFD0.unCREL.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD0_CREL_MON	(CPG_CANFD0.unCREL.au8Byte[1])  /*@bfbyte@*/
#define CPG_CANFD0_CREL_YEAR	(CPG_CANFD0.unCREL.stcField.u4YEAR)  /*@bf@*/
#define CPG_CANFD0_CREL_SUBSTEP	(CPG_CANFD0.unCREL.stcField.u4SUBSTEP)  /*@bf@*/
#define CPG_CANFD0_CREL_STEP	(CPG_CANFD0.unCREL.stcField.u4STEP)  /*@bf@*/
#define CPG_CANFD0_CREL_REL	(CPG_CANFD0.unCREL.stcField.u4REL)  /*@bf@*/

#define CPG_CANFD1_CREL	(CPG_CANFD1.unCREL.u32Register)  /*@rg@*/
#define CPG_CANFD1_CREL_DAY	(CPG_CANFD1.unCREL.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD1_CREL_MON	(CPG_CANFD1.unCREL.au8Byte[1])  /*@bfbyte@*/
#define CPG_CANFD1_CREL_YEAR	(CPG_CANFD1.unCREL.stcField.u4YEAR)  /*@bf@*/
#define CPG_CANFD1_CREL_SUBSTEP	(CPG_CANFD1.unCREL.stcField.u4SUBSTEP)  /*@bf@*/
#define CPG_CANFD1_CREL_STEP	(CPG_CANFD1.unCREL.stcField.u4STEP)  /*@bf@*/
#define CPG_CANFD1_CREL_REL	(CPG_CANFD1.unCREL.stcField.u4REL)  /*@bf@*/

#define CPG_CANFD2_CREL	(CPG_CANFD2.unCREL.u32Register)  /*@rg@*/
#define CPG_CANFD2_CREL_DAY	(CPG_CANFD2.unCREL.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD2_CREL_MON	(CPG_CANFD2.unCREL.au8Byte[1])  /*@bfbyte@*/
#define CPG_CANFD2_CREL_YEAR	(CPG_CANFD2.unCREL.stcField.u4YEAR)  /*@bf@*/
#define CPG_CANFD2_CREL_SUBSTEP	(CPG_CANFD2.unCREL.stcField.u4SUBSTEP)  /*@bf@*/
#define CPG_CANFD2_CREL_STEP	(CPG_CANFD2.unCREL.stcField.u4STEP)  /*@bf@*/
#define CPG_CANFD2_CREL_REL	(CPG_CANFD2.unCREL.stcField.u4REL)  /*@bf@*/

#define CPG_CANFD3_CREL	(CPG_CANFD3.unCREL.u32Register)  /*@rg@*/
#define CPG_CANFD3_CREL_DAY	(CPG_CANFD3.unCREL.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD3_CREL_MON	(CPG_CANFD3.unCREL.au8Byte[1])  /*@bfbyte@*/
#define CPG_CANFD3_CREL_YEAR	(CPG_CANFD3.unCREL.stcField.u4YEAR)  /*@bf@*/
#define CPG_CANFD3_CREL_SUBSTEP	(CPG_CANFD3.unCREL.stcField.u4SUBSTEP)  /*@bf@*/
#define CPG_CANFD3_CREL_STEP	(CPG_CANFD3.unCREL.stcField.u4STEP)  /*@bf@*/
#define CPG_CANFD3_CREL_REL	(CPG_CANFD3.unCREL.stcField.u4REL)  /*@bf@*/

typedef struct stc_cpg_canfdn_crel_field{
    uint_io32_t		u8DAY:8;
    uint_io32_t		u8MON:8;
    uint_io32_t		u4YEAR:4;
    uint_io32_t		u4SUBSTEP:4;
    uint_io32_t		u4STEP:4;
    uint_io32_t		u4REL:4;
}stc_cpg_canfdn_crel_field_t;

typedef union un_cpg_canfdn_crel{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_crel_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_crel_t;

/* ENDN */
#define CPG_CANFD0_ENDN	(CPG_CANFD0.unENDN.u32Register)  /*@rg@*/
#define CPG_CANFD0_ENDN_ETV	CPG_CANFD0_ENDN  /*@bfrg@*/

#define CPG_CANFD1_ENDN	(CPG_CANFD1.unENDN.u32Register)  /*@rg@*/
#define CPG_CANFD1_ENDN_ETV	CPG_CANFD1_ENDN  /*@bfrg@*/

#define CPG_CANFD2_ENDN	(CPG_CANFD2.unENDN.u32Register)  /*@rg@*/
#define CPG_CANFD2_ENDN_ETV	CPG_CANFD2_ENDN  /*@bfrg@*/

#define CPG_CANFD3_ENDN	(CPG_CANFD3.unENDN.u32Register)  /*@rg@*/
#define CPG_CANFD3_ENDN_ETV	CPG_CANFD3_ENDN  /*@bfrg@*/

typedef union un_cpg_canfdn_endn{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_endn_t;

/* DBTP */
#define CPG_CANFD0_DBTP	(CPG_CANFD0.unDBTP.u32Register)  /*@rg@*/
#define CPG_CANFD0_DBTP_DSJW	(CPG_CANFD0.unDBTP.stcField.u4DSJW)  /*@bf@*/
#define CPG_CANFD0_DBTP_DTSEG2	(CPG_CANFD0.unDBTP.stcField.u4DTSEG2)  /*@bf@*/
#define CPG_CANFD0_DBTP_DTSEG1	(CPG_CANFD0.unDBTP.stcField.u5DTSEG1)  /*@bf@*/
#define CPG_CANFD0_DBTP_DBRP	(CPG_CANFD0.unDBTP.stcField.u5DBRP)  /*@bf@*/
#define CPG_CANFD0_DBTP_TDC	(*(volatile uint_io8_t*)0xB4C00077UL)  /*@bfbba@*/

#define CPG_CANFD1_DBTP	(CPG_CANFD1.unDBTP.u32Register)  /*@rg@*/
#define CPG_CANFD1_DBTP_DSJW	(CPG_CANFD1.unDBTP.stcField.u4DSJW)  /*@bf@*/
#define CPG_CANFD1_DBTP_DTSEG2	(CPG_CANFD1.unDBTP.stcField.u4DTSEG2)  /*@bf@*/
#define CPG_CANFD1_DBTP_DTSEG1	(CPG_CANFD1.unDBTP.stcField.u5DTSEG1)  /*@bf@*/
#define CPG_CANFD1_DBTP_DBRP	(CPG_CANFD1.unDBTP.stcField.u5DBRP)  /*@bf@*/
#define CPG_CANFD1_DBTP_TDC	(*(volatile uint_io8_t*)0xB4C80077UL)  /*@bfbba@*/

#define CPG_CANFD2_DBTP	(CPG_CANFD2.unDBTP.u32Register)  /*@rg@*/
#define CPG_CANFD2_DBTP_DSJW	(CPG_CANFD2.unDBTP.stcField.u4DSJW)  /*@bf@*/
#define CPG_CANFD2_DBTP_DTSEG2	(CPG_CANFD2.unDBTP.stcField.u4DTSEG2)  /*@bf@*/
#define CPG_CANFD2_DBTP_DTSEG1	(CPG_CANFD2.unDBTP.stcField.u5DTSEG1)  /*@bf@*/
#define CPG_CANFD2_DBTP_DBRP	(CPG_CANFD2.unDBTP.stcField.u5DBRP)  /*@bf@*/
#define CPG_CANFD2_DBTP_TDC	(*(volatile uint_io8_t*)0xB4D00077UL)  /*@bfbba@*/

#define CPG_CANFD3_DBTP	(CPG_CANFD3.unDBTP.u32Register)  /*@rg@*/
#define CPG_CANFD3_DBTP_DSJW	(CPG_CANFD3.unDBTP.stcField.u4DSJW)  /*@bf@*/
#define CPG_CANFD3_DBTP_DTSEG2	(CPG_CANFD3.unDBTP.stcField.u4DTSEG2)  /*@bf@*/
#define CPG_CANFD3_DBTP_DTSEG1	(CPG_CANFD3.unDBTP.stcField.u5DTSEG1)  /*@bf@*/
#define CPG_CANFD3_DBTP_DBRP	(CPG_CANFD3.unDBTP.stcField.u5DBRP)  /*@bf@*/
#define CPG_CANFD3_DBTP_TDC	(*(volatile uint_io8_t*)0xB4D80077UL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_dbtp_field{
    uint_io32_t		u4DSJW:4;
    uint_io32_t		u4DTSEG2:4;
    uint_io32_t		u5DTSEG1:5;
    uint_io32_t		:3;
    uint_io32_t		u5DBRP:5;
    uint_io32_t		:2;
    uint_io32_t		u1TDC:1;
    uint_io32_t		:8;
}stc_cpg_canfdn_dbtp_field_t;

typedef union un_cpg_canfdn_dbtp{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_dbtp_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_dbtp_t;

/* TEST */
#define CPG_CANFD0_TEST	(CPG_CANFD0.unTEST.u32Register)  /*@rg@*/
#define CPG_CANFD0_TEST_LBCK	(*(volatile uint_io8_t*)0xB4C00084UL)  /*@bfbba@*/
#define CPG_CANFD0_TEST_TX	(CPG_CANFD0.unTEST.stcField.u2TX)  /*@bf@*/
#define CPG_CANFD0_TEST_RX	(*(volatile uint_io8_t*)0xB4C00087UL)  /*@bfbba@*/

#define CPG_CANFD1_TEST	(CPG_CANFD1.unTEST.u32Register)  /*@rg@*/
#define CPG_CANFD1_TEST_LBCK	(*(volatile uint_io8_t*)0xB4C80084UL)  /*@bfbba@*/
#define CPG_CANFD1_TEST_TX	(CPG_CANFD1.unTEST.stcField.u2TX)  /*@bf@*/
#define CPG_CANFD1_TEST_RX	(*(volatile uint_io8_t*)0xB4C80087UL)  /*@bfbba@*/

#define CPG_CANFD2_TEST	(CPG_CANFD2.unTEST.u32Register)  /*@rg@*/
#define CPG_CANFD2_TEST_LBCK	(*(volatile uint_io8_t*)0xB4D00084UL)  /*@bfbba@*/
#define CPG_CANFD2_TEST_TX	(CPG_CANFD2.unTEST.stcField.u2TX)  /*@bf@*/
#define CPG_CANFD2_TEST_RX	(*(volatile uint_io8_t*)0xB4D00087UL)  /*@bfbba@*/

#define CPG_CANFD3_TEST	(CPG_CANFD3.unTEST.u32Register)  /*@rg@*/
#define CPG_CANFD3_TEST_LBCK	(*(volatile uint_io8_t*)0xB4D80084UL)  /*@bfbba@*/
#define CPG_CANFD3_TEST_TX	(CPG_CANFD3.unTEST.stcField.u2TX)  /*@bf@*/
#define CPG_CANFD3_TEST_RX	(*(volatile uint_io8_t*)0xB4D80087UL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_test_field{
    uint_io32_t		:4;
    uint_io32_t		u1LBCK:1;
    uint_io32_t		u2TX:2;
    uint_io32_t		u1RX:1;
    uint_io32_t		:24;
}stc_cpg_canfdn_test_field_t;

typedef union un_cpg_canfdn_test{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_test_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_test_t;

/* RWD */
#define CPG_CANFD0_RWD	(CPG_CANFD0.unRWD.u32Register)  /*@rg@*/
#define CPG_CANFD0_RWD_WDC	(CPG_CANFD0.unRWD.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD0_RWD_WDV	(CPG_CANFD0.unRWD.au8Byte[1])  /*@bfbyte@*/

#define CPG_CANFD1_RWD	(CPG_CANFD1.unRWD.u32Register)  /*@rg@*/
#define CPG_CANFD1_RWD_WDC	(CPG_CANFD1.unRWD.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD1_RWD_WDV	(CPG_CANFD1.unRWD.au8Byte[1])  /*@bfbyte@*/

#define CPG_CANFD2_RWD	(CPG_CANFD2.unRWD.u32Register)  /*@rg@*/
#define CPG_CANFD2_RWD_WDC	(CPG_CANFD2.unRWD.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD2_RWD_WDV	(CPG_CANFD2.unRWD.au8Byte[1])  /*@bfbyte@*/

#define CPG_CANFD3_RWD	(CPG_CANFD3.unRWD.u32Register)  /*@rg@*/
#define CPG_CANFD3_RWD_WDC	(CPG_CANFD3.unRWD.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD3_RWD_WDV	(CPG_CANFD3.unRWD.au8Byte[1])  /*@bfbyte@*/

typedef struct stc_cpg_canfdn_rwd_field{
    uint_io32_t		u8WDC:8;
    uint_io32_t		u8WDV:8;
    uint_io32_t		:16;
}stc_cpg_canfdn_rwd_field_t;

typedef union un_cpg_canfdn_rwd{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_rwd_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_rwd_t;

/* CCCR */
#define CPG_CANFD0_CCCR	(CPG_CANFD0.unCCCR.u32Register)  /*@rg@*/
#define CPG_CANFD0_CCCR_INIT	(*(volatile uint_io8_t*)0xB4C000C0UL)  /*@bfbba@*/
#define CPG_CANFD0_CCCR_CCE	(*(volatile uint_io8_t*)0xB4C000C1UL)  /*@bfbba@*/
#define CPG_CANFD0_CCCR_ASM	(*(volatile uint_io8_t*)0xB4C000C2UL)  /*@bfbba@*/
#define CPG_CANFD0_CCCR_CSA	(*(volatile uint_io8_t*)0xB4C000C3UL)  /*@bfbba@*/
#define CPG_CANFD0_CCCR_CSR	(*(volatile uint_io8_t*)0xB4C000C4UL)  /*@bfbba@*/
#define CPG_CANFD0_CCCR_MON	(*(volatile uint_io8_t*)0xB4C000C5UL)  /*@bfbba@*/
#define CPG_CANFD0_CCCR_DAR	(*(volatile uint_io8_t*)0xB4C000C6UL)  /*@bfbba@*/
#define CPG_CANFD0_CCCR_TEST	(*(volatile uint_io8_t*)0xB4C000C7UL)  /*@bfbba@*/
#define CPG_CANFD0_CCCR_FDOE	(*(volatile uint_io8_t*)0xB4C000C8UL)  /*@bfbba@*/
#define CPG_CANFD0_CCCR_BRSE	(*(volatile uint_io8_t*)0xB4C000C9UL)  /*@bfbba@*/
#define CPG_CANFD0_CCCR_PXHD	(*(volatile uint_io8_t*)0xB4C000CCUL)  /*@bfbba@*/
#define CPG_CANFD0_CCCR_EFBI	(*(volatile uint_io8_t*)0xB4C000CDUL)  /*@bfbba@*/
#define CPG_CANFD0_CCCR_TXP	(*(volatile uint_io8_t*)0xB4C000CEUL)  /*@bfbba@*/
#define CPG_CANFD0_CCCR_NISO	(*(volatile uint_io8_t*)0xB4C000CFUL)  /*@bfbba@*/

#define CPG_CANFD1_CCCR	(CPG_CANFD1.unCCCR.u32Register)  /*@rg@*/
#define CPG_CANFD1_CCCR_INIT	(*(volatile uint_io8_t*)0xB4C800C0UL)  /*@bfbba@*/
#define CPG_CANFD1_CCCR_CCE	(*(volatile uint_io8_t*)0xB4C800C1UL)  /*@bfbba@*/
#define CPG_CANFD1_CCCR_ASM	(*(volatile uint_io8_t*)0xB4C800C2UL)  /*@bfbba@*/
#define CPG_CANFD1_CCCR_CSA	(*(volatile uint_io8_t*)0xB4C800C3UL)  /*@bfbba@*/
#define CPG_CANFD1_CCCR_CSR	(*(volatile uint_io8_t*)0xB4C800C4UL)  /*@bfbba@*/
#define CPG_CANFD1_CCCR_MON	(*(volatile uint_io8_t*)0xB4C800C5UL)  /*@bfbba@*/
#define CPG_CANFD1_CCCR_DAR	(*(volatile uint_io8_t*)0xB4C800C6UL)  /*@bfbba@*/
#define CPG_CANFD1_CCCR_TEST	(*(volatile uint_io8_t*)0xB4C800C7UL)  /*@bfbba@*/
#define CPG_CANFD1_CCCR_FDOE	(*(volatile uint_io8_t*)0xB4C800C8UL)  /*@bfbba@*/
#define CPG_CANFD1_CCCR_BRSE	(*(volatile uint_io8_t*)0xB4C800C9UL)  /*@bfbba@*/
#define CPG_CANFD1_CCCR_PXHD	(*(volatile uint_io8_t*)0xB4C800CCUL)  /*@bfbba@*/
#define CPG_CANFD1_CCCR_EFBI	(*(volatile uint_io8_t*)0xB4C800CDUL)  /*@bfbba@*/
#define CPG_CANFD1_CCCR_TXP	(*(volatile uint_io8_t*)0xB4C800CEUL)  /*@bfbba@*/
#define CPG_CANFD1_CCCR_NISO	(*(volatile uint_io8_t*)0xB4C800CFUL)  /*@bfbba@*/

#define CPG_CANFD2_CCCR	(CPG_CANFD2.unCCCR.u32Register)  /*@rg@*/
#define CPG_CANFD2_CCCR_INIT	(*(volatile uint_io8_t*)0xB4D000C0UL)  /*@bfbba@*/
#define CPG_CANFD2_CCCR_CCE	(*(volatile uint_io8_t*)0xB4D000C1UL)  /*@bfbba@*/
#define CPG_CANFD2_CCCR_ASM	(*(volatile uint_io8_t*)0xB4D000C2UL)  /*@bfbba@*/
#define CPG_CANFD2_CCCR_CSA	(*(volatile uint_io8_t*)0xB4D000C3UL)  /*@bfbba@*/
#define CPG_CANFD2_CCCR_CSR	(*(volatile uint_io8_t*)0xB4D000C4UL)  /*@bfbba@*/
#define CPG_CANFD2_CCCR_MON	(*(volatile uint_io8_t*)0xB4D000C5UL)  /*@bfbba@*/
#define CPG_CANFD2_CCCR_DAR	(*(volatile uint_io8_t*)0xB4D000C6UL)  /*@bfbba@*/
#define CPG_CANFD2_CCCR_TEST	(*(volatile uint_io8_t*)0xB4D000C7UL)  /*@bfbba@*/
#define CPG_CANFD2_CCCR_FDOE	(*(volatile uint_io8_t*)0xB4D000C8UL)  /*@bfbba@*/
#define CPG_CANFD2_CCCR_BRSE	(*(volatile uint_io8_t*)0xB4D000C9UL)  /*@bfbba@*/
#define CPG_CANFD2_CCCR_PXHD	(*(volatile uint_io8_t*)0xB4D000CCUL)  /*@bfbba@*/
#define CPG_CANFD2_CCCR_EFBI	(*(volatile uint_io8_t*)0xB4D000CDUL)  /*@bfbba@*/
#define CPG_CANFD2_CCCR_TXP	(*(volatile uint_io8_t*)0xB4D000CEUL)  /*@bfbba@*/
#define CPG_CANFD2_CCCR_NISO	(*(volatile uint_io8_t*)0xB4D000CFUL)  /*@bfbba@*/

#define CPG_CANFD3_CCCR	(CPG_CANFD3.unCCCR.u32Register)  /*@rg@*/
#define CPG_CANFD3_CCCR_INIT	(*(volatile uint_io8_t*)0xB4D800C0UL)  /*@bfbba@*/
#define CPG_CANFD3_CCCR_CCE	(*(volatile uint_io8_t*)0xB4D800C1UL)  /*@bfbba@*/
#define CPG_CANFD3_CCCR_ASM	(*(volatile uint_io8_t*)0xB4D800C2UL)  /*@bfbba@*/
#define CPG_CANFD3_CCCR_CSA	(*(volatile uint_io8_t*)0xB4D800C3UL)  /*@bfbba@*/
#define CPG_CANFD3_CCCR_CSR	(*(volatile uint_io8_t*)0xB4D800C4UL)  /*@bfbba@*/
#define CPG_CANFD3_CCCR_MON	(*(volatile uint_io8_t*)0xB4D800C5UL)  /*@bfbba@*/
#define CPG_CANFD3_CCCR_DAR	(*(volatile uint_io8_t*)0xB4D800C6UL)  /*@bfbba@*/
#define CPG_CANFD3_CCCR_TEST	(*(volatile uint_io8_t*)0xB4D800C7UL)  /*@bfbba@*/
#define CPG_CANFD3_CCCR_FDOE	(*(volatile uint_io8_t*)0xB4D800C8UL)  /*@bfbba@*/
#define CPG_CANFD3_CCCR_BRSE	(*(volatile uint_io8_t*)0xB4D800C9UL)  /*@bfbba@*/
#define CPG_CANFD3_CCCR_PXHD	(*(volatile uint_io8_t*)0xB4D800CCUL)  /*@bfbba@*/
#define CPG_CANFD3_CCCR_EFBI	(*(volatile uint_io8_t*)0xB4D800CDUL)  /*@bfbba@*/
#define CPG_CANFD3_CCCR_TXP	(*(volatile uint_io8_t*)0xB4D800CEUL)  /*@bfbba@*/
#define CPG_CANFD3_CCCR_NISO	(*(volatile uint_io8_t*)0xB4D800CFUL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_cccr_field{
    uint_io32_t		u1INIT:1;
    uint_io32_t		u1CCE:1;
    uint_io32_t		u1ASM:1;
    uint_io32_t		u1CSA:1;
    uint_io32_t		u1CSR:1;
    uint_io32_t		u1MON:1;
    uint_io32_t		u1DAR:1;
    uint_io32_t		u1TEST:1;
    uint_io32_t		u1FDOE:1;
    uint_io32_t		u1BRSE:1;
    uint_io32_t		:2;
    uint_io32_t		u1PXHD:1;
    uint_io32_t		u1EFBI:1;
    uint_io32_t		u1TXP:1;
    uint_io32_t		u1NISO:1;
    uint_io32_t		:16;
}stc_cpg_canfdn_cccr_field_t;

typedef union un_cpg_canfdn_cccr{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_cccr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_cccr_t;

/* NBTP */
#define CPG_CANFD0_NBTP	(CPG_CANFD0.unNBTP.u32Register)  /*@rg@*/
#define CPG_CANFD0_NBTP_NTSEG2	(CPG_CANFD0.unNBTP.stcField.u7NTSEG2)  /*@bf@*/
#define CPG_CANFD0_NBTP_NTSEG1	(CPG_CANFD0.unNBTP.au8Byte[1])  /*@bfbyte@*/
#define CPG_CANFD0_NBTP_NBRP	(CPG_CANFD0.unNBTP.stcField.u9NBRP)  /*@bf@*/
#define CPG_CANFD0_NBTP_NSJW	(CPG_CANFD0.unNBTP.stcField.u7NSJW)  /*@bf@*/

#define CPG_CANFD1_NBTP	(CPG_CANFD1.unNBTP.u32Register)  /*@rg@*/
#define CPG_CANFD1_NBTP_NTSEG2	(CPG_CANFD1.unNBTP.stcField.u7NTSEG2)  /*@bf@*/
#define CPG_CANFD1_NBTP_NTSEG1	(CPG_CANFD1.unNBTP.au8Byte[1])  /*@bfbyte@*/
#define CPG_CANFD1_NBTP_NBRP	(CPG_CANFD1.unNBTP.stcField.u9NBRP)  /*@bf@*/
#define CPG_CANFD1_NBTP_NSJW	(CPG_CANFD1.unNBTP.stcField.u7NSJW)  /*@bf@*/

#define CPG_CANFD2_NBTP	(CPG_CANFD2.unNBTP.u32Register)  /*@rg@*/
#define CPG_CANFD2_NBTP_NTSEG2	(CPG_CANFD2.unNBTP.stcField.u7NTSEG2)  /*@bf@*/
#define CPG_CANFD2_NBTP_NTSEG1	(CPG_CANFD2.unNBTP.au8Byte[1])  /*@bfbyte@*/
#define CPG_CANFD2_NBTP_NBRP	(CPG_CANFD2.unNBTP.stcField.u9NBRP)  /*@bf@*/
#define CPG_CANFD2_NBTP_NSJW	(CPG_CANFD2.unNBTP.stcField.u7NSJW)  /*@bf@*/

#define CPG_CANFD3_NBTP	(CPG_CANFD3.unNBTP.u32Register)  /*@rg@*/
#define CPG_CANFD3_NBTP_NTSEG2	(CPG_CANFD3.unNBTP.stcField.u7NTSEG2)  /*@bf@*/
#define CPG_CANFD3_NBTP_NTSEG1	(CPG_CANFD3.unNBTP.au8Byte[1])  /*@bfbyte@*/
#define CPG_CANFD3_NBTP_NBRP	(CPG_CANFD3.unNBTP.stcField.u9NBRP)  /*@bf@*/
#define CPG_CANFD3_NBTP_NSJW	(CPG_CANFD3.unNBTP.stcField.u7NSJW)  /*@bf@*/

typedef struct stc_cpg_canfdn_nbtp_field{
    uint_io32_t		u7NTSEG2:7;
    uint_io32_t		:1;
    uint_io32_t		u8NTSEG1:8;
    uint_io32_t		u9NBRP:9;
    uint_io32_t		u7NSJW:7;
}stc_cpg_canfdn_nbtp_field_t;

typedef union un_cpg_canfdn_nbtp{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_nbtp_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_nbtp_t;

/* TSCC */
#define CPG_CANFD0_TSCC	(CPG_CANFD0.unTSCC.u32Register)  /*@rg@*/
#define CPG_CANFD0_TSCC_TSS	(CPG_CANFD0.unTSCC.stcField.u2TSS)  /*@bf@*/
#define CPG_CANFD0_TSCC_TCP	(CPG_CANFD0.unTSCC.stcField.u4TCP)  /*@bf@*/

#define CPG_CANFD1_TSCC	(CPG_CANFD1.unTSCC.u32Register)  /*@rg@*/
#define CPG_CANFD1_TSCC_TSS	(CPG_CANFD1.unTSCC.stcField.u2TSS)  /*@bf@*/
#define CPG_CANFD1_TSCC_TCP	(CPG_CANFD1.unTSCC.stcField.u4TCP)  /*@bf@*/

#define CPG_CANFD2_TSCC	(CPG_CANFD2.unTSCC.u32Register)  /*@rg@*/
#define CPG_CANFD2_TSCC_TSS	(CPG_CANFD2.unTSCC.stcField.u2TSS)  /*@bf@*/
#define CPG_CANFD2_TSCC_TCP	(CPG_CANFD2.unTSCC.stcField.u4TCP)  /*@bf@*/

#define CPG_CANFD3_TSCC	(CPG_CANFD3.unTSCC.u32Register)  /*@rg@*/
#define CPG_CANFD3_TSCC_TSS	(CPG_CANFD3.unTSCC.stcField.u2TSS)  /*@bf@*/
#define CPG_CANFD3_TSCC_TCP	(CPG_CANFD3.unTSCC.stcField.u4TCP)  /*@bf@*/

typedef struct stc_cpg_canfdn_tscc_field{
    uint_io32_t		u2TSS:2;
    uint_io32_t		:14;
    uint_io32_t		u4TCP:4;
    uint_io32_t		:12;
}stc_cpg_canfdn_tscc_field_t;

typedef union un_cpg_canfdn_tscc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_tscc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_tscc_t;

/* TSCV */
#define CPG_CANFD0_TSCV	(CPG_CANFD0.unTSCV.u32Register)  /*@rg@*/
#define CPG_CANFD0_TSCV_TSC	(CPG_CANFD0.unTSCV.au16Halfword[0])  /*@bfhword@*/

#define CPG_CANFD1_TSCV	(CPG_CANFD1.unTSCV.u32Register)  /*@rg@*/
#define CPG_CANFD1_TSCV_TSC	(CPG_CANFD1.unTSCV.au16Halfword[0])  /*@bfhword@*/

#define CPG_CANFD2_TSCV	(CPG_CANFD2.unTSCV.u32Register)  /*@rg@*/
#define CPG_CANFD2_TSCV_TSC	(CPG_CANFD2.unTSCV.au16Halfword[0])  /*@bfhword@*/

#define CPG_CANFD3_TSCV	(CPG_CANFD3.unTSCV.u32Register)  /*@rg@*/
#define CPG_CANFD3_TSCV_TSC	(CPG_CANFD3.unTSCV.au16Halfword[0])  /*@bfhword@*/

typedef struct stc_cpg_canfdn_tscv_field{
    uint_io32_t		u16TSC:16;
    uint_io32_t		:16;
}stc_cpg_canfdn_tscv_field_t;

typedef union un_cpg_canfdn_tscv{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_tscv_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_tscv_t;

/* TOCC */
#define CPG_CANFD0_TOCC	(CPG_CANFD0.unTOCC.u32Register)  /*@rg@*/
#define CPG_CANFD0_TOCC_ETOC	(*(volatile uint_io8_t*)0xB4C00140UL)  /*@bfbba@*/
#define CPG_CANFD0_TOCC_TOS	(CPG_CANFD0.unTOCC.stcField.u2TOS)  /*@bf@*/
#define CPG_CANFD0_TOCC_TOP	(CPG_CANFD0.unTOCC.au16Halfword[1])  /*@bfhword@*/

#define CPG_CANFD1_TOCC	(CPG_CANFD1.unTOCC.u32Register)  /*@rg@*/
#define CPG_CANFD1_TOCC_ETOC	(*(volatile uint_io8_t*)0xB4C80140UL)  /*@bfbba@*/
#define CPG_CANFD1_TOCC_TOS	(CPG_CANFD1.unTOCC.stcField.u2TOS)  /*@bf@*/
#define CPG_CANFD1_TOCC_TOP	(CPG_CANFD1.unTOCC.au16Halfword[1])  /*@bfhword@*/

#define CPG_CANFD2_TOCC	(CPG_CANFD2.unTOCC.u32Register)  /*@rg@*/
#define CPG_CANFD2_TOCC_ETOC	(*(volatile uint_io8_t*)0xB4D00140UL)  /*@bfbba@*/
#define CPG_CANFD2_TOCC_TOS	(CPG_CANFD2.unTOCC.stcField.u2TOS)  /*@bf@*/
#define CPG_CANFD2_TOCC_TOP	(CPG_CANFD2.unTOCC.au16Halfword[1])  /*@bfhword@*/

#define CPG_CANFD3_TOCC	(CPG_CANFD3.unTOCC.u32Register)  /*@rg@*/
#define CPG_CANFD3_TOCC_ETOC	(*(volatile uint_io8_t*)0xB4D80140UL)  /*@bfbba@*/
#define CPG_CANFD3_TOCC_TOS	(CPG_CANFD3.unTOCC.stcField.u2TOS)  /*@bf@*/
#define CPG_CANFD3_TOCC_TOP	(CPG_CANFD3.unTOCC.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_cpg_canfdn_tocc_field{
    uint_io32_t		u1ETOC:1;
    uint_io32_t		u2TOS:2;
    uint_io32_t		:13;
    uint_io32_t		u16TOP:16;
}stc_cpg_canfdn_tocc_field_t;

typedef union un_cpg_canfdn_tocc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_tocc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_tocc_t;

/* TOCV */
#define CPG_CANFD0_TOCV	(CPG_CANFD0.unTOCV.u32Register)  /*@rg@*/
#define CPG_CANFD0_TOCV_TOC	(CPG_CANFD0.unTOCV.au16Halfword[0])  /*@bfhword@*/

#define CPG_CANFD1_TOCV	(CPG_CANFD1.unTOCV.u32Register)  /*@rg@*/
#define CPG_CANFD1_TOCV_TOC	(CPG_CANFD1.unTOCV.au16Halfword[0])  /*@bfhword@*/

#define CPG_CANFD2_TOCV	(CPG_CANFD2.unTOCV.u32Register)  /*@rg@*/
#define CPG_CANFD2_TOCV_TOC	(CPG_CANFD2.unTOCV.au16Halfword[0])  /*@bfhword@*/

#define CPG_CANFD3_TOCV	(CPG_CANFD3.unTOCV.u32Register)  /*@rg@*/
#define CPG_CANFD3_TOCV_TOC	(CPG_CANFD3.unTOCV.au16Halfword[0])  /*@bfhword@*/

typedef struct stc_cpg_canfdn_tocv_field{
    uint_io32_t		u16TOC:16;
    uint_io32_t		:16;
}stc_cpg_canfdn_tocv_field_t;

typedef union un_cpg_canfdn_tocv{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_tocv_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_tocv_t;

/* ECR */
#define CPG_CANFD0_ECR	(CPG_CANFD0.unECR.u32Register)  /*@rg@*/
#define CPG_CANFD0_ECR_TEC	(CPG_CANFD0.unECR.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD0_ECR_REC	(CPG_CANFD0.unECR.stcField.u7REC)  /*@bf@*/
#define CPG_CANFD0_ECR_RP	(*(volatile uint_io8_t*)0xB4C0020FUL)  /*@bfbba@*/
#define CPG_CANFD0_ECR_CEL	(CPG_CANFD0.unECR.au8Byte[2])  /*@bfbyte@*/

#define CPG_CANFD1_ECR	(CPG_CANFD1.unECR.u32Register)  /*@rg@*/
#define CPG_CANFD1_ECR_TEC	(CPG_CANFD1.unECR.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD1_ECR_REC	(CPG_CANFD1.unECR.stcField.u7REC)  /*@bf@*/
#define CPG_CANFD1_ECR_RP	(*(volatile uint_io8_t*)0xB4C8020FUL)  /*@bfbba@*/
#define CPG_CANFD1_ECR_CEL	(CPG_CANFD1.unECR.au8Byte[2])  /*@bfbyte@*/

#define CPG_CANFD2_ECR	(CPG_CANFD2.unECR.u32Register)  /*@rg@*/
#define CPG_CANFD2_ECR_TEC	(CPG_CANFD2.unECR.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD2_ECR_REC	(CPG_CANFD2.unECR.stcField.u7REC)  /*@bf@*/
#define CPG_CANFD2_ECR_RP	(*(volatile uint_io8_t*)0xB4D0020FUL)  /*@bfbba@*/
#define CPG_CANFD2_ECR_CEL	(CPG_CANFD2.unECR.au8Byte[2])  /*@bfbyte@*/

#define CPG_CANFD3_ECR	(CPG_CANFD3.unECR.u32Register)  /*@rg@*/
#define CPG_CANFD3_ECR_TEC	(CPG_CANFD3.unECR.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD3_ECR_REC	(CPG_CANFD3.unECR.stcField.u7REC)  /*@bf@*/
#define CPG_CANFD3_ECR_RP	(*(volatile uint_io8_t*)0xB4D8020FUL)  /*@bfbba@*/
#define CPG_CANFD3_ECR_CEL	(CPG_CANFD3.unECR.au8Byte[2])  /*@bfbyte@*/

typedef struct stc_cpg_canfdn_ecr_field{
    uint_io32_t		u8TEC:8;
    uint_io32_t		u7REC:7;
    uint_io32_t		u1RP:1;
    uint_io32_t		u8CEL:8;
    uint_io32_t		:8;
}stc_cpg_canfdn_ecr_field_t;

typedef union un_cpg_canfdn_ecr{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_ecr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_ecr_t;

/* PSR */
#define CPG_CANFD0_PSR	(CPG_CANFD0.unPSR.u32Register)  /*@rg@*/
#define CPG_CANFD0_PSR_LEC	(CPG_CANFD0.unPSR.stcField.u3LEC)  /*@bf@*/
#define CPG_CANFD0_PSR_ACT	(CPG_CANFD0.unPSR.stcField.u2ACT)  /*@bf@*/
#define CPG_CANFD0_PSR_EP	(*(volatile uint_io8_t*)0xB4C00225UL)  /*@bfbba@*/
#define CPG_CANFD0_PSR_EW	(*(volatile uint_io8_t*)0xB4C00226UL)  /*@bfbba@*/
#define CPG_CANFD0_PSR_BO	(*(volatile uint_io8_t*)0xB4C00227UL)  /*@bfbba@*/
#define CPG_CANFD0_PSR_DLEC	(CPG_CANFD0.unPSR.stcField.u3DLEC)  /*@bf@*/
#define CPG_CANFD0_PSR_RESI	(*(volatile uint_io8_t*)0xB4C0022BUL)  /*@bfbba@*/
#define CPG_CANFD0_PSR_RBRS	(*(volatile uint_io8_t*)0xB4C0022CUL)  /*@bfbba@*/
#define CPG_CANFD0_PSR_RFDF	(*(volatile uint_io8_t*)0xB4C0022DUL)  /*@bfbba@*/
#define CPG_CANFD0_PSR_PXE	(*(volatile uint_io8_t*)0xB4C0022EUL)  /*@bfbba@*/
#define CPG_CANFD0_PSR_TDCV	(CPG_CANFD0.unPSR.stcField.u7TDCV)  /*@bf@*/

#define CPG_CANFD1_PSR	(CPG_CANFD1.unPSR.u32Register)  /*@rg@*/
#define CPG_CANFD1_PSR_LEC	(CPG_CANFD1.unPSR.stcField.u3LEC)  /*@bf@*/
#define CPG_CANFD1_PSR_ACT	(CPG_CANFD1.unPSR.stcField.u2ACT)  /*@bf@*/
#define CPG_CANFD1_PSR_EP	(*(volatile uint_io8_t*)0xB4C80225UL)  /*@bfbba@*/
#define CPG_CANFD1_PSR_EW	(*(volatile uint_io8_t*)0xB4C80226UL)  /*@bfbba@*/
#define CPG_CANFD1_PSR_BO	(*(volatile uint_io8_t*)0xB4C80227UL)  /*@bfbba@*/
#define CPG_CANFD1_PSR_DLEC	(CPG_CANFD1.unPSR.stcField.u3DLEC)  /*@bf@*/
#define CPG_CANFD1_PSR_RESI	(*(volatile uint_io8_t*)0xB4C8022BUL)  /*@bfbba@*/
#define CPG_CANFD1_PSR_RBRS	(*(volatile uint_io8_t*)0xB4C8022CUL)  /*@bfbba@*/
#define CPG_CANFD1_PSR_RFDF	(*(volatile uint_io8_t*)0xB4C8022DUL)  /*@bfbba@*/
#define CPG_CANFD1_PSR_PXE	(*(volatile uint_io8_t*)0xB4C8022EUL)  /*@bfbba@*/
#define CPG_CANFD1_PSR_TDCV	(CPG_CANFD1.unPSR.stcField.u7TDCV)  /*@bf@*/

#define CPG_CANFD2_PSR	(CPG_CANFD2.unPSR.u32Register)  /*@rg@*/
#define CPG_CANFD2_PSR_LEC	(CPG_CANFD2.unPSR.stcField.u3LEC)  /*@bf@*/
#define CPG_CANFD2_PSR_ACT	(CPG_CANFD2.unPSR.stcField.u2ACT)  /*@bf@*/
#define CPG_CANFD2_PSR_EP	(*(volatile uint_io8_t*)0xB4D00225UL)  /*@bfbba@*/
#define CPG_CANFD2_PSR_EW	(*(volatile uint_io8_t*)0xB4D00226UL)  /*@bfbba@*/
#define CPG_CANFD2_PSR_BO	(*(volatile uint_io8_t*)0xB4D00227UL)  /*@bfbba@*/
#define CPG_CANFD2_PSR_DLEC	(CPG_CANFD2.unPSR.stcField.u3DLEC)  /*@bf@*/
#define CPG_CANFD2_PSR_RESI	(*(volatile uint_io8_t*)0xB4D0022BUL)  /*@bfbba@*/
#define CPG_CANFD2_PSR_RBRS	(*(volatile uint_io8_t*)0xB4D0022CUL)  /*@bfbba@*/
#define CPG_CANFD2_PSR_RFDF	(*(volatile uint_io8_t*)0xB4D0022DUL)  /*@bfbba@*/
#define CPG_CANFD2_PSR_PXE	(*(volatile uint_io8_t*)0xB4D0022EUL)  /*@bfbba@*/
#define CPG_CANFD2_PSR_TDCV	(CPG_CANFD2.unPSR.stcField.u7TDCV)  /*@bf@*/

#define CPG_CANFD3_PSR	(CPG_CANFD3.unPSR.u32Register)  /*@rg@*/
#define CPG_CANFD3_PSR_LEC	(CPG_CANFD3.unPSR.stcField.u3LEC)  /*@bf@*/
#define CPG_CANFD3_PSR_ACT	(CPG_CANFD3.unPSR.stcField.u2ACT)  /*@bf@*/
#define CPG_CANFD3_PSR_EP	(*(volatile uint_io8_t*)0xB4D80225UL)  /*@bfbba@*/
#define CPG_CANFD3_PSR_EW	(*(volatile uint_io8_t*)0xB4D80226UL)  /*@bfbba@*/
#define CPG_CANFD3_PSR_BO	(*(volatile uint_io8_t*)0xB4D80227UL)  /*@bfbba@*/
#define CPG_CANFD3_PSR_DLEC	(CPG_CANFD3.unPSR.stcField.u3DLEC)  /*@bf@*/
#define CPG_CANFD3_PSR_RESI	(*(volatile uint_io8_t*)0xB4D8022BUL)  /*@bfbba@*/
#define CPG_CANFD3_PSR_RBRS	(*(volatile uint_io8_t*)0xB4D8022CUL)  /*@bfbba@*/
#define CPG_CANFD3_PSR_RFDF	(*(volatile uint_io8_t*)0xB4D8022DUL)  /*@bfbba@*/
#define CPG_CANFD3_PSR_PXE	(*(volatile uint_io8_t*)0xB4D8022EUL)  /*@bfbba@*/
#define CPG_CANFD3_PSR_TDCV	(CPG_CANFD3.unPSR.stcField.u7TDCV)  /*@bf@*/

typedef struct stc_cpg_canfdn_psr_field{
    uint_io32_t		u3LEC:3;
    uint_io32_t		u2ACT:2;
    uint_io32_t		u1EP:1;
    uint_io32_t		u1EW:1;
    uint_io32_t		u1BO:1;
    uint_io32_t		u3DLEC:3;
    uint_io32_t		u1RESI:1;
    uint_io32_t		u1RBRS:1;
    uint_io32_t		u1RFDF:1;
    uint_io32_t		u1PXE:1;
    uint_io32_t		:1;
    uint_io32_t		u7TDCV:7;
    uint_io32_t		:9;
}stc_cpg_canfdn_psr_field_t;

typedef union un_cpg_canfdn_psr{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_psr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_psr_t;

/* TDCR */
#define CPG_CANFD0_TDCR	(CPG_CANFD0.unTDCR.u32Register)  /*@rg@*/
#define CPG_CANFD0_TDCR_TDCF	(CPG_CANFD0.unTDCR.stcField.u7TDCF)  /*@bf@*/
#define CPG_CANFD0_TDCR_TDCO	(CPG_CANFD0.unTDCR.stcField.u7TDCO)  /*@bf@*/

#define CPG_CANFD1_TDCR	(CPG_CANFD1.unTDCR.u32Register)  /*@rg@*/
#define CPG_CANFD1_TDCR_TDCF	(CPG_CANFD1.unTDCR.stcField.u7TDCF)  /*@bf@*/
#define CPG_CANFD1_TDCR_TDCO	(CPG_CANFD1.unTDCR.stcField.u7TDCO)  /*@bf@*/

#define CPG_CANFD2_TDCR	(CPG_CANFD2.unTDCR.u32Register)  /*@rg@*/
#define CPG_CANFD2_TDCR_TDCF	(CPG_CANFD2.unTDCR.stcField.u7TDCF)  /*@bf@*/
#define CPG_CANFD2_TDCR_TDCO	(CPG_CANFD2.unTDCR.stcField.u7TDCO)  /*@bf@*/

#define CPG_CANFD3_TDCR	(CPG_CANFD3.unTDCR.u32Register)  /*@rg@*/
#define CPG_CANFD3_TDCR_TDCF	(CPG_CANFD3.unTDCR.stcField.u7TDCF)  /*@bf@*/
#define CPG_CANFD3_TDCR_TDCO	(CPG_CANFD3.unTDCR.stcField.u7TDCO)  /*@bf@*/

typedef struct stc_cpg_canfdn_tdcr_field{
    uint_io32_t		u7TDCF:7;
    uint_io32_t		:1;
    uint_io32_t		u7TDCO:7;
    uint_io32_t		:17;
}stc_cpg_canfdn_tdcr_field_t;

typedef union un_cpg_canfdn_tdcr{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_tdcr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_tdcr_t;

/* IR */
#define CPG_CANFD0_IR	(CPG_CANFD0.unIR.u32Register)  /*@rg@*/
#define CPG_CANFD0_IR_RF0N	(*(volatile uint_io8_t*)0xB4C00280UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_RF0W	(*(volatile uint_io8_t*)0xB4C00281UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_RF0F	(*(volatile uint_io8_t*)0xB4C00282UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_RF0L	(*(volatile uint_io8_t*)0xB4C00283UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_RF1N	(*(volatile uint_io8_t*)0xB4C00284UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_RF1W	(*(volatile uint_io8_t*)0xB4C00285UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_RF1F	(*(volatile uint_io8_t*)0xB4C00286UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_RF1L	(*(volatile uint_io8_t*)0xB4C00287UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_HPM	(*(volatile uint_io8_t*)0xB4C00288UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_TC	(*(volatile uint_io8_t*)0xB4C00289UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_TCF	(*(volatile uint_io8_t*)0xB4C0028AUL)  /*@bfbba@*/
#define CPG_CANFD0_IR_TFE	(*(volatile uint_io8_t*)0xB4C0028BUL)  /*@bfbba@*/
#define CPG_CANFD0_IR_TEFN	(*(volatile uint_io8_t*)0xB4C0028CUL)  /*@bfbba@*/
#define CPG_CANFD0_IR_TEFW	(*(volatile uint_io8_t*)0xB4C0028DUL)  /*@bfbba@*/
#define CPG_CANFD0_IR_TEFF	(*(volatile uint_io8_t*)0xB4C0028EUL)  /*@bfbba@*/
#define CPG_CANFD0_IR_TEFL	(*(volatile uint_io8_t*)0xB4C0028FUL)  /*@bfbba@*/
#define CPG_CANFD0_IR_TSW	(*(volatile uint_io8_t*)0xB4C00290UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_MRAF	(*(volatile uint_io8_t*)0xB4C00291UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_TOO	(*(volatile uint_io8_t*)0xB4C00292UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_DRX	(*(volatile uint_io8_t*)0xB4C00293UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_BEC	(*(volatile uint_io8_t*)0xB4C00294UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_BEU	(*(volatile uint_io8_t*)0xB4C00295UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_ELO	(*(volatile uint_io8_t*)0xB4C00296UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_EP	(*(volatile uint_io8_t*)0xB4C00297UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_EW	(*(volatile uint_io8_t*)0xB4C00298UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_BO	(*(volatile uint_io8_t*)0xB4C00299UL)  /*@bfbba@*/
#define CPG_CANFD0_IR_WDI	(*(volatile uint_io8_t*)0xB4C0029AUL)  /*@bfbba@*/
#define CPG_CANFD0_IR_PEA	(*(volatile uint_io8_t*)0xB4C0029BUL)  /*@bfbba@*/
#define CPG_CANFD0_IR_PED	(*(volatile uint_io8_t*)0xB4C0029CUL)  /*@bfbba@*/
#define CPG_CANFD0_IR_ARA	(*(volatile uint_io8_t*)0xB4C0029DUL)  /*@bfbba@*/

#define CPG_CANFD1_IR	(CPG_CANFD1.unIR.u32Register)  /*@rg@*/
#define CPG_CANFD1_IR_RF0N	(*(volatile uint_io8_t*)0xB4C80280UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_RF0W	(*(volatile uint_io8_t*)0xB4C80281UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_RF0F	(*(volatile uint_io8_t*)0xB4C80282UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_RF0L	(*(volatile uint_io8_t*)0xB4C80283UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_RF1N	(*(volatile uint_io8_t*)0xB4C80284UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_RF1W	(*(volatile uint_io8_t*)0xB4C80285UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_RF1F	(*(volatile uint_io8_t*)0xB4C80286UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_RF1L	(*(volatile uint_io8_t*)0xB4C80287UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_HPM	(*(volatile uint_io8_t*)0xB4C80288UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_TC	(*(volatile uint_io8_t*)0xB4C80289UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_TCF	(*(volatile uint_io8_t*)0xB4C8028AUL)  /*@bfbba@*/
#define CPG_CANFD1_IR_TFE	(*(volatile uint_io8_t*)0xB4C8028BUL)  /*@bfbba@*/
#define CPG_CANFD1_IR_TEFN	(*(volatile uint_io8_t*)0xB4C8028CUL)  /*@bfbba@*/
#define CPG_CANFD1_IR_TEFW	(*(volatile uint_io8_t*)0xB4C8028DUL)  /*@bfbba@*/
#define CPG_CANFD1_IR_TEFF	(*(volatile uint_io8_t*)0xB4C8028EUL)  /*@bfbba@*/
#define CPG_CANFD1_IR_TEFL	(*(volatile uint_io8_t*)0xB4C8028FUL)  /*@bfbba@*/
#define CPG_CANFD1_IR_TSW	(*(volatile uint_io8_t*)0xB4C80290UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_MRAF	(*(volatile uint_io8_t*)0xB4C80291UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_TOO	(*(volatile uint_io8_t*)0xB4C80292UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_DRX	(*(volatile uint_io8_t*)0xB4C80293UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_BEC	(*(volatile uint_io8_t*)0xB4C80294UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_BEU	(*(volatile uint_io8_t*)0xB4C80295UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_ELO	(*(volatile uint_io8_t*)0xB4C80296UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_EP	(*(volatile uint_io8_t*)0xB4C80297UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_EW	(*(volatile uint_io8_t*)0xB4C80298UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_BO	(*(volatile uint_io8_t*)0xB4C80299UL)  /*@bfbba@*/
#define CPG_CANFD1_IR_WDI	(*(volatile uint_io8_t*)0xB4C8029AUL)  /*@bfbba@*/
#define CPG_CANFD1_IR_PEA	(*(volatile uint_io8_t*)0xB4C8029BUL)  /*@bfbba@*/
#define CPG_CANFD1_IR_PED	(*(volatile uint_io8_t*)0xB4C8029CUL)  /*@bfbba@*/
#define CPG_CANFD1_IR_ARA	(*(volatile uint_io8_t*)0xB4C8029DUL)  /*@bfbba@*/

#define CPG_CANFD2_IR	(CPG_CANFD2.unIR.u32Register)  /*@rg@*/
#define CPG_CANFD2_IR_RF0N	(*(volatile uint_io8_t*)0xB4D00280UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_RF0W	(*(volatile uint_io8_t*)0xB4D00281UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_RF0F	(*(volatile uint_io8_t*)0xB4D00282UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_RF0L	(*(volatile uint_io8_t*)0xB4D00283UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_RF1N	(*(volatile uint_io8_t*)0xB4D00284UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_RF1W	(*(volatile uint_io8_t*)0xB4D00285UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_RF1F	(*(volatile uint_io8_t*)0xB4D00286UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_RF1L	(*(volatile uint_io8_t*)0xB4D00287UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_HPM	(*(volatile uint_io8_t*)0xB4D00288UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_TC	(*(volatile uint_io8_t*)0xB4D00289UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_TCF	(*(volatile uint_io8_t*)0xB4D0028AUL)  /*@bfbba@*/
#define CPG_CANFD2_IR_TFE	(*(volatile uint_io8_t*)0xB4D0028BUL)  /*@bfbba@*/
#define CPG_CANFD2_IR_TEFN	(*(volatile uint_io8_t*)0xB4D0028CUL)  /*@bfbba@*/
#define CPG_CANFD2_IR_TEFW	(*(volatile uint_io8_t*)0xB4D0028DUL)  /*@bfbba@*/
#define CPG_CANFD2_IR_TEFF	(*(volatile uint_io8_t*)0xB4D0028EUL)  /*@bfbba@*/
#define CPG_CANFD2_IR_TEFL	(*(volatile uint_io8_t*)0xB4D0028FUL)  /*@bfbba@*/
#define CPG_CANFD2_IR_TSW	(*(volatile uint_io8_t*)0xB4D00290UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_MRAF	(*(volatile uint_io8_t*)0xB4D00291UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_TOO	(*(volatile uint_io8_t*)0xB4D00292UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_DRX	(*(volatile uint_io8_t*)0xB4D00293UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_BEC	(*(volatile uint_io8_t*)0xB4D00294UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_BEU	(*(volatile uint_io8_t*)0xB4D00295UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_ELO	(*(volatile uint_io8_t*)0xB4D00296UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_EP	(*(volatile uint_io8_t*)0xB4D00297UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_EW	(*(volatile uint_io8_t*)0xB4D00298UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_BO	(*(volatile uint_io8_t*)0xB4D00299UL)  /*@bfbba@*/
#define CPG_CANFD2_IR_WDI	(*(volatile uint_io8_t*)0xB4D0029AUL)  /*@bfbba@*/
#define CPG_CANFD2_IR_PEA	(*(volatile uint_io8_t*)0xB4D0029BUL)  /*@bfbba@*/
#define CPG_CANFD2_IR_PED	(*(volatile uint_io8_t*)0xB4D0029CUL)  /*@bfbba@*/
#define CPG_CANFD2_IR_ARA	(*(volatile uint_io8_t*)0xB4D0029DUL)  /*@bfbba@*/

#define CPG_CANFD3_IR	(CPG_CANFD3.unIR.u32Register)  /*@rg@*/
#define CPG_CANFD3_IR_RF0N	(*(volatile uint_io8_t*)0xB4D80280UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_RF0W	(*(volatile uint_io8_t*)0xB4D80281UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_RF0F	(*(volatile uint_io8_t*)0xB4D80282UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_RF0L	(*(volatile uint_io8_t*)0xB4D80283UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_RF1N	(*(volatile uint_io8_t*)0xB4D80284UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_RF1W	(*(volatile uint_io8_t*)0xB4D80285UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_RF1F	(*(volatile uint_io8_t*)0xB4D80286UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_RF1L	(*(volatile uint_io8_t*)0xB4D80287UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_HPM	(*(volatile uint_io8_t*)0xB4D80288UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_TC	(*(volatile uint_io8_t*)0xB4D80289UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_TCF	(*(volatile uint_io8_t*)0xB4D8028AUL)  /*@bfbba@*/
#define CPG_CANFD3_IR_TFE	(*(volatile uint_io8_t*)0xB4D8028BUL)  /*@bfbba@*/
#define CPG_CANFD3_IR_TEFN	(*(volatile uint_io8_t*)0xB4D8028CUL)  /*@bfbba@*/
#define CPG_CANFD3_IR_TEFW	(*(volatile uint_io8_t*)0xB4D8028DUL)  /*@bfbba@*/
#define CPG_CANFD3_IR_TEFF	(*(volatile uint_io8_t*)0xB4D8028EUL)  /*@bfbba@*/
#define CPG_CANFD3_IR_TEFL	(*(volatile uint_io8_t*)0xB4D8028FUL)  /*@bfbba@*/
#define CPG_CANFD3_IR_TSW	(*(volatile uint_io8_t*)0xB4D80290UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_MRAF	(*(volatile uint_io8_t*)0xB4D80291UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_TOO	(*(volatile uint_io8_t*)0xB4D80292UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_DRX	(*(volatile uint_io8_t*)0xB4D80293UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_BEC	(*(volatile uint_io8_t*)0xB4D80294UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_BEU	(*(volatile uint_io8_t*)0xB4D80295UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_ELO	(*(volatile uint_io8_t*)0xB4D80296UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_EP	(*(volatile uint_io8_t*)0xB4D80297UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_EW	(*(volatile uint_io8_t*)0xB4D80298UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_BO	(*(volatile uint_io8_t*)0xB4D80299UL)  /*@bfbba@*/
#define CPG_CANFD3_IR_WDI	(*(volatile uint_io8_t*)0xB4D8029AUL)  /*@bfbba@*/
#define CPG_CANFD3_IR_PEA	(*(volatile uint_io8_t*)0xB4D8029BUL)  /*@bfbba@*/
#define CPG_CANFD3_IR_PED	(*(volatile uint_io8_t*)0xB4D8029CUL)  /*@bfbba@*/
#define CPG_CANFD3_IR_ARA	(*(volatile uint_io8_t*)0xB4D8029DUL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_ir_field{
    uint_io32_t		u1RF0N:1;
    uint_io32_t		u1RF0W:1;
    uint_io32_t		u1RF0F:1;
    uint_io32_t		u1RF0L:1;
    uint_io32_t		u1RF1N:1;
    uint_io32_t		u1RF1W:1;
    uint_io32_t		u1RF1F:1;
    uint_io32_t		u1RF1L:1;
    uint_io32_t		u1HPM:1;
    uint_io32_t		u1TC:1;
    uint_io32_t		u1TCF:1;
    uint_io32_t		u1TFE:1;
    uint_io32_t		u1TEFN:1;
    uint_io32_t		u1TEFW:1;
    uint_io32_t		u1TEFF:1;
    uint_io32_t		u1TEFL:1;
    uint_io32_t		u1TSW:1;
    uint_io32_t		u1MRAF:1;
    uint_io32_t		u1TOO:1;
    uint_io32_t		u1DRX:1;
    uint_io32_t		u1BEC:1;
    uint_io32_t		u1BEU:1;
    uint_io32_t		u1ELO:1;
    uint_io32_t		u1EP:1;
    uint_io32_t		u1EW:1;
    uint_io32_t		u1BO:1;
    uint_io32_t		u1WDI:1;
    uint_io32_t		u1PEA:1;
    uint_io32_t		u1PED:1;
    uint_io32_t		u1ARA:1;
    uint_io32_t		:2;
}stc_cpg_canfdn_ir_field_t;

typedef union un_cpg_canfdn_ir{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_ir_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_ir_t;

/* IE */
#define CPG_CANFD0_IE	(CPG_CANFD0.unIE.u32Register)  /*@rg@*/
#define CPG_CANFD0_IE_RF0NE	(*(volatile uint_io8_t*)0xB4C002A0UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_RF0WE	(*(volatile uint_io8_t*)0xB4C002A1UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_RF0FE	(*(volatile uint_io8_t*)0xB4C002A2UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_RF0LE	(*(volatile uint_io8_t*)0xB4C002A3UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_RF1NE	(*(volatile uint_io8_t*)0xB4C002A4UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_RF1WE	(*(volatile uint_io8_t*)0xB4C002A5UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_RF1FE	(*(volatile uint_io8_t*)0xB4C002A6UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_RF1LE	(*(volatile uint_io8_t*)0xB4C002A7UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_HPME	(*(volatile uint_io8_t*)0xB4C002A8UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_TCE	(*(volatile uint_io8_t*)0xB4C002A9UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_TCFE	(*(volatile uint_io8_t*)0xB4C002AAUL)  /*@bfbba@*/
#define CPG_CANFD0_IE_TFEE	(*(volatile uint_io8_t*)0xB4C002ABUL)  /*@bfbba@*/
#define CPG_CANFD0_IE_TEFNE	(*(volatile uint_io8_t*)0xB4C002ACUL)  /*@bfbba@*/
#define CPG_CANFD0_IE_TEFWE	(*(volatile uint_io8_t*)0xB4C002ADUL)  /*@bfbba@*/
#define CPG_CANFD0_IE_TEFFE	(*(volatile uint_io8_t*)0xB4C002AEUL)  /*@bfbba@*/
#define CPG_CANFD0_IE_TEFLE	(*(volatile uint_io8_t*)0xB4C002AFUL)  /*@bfbba@*/
#define CPG_CANFD0_IE_TSWE	(*(volatile uint_io8_t*)0xB4C002B0UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_MRAFE	(*(volatile uint_io8_t*)0xB4C002B1UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_TOOE	(*(volatile uint_io8_t*)0xB4C002B2UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_DRXE	(*(volatile uint_io8_t*)0xB4C002B3UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_BECE	(*(volatile uint_io8_t*)0xB4C002B4UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_BEUE	(*(volatile uint_io8_t*)0xB4C002B5UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_ELOE	(*(volatile uint_io8_t*)0xB4C002B6UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_EPE	(*(volatile uint_io8_t*)0xB4C002B7UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_EWE	(*(volatile uint_io8_t*)0xB4C002B8UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_BOE	(*(volatile uint_io8_t*)0xB4C002B9UL)  /*@bfbba@*/
#define CPG_CANFD0_IE_WDIE	(*(volatile uint_io8_t*)0xB4C002BAUL)  /*@bfbba@*/
#define CPG_CANFD0_IE_PEAE	(*(volatile uint_io8_t*)0xB4C002BBUL)  /*@bfbba@*/
#define CPG_CANFD0_IE_PEDE	(*(volatile uint_io8_t*)0xB4C002BCUL)  /*@bfbba@*/
#define CPG_CANFD0_IE_ARAE	(*(volatile uint_io8_t*)0xB4C002BDUL)  /*@bfbba@*/

#define CPG_CANFD1_IE	(CPG_CANFD1.unIE.u32Register)  /*@rg@*/
#define CPG_CANFD1_IE_RF0NE	(*(volatile uint_io8_t*)0xB4C802A0UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_RF0WE	(*(volatile uint_io8_t*)0xB4C802A1UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_RF0FE	(*(volatile uint_io8_t*)0xB4C802A2UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_RF0LE	(*(volatile uint_io8_t*)0xB4C802A3UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_RF1NE	(*(volatile uint_io8_t*)0xB4C802A4UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_RF1WE	(*(volatile uint_io8_t*)0xB4C802A5UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_RF1FE	(*(volatile uint_io8_t*)0xB4C802A6UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_RF1LE	(*(volatile uint_io8_t*)0xB4C802A7UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_HPME	(*(volatile uint_io8_t*)0xB4C802A8UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_TCE	(*(volatile uint_io8_t*)0xB4C802A9UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_TCFE	(*(volatile uint_io8_t*)0xB4C802AAUL)  /*@bfbba@*/
#define CPG_CANFD1_IE_TFEE	(*(volatile uint_io8_t*)0xB4C802ABUL)  /*@bfbba@*/
#define CPG_CANFD1_IE_TEFNE	(*(volatile uint_io8_t*)0xB4C802ACUL)  /*@bfbba@*/
#define CPG_CANFD1_IE_TEFWE	(*(volatile uint_io8_t*)0xB4C802ADUL)  /*@bfbba@*/
#define CPG_CANFD1_IE_TEFFE	(*(volatile uint_io8_t*)0xB4C802AEUL)  /*@bfbba@*/
#define CPG_CANFD1_IE_TEFLE	(*(volatile uint_io8_t*)0xB4C802AFUL)  /*@bfbba@*/
#define CPG_CANFD1_IE_TSWE	(*(volatile uint_io8_t*)0xB4C802B0UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_MRAFE	(*(volatile uint_io8_t*)0xB4C802B1UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_TOOE	(*(volatile uint_io8_t*)0xB4C802B2UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_DRXE	(*(volatile uint_io8_t*)0xB4C802B3UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_BECE	(*(volatile uint_io8_t*)0xB4C802B4UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_BEUE	(*(volatile uint_io8_t*)0xB4C802B5UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_ELOE	(*(volatile uint_io8_t*)0xB4C802B6UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_EPE	(*(volatile uint_io8_t*)0xB4C802B7UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_EWE	(*(volatile uint_io8_t*)0xB4C802B8UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_BOE	(*(volatile uint_io8_t*)0xB4C802B9UL)  /*@bfbba@*/
#define CPG_CANFD1_IE_WDIE	(*(volatile uint_io8_t*)0xB4C802BAUL)  /*@bfbba@*/
#define CPG_CANFD1_IE_PEAE	(*(volatile uint_io8_t*)0xB4C802BBUL)  /*@bfbba@*/
#define CPG_CANFD1_IE_PEDE	(*(volatile uint_io8_t*)0xB4C802BCUL)  /*@bfbba@*/
#define CPG_CANFD1_IE_ARAE	(*(volatile uint_io8_t*)0xB4C802BDUL)  /*@bfbba@*/

#define CPG_CANFD2_IE	(CPG_CANFD2.unIE.u32Register)  /*@rg@*/
#define CPG_CANFD2_IE_RF0NE	(*(volatile uint_io8_t*)0xB4D002A0UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_RF0WE	(*(volatile uint_io8_t*)0xB4D002A1UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_RF0FE	(*(volatile uint_io8_t*)0xB4D002A2UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_RF0LE	(*(volatile uint_io8_t*)0xB4D002A3UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_RF1NE	(*(volatile uint_io8_t*)0xB4D002A4UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_RF1WE	(*(volatile uint_io8_t*)0xB4D002A5UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_RF1FE	(*(volatile uint_io8_t*)0xB4D002A6UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_RF1LE	(*(volatile uint_io8_t*)0xB4D002A7UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_HPME	(*(volatile uint_io8_t*)0xB4D002A8UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_TCE	(*(volatile uint_io8_t*)0xB4D002A9UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_TCFE	(*(volatile uint_io8_t*)0xB4D002AAUL)  /*@bfbba@*/
#define CPG_CANFD2_IE_TFEE	(*(volatile uint_io8_t*)0xB4D002ABUL)  /*@bfbba@*/
#define CPG_CANFD2_IE_TEFNE	(*(volatile uint_io8_t*)0xB4D002ACUL)  /*@bfbba@*/
#define CPG_CANFD2_IE_TEFWE	(*(volatile uint_io8_t*)0xB4D002ADUL)  /*@bfbba@*/
#define CPG_CANFD2_IE_TEFFE	(*(volatile uint_io8_t*)0xB4D002AEUL)  /*@bfbba@*/
#define CPG_CANFD2_IE_TEFLE	(*(volatile uint_io8_t*)0xB4D002AFUL)  /*@bfbba@*/
#define CPG_CANFD2_IE_TSWE	(*(volatile uint_io8_t*)0xB4D002B0UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_MRAFE	(*(volatile uint_io8_t*)0xB4D002B1UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_TOOE	(*(volatile uint_io8_t*)0xB4D002B2UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_DRXE	(*(volatile uint_io8_t*)0xB4D002B3UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_BECE	(*(volatile uint_io8_t*)0xB4D002B4UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_BEUE	(*(volatile uint_io8_t*)0xB4D002B5UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_ELOE	(*(volatile uint_io8_t*)0xB4D002B6UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_EPE	(*(volatile uint_io8_t*)0xB4D002B7UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_EWE	(*(volatile uint_io8_t*)0xB4D002B8UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_BOE	(*(volatile uint_io8_t*)0xB4D002B9UL)  /*@bfbba@*/
#define CPG_CANFD2_IE_WDIE	(*(volatile uint_io8_t*)0xB4D002BAUL)  /*@bfbba@*/
#define CPG_CANFD2_IE_PEAE	(*(volatile uint_io8_t*)0xB4D002BBUL)  /*@bfbba@*/
#define CPG_CANFD2_IE_PEDE	(*(volatile uint_io8_t*)0xB4D002BCUL)  /*@bfbba@*/
#define CPG_CANFD2_IE_ARAE	(*(volatile uint_io8_t*)0xB4D002BDUL)  /*@bfbba@*/

#define CPG_CANFD3_IE	(CPG_CANFD3.unIE.u32Register)  /*@rg@*/
#define CPG_CANFD3_IE_RF0NE	(*(volatile uint_io8_t*)0xB4D802A0UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_RF0WE	(*(volatile uint_io8_t*)0xB4D802A1UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_RF0FE	(*(volatile uint_io8_t*)0xB4D802A2UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_RF0LE	(*(volatile uint_io8_t*)0xB4D802A3UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_RF1NE	(*(volatile uint_io8_t*)0xB4D802A4UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_RF1WE	(*(volatile uint_io8_t*)0xB4D802A5UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_RF1FE	(*(volatile uint_io8_t*)0xB4D802A6UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_RF1LE	(*(volatile uint_io8_t*)0xB4D802A7UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_HPME	(*(volatile uint_io8_t*)0xB4D802A8UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_TCE	(*(volatile uint_io8_t*)0xB4D802A9UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_TCFE	(*(volatile uint_io8_t*)0xB4D802AAUL)  /*@bfbba@*/
#define CPG_CANFD3_IE_TFEE	(*(volatile uint_io8_t*)0xB4D802ABUL)  /*@bfbba@*/
#define CPG_CANFD3_IE_TEFNE	(*(volatile uint_io8_t*)0xB4D802ACUL)  /*@bfbba@*/
#define CPG_CANFD3_IE_TEFWE	(*(volatile uint_io8_t*)0xB4D802ADUL)  /*@bfbba@*/
#define CPG_CANFD3_IE_TEFFE	(*(volatile uint_io8_t*)0xB4D802AEUL)  /*@bfbba@*/
#define CPG_CANFD3_IE_TEFLE	(*(volatile uint_io8_t*)0xB4D802AFUL)  /*@bfbba@*/
#define CPG_CANFD3_IE_TSWE	(*(volatile uint_io8_t*)0xB4D802B0UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_MRAFE	(*(volatile uint_io8_t*)0xB4D802B1UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_TOOE	(*(volatile uint_io8_t*)0xB4D802B2UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_DRXE	(*(volatile uint_io8_t*)0xB4D802B3UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_BECE	(*(volatile uint_io8_t*)0xB4D802B4UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_BEUE	(*(volatile uint_io8_t*)0xB4D802B5UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_ELOE	(*(volatile uint_io8_t*)0xB4D802B6UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_EPE	(*(volatile uint_io8_t*)0xB4D802B7UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_EWE	(*(volatile uint_io8_t*)0xB4D802B8UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_BOE	(*(volatile uint_io8_t*)0xB4D802B9UL)  /*@bfbba@*/
#define CPG_CANFD3_IE_WDIE	(*(volatile uint_io8_t*)0xB4D802BAUL)  /*@bfbba@*/
#define CPG_CANFD3_IE_PEAE	(*(volatile uint_io8_t*)0xB4D802BBUL)  /*@bfbba@*/
#define CPG_CANFD3_IE_PEDE	(*(volatile uint_io8_t*)0xB4D802BCUL)  /*@bfbba@*/
#define CPG_CANFD3_IE_ARAE	(*(volatile uint_io8_t*)0xB4D802BDUL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_ie_field{
    uint_io32_t		u1RF0NE:1;
    uint_io32_t		u1RF0WE:1;
    uint_io32_t		u1RF0FE:1;
    uint_io32_t		u1RF0LE:1;
    uint_io32_t		u1RF1NE:1;
    uint_io32_t		u1RF1WE:1;
    uint_io32_t		u1RF1FE:1;
    uint_io32_t		u1RF1LE:1;
    uint_io32_t		u1HPME:1;
    uint_io32_t		u1TCE:1;
    uint_io32_t		u1TCFE:1;
    uint_io32_t		u1TFEE:1;
    uint_io32_t		u1TEFNE:1;
    uint_io32_t		u1TEFWE:1;
    uint_io32_t		u1TEFFE:1;
    uint_io32_t		u1TEFLE:1;
    uint_io32_t		u1TSWE:1;
    uint_io32_t		u1MRAFE:1;
    uint_io32_t		u1TOOE:1;
    uint_io32_t		u1DRXE:1;
    uint_io32_t		u1BECE:1;
    uint_io32_t		u1BEUE:1;
    uint_io32_t		u1ELOE:1;
    uint_io32_t		u1EPE:1;
    uint_io32_t		u1EWE:1;
    uint_io32_t		u1BOE:1;
    uint_io32_t		u1WDIE:1;
    uint_io32_t		u1PEAE:1;
    uint_io32_t		u1PEDE:1;
    uint_io32_t		u1ARAE:1;
    uint_io32_t		:2;
}stc_cpg_canfdn_ie_field_t;

typedef union un_cpg_canfdn_ie{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_ie_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_ie_t;

/* ILS */
#define CPG_CANFD0_ILS	(CPG_CANFD0.unILS.u32Register)  /*@rg@*/
#define CPG_CANFD0_ILS_RF0NL	(*(volatile uint_io8_t*)0xB4C002C0UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_RF0WL	(*(volatile uint_io8_t*)0xB4C002C1UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_RF0FL	(*(volatile uint_io8_t*)0xB4C002C2UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_RF0LL	(*(volatile uint_io8_t*)0xB4C002C3UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_RF1NL	(*(volatile uint_io8_t*)0xB4C002C4UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_RF1WL	(*(volatile uint_io8_t*)0xB4C002C5UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_RF1FL	(*(volatile uint_io8_t*)0xB4C002C6UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_RF1LL	(*(volatile uint_io8_t*)0xB4C002C7UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_HPML	(*(volatile uint_io8_t*)0xB4C002C8UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_TCL	(*(volatile uint_io8_t*)0xB4C002C9UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_TCFL	(*(volatile uint_io8_t*)0xB4C002CAUL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_TFEL	(*(volatile uint_io8_t*)0xB4C002CBUL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_TEFNL	(*(volatile uint_io8_t*)0xB4C002CCUL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_TEFWL	(*(volatile uint_io8_t*)0xB4C002CDUL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_TEFFL	(*(volatile uint_io8_t*)0xB4C002CEUL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_TEFLL	(*(volatile uint_io8_t*)0xB4C002CFUL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_TSWL	(*(volatile uint_io8_t*)0xB4C002D0UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_MRAFL	(*(volatile uint_io8_t*)0xB4C002D1UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_TOOL	(*(volatile uint_io8_t*)0xB4C002D2UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_DRXL	(*(volatile uint_io8_t*)0xB4C002D3UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_BECL	(*(volatile uint_io8_t*)0xB4C002D4UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_BEUL	(*(volatile uint_io8_t*)0xB4C002D5UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_ELOL	(*(volatile uint_io8_t*)0xB4C002D6UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_EPL	(*(volatile uint_io8_t*)0xB4C002D7UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_EWL	(*(volatile uint_io8_t*)0xB4C002D8UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_BOL	(*(volatile uint_io8_t*)0xB4C002D9UL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_WDIL	(*(volatile uint_io8_t*)0xB4C002DAUL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_PEAL	(*(volatile uint_io8_t*)0xB4C002DBUL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_PEDL	(*(volatile uint_io8_t*)0xB4C002DCUL)  /*@bfbba@*/
#define CPG_CANFD0_ILS_ARAL	(*(volatile uint_io8_t*)0xB4C002DDUL)  /*@bfbba@*/

#define CPG_CANFD1_ILS	(CPG_CANFD1.unILS.u32Register)  /*@rg@*/
#define CPG_CANFD1_ILS_RF0NL	(*(volatile uint_io8_t*)0xB4C802C0UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_RF0WL	(*(volatile uint_io8_t*)0xB4C802C1UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_RF0FL	(*(volatile uint_io8_t*)0xB4C802C2UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_RF0LL	(*(volatile uint_io8_t*)0xB4C802C3UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_RF1NL	(*(volatile uint_io8_t*)0xB4C802C4UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_RF1WL	(*(volatile uint_io8_t*)0xB4C802C5UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_RF1FL	(*(volatile uint_io8_t*)0xB4C802C6UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_RF1LL	(*(volatile uint_io8_t*)0xB4C802C7UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_HPML	(*(volatile uint_io8_t*)0xB4C802C8UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_TCL	(*(volatile uint_io8_t*)0xB4C802C9UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_TCFL	(*(volatile uint_io8_t*)0xB4C802CAUL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_TFEL	(*(volatile uint_io8_t*)0xB4C802CBUL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_TEFNL	(*(volatile uint_io8_t*)0xB4C802CCUL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_TEFWL	(*(volatile uint_io8_t*)0xB4C802CDUL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_TEFFL	(*(volatile uint_io8_t*)0xB4C802CEUL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_TEFLL	(*(volatile uint_io8_t*)0xB4C802CFUL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_TSWL	(*(volatile uint_io8_t*)0xB4C802D0UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_MRAFL	(*(volatile uint_io8_t*)0xB4C802D1UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_TOOL	(*(volatile uint_io8_t*)0xB4C802D2UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_DRXL	(*(volatile uint_io8_t*)0xB4C802D3UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_BECL	(*(volatile uint_io8_t*)0xB4C802D4UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_BEUL	(*(volatile uint_io8_t*)0xB4C802D5UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_ELOL	(*(volatile uint_io8_t*)0xB4C802D6UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_EPL	(*(volatile uint_io8_t*)0xB4C802D7UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_EWL	(*(volatile uint_io8_t*)0xB4C802D8UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_BOL	(*(volatile uint_io8_t*)0xB4C802D9UL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_WDIL	(*(volatile uint_io8_t*)0xB4C802DAUL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_PEAL	(*(volatile uint_io8_t*)0xB4C802DBUL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_PEDL	(*(volatile uint_io8_t*)0xB4C802DCUL)  /*@bfbba@*/
#define CPG_CANFD1_ILS_ARAL	(*(volatile uint_io8_t*)0xB4C802DDUL)  /*@bfbba@*/

#define CPG_CANFD2_ILS	(CPG_CANFD2.unILS.u32Register)  /*@rg@*/
#define CPG_CANFD2_ILS_RF0NL	(*(volatile uint_io8_t*)0xB4D002C0UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_RF0WL	(*(volatile uint_io8_t*)0xB4D002C1UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_RF0FL	(*(volatile uint_io8_t*)0xB4D002C2UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_RF0LL	(*(volatile uint_io8_t*)0xB4D002C3UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_RF1NL	(*(volatile uint_io8_t*)0xB4D002C4UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_RF1WL	(*(volatile uint_io8_t*)0xB4D002C5UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_RF1FL	(*(volatile uint_io8_t*)0xB4D002C6UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_RF1LL	(*(volatile uint_io8_t*)0xB4D002C7UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_HPML	(*(volatile uint_io8_t*)0xB4D002C8UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_TCL	(*(volatile uint_io8_t*)0xB4D002C9UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_TCFL	(*(volatile uint_io8_t*)0xB4D002CAUL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_TFEL	(*(volatile uint_io8_t*)0xB4D002CBUL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_TEFNL	(*(volatile uint_io8_t*)0xB4D002CCUL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_TEFWL	(*(volatile uint_io8_t*)0xB4D002CDUL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_TEFFL	(*(volatile uint_io8_t*)0xB4D002CEUL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_TEFLL	(*(volatile uint_io8_t*)0xB4D002CFUL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_TSWL	(*(volatile uint_io8_t*)0xB4D002D0UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_MRAFL	(*(volatile uint_io8_t*)0xB4D002D1UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_TOOL	(*(volatile uint_io8_t*)0xB4D002D2UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_DRXL	(*(volatile uint_io8_t*)0xB4D002D3UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_BECL	(*(volatile uint_io8_t*)0xB4D002D4UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_BEUL	(*(volatile uint_io8_t*)0xB4D002D5UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_ELOL	(*(volatile uint_io8_t*)0xB4D002D6UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_EPL	(*(volatile uint_io8_t*)0xB4D002D7UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_EWL	(*(volatile uint_io8_t*)0xB4D002D8UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_BOL	(*(volatile uint_io8_t*)0xB4D002D9UL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_WDIL	(*(volatile uint_io8_t*)0xB4D002DAUL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_PEAL	(*(volatile uint_io8_t*)0xB4D002DBUL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_PEDL	(*(volatile uint_io8_t*)0xB4D002DCUL)  /*@bfbba@*/
#define CPG_CANFD2_ILS_ARAL	(*(volatile uint_io8_t*)0xB4D002DDUL)  /*@bfbba@*/

#define CPG_CANFD3_ILS	(CPG_CANFD3.unILS.u32Register)  /*@rg@*/
#define CPG_CANFD3_ILS_RF0NL	(*(volatile uint_io8_t*)0xB4D802C0UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_RF0WL	(*(volatile uint_io8_t*)0xB4D802C1UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_RF0FL	(*(volatile uint_io8_t*)0xB4D802C2UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_RF0LL	(*(volatile uint_io8_t*)0xB4D802C3UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_RF1NL	(*(volatile uint_io8_t*)0xB4D802C4UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_RF1WL	(*(volatile uint_io8_t*)0xB4D802C5UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_RF1FL	(*(volatile uint_io8_t*)0xB4D802C6UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_RF1LL	(*(volatile uint_io8_t*)0xB4D802C7UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_HPML	(*(volatile uint_io8_t*)0xB4D802C8UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_TCL	(*(volatile uint_io8_t*)0xB4D802C9UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_TCFL	(*(volatile uint_io8_t*)0xB4D802CAUL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_TFEL	(*(volatile uint_io8_t*)0xB4D802CBUL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_TEFNL	(*(volatile uint_io8_t*)0xB4D802CCUL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_TEFWL	(*(volatile uint_io8_t*)0xB4D802CDUL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_TEFFL	(*(volatile uint_io8_t*)0xB4D802CEUL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_TEFLL	(*(volatile uint_io8_t*)0xB4D802CFUL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_TSWL	(*(volatile uint_io8_t*)0xB4D802D0UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_MRAFL	(*(volatile uint_io8_t*)0xB4D802D1UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_TOOL	(*(volatile uint_io8_t*)0xB4D802D2UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_DRXL	(*(volatile uint_io8_t*)0xB4D802D3UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_BECL	(*(volatile uint_io8_t*)0xB4D802D4UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_BEUL	(*(volatile uint_io8_t*)0xB4D802D5UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_ELOL	(*(volatile uint_io8_t*)0xB4D802D6UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_EPL	(*(volatile uint_io8_t*)0xB4D802D7UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_EWL	(*(volatile uint_io8_t*)0xB4D802D8UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_BOL	(*(volatile uint_io8_t*)0xB4D802D9UL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_WDIL	(*(volatile uint_io8_t*)0xB4D802DAUL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_PEAL	(*(volatile uint_io8_t*)0xB4D802DBUL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_PEDL	(*(volatile uint_io8_t*)0xB4D802DCUL)  /*@bfbba@*/
#define CPG_CANFD3_ILS_ARAL	(*(volatile uint_io8_t*)0xB4D802DDUL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_ils_field{
    uint_io32_t		u1RF0NL:1;
    uint_io32_t		u1RF0WL:1;
    uint_io32_t		u1RF0FL:1;
    uint_io32_t		u1RF0LL:1;
    uint_io32_t		u1RF1NL:1;
    uint_io32_t		u1RF1WL:1;
    uint_io32_t		u1RF1FL:1;
    uint_io32_t		u1RF1LL:1;
    uint_io32_t		u1HPML:1;
    uint_io32_t		u1TCL:1;
    uint_io32_t		u1TCFL:1;
    uint_io32_t		u1TFEL:1;
    uint_io32_t		u1TEFNL:1;
    uint_io32_t		u1TEFWL:1;
    uint_io32_t		u1TEFFL:1;
    uint_io32_t		u1TEFLL:1;
    uint_io32_t		u1TSWL:1;
    uint_io32_t		u1MRAFL:1;
    uint_io32_t		u1TOOL:1;
    uint_io32_t		u1DRXL:1;
    uint_io32_t		u1BECL:1;
    uint_io32_t		u1BEUL:1;
    uint_io32_t		u1ELOL:1;
    uint_io32_t		u1EPL:1;
    uint_io32_t		u1EWL:1;
    uint_io32_t		u1BOL:1;
    uint_io32_t		u1WDIL:1;
    uint_io32_t		u1PEAL:1;
    uint_io32_t		u1PEDL:1;
    uint_io32_t		u1ARAL:1;
    uint_io32_t		:2;
}stc_cpg_canfdn_ils_field_t;

typedef union un_cpg_canfdn_ils{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_ils_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_ils_t;

/* ILE */
#define CPG_CANFD0_ILE	(CPG_CANFD0.unILE.u32Register)  /*@rg@*/
#define CPG_CANFD0_ILE_EINT0	(*(volatile uint_io8_t*)0xB4C002E0UL)  /*@bfbba@*/
#define CPG_CANFD0_ILE_EINT1	(*(volatile uint_io8_t*)0xB4C002E1UL)  /*@bfbba@*/

#define CPG_CANFD1_ILE	(CPG_CANFD1.unILE.u32Register)  /*@rg@*/
#define CPG_CANFD1_ILE_EINT0	(*(volatile uint_io8_t*)0xB4C802E0UL)  /*@bfbba@*/
#define CPG_CANFD1_ILE_EINT1	(*(volatile uint_io8_t*)0xB4C802E1UL)  /*@bfbba@*/

#define CPG_CANFD2_ILE	(CPG_CANFD2.unILE.u32Register)  /*@rg@*/
#define CPG_CANFD2_ILE_EINT0	(*(volatile uint_io8_t*)0xB4D002E0UL)  /*@bfbba@*/
#define CPG_CANFD2_ILE_EINT1	(*(volatile uint_io8_t*)0xB4D002E1UL)  /*@bfbba@*/

#define CPG_CANFD3_ILE	(CPG_CANFD3.unILE.u32Register)  /*@rg@*/
#define CPG_CANFD3_ILE_EINT0	(*(volatile uint_io8_t*)0xB4D802E0UL)  /*@bfbba@*/
#define CPG_CANFD3_ILE_EINT1	(*(volatile uint_io8_t*)0xB4D802E1UL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_ile_field{
    uint_io32_t		u1EINT0:1;
    uint_io32_t		u1EINT1:1;
    uint_io32_t		:30;
}stc_cpg_canfdn_ile_field_t;

typedef union un_cpg_canfdn_ile{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_ile_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_ile_t;

/* GFC */
#define CPG_CANFD0_GFC	(CPG_CANFD0.unGFC.u32Register)  /*@rg@*/
#define CPG_CANFD0_GFC_RRFE	(*(volatile uint_io8_t*)0xB4C00400UL)  /*@bfbba@*/
#define CPG_CANFD0_GFC_RRFS	(*(volatile uint_io8_t*)0xB4C00401UL)  /*@bfbba@*/
#define CPG_CANFD0_GFC_ANFE	(CPG_CANFD0.unGFC.stcField.u2ANFE)  /*@bf@*/
#define CPG_CANFD0_GFC_ANFS	(CPG_CANFD0.unGFC.stcField.u2ANFS)  /*@bf@*/

#define CPG_CANFD1_GFC	(CPG_CANFD1.unGFC.u32Register)  /*@rg@*/
#define CPG_CANFD1_GFC_RRFE	(*(volatile uint_io8_t*)0xB4C80400UL)  /*@bfbba@*/
#define CPG_CANFD1_GFC_RRFS	(*(volatile uint_io8_t*)0xB4C80401UL)  /*@bfbba@*/
#define CPG_CANFD1_GFC_ANFE	(CPG_CANFD1.unGFC.stcField.u2ANFE)  /*@bf@*/
#define CPG_CANFD1_GFC_ANFS	(CPG_CANFD1.unGFC.stcField.u2ANFS)  /*@bf@*/

#define CPG_CANFD2_GFC	(CPG_CANFD2.unGFC.u32Register)  /*@rg@*/
#define CPG_CANFD2_GFC_RRFE	(*(volatile uint_io8_t*)0xB4D00400UL)  /*@bfbba@*/
#define CPG_CANFD2_GFC_RRFS	(*(volatile uint_io8_t*)0xB4D00401UL)  /*@bfbba@*/
#define CPG_CANFD2_GFC_ANFE	(CPG_CANFD2.unGFC.stcField.u2ANFE)  /*@bf@*/
#define CPG_CANFD2_GFC_ANFS	(CPG_CANFD2.unGFC.stcField.u2ANFS)  /*@bf@*/

#define CPG_CANFD3_GFC	(CPG_CANFD3.unGFC.u32Register)  /*@rg@*/
#define CPG_CANFD3_GFC_RRFE	(*(volatile uint_io8_t*)0xB4D80400UL)  /*@bfbba@*/
#define CPG_CANFD3_GFC_RRFS	(*(volatile uint_io8_t*)0xB4D80401UL)  /*@bfbba@*/
#define CPG_CANFD3_GFC_ANFE	(CPG_CANFD3.unGFC.stcField.u2ANFE)  /*@bf@*/
#define CPG_CANFD3_GFC_ANFS	(CPG_CANFD3.unGFC.stcField.u2ANFS)  /*@bf@*/

typedef struct stc_cpg_canfdn_gfc_field{
    uint_io32_t		u1RRFE:1;
    uint_io32_t		u1RRFS:1;
    uint_io32_t		u2ANFE:2;
    uint_io32_t		u2ANFS:2;
    uint_io32_t		:26;
}stc_cpg_canfdn_gfc_field_t;

typedef union un_cpg_canfdn_gfc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_gfc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_gfc_t;

/* SIDFC */
#define CPG_CANFD0_SIDFC	(CPG_CANFD0.unSIDFC.u32Register)  /*@rg@*/
#define CPG_CANFD0_SIDFC_FLSSA	(CPG_CANFD0.unSIDFC.stcField.u14FLSSA)  /*@bf@*/
#define CPG_CANFD0_SIDFC_LSS	(CPG_CANFD0.unSIDFC.au8Byte[2])  /*@bfbyte@*/

#define CPG_CANFD1_SIDFC	(CPG_CANFD1.unSIDFC.u32Register)  /*@rg@*/
#define CPG_CANFD1_SIDFC_FLSSA	(CPG_CANFD1.unSIDFC.stcField.u14FLSSA)  /*@bf@*/
#define CPG_CANFD1_SIDFC_LSS	(CPG_CANFD1.unSIDFC.au8Byte[2])  /*@bfbyte@*/

#define CPG_CANFD2_SIDFC	(CPG_CANFD2.unSIDFC.u32Register)  /*@rg@*/
#define CPG_CANFD2_SIDFC_FLSSA	(CPG_CANFD2.unSIDFC.stcField.u14FLSSA)  /*@bf@*/
#define CPG_CANFD2_SIDFC_LSS	(CPG_CANFD2.unSIDFC.au8Byte[2])  /*@bfbyte@*/

#define CPG_CANFD3_SIDFC	(CPG_CANFD3.unSIDFC.u32Register)  /*@rg@*/
#define CPG_CANFD3_SIDFC_FLSSA	(CPG_CANFD3.unSIDFC.stcField.u14FLSSA)  /*@bf@*/
#define CPG_CANFD3_SIDFC_LSS	(CPG_CANFD3.unSIDFC.au8Byte[2])  /*@bfbyte@*/

typedef struct stc_cpg_canfdn_sidfc_field{
    uint_io32_t		:2;
    uint_io32_t		u14FLSSA:14;
    uint_io32_t		u8LSS:8;
    uint_io32_t		:8;
}stc_cpg_canfdn_sidfc_field_t;

typedef union un_cpg_canfdn_sidfc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_sidfc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_sidfc_t;

/* XIDFC */
#define CPG_CANFD0_XIDFC	(CPG_CANFD0.unXIDFC.u32Register)  /*@rg@*/
#define CPG_CANFD0_XIDFC_FLESA	(CPG_CANFD0.unXIDFC.stcField.u14FLESA)  /*@bf@*/
#define CPG_CANFD0_XIDFC_LSE	(CPG_CANFD0.unXIDFC.stcField.u7LSE)  /*@bf@*/

#define CPG_CANFD1_XIDFC	(CPG_CANFD1.unXIDFC.u32Register)  /*@rg@*/
#define CPG_CANFD1_XIDFC_FLESA	(CPG_CANFD1.unXIDFC.stcField.u14FLESA)  /*@bf@*/
#define CPG_CANFD1_XIDFC_LSE	(CPG_CANFD1.unXIDFC.stcField.u7LSE)  /*@bf@*/

#define CPG_CANFD2_XIDFC	(CPG_CANFD2.unXIDFC.u32Register)  /*@rg@*/
#define CPG_CANFD2_XIDFC_FLESA	(CPG_CANFD2.unXIDFC.stcField.u14FLESA)  /*@bf@*/
#define CPG_CANFD2_XIDFC_LSE	(CPG_CANFD2.unXIDFC.stcField.u7LSE)  /*@bf@*/

#define CPG_CANFD3_XIDFC	(CPG_CANFD3.unXIDFC.u32Register)  /*@rg@*/
#define CPG_CANFD3_XIDFC_FLESA	(CPG_CANFD3.unXIDFC.stcField.u14FLESA)  /*@bf@*/
#define CPG_CANFD3_XIDFC_LSE	(CPG_CANFD3.unXIDFC.stcField.u7LSE)  /*@bf@*/

typedef struct stc_cpg_canfdn_xidfc_field{
    uint_io32_t		:2;
    uint_io32_t		u14FLESA:14;
    uint_io32_t		u7LSE:7;
    uint_io32_t		:9;
}stc_cpg_canfdn_xidfc_field_t;

typedef union un_cpg_canfdn_xidfc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_xidfc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_xidfc_t;

/* XIDAM */
#define CPG_CANFD0_XIDAM	(CPG_CANFD0.unXIDAM.u32Register)  /*@rg@*/
#define CPG_CANFD0_XIDAM_EIDM	(CPG_CANFD0.unXIDAM.stcField.u29EIDM)  /*@bf@*/

#define CPG_CANFD1_XIDAM	(CPG_CANFD1.unXIDAM.u32Register)  /*@rg@*/
#define CPG_CANFD1_XIDAM_EIDM	(CPG_CANFD1.unXIDAM.stcField.u29EIDM)  /*@bf@*/

#define CPG_CANFD2_XIDAM	(CPG_CANFD2.unXIDAM.u32Register)  /*@rg@*/
#define CPG_CANFD2_XIDAM_EIDM	(CPG_CANFD2.unXIDAM.stcField.u29EIDM)  /*@bf@*/

#define CPG_CANFD3_XIDAM	(CPG_CANFD3.unXIDAM.u32Register)  /*@rg@*/
#define CPG_CANFD3_XIDAM_EIDM	(CPG_CANFD3.unXIDAM.stcField.u29EIDM)  /*@bf@*/

typedef struct stc_cpg_canfdn_xidam_field{
    uint_io32_t		u29EIDM:29;
    uint_io32_t		:3;
}stc_cpg_canfdn_xidam_field_t;

typedef union un_cpg_canfdn_xidam{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_xidam_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_xidam_t;

/* HPMS */
#define CPG_CANFD0_HPMS	(CPG_CANFD0.unHPMS.u32Register)  /*@rg@*/
#define CPG_CANFD0_HPMS_BIDX	(CPG_CANFD0.unHPMS.stcField.u6BIDX)  /*@bf@*/
#define CPG_CANFD0_HPMS_MSI	(CPG_CANFD0.unHPMS.stcField.u2MSI)  /*@bf@*/
#define CPG_CANFD0_HPMS_FIDX	(CPG_CANFD0.unHPMS.stcField.u7FIDX)  /*@bf@*/
#define CPG_CANFD0_HPMS_FLST	(*(volatile uint_io8_t*)0xB4C004AFUL)  /*@bfbba@*/

#define CPG_CANFD1_HPMS	(CPG_CANFD1.unHPMS.u32Register)  /*@rg@*/
#define CPG_CANFD1_HPMS_BIDX	(CPG_CANFD1.unHPMS.stcField.u6BIDX)  /*@bf@*/
#define CPG_CANFD1_HPMS_MSI	(CPG_CANFD1.unHPMS.stcField.u2MSI)  /*@bf@*/
#define CPG_CANFD1_HPMS_FIDX	(CPG_CANFD1.unHPMS.stcField.u7FIDX)  /*@bf@*/
#define CPG_CANFD1_HPMS_FLST	(*(volatile uint_io8_t*)0xB4C804AFUL)  /*@bfbba@*/

#define CPG_CANFD2_HPMS	(CPG_CANFD2.unHPMS.u32Register)  /*@rg@*/
#define CPG_CANFD2_HPMS_BIDX	(CPG_CANFD2.unHPMS.stcField.u6BIDX)  /*@bf@*/
#define CPG_CANFD2_HPMS_MSI	(CPG_CANFD2.unHPMS.stcField.u2MSI)  /*@bf@*/
#define CPG_CANFD2_HPMS_FIDX	(CPG_CANFD2.unHPMS.stcField.u7FIDX)  /*@bf@*/
#define CPG_CANFD2_HPMS_FLST	(*(volatile uint_io8_t*)0xB4D004AFUL)  /*@bfbba@*/

#define CPG_CANFD3_HPMS	(CPG_CANFD3.unHPMS.u32Register)  /*@rg@*/
#define CPG_CANFD3_HPMS_BIDX	(CPG_CANFD3.unHPMS.stcField.u6BIDX)  /*@bf@*/
#define CPG_CANFD3_HPMS_MSI	(CPG_CANFD3.unHPMS.stcField.u2MSI)  /*@bf@*/
#define CPG_CANFD3_HPMS_FIDX	(CPG_CANFD3.unHPMS.stcField.u7FIDX)  /*@bf@*/
#define CPG_CANFD3_HPMS_FLST	(*(volatile uint_io8_t*)0xB4D804AFUL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_hpms_field{
    uint_io32_t		u6BIDX:6;
    uint_io32_t		u2MSI:2;
    uint_io32_t		u7FIDX:7;
    uint_io32_t		u1FLST:1;
    uint_io32_t		:16;
}stc_cpg_canfdn_hpms_field_t;

typedef union un_cpg_canfdn_hpms{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_hpms_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_hpms_t;

/* NDAT1 */
#define CPG_CANFD0_NDAT1	(CPG_CANFD0.unNDAT1.u32Register)  /*@rg@*/
#define CPG_CANFD0_NDAT1_ND0	(*(volatile uint_io8_t*)0xB4C004C0UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND1	(*(volatile uint_io8_t*)0xB4C004C1UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND2	(*(volatile uint_io8_t*)0xB4C004C2UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND3	(*(volatile uint_io8_t*)0xB4C004C3UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND4	(*(volatile uint_io8_t*)0xB4C004C4UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND5	(*(volatile uint_io8_t*)0xB4C004C5UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND6	(*(volatile uint_io8_t*)0xB4C004C6UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND7	(*(volatile uint_io8_t*)0xB4C004C7UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND8	(*(volatile uint_io8_t*)0xB4C004C8UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND9	(*(volatile uint_io8_t*)0xB4C004C9UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND10	(*(volatile uint_io8_t*)0xB4C004CAUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND11	(*(volatile uint_io8_t*)0xB4C004CBUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND12	(*(volatile uint_io8_t*)0xB4C004CCUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND13	(*(volatile uint_io8_t*)0xB4C004CDUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND14	(*(volatile uint_io8_t*)0xB4C004CEUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND15	(*(volatile uint_io8_t*)0xB4C004CFUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND16	(*(volatile uint_io8_t*)0xB4C004D0UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND17	(*(volatile uint_io8_t*)0xB4C004D1UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND18	(*(volatile uint_io8_t*)0xB4C004D2UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND19	(*(volatile uint_io8_t*)0xB4C004D3UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND20	(*(volatile uint_io8_t*)0xB4C004D4UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND21	(*(volatile uint_io8_t*)0xB4C004D5UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND22	(*(volatile uint_io8_t*)0xB4C004D6UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND23	(*(volatile uint_io8_t*)0xB4C004D7UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND24	(*(volatile uint_io8_t*)0xB4C004D8UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND25	(*(volatile uint_io8_t*)0xB4C004D9UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND26	(*(volatile uint_io8_t*)0xB4C004DAUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND27	(*(volatile uint_io8_t*)0xB4C004DBUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND28	(*(volatile uint_io8_t*)0xB4C004DCUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND29	(*(volatile uint_io8_t*)0xB4C004DDUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND30	(*(volatile uint_io8_t*)0xB4C004DEUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT1_ND31	(*(volatile uint_io8_t*)0xB4C004DFUL)  /*@bfbba@*/

#define CPG_CANFD1_NDAT1	(CPG_CANFD1.unNDAT1.u32Register)  /*@rg@*/
#define CPG_CANFD1_NDAT1_ND0	(*(volatile uint_io8_t*)0xB4C804C0UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND1	(*(volatile uint_io8_t*)0xB4C804C1UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND2	(*(volatile uint_io8_t*)0xB4C804C2UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND3	(*(volatile uint_io8_t*)0xB4C804C3UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND4	(*(volatile uint_io8_t*)0xB4C804C4UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND5	(*(volatile uint_io8_t*)0xB4C804C5UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND6	(*(volatile uint_io8_t*)0xB4C804C6UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND7	(*(volatile uint_io8_t*)0xB4C804C7UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND8	(*(volatile uint_io8_t*)0xB4C804C8UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND9	(*(volatile uint_io8_t*)0xB4C804C9UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND10	(*(volatile uint_io8_t*)0xB4C804CAUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND11	(*(volatile uint_io8_t*)0xB4C804CBUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND12	(*(volatile uint_io8_t*)0xB4C804CCUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND13	(*(volatile uint_io8_t*)0xB4C804CDUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND14	(*(volatile uint_io8_t*)0xB4C804CEUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND15	(*(volatile uint_io8_t*)0xB4C804CFUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND16	(*(volatile uint_io8_t*)0xB4C804D0UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND17	(*(volatile uint_io8_t*)0xB4C804D1UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND18	(*(volatile uint_io8_t*)0xB4C804D2UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND19	(*(volatile uint_io8_t*)0xB4C804D3UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND20	(*(volatile uint_io8_t*)0xB4C804D4UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND21	(*(volatile uint_io8_t*)0xB4C804D5UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND22	(*(volatile uint_io8_t*)0xB4C804D6UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND23	(*(volatile uint_io8_t*)0xB4C804D7UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND24	(*(volatile uint_io8_t*)0xB4C804D8UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND25	(*(volatile uint_io8_t*)0xB4C804D9UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND26	(*(volatile uint_io8_t*)0xB4C804DAUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND27	(*(volatile uint_io8_t*)0xB4C804DBUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND28	(*(volatile uint_io8_t*)0xB4C804DCUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND29	(*(volatile uint_io8_t*)0xB4C804DDUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND30	(*(volatile uint_io8_t*)0xB4C804DEUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT1_ND31	(*(volatile uint_io8_t*)0xB4C804DFUL)  /*@bfbba@*/

#define CPG_CANFD2_NDAT1	(CPG_CANFD2.unNDAT1.u32Register)  /*@rg@*/
#define CPG_CANFD2_NDAT1_ND0	(*(volatile uint_io8_t*)0xB4D004C0UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND1	(*(volatile uint_io8_t*)0xB4D004C1UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND2	(*(volatile uint_io8_t*)0xB4D004C2UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND3	(*(volatile uint_io8_t*)0xB4D004C3UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND4	(*(volatile uint_io8_t*)0xB4D004C4UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND5	(*(volatile uint_io8_t*)0xB4D004C5UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND6	(*(volatile uint_io8_t*)0xB4D004C6UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND7	(*(volatile uint_io8_t*)0xB4D004C7UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND8	(*(volatile uint_io8_t*)0xB4D004C8UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND9	(*(volatile uint_io8_t*)0xB4D004C9UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND10	(*(volatile uint_io8_t*)0xB4D004CAUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND11	(*(volatile uint_io8_t*)0xB4D004CBUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND12	(*(volatile uint_io8_t*)0xB4D004CCUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND13	(*(volatile uint_io8_t*)0xB4D004CDUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND14	(*(volatile uint_io8_t*)0xB4D004CEUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND15	(*(volatile uint_io8_t*)0xB4D004CFUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND16	(*(volatile uint_io8_t*)0xB4D004D0UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND17	(*(volatile uint_io8_t*)0xB4D004D1UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND18	(*(volatile uint_io8_t*)0xB4D004D2UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND19	(*(volatile uint_io8_t*)0xB4D004D3UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND20	(*(volatile uint_io8_t*)0xB4D004D4UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND21	(*(volatile uint_io8_t*)0xB4D004D5UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND22	(*(volatile uint_io8_t*)0xB4D004D6UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND23	(*(volatile uint_io8_t*)0xB4D004D7UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND24	(*(volatile uint_io8_t*)0xB4D004D8UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND25	(*(volatile uint_io8_t*)0xB4D004D9UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND26	(*(volatile uint_io8_t*)0xB4D004DAUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND27	(*(volatile uint_io8_t*)0xB4D004DBUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND28	(*(volatile uint_io8_t*)0xB4D004DCUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND29	(*(volatile uint_io8_t*)0xB4D004DDUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND30	(*(volatile uint_io8_t*)0xB4D004DEUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT1_ND31	(*(volatile uint_io8_t*)0xB4D004DFUL)  /*@bfbba@*/

#define CPG_CANFD3_NDAT1	(CPG_CANFD3.unNDAT1.u32Register)  /*@rg@*/
#define CPG_CANFD3_NDAT1_ND0	(*(volatile uint_io8_t*)0xB4D804C0UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND1	(*(volatile uint_io8_t*)0xB4D804C1UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND2	(*(volatile uint_io8_t*)0xB4D804C2UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND3	(*(volatile uint_io8_t*)0xB4D804C3UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND4	(*(volatile uint_io8_t*)0xB4D804C4UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND5	(*(volatile uint_io8_t*)0xB4D804C5UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND6	(*(volatile uint_io8_t*)0xB4D804C6UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND7	(*(volatile uint_io8_t*)0xB4D804C7UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND8	(*(volatile uint_io8_t*)0xB4D804C8UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND9	(*(volatile uint_io8_t*)0xB4D804C9UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND10	(*(volatile uint_io8_t*)0xB4D804CAUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND11	(*(volatile uint_io8_t*)0xB4D804CBUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND12	(*(volatile uint_io8_t*)0xB4D804CCUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND13	(*(volatile uint_io8_t*)0xB4D804CDUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND14	(*(volatile uint_io8_t*)0xB4D804CEUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND15	(*(volatile uint_io8_t*)0xB4D804CFUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND16	(*(volatile uint_io8_t*)0xB4D804D0UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND17	(*(volatile uint_io8_t*)0xB4D804D1UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND18	(*(volatile uint_io8_t*)0xB4D804D2UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND19	(*(volatile uint_io8_t*)0xB4D804D3UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND20	(*(volatile uint_io8_t*)0xB4D804D4UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND21	(*(volatile uint_io8_t*)0xB4D804D5UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND22	(*(volatile uint_io8_t*)0xB4D804D6UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND23	(*(volatile uint_io8_t*)0xB4D804D7UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND24	(*(volatile uint_io8_t*)0xB4D804D8UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND25	(*(volatile uint_io8_t*)0xB4D804D9UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND26	(*(volatile uint_io8_t*)0xB4D804DAUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND27	(*(volatile uint_io8_t*)0xB4D804DBUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND28	(*(volatile uint_io8_t*)0xB4D804DCUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND29	(*(volatile uint_io8_t*)0xB4D804DDUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND30	(*(volatile uint_io8_t*)0xB4D804DEUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT1_ND31	(*(volatile uint_io8_t*)0xB4D804DFUL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_ndat1_field{
    uint_io32_t		u1ND0:1;
    uint_io32_t		u1ND1:1;
    uint_io32_t		u1ND2:1;
    uint_io32_t		u1ND3:1;
    uint_io32_t		u1ND4:1;
    uint_io32_t		u1ND5:1;
    uint_io32_t		u1ND6:1;
    uint_io32_t		u1ND7:1;
    uint_io32_t		u1ND8:1;
    uint_io32_t		u1ND9:1;
    uint_io32_t		u1ND10:1;
    uint_io32_t		u1ND11:1;
    uint_io32_t		u1ND12:1;
    uint_io32_t		u1ND13:1;
    uint_io32_t		u1ND14:1;
    uint_io32_t		u1ND15:1;
    uint_io32_t		u1ND16:1;
    uint_io32_t		u1ND17:1;
    uint_io32_t		u1ND18:1;
    uint_io32_t		u1ND19:1;
    uint_io32_t		u1ND20:1;
    uint_io32_t		u1ND21:1;
    uint_io32_t		u1ND22:1;
    uint_io32_t		u1ND23:1;
    uint_io32_t		u1ND24:1;
    uint_io32_t		u1ND25:1;
    uint_io32_t		u1ND26:1;
    uint_io32_t		u1ND27:1;
    uint_io32_t		u1ND28:1;
    uint_io32_t		u1ND29:1;
    uint_io32_t		u1ND30:1;
    uint_io32_t		u1ND31:1;
}stc_cpg_canfdn_ndat1_field_t;

typedef union un_cpg_canfdn_ndat1{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_ndat1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_ndat1_t;

/* NDAT2 */
#define CPG_CANFD0_NDAT2	(CPG_CANFD0.unNDAT2.u32Register)  /*@rg@*/
#define CPG_CANFD0_NDAT2_ND32	(*(volatile uint_io8_t*)0xB4C004E0UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND33	(*(volatile uint_io8_t*)0xB4C004E1UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND34	(*(volatile uint_io8_t*)0xB4C004E2UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND35	(*(volatile uint_io8_t*)0xB4C004E3UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND36	(*(volatile uint_io8_t*)0xB4C004E4UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND37	(*(volatile uint_io8_t*)0xB4C004E5UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND38	(*(volatile uint_io8_t*)0xB4C004E6UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND39	(*(volatile uint_io8_t*)0xB4C004E7UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND40	(*(volatile uint_io8_t*)0xB4C004E8UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND41	(*(volatile uint_io8_t*)0xB4C004E9UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND42	(*(volatile uint_io8_t*)0xB4C004EAUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND43	(*(volatile uint_io8_t*)0xB4C004EBUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND44	(*(volatile uint_io8_t*)0xB4C004ECUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND45	(*(volatile uint_io8_t*)0xB4C004EDUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND46	(*(volatile uint_io8_t*)0xB4C004EEUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND47	(*(volatile uint_io8_t*)0xB4C004EFUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND48	(*(volatile uint_io8_t*)0xB4C004F0UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND49	(*(volatile uint_io8_t*)0xB4C004F1UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND50	(*(volatile uint_io8_t*)0xB4C004F2UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND51	(*(volatile uint_io8_t*)0xB4C004F3UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND52	(*(volatile uint_io8_t*)0xB4C004F4UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND53	(*(volatile uint_io8_t*)0xB4C004F5UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND54	(*(volatile uint_io8_t*)0xB4C004F6UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND55	(*(volatile uint_io8_t*)0xB4C004F7UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND56	(*(volatile uint_io8_t*)0xB4C004F8UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND57	(*(volatile uint_io8_t*)0xB4C004F9UL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND58	(*(volatile uint_io8_t*)0xB4C004FAUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND59	(*(volatile uint_io8_t*)0xB4C004FBUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND60	(*(volatile uint_io8_t*)0xB4C004FCUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND61	(*(volatile uint_io8_t*)0xB4C004FDUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND62	(*(volatile uint_io8_t*)0xB4C004FEUL)  /*@bfbba@*/
#define CPG_CANFD0_NDAT2_ND63	(*(volatile uint_io8_t*)0xB4C004FFUL)  /*@bfbba@*/

#define CPG_CANFD1_NDAT2	(CPG_CANFD1.unNDAT2.u32Register)  /*@rg@*/
#define CPG_CANFD1_NDAT2_ND32	(*(volatile uint_io8_t*)0xB4C804E0UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND33	(*(volatile uint_io8_t*)0xB4C804E1UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND34	(*(volatile uint_io8_t*)0xB4C804E2UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND35	(*(volatile uint_io8_t*)0xB4C804E3UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND36	(*(volatile uint_io8_t*)0xB4C804E4UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND37	(*(volatile uint_io8_t*)0xB4C804E5UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND38	(*(volatile uint_io8_t*)0xB4C804E6UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND39	(*(volatile uint_io8_t*)0xB4C804E7UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND40	(*(volatile uint_io8_t*)0xB4C804E8UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND41	(*(volatile uint_io8_t*)0xB4C804E9UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND42	(*(volatile uint_io8_t*)0xB4C804EAUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND43	(*(volatile uint_io8_t*)0xB4C804EBUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND44	(*(volatile uint_io8_t*)0xB4C804ECUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND45	(*(volatile uint_io8_t*)0xB4C804EDUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND46	(*(volatile uint_io8_t*)0xB4C804EEUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND47	(*(volatile uint_io8_t*)0xB4C804EFUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND48	(*(volatile uint_io8_t*)0xB4C804F0UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND49	(*(volatile uint_io8_t*)0xB4C804F1UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND50	(*(volatile uint_io8_t*)0xB4C804F2UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND51	(*(volatile uint_io8_t*)0xB4C804F3UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND52	(*(volatile uint_io8_t*)0xB4C804F4UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND53	(*(volatile uint_io8_t*)0xB4C804F5UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND54	(*(volatile uint_io8_t*)0xB4C804F6UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND55	(*(volatile uint_io8_t*)0xB4C804F7UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND56	(*(volatile uint_io8_t*)0xB4C804F8UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND57	(*(volatile uint_io8_t*)0xB4C804F9UL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND58	(*(volatile uint_io8_t*)0xB4C804FAUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND59	(*(volatile uint_io8_t*)0xB4C804FBUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND60	(*(volatile uint_io8_t*)0xB4C804FCUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND61	(*(volatile uint_io8_t*)0xB4C804FDUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND62	(*(volatile uint_io8_t*)0xB4C804FEUL)  /*@bfbba@*/
#define CPG_CANFD1_NDAT2_ND63	(*(volatile uint_io8_t*)0xB4C804FFUL)  /*@bfbba@*/

#define CPG_CANFD2_NDAT2	(CPG_CANFD2.unNDAT2.u32Register)  /*@rg@*/
#define CPG_CANFD2_NDAT2_ND32	(*(volatile uint_io8_t*)0xB4D004E0UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND33	(*(volatile uint_io8_t*)0xB4D004E1UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND34	(*(volatile uint_io8_t*)0xB4D004E2UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND35	(*(volatile uint_io8_t*)0xB4D004E3UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND36	(*(volatile uint_io8_t*)0xB4D004E4UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND37	(*(volatile uint_io8_t*)0xB4D004E5UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND38	(*(volatile uint_io8_t*)0xB4D004E6UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND39	(*(volatile uint_io8_t*)0xB4D004E7UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND40	(*(volatile uint_io8_t*)0xB4D004E8UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND41	(*(volatile uint_io8_t*)0xB4D004E9UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND42	(*(volatile uint_io8_t*)0xB4D004EAUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND43	(*(volatile uint_io8_t*)0xB4D004EBUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND44	(*(volatile uint_io8_t*)0xB4D004ECUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND45	(*(volatile uint_io8_t*)0xB4D004EDUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND46	(*(volatile uint_io8_t*)0xB4D004EEUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND47	(*(volatile uint_io8_t*)0xB4D004EFUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND48	(*(volatile uint_io8_t*)0xB4D004F0UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND49	(*(volatile uint_io8_t*)0xB4D004F1UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND50	(*(volatile uint_io8_t*)0xB4D004F2UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND51	(*(volatile uint_io8_t*)0xB4D004F3UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND52	(*(volatile uint_io8_t*)0xB4D004F4UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND53	(*(volatile uint_io8_t*)0xB4D004F5UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND54	(*(volatile uint_io8_t*)0xB4D004F6UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND55	(*(volatile uint_io8_t*)0xB4D004F7UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND56	(*(volatile uint_io8_t*)0xB4D004F8UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND57	(*(volatile uint_io8_t*)0xB4D004F9UL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND58	(*(volatile uint_io8_t*)0xB4D004FAUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND59	(*(volatile uint_io8_t*)0xB4D004FBUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND60	(*(volatile uint_io8_t*)0xB4D004FCUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND61	(*(volatile uint_io8_t*)0xB4D004FDUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND62	(*(volatile uint_io8_t*)0xB4D004FEUL)  /*@bfbba@*/
#define CPG_CANFD2_NDAT2_ND63	(*(volatile uint_io8_t*)0xB4D004FFUL)  /*@bfbba@*/

#define CPG_CANFD3_NDAT2	(CPG_CANFD3.unNDAT2.u32Register)  /*@rg@*/
#define CPG_CANFD3_NDAT2_ND32	(*(volatile uint_io8_t*)0xB4D804E0UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND33	(*(volatile uint_io8_t*)0xB4D804E1UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND34	(*(volatile uint_io8_t*)0xB4D804E2UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND35	(*(volatile uint_io8_t*)0xB4D804E3UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND36	(*(volatile uint_io8_t*)0xB4D804E4UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND37	(*(volatile uint_io8_t*)0xB4D804E5UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND38	(*(volatile uint_io8_t*)0xB4D804E6UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND39	(*(volatile uint_io8_t*)0xB4D804E7UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND40	(*(volatile uint_io8_t*)0xB4D804E8UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND41	(*(volatile uint_io8_t*)0xB4D804E9UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND42	(*(volatile uint_io8_t*)0xB4D804EAUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND43	(*(volatile uint_io8_t*)0xB4D804EBUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND44	(*(volatile uint_io8_t*)0xB4D804ECUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND45	(*(volatile uint_io8_t*)0xB4D804EDUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND46	(*(volatile uint_io8_t*)0xB4D804EEUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND47	(*(volatile uint_io8_t*)0xB4D804EFUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND48	(*(volatile uint_io8_t*)0xB4D804F0UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND49	(*(volatile uint_io8_t*)0xB4D804F1UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND50	(*(volatile uint_io8_t*)0xB4D804F2UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND51	(*(volatile uint_io8_t*)0xB4D804F3UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND52	(*(volatile uint_io8_t*)0xB4D804F4UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND53	(*(volatile uint_io8_t*)0xB4D804F5UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND54	(*(volatile uint_io8_t*)0xB4D804F6UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND55	(*(volatile uint_io8_t*)0xB4D804F7UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND56	(*(volatile uint_io8_t*)0xB4D804F8UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND57	(*(volatile uint_io8_t*)0xB4D804F9UL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND58	(*(volatile uint_io8_t*)0xB4D804FAUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND59	(*(volatile uint_io8_t*)0xB4D804FBUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND60	(*(volatile uint_io8_t*)0xB4D804FCUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND61	(*(volatile uint_io8_t*)0xB4D804FDUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND62	(*(volatile uint_io8_t*)0xB4D804FEUL)  /*@bfbba@*/
#define CPG_CANFD3_NDAT2_ND63	(*(volatile uint_io8_t*)0xB4D804FFUL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_ndat2_field{
    uint_io32_t		u1ND32:1;
    uint_io32_t		u1ND33:1;
    uint_io32_t		u1ND34:1;
    uint_io32_t		u1ND35:1;
    uint_io32_t		u1ND36:1;
    uint_io32_t		u1ND37:1;
    uint_io32_t		u1ND38:1;
    uint_io32_t		u1ND39:1;
    uint_io32_t		u1ND40:1;
    uint_io32_t		u1ND41:1;
    uint_io32_t		u1ND42:1;
    uint_io32_t		u1ND43:1;
    uint_io32_t		u1ND44:1;
    uint_io32_t		u1ND45:1;
    uint_io32_t		u1ND46:1;
    uint_io32_t		u1ND47:1;
    uint_io32_t		u1ND48:1;
    uint_io32_t		u1ND49:1;
    uint_io32_t		u1ND50:1;
    uint_io32_t		u1ND51:1;
    uint_io32_t		u1ND52:1;
    uint_io32_t		u1ND53:1;
    uint_io32_t		u1ND54:1;
    uint_io32_t		u1ND55:1;
    uint_io32_t		u1ND56:1;
    uint_io32_t		u1ND57:1;
    uint_io32_t		u1ND58:1;
    uint_io32_t		u1ND59:1;
    uint_io32_t		u1ND60:1;
    uint_io32_t		u1ND61:1;
    uint_io32_t		u1ND62:1;
    uint_io32_t		u1ND63:1;
}stc_cpg_canfdn_ndat2_field_t;

typedef union un_cpg_canfdn_ndat2{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_ndat2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_ndat2_t;

/* RXF0C */
#define CPG_CANFD0_RXF0C	(CPG_CANFD0.unRXF0C.u32Register)  /*@rg@*/
#define CPG_CANFD0_RXF0C_F0SA	(CPG_CANFD0.unRXF0C.stcField.u14F0SA)  /*@bf@*/
#define CPG_CANFD0_RXF0C_F0S	(CPG_CANFD0.unRXF0C.stcField.u7F0S)  /*@bf@*/
#define CPG_CANFD0_RXF0C_F0WM	(CPG_CANFD0.unRXF0C.stcField.u7F0WM)  /*@bf@*/
#define CPG_CANFD0_RXF0C_F0OM	(*(volatile uint_io8_t*)0xB4C0051FUL)  /*@bfbba@*/

#define CPG_CANFD1_RXF0C	(CPG_CANFD1.unRXF0C.u32Register)  /*@rg@*/
#define CPG_CANFD1_RXF0C_F0SA	(CPG_CANFD1.unRXF0C.stcField.u14F0SA)  /*@bf@*/
#define CPG_CANFD1_RXF0C_F0S	(CPG_CANFD1.unRXF0C.stcField.u7F0S)  /*@bf@*/
#define CPG_CANFD1_RXF0C_F0WM	(CPG_CANFD1.unRXF0C.stcField.u7F0WM)  /*@bf@*/
#define CPG_CANFD1_RXF0C_F0OM	(*(volatile uint_io8_t*)0xB4C8051FUL)  /*@bfbba@*/

#define CPG_CANFD2_RXF0C	(CPG_CANFD2.unRXF0C.u32Register)  /*@rg@*/
#define CPG_CANFD2_RXF0C_F0SA	(CPG_CANFD2.unRXF0C.stcField.u14F0SA)  /*@bf@*/
#define CPG_CANFD2_RXF0C_F0S	(CPG_CANFD2.unRXF0C.stcField.u7F0S)  /*@bf@*/
#define CPG_CANFD2_RXF0C_F0WM	(CPG_CANFD2.unRXF0C.stcField.u7F0WM)  /*@bf@*/
#define CPG_CANFD2_RXF0C_F0OM	(*(volatile uint_io8_t*)0xB4D0051FUL)  /*@bfbba@*/

#define CPG_CANFD3_RXF0C	(CPG_CANFD3.unRXF0C.u32Register)  /*@rg@*/
#define CPG_CANFD3_RXF0C_F0SA	(CPG_CANFD3.unRXF0C.stcField.u14F0SA)  /*@bf@*/
#define CPG_CANFD3_RXF0C_F0S	(CPG_CANFD3.unRXF0C.stcField.u7F0S)  /*@bf@*/
#define CPG_CANFD3_RXF0C_F0WM	(CPG_CANFD3.unRXF0C.stcField.u7F0WM)  /*@bf@*/
#define CPG_CANFD3_RXF0C_F0OM	(*(volatile uint_io8_t*)0xB4D8051FUL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_rxf0c_field{
    uint_io32_t		:2;
    uint_io32_t		u14F0SA:14;
    uint_io32_t		u7F0S:7;
    uint_io32_t		:1;
    uint_io32_t		u7F0WM:7;
    uint_io32_t		u1F0OM:1;
}stc_cpg_canfdn_rxf0c_field_t;

typedef union un_cpg_canfdn_rxf0c{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_rxf0c_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_rxf0c_t;

/* RXF0S */
#define CPG_CANFD0_RXF0S	(CPG_CANFD0.unRXF0S.u32Register)  /*@rg@*/
#define CPG_CANFD0_RXF0S_F0FL	(CPG_CANFD0.unRXF0S.stcField.u7F0FL)  /*@bf@*/
#define CPG_CANFD0_RXF0S_F0GI	(CPG_CANFD0.unRXF0S.stcField.u6F0GI)  /*@bf@*/
#define CPG_CANFD0_RXF0S_F0PI	(CPG_CANFD0.unRXF0S.stcField.u6F0PI)  /*@bf@*/
#define CPG_CANFD0_RXF0S_F0F	(*(volatile uint_io8_t*)0xB4C00538UL)  /*@bfbba@*/
#define CPG_CANFD0_RXF0S_RF0L	(*(volatile uint_io8_t*)0xB4C00539UL)  /*@bfbba@*/

#define CPG_CANFD1_RXF0S	(CPG_CANFD1.unRXF0S.u32Register)  /*@rg@*/
#define CPG_CANFD1_RXF0S_F0FL	(CPG_CANFD1.unRXF0S.stcField.u7F0FL)  /*@bf@*/
#define CPG_CANFD1_RXF0S_F0GI	(CPG_CANFD1.unRXF0S.stcField.u6F0GI)  /*@bf@*/
#define CPG_CANFD1_RXF0S_F0PI	(CPG_CANFD1.unRXF0S.stcField.u6F0PI)  /*@bf@*/
#define CPG_CANFD1_RXF0S_F0F	(*(volatile uint_io8_t*)0xB4C80538UL)  /*@bfbba@*/
#define CPG_CANFD1_RXF0S_RF0L	(*(volatile uint_io8_t*)0xB4C80539UL)  /*@bfbba@*/

#define CPG_CANFD2_RXF0S	(CPG_CANFD2.unRXF0S.u32Register)  /*@rg@*/
#define CPG_CANFD2_RXF0S_F0FL	(CPG_CANFD2.unRXF0S.stcField.u7F0FL)  /*@bf@*/
#define CPG_CANFD2_RXF0S_F0GI	(CPG_CANFD2.unRXF0S.stcField.u6F0GI)  /*@bf@*/
#define CPG_CANFD2_RXF0S_F0PI	(CPG_CANFD2.unRXF0S.stcField.u6F0PI)  /*@bf@*/
#define CPG_CANFD2_RXF0S_F0F	(*(volatile uint_io8_t*)0xB4D00538UL)  /*@bfbba@*/
#define CPG_CANFD2_RXF0S_RF0L	(*(volatile uint_io8_t*)0xB4D00539UL)  /*@bfbba@*/

#define CPG_CANFD3_RXF0S	(CPG_CANFD3.unRXF0S.u32Register)  /*@rg@*/
#define CPG_CANFD3_RXF0S_F0FL	(CPG_CANFD3.unRXF0S.stcField.u7F0FL)  /*@bf@*/
#define CPG_CANFD3_RXF0S_F0GI	(CPG_CANFD3.unRXF0S.stcField.u6F0GI)  /*@bf@*/
#define CPG_CANFD3_RXF0S_F0PI	(CPG_CANFD3.unRXF0S.stcField.u6F0PI)  /*@bf@*/
#define CPG_CANFD3_RXF0S_F0F	(*(volatile uint_io8_t*)0xB4D80538UL)  /*@bfbba@*/
#define CPG_CANFD3_RXF0S_RF0L	(*(volatile uint_io8_t*)0xB4D80539UL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_rxf0s_field{
    uint_io32_t		u7F0FL:7;
    uint_io32_t		:1;
    uint_io32_t		u6F0GI:6;
    uint_io32_t		:2;
    uint_io32_t		u6F0PI:6;
    uint_io32_t		:2;
    uint_io32_t		u1F0F:1;
    uint_io32_t		u1RF0L:1;
    uint_io32_t		:6;
}stc_cpg_canfdn_rxf0s_field_t;

typedef union un_cpg_canfdn_rxf0s{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_rxf0s_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_rxf0s_t;

/* RXF0A */
#define CPG_CANFD0_RXF0A	(CPG_CANFD0.unRXF0A.u32Register)  /*@rg@*/
#define CPG_CANFD0_RXF0A_F0AI	(CPG_CANFD0.unRXF0A.stcField.u6F0AI)  /*@bf@*/

#define CPG_CANFD1_RXF0A	(CPG_CANFD1.unRXF0A.u32Register)  /*@rg@*/
#define CPG_CANFD1_RXF0A_F0AI	(CPG_CANFD1.unRXF0A.stcField.u6F0AI)  /*@bf@*/

#define CPG_CANFD2_RXF0A	(CPG_CANFD2.unRXF0A.u32Register)  /*@rg@*/
#define CPG_CANFD2_RXF0A_F0AI	(CPG_CANFD2.unRXF0A.stcField.u6F0AI)  /*@bf@*/

#define CPG_CANFD3_RXF0A	(CPG_CANFD3.unRXF0A.u32Register)  /*@rg@*/
#define CPG_CANFD3_RXF0A_F0AI	(CPG_CANFD3.unRXF0A.stcField.u6F0AI)  /*@bf@*/

typedef struct stc_cpg_canfdn_rxf0a_field{
    uint_io32_t		u6F0AI:6;
    uint_io32_t		:26;
}stc_cpg_canfdn_rxf0a_field_t;

typedef union un_cpg_canfdn_rxf0a{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_rxf0a_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_rxf0a_t;

/* RXBC */
#define CPG_CANFD0_RXBC	(CPG_CANFD0.unRXBC.u32Register)  /*@rg@*/
#define CPG_CANFD0_RXBC_RBSA	(CPG_CANFD0.unRXBC.stcField.u14RBSA)  /*@bf@*/

#define CPG_CANFD1_RXBC	(CPG_CANFD1.unRXBC.u32Register)  /*@rg@*/
#define CPG_CANFD1_RXBC_RBSA	(CPG_CANFD1.unRXBC.stcField.u14RBSA)  /*@bf@*/

#define CPG_CANFD2_RXBC	(CPG_CANFD2.unRXBC.u32Register)  /*@rg@*/
#define CPG_CANFD2_RXBC_RBSA	(CPG_CANFD2.unRXBC.stcField.u14RBSA)  /*@bf@*/

#define CPG_CANFD3_RXBC	(CPG_CANFD3.unRXBC.u32Register)  /*@rg@*/
#define CPG_CANFD3_RXBC_RBSA	(CPG_CANFD3.unRXBC.stcField.u14RBSA)  /*@bf@*/

typedef struct stc_cpg_canfdn_rxbc_field{
    uint_io32_t		:2;
    uint_io32_t		u14RBSA:14;
    uint_io32_t		:16;
}stc_cpg_canfdn_rxbc_field_t;

typedef union un_cpg_canfdn_rxbc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_rxbc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_rxbc_t;

/* RXF1C */
#define CPG_CANFD0_RXF1C	(CPG_CANFD0.unRXF1C.u32Register)  /*@rg@*/
#define CPG_CANFD0_RXF1C_F1SA	(CPG_CANFD0.unRXF1C.stcField.u14F1SA)  /*@bf@*/
#define CPG_CANFD0_RXF1C_F1S	(CPG_CANFD0.unRXF1C.stcField.u7F1S)  /*@bf@*/
#define CPG_CANFD0_RXF1C_F1WM	(CPG_CANFD0.unRXF1C.stcField.u7F1WM)  /*@bf@*/
#define CPG_CANFD0_RXF1C_F1OM	(*(volatile uint_io8_t*)0xB4C0059FUL)  /*@bfbba@*/

#define CPG_CANFD1_RXF1C	(CPG_CANFD1.unRXF1C.u32Register)  /*@rg@*/
#define CPG_CANFD1_RXF1C_F1SA	(CPG_CANFD1.unRXF1C.stcField.u14F1SA)  /*@bf@*/
#define CPG_CANFD1_RXF1C_F1S	(CPG_CANFD1.unRXF1C.stcField.u7F1S)  /*@bf@*/
#define CPG_CANFD1_RXF1C_F1WM	(CPG_CANFD1.unRXF1C.stcField.u7F1WM)  /*@bf@*/
#define CPG_CANFD1_RXF1C_F1OM	(*(volatile uint_io8_t*)0xB4C8059FUL)  /*@bfbba@*/

#define CPG_CANFD2_RXF1C	(CPG_CANFD2.unRXF1C.u32Register)  /*@rg@*/
#define CPG_CANFD2_RXF1C_F1SA	(CPG_CANFD2.unRXF1C.stcField.u14F1SA)  /*@bf@*/
#define CPG_CANFD2_RXF1C_F1S	(CPG_CANFD2.unRXF1C.stcField.u7F1S)  /*@bf@*/
#define CPG_CANFD2_RXF1C_F1WM	(CPG_CANFD2.unRXF1C.stcField.u7F1WM)  /*@bf@*/
#define CPG_CANFD2_RXF1C_F1OM	(*(volatile uint_io8_t*)0xB4D0059FUL)  /*@bfbba@*/

#define CPG_CANFD3_RXF1C	(CPG_CANFD3.unRXF1C.u32Register)  /*@rg@*/
#define CPG_CANFD3_RXF1C_F1SA	(CPG_CANFD3.unRXF1C.stcField.u14F1SA)  /*@bf@*/
#define CPG_CANFD3_RXF1C_F1S	(CPG_CANFD3.unRXF1C.stcField.u7F1S)  /*@bf@*/
#define CPG_CANFD3_RXF1C_F1WM	(CPG_CANFD3.unRXF1C.stcField.u7F1WM)  /*@bf@*/
#define CPG_CANFD3_RXF1C_F1OM	(*(volatile uint_io8_t*)0xB4D8059FUL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_rxf1c_field{
    uint_io32_t		:2;
    uint_io32_t		u14F1SA:14;
    uint_io32_t		u7F1S:7;
    uint_io32_t		:1;
    uint_io32_t		u7F1WM:7;
    uint_io32_t		u1F1OM:1;
}stc_cpg_canfdn_rxf1c_field_t;

typedef union un_cpg_canfdn_rxf1c{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_rxf1c_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_rxf1c_t;

/* RXF1S */
#define CPG_CANFD0_RXF1S	(CPG_CANFD0.unRXF1S.u32Register)  /*@rg@*/
#define CPG_CANFD0_RXF1S_F1FL	(CPG_CANFD0.unRXF1S.stcField.u7F1FL)  /*@bf@*/
#define CPG_CANFD0_RXF1S_F1GI	(CPG_CANFD0.unRXF1S.stcField.u6F1GI)  /*@bf@*/
#define CPG_CANFD0_RXF1S_F1PI	(CPG_CANFD0.unRXF1S.stcField.u6F1PI)  /*@bf@*/
#define CPG_CANFD0_RXF1S_F1F	(*(volatile uint_io8_t*)0xB4C005B8UL)  /*@bfbba@*/
#define CPG_CANFD0_RXF1S_RF1L	(*(volatile uint_io8_t*)0xB4C005B9UL)  /*@bfbba@*/
#define CPG_CANFD0_RXF1S_DMS	(CPG_CANFD0.unRXF1S.stcField.u2DMS)  /*@bf@*/

#define CPG_CANFD1_RXF1S	(CPG_CANFD1.unRXF1S.u32Register)  /*@rg@*/
#define CPG_CANFD1_RXF1S_F1FL	(CPG_CANFD1.unRXF1S.stcField.u7F1FL)  /*@bf@*/
#define CPG_CANFD1_RXF1S_F1GI	(CPG_CANFD1.unRXF1S.stcField.u6F1GI)  /*@bf@*/
#define CPG_CANFD1_RXF1S_F1PI	(CPG_CANFD1.unRXF1S.stcField.u6F1PI)  /*@bf@*/
#define CPG_CANFD1_RXF1S_F1F	(*(volatile uint_io8_t*)0xB4C805B8UL)  /*@bfbba@*/
#define CPG_CANFD1_RXF1S_RF1L	(*(volatile uint_io8_t*)0xB4C805B9UL)  /*@bfbba@*/
#define CPG_CANFD1_RXF1S_DMS	(CPG_CANFD1.unRXF1S.stcField.u2DMS)  /*@bf@*/

#define CPG_CANFD2_RXF1S	(CPG_CANFD2.unRXF1S.u32Register)  /*@rg@*/
#define CPG_CANFD2_RXF1S_F1FL	(CPG_CANFD2.unRXF1S.stcField.u7F1FL)  /*@bf@*/
#define CPG_CANFD2_RXF1S_F1GI	(CPG_CANFD2.unRXF1S.stcField.u6F1GI)  /*@bf@*/
#define CPG_CANFD2_RXF1S_F1PI	(CPG_CANFD2.unRXF1S.stcField.u6F1PI)  /*@bf@*/
#define CPG_CANFD2_RXF1S_F1F	(*(volatile uint_io8_t*)0xB4D005B8UL)  /*@bfbba@*/
#define CPG_CANFD2_RXF1S_RF1L	(*(volatile uint_io8_t*)0xB4D005B9UL)  /*@bfbba@*/
#define CPG_CANFD2_RXF1S_DMS	(CPG_CANFD2.unRXF1S.stcField.u2DMS)  /*@bf@*/

#define CPG_CANFD3_RXF1S	(CPG_CANFD3.unRXF1S.u32Register)  /*@rg@*/
#define CPG_CANFD3_RXF1S_F1FL	(CPG_CANFD3.unRXF1S.stcField.u7F1FL)  /*@bf@*/
#define CPG_CANFD3_RXF1S_F1GI	(CPG_CANFD3.unRXF1S.stcField.u6F1GI)  /*@bf@*/
#define CPG_CANFD3_RXF1S_F1PI	(CPG_CANFD3.unRXF1S.stcField.u6F1PI)  /*@bf@*/
#define CPG_CANFD3_RXF1S_F1F	(*(volatile uint_io8_t*)0xB4D805B8UL)  /*@bfbba@*/
#define CPG_CANFD3_RXF1S_RF1L	(*(volatile uint_io8_t*)0xB4D805B9UL)  /*@bfbba@*/
#define CPG_CANFD3_RXF1S_DMS	(CPG_CANFD3.unRXF1S.stcField.u2DMS)  /*@bf@*/

typedef struct stc_cpg_canfdn_rxf1s_field{
    uint_io32_t		u7F1FL:7;
    uint_io32_t		:1;
    uint_io32_t		u6F1GI:6;
    uint_io32_t		:2;
    uint_io32_t		u6F1PI:6;
    uint_io32_t		:2;
    uint_io32_t		u1F1F:1;
    uint_io32_t		u1RF1L:1;
    uint_io32_t		:4;
    uint_io32_t		u2DMS:2;
}stc_cpg_canfdn_rxf1s_field_t;

typedef union un_cpg_canfdn_rxf1s{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_rxf1s_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_rxf1s_t;

/* RXF1A */
#define CPG_CANFD0_RXF1A	(CPG_CANFD0.unRXF1A.u32Register)  /*@rg@*/
#define CPG_CANFD0_RXF1A_F1AI	(CPG_CANFD0.unRXF1A.stcField.u6F1AI)  /*@bf@*/

#define CPG_CANFD1_RXF1A	(CPG_CANFD1.unRXF1A.u32Register)  /*@rg@*/
#define CPG_CANFD1_RXF1A_F1AI	(CPG_CANFD1.unRXF1A.stcField.u6F1AI)  /*@bf@*/

#define CPG_CANFD2_RXF1A	(CPG_CANFD2.unRXF1A.u32Register)  /*@rg@*/
#define CPG_CANFD2_RXF1A_F1AI	(CPG_CANFD2.unRXF1A.stcField.u6F1AI)  /*@bf@*/

#define CPG_CANFD3_RXF1A	(CPG_CANFD3.unRXF1A.u32Register)  /*@rg@*/
#define CPG_CANFD3_RXF1A_F1AI	(CPG_CANFD3.unRXF1A.stcField.u6F1AI)  /*@bf@*/

typedef struct stc_cpg_canfdn_rxf1a_field{
    uint_io32_t		u6F1AI:6;
    uint_io32_t		:26;
}stc_cpg_canfdn_rxf1a_field_t;

typedef union un_cpg_canfdn_rxf1a{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_rxf1a_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_rxf1a_t;

/* RXESC */
#define CPG_CANFD0_RXESC	(CPG_CANFD0.unRXESC.u32Register)  /*@rg@*/
#define CPG_CANFD0_RXESC_F0DS	(CPG_CANFD0.unRXESC.stcField.u3F0DS)  /*@bf@*/
#define CPG_CANFD0_RXESC_F1DS	(CPG_CANFD0.unRXESC.stcField.u3F1DS)  /*@bf@*/
#define CPG_CANFD0_RXESC_RBDS	(CPG_CANFD0.unRXESC.stcField.u3RBDS)  /*@bf@*/

#define CPG_CANFD1_RXESC	(CPG_CANFD1.unRXESC.u32Register)  /*@rg@*/
#define CPG_CANFD1_RXESC_F0DS	(CPG_CANFD1.unRXESC.stcField.u3F0DS)  /*@bf@*/
#define CPG_CANFD1_RXESC_F1DS	(CPG_CANFD1.unRXESC.stcField.u3F1DS)  /*@bf@*/
#define CPG_CANFD1_RXESC_RBDS	(CPG_CANFD1.unRXESC.stcField.u3RBDS)  /*@bf@*/

#define CPG_CANFD2_RXESC	(CPG_CANFD2.unRXESC.u32Register)  /*@rg@*/
#define CPG_CANFD2_RXESC_F0DS	(CPG_CANFD2.unRXESC.stcField.u3F0DS)  /*@bf@*/
#define CPG_CANFD2_RXESC_F1DS	(CPG_CANFD2.unRXESC.stcField.u3F1DS)  /*@bf@*/
#define CPG_CANFD2_RXESC_RBDS	(CPG_CANFD2.unRXESC.stcField.u3RBDS)  /*@bf@*/

#define CPG_CANFD3_RXESC	(CPG_CANFD3.unRXESC.u32Register)  /*@rg@*/
#define CPG_CANFD3_RXESC_F0DS	(CPG_CANFD3.unRXESC.stcField.u3F0DS)  /*@bf@*/
#define CPG_CANFD3_RXESC_F1DS	(CPG_CANFD3.unRXESC.stcField.u3F1DS)  /*@bf@*/
#define CPG_CANFD3_RXESC_RBDS	(CPG_CANFD3.unRXESC.stcField.u3RBDS)  /*@bf@*/

typedef struct stc_cpg_canfdn_rxesc_field{
    uint_io32_t		u3F0DS:3;
    uint_io32_t		:1;
    uint_io32_t		u3F1DS:3;
    uint_io32_t		:1;
    uint_io32_t		u3RBDS:3;
    uint_io32_t		:21;
}stc_cpg_canfdn_rxesc_field_t;

typedef union un_cpg_canfdn_rxesc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_rxesc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_rxesc_t;

/* TXBC */
#define CPG_CANFD0_TXBC	(CPG_CANFD0.unTXBC.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXBC_TBSA	(CPG_CANFD0.unTXBC.stcField.u14TBSA)  /*@bf@*/
#define CPG_CANFD0_TXBC_NDTB	(CPG_CANFD0.unTXBC.stcField.u6NDTB)  /*@bf@*/
#define CPG_CANFD0_TXBC_TFQS	(CPG_CANFD0.unTXBC.stcField.u6TFQS)  /*@bf@*/
#define CPG_CANFD0_TXBC_TFQM	(*(volatile uint_io8_t*)0xB4C0061EUL)  /*@bfbba@*/

#define CPG_CANFD1_TXBC	(CPG_CANFD1.unTXBC.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXBC_TBSA	(CPG_CANFD1.unTXBC.stcField.u14TBSA)  /*@bf@*/
#define CPG_CANFD1_TXBC_NDTB	(CPG_CANFD1.unTXBC.stcField.u6NDTB)  /*@bf@*/
#define CPG_CANFD1_TXBC_TFQS	(CPG_CANFD1.unTXBC.stcField.u6TFQS)  /*@bf@*/
#define CPG_CANFD1_TXBC_TFQM	(*(volatile uint_io8_t*)0xB4C8061EUL)  /*@bfbba@*/

#define CPG_CANFD2_TXBC	(CPG_CANFD2.unTXBC.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXBC_TBSA	(CPG_CANFD2.unTXBC.stcField.u14TBSA)  /*@bf@*/
#define CPG_CANFD2_TXBC_NDTB	(CPG_CANFD2.unTXBC.stcField.u6NDTB)  /*@bf@*/
#define CPG_CANFD2_TXBC_TFQS	(CPG_CANFD2.unTXBC.stcField.u6TFQS)  /*@bf@*/
#define CPG_CANFD2_TXBC_TFQM	(*(volatile uint_io8_t*)0xB4D0061EUL)  /*@bfbba@*/

#define CPG_CANFD3_TXBC	(CPG_CANFD3.unTXBC.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXBC_TBSA	(CPG_CANFD3.unTXBC.stcField.u14TBSA)  /*@bf@*/
#define CPG_CANFD3_TXBC_NDTB	(CPG_CANFD3.unTXBC.stcField.u6NDTB)  /*@bf@*/
#define CPG_CANFD3_TXBC_TFQS	(CPG_CANFD3.unTXBC.stcField.u6TFQS)  /*@bf@*/
#define CPG_CANFD3_TXBC_TFQM	(*(volatile uint_io8_t*)0xB4D8061EUL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_txbc_field{
    uint_io32_t		:2;
    uint_io32_t		u14TBSA:14;
    uint_io32_t		u6NDTB:6;
    uint_io32_t		:2;
    uint_io32_t		u6TFQS:6;
    uint_io32_t		u1TFQM:1;
    uint_io32_t		:1;
}stc_cpg_canfdn_txbc_field_t;

typedef union un_cpg_canfdn_txbc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txbc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txbc_t;

/* TXFQS */
#define CPG_CANFD0_TXFQS	(CPG_CANFD0.unTXFQS.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXFQS_TFFL	(CPG_CANFD0.unTXFQS.stcField.u6TFFL)  /*@bf@*/
#define CPG_CANFD0_TXFQS_TFGI	(CPG_CANFD0.unTXFQS.stcField.u5TFGI)  /*@bf@*/
#define CPG_CANFD0_TXFQS_TFQPI	(CPG_CANFD0.unTXFQS.stcField.u5TFQPI)  /*@bf@*/
#define CPG_CANFD0_TXFQS_TFQF	(*(volatile uint_io8_t*)0xB4C00635UL)  /*@bfbba@*/

#define CPG_CANFD1_TXFQS	(CPG_CANFD1.unTXFQS.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXFQS_TFFL	(CPG_CANFD1.unTXFQS.stcField.u6TFFL)  /*@bf@*/
#define CPG_CANFD1_TXFQS_TFGI	(CPG_CANFD1.unTXFQS.stcField.u5TFGI)  /*@bf@*/
#define CPG_CANFD1_TXFQS_TFQPI	(CPG_CANFD1.unTXFQS.stcField.u5TFQPI)  /*@bf@*/
#define CPG_CANFD1_TXFQS_TFQF	(*(volatile uint_io8_t*)0xB4C80635UL)  /*@bfbba@*/

#define CPG_CANFD2_TXFQS	(CPG_CANFD2.unTXFQS.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXFQS_TFFL	(CPG_CANFD2.unTXFQS.stcField.u6TFFL)  /*@bf@*/
#define CPG_CANFD2_TXFQS_TFGI	(CPG_CANFD2.unTXFQS.stcField.u5TFGI)  /*@bf@*/
#define CPG_CANFD2_TXFQS_TFQPI	(CPG_CANFD2.unTXFQS.stcField.u5TFQPI)  /*@bf@*/
#define CPG_CANFD2_TXFQS_TFQF	(*(volatile uint_io8_t*)0xB4D00635UL)  /*@bfbba@*/

#define CPG_CANFD3_TXFQS	(CPG_CANFD3.unTXFQS.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXFQS_TFFL	(CPG_CANFD3.unTXFQS.stcField.u6TFFL)  /*@bf@*/
#define CPG_CANFD3_TXFQS_TFGI	(CPG_CANFD3.unTXFQS.stcField.u5TFGI)  /*@bf@*/
#define CPG_CANFD3_TXFQS_TFQPI	(CPG_CANFD3.unTXFQS.stcField.u5TFQPI)  /*@bf@*/
#define CPG_CANFD3_TXFQS_TFQF	(*(volatile uint_io8_t*)0xB4D80635UL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_txfqs_field{
    uint_io32_t		u6TFFL:6;
    uint_io32_t		:2;
    uint_io32_t		u5TFGI:5;
    uint_io32_t		:3;
    uint_io32_t		u5TFQPI:5;
    uint_io32_t		u1TFQF:1;
    uint_io32_t		:10;
}stc_cpg_canfdn_txfqs_field_t;

typedef union un_cpg_canfdn_txfqs{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txfqs_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txfqs_t;

/* TXESC */
#define CPG_CANFD0_TXESC	(CPG_CANFD0.unTXESC.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXESC_TBDS	(CPG_CANFD0.unTXESC.stcField.u3TBDS)  /*@bf@*/

#define CPG_CANFD1_TXESC	(CPG_CANFD1.unTXESC.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXESC_TBDS	(CPG_CANFD1.unTXESC.stcField.u3TBDS)  /*@bf@*/

#define CPG_CANFD2_TXESC	(CPG_CANFD2.unTXESC.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXESC_TBDS	(CPG_CANFD2.unTXESC.stcField.u3TBDS)  /*@bf@*/

#define CPG_CANFD3_TXESC	(CPG_CANFD3.unTXESC.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXESC_TBDS	(CPG_CANFD3.unTXESC.stcField.u3TBDS)  /*@bf@*/

typedef struct stc_cpg_canfdn_txesc_field{
    uint_io32_t		u3TBDS:3;
    uint_io32_t		:29;
}stc_cpg_canfdn_txesc_field_t;

typedef union un_cpg_canfdn_txesc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txesc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txesc_t;

/* TXBRP */
#define CPG_CANFD0_TXBRP	(CPG_CANFD0.unTXBRP.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXBRP_TRP0	(*(volatile uint_io8_t*)0xB4C00660UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP1	(*(volatile uint_io8_t*)0xB4C00661UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP2	(*(volatile uint_io8_t*)0xB4C00662UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP3	(*(volatile uint_io8_t*)0xB4C00663UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP4	(*(volatile uint_io8_t*)0xB4C00664UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP5	(*(volatile uint_io8_t*)0xB4C00665UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP6	(*(volatile uint_io8_t*)0xB4C00666UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP7	(*(volatile uint_io8_t*)0xB4C00667UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP8	(*(volatile uint_io8_t*)0xB4C00668UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP9	(*(volatile uint_io8_t*)0xB4C00669UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP10	(*(volatile uint_io8_t*)0xB4C0066AUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP11	(*(volatile uint_io8_t*)0xB4C0066BUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP12	(*(volatile uint_io8_t*)0xB4C0066CUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP13	(*(volatile uint_io8_t*)0xB4C0066DUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP14	(*(volatile uint_io8_t*)0xB4C0066EUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP15	(*(volatile uint_io8_t*)0xB4C0066FUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP16	(*(volatile uint_io8_t*)0xB4C00670UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP17	(*(volatile uint_io8_t*)0xB4C00671UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP18	(*(volatile uint_io8_t*)0xB4C00672UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP19	(*(volatile uint_io8_t*)0xB4C00673UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP20	(*(volatile uint_io8_t*)0xB4C00674UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP21	(*(volatile uint_io8_t*)0xB4C00675UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP22	(*(volatile uint_io8_t*)0xB4C00676UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP23	(*(volatile uint_io8_t*)0xB4C00677UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP24	(*(volatile uint_io8_t*)0xB4C00678UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP25	(*(volatile uint_io8_t*)0xB4C00679UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP26	(*(volatile uint_io8_t*)0xB4C0067AUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP27	(*(volatile uint_io8_t*)0xB4C0067BUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP28	(*(volatile uint_io8_t*)0xB4C0067CUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP29	(*(volatile uint_io8_t*)0xB4C0067DUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP30	(*(volatile uint_io8_t*)0xB4C0067EUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBRP_TRP31	(*(volatile uint_io8_t*)0xB4C0067FUL)  /*@bfbba@*/

#define CPG_CANFD1_TXBRP	(CPG_CANFD1.unTXBRP.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXBRP_TRP0	(*(volatile uint_io8_t*)0xB4C80660UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP1	(*(volatile uint_io8_t*)0xB4C80661UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP2	(*(volatile uint_io8_t*)0xB4C80662UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP3	(*(volatile uint_io8_t*)0xB4C80663UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP4	(*(volatile uint_io8_t*)0xB4C80664UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP5	(*(volatile uint_io8_t*)0xB4C80665UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP6	(*(volatile uint_io8_t*)0xB4C80666UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP7	(*(volatile uint_io8_t*)0xB4C80667UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP8	(*(volatile uint_io8_t*)0xB4C80668UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP9	(*(volatile uint_io8_t*)0xB4C80669UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP10	(*(volatile uint_io8_t*)0xB4C8066AUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP11	(*(volatile uint_io8_t*)0xB4C8066BUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP12	(*(volatile uint_io8_t*)0xB4C8066CUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP13	(*(volatile uint_io8_t*)0xB4C8066DUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP14	(*(volatile uint_io8_t*)0xB4C8066EUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP15	(*(volatile uint_io8_t*)0xB4C8066FUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP16	(*(volatile uint_io8_t*)0xB4C80670UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP17	(*(volatile uint_io8_t*)0xB4C80671UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP18	(*(volatile uint_io8_t*)0xB4C80672UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP19	(*(volatile uint_io8_t*)0xB4C80673UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP20	(*(volatile uint_io8_t*)0xB4C80674UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP21	(*(volatile uint_io8_t*)0xB4C80675UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP22	(*(volatile uint_io8_t*)0xB4C80676UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP23	(*(volatile uint_io8_t*)0xB4C80677UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP24	(*(volatile uint_io8_t*)0xB4C80678UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP25	(*(volatile uint_io8_t*)0xB4C80679UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP26	(*(volatile uint_io8_t*)0xB4C8067AUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP27	(*(volatile uint_io8_t*)0xB4C8067BUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP28	(*(volatile uint_io8_t*)0xB4C8067CUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP29	(*(volatile uint_io8_t*)0xB4C8067DUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP30	(*(volatile uint_io8_t*)0xB4C8067EUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBRP_TRP31	(*(volatile uint_io8_t*)0xB4C8067FUL)  /*@bfbba@*/

#define CPG_CANFD2_TXBRP	(CPG_CANFD2.unTXBRP.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXBRP_TRP0	(*(volatile uint_io8_t*)0xB4D00660UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP1	(*(volatile uint_io8_t*)0xB4D00661UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP2	(*(volatile uint_io8_t*)0xB4D00662UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP3	(*(volatile uint_io8_t*)0xB4D00663UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP4	(*(volatile uint_io8_t*)0xB4D00664UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP5	(*(volatile uint_io8_t*)0xB4D00665UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP6	(*(volatile uint_io8_t*)0xB4D00666UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP7	(*(volatile uint_io8_t*)0xB4D00667UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP8	(*(volatile uint_io8_t*)0xB4D00668UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP9	(*(volatile uint_io8_t*)0xB4D00669UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP10	(*(volatile uint_io8_t*)0xB4D0066AUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP11	(*(volatile uint_io8_t*)0xB4D0066BUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP12	(*(volatile uint_io8_t*)0xB4D0066CUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP13	(*(volatile uint_io8_t*)0xB4D0066DUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP14	(*(volatile uint_io8_t*)0xB4D0066EUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP15	(*(volatile uint_io8_t*)0xB4D0066FUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP16	(*(volatile uint_io8_t*)0xB4D00670UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP17	(*(volatile uint_io8_t*)0xB4D00671UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP18	(*(volatile uint_io8_t*)0xB4D00672UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP19	(*(volatile uint_io8_t*)0xB4D00673UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP20	(*(volatile uint_io8_t*)0xB4D00674UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP21	(*(volatile uint_io8_t*)0xB4D00675UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP22	(*(volatile uint_io8_t*)0xB4D00676UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP23	(*(volatile uint_io8_t*)0xB4D00677UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP24	(*(volatile uint_io8_t*)0xB4D00678UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP25	(*(volatile uint_io8_t*)0xB4D00679UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP26	(*(volatile uint_io8_t*)0xB4D0067AUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP27	(*(volatile uint_io8_t*)0xB4D0067BUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP28	(*(volatile uint_io8_t*)0xB4D0067CUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP29	(*(volatile uint_io8_t*)0xB4D0067DUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP30	(*(volatile uint_io8_t*)0xB4D0067EUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBRP_TRP31	(*(volatile uint_io8_t*)0xB4D0067FUL)  /*@bfbba@*/

#define CPG_CANFD3_TXBRP	(CPG_CANFD3.unTXBRP.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXBRP_TRP0	(*(volatile uint_io8_t*)0xB4D80660UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP1	(*(volatile uint_io8_t*)0xB4D80661UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP2	(*(volatile uint_io8_t*)0xB4D80662UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP3	(*(volatile uint_io8_t*)0xB4D80663UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP4	(*(volatile uint_io8_t*)0xB4D80664UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP5	(*(volatile uint_io8_t*)0xB4D80665UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP6	(*(volatile uint_io8_t*)0xB4D80666UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP7	(*(volatile uint_io8_t*)0xB4D80667UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP8	(*(volatile uint_io8_t*)0xB4D80668UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP9	(*(volatile uint_io8_t*)0xB4D80669UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP10	(*(volatile uint_io8_t*)0xB4D8066AUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP11	(*(volatile uint_io8_t*)0xB4D8066BUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP12	(*(volatile uint_io8_t*)0xB4D8066CUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP13	(*(volatile uint_io8_t*)0xB4D8066DUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP14	(*(volatile uint_io8_t*)0xB4D8066EUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP15	(*(volatile uint_io8_t*)0xB4D8066FUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP16	(*(volatile uint_io8_t*)0xB4D80670UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP17	(*(volatile uint_io8_t*)0xB4D80671UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP18	(*(volatile uint_io8_t*)0xB4D80672UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP19	(*(volatile uint_io8_t*)0xB4D80673UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP20	(*(volatile uint_io8_t*)0xB4D80674UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP21	(*(volatile uint_io8_t*)0xB4D80675UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP22	(*(volatile uint_io8_t*)0xB4D80676UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP23	(*(volatile uint_io8_t*)0xB4D80677UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP24	(*(volatile uint_io8_t*)0xB4D80678UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP25	(*(volatile uint_io8_t*)0xB4D80679UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP26	(*(volatile uint_io8_t*)0xB4D8067AUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP27	(*(volatile uint_io8_t*)0xB4D8067BUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP28	(*(volatile uint_io8_t*)0xB4D8067CUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP29	(*(volatile uint_io8_t*)0xB4D8067DUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP30	(*(volatile uint_io8_t*)0xB4D8067EUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBRP_TRP31	(*(volatile uint_io8_t*)0xB4D8067FUL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_txbrp_field{
    uint_io32_t		u1TRP0:1;
    uint_io32_t		u1TRP1:1;
    uint_io32_t		u1TRP2:1;
    uint_io32_t		u1TRP3:1;
    uint_io32_t		u1TRP4:1;
    uint_io32_t		u1TRP5:1;
    uint_io32_t		u1TRP6:1;
    uint_io32_t		u1TRP7:1;
    uint_io32_t		u1TRP8:1;
    uint_io32_t		u1TRP9:1;
    uint_io32_t		u1TRP10:1;
    uint_io32_t		u1TRP11:1;
    uint_io32_t		u1TRP12:1;
    uint_io32_t		u1TRP13:1;
    uint_io32_t		u1TRP14:1;
    uint_io32_t		u1TRP15:1;
    uint_io32_t		u1TRP16:1;
    uint_io32_t		u1TRP17:1;
    uint_io32_t		u1TRP18:1;
    uint_io32_t		u1TRP19:1;
    uint_io32_t		u1TRP20:1;
    uint_io32_t		u1TRP21:1;
    uint_io32_t		u1TRP22:1;
    uint_io32_t		u1TRP23:1;
    uint_io32_t		u1TRP24:1;
    uint_io32_t		u1TRP25:1;
    uint_io32_t		u1TRP26:1;
    uint_io32_t		u1TRP27:1;
    uint_io32_t		u1TRP28:1;
    uint_io32_t		u1TRP29:1;
    uint_io32_t		u1TRP30:1;
    uint_io32_t		u1TRP31:1;
}stc_cpg_canfdn_txbrp_field_t;

typedef union un_cpg_canfdn_txbrp{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txbrp_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txbrp_t;

/* TXBAR */
#define CPG_CANFD0_TXBAR	(CPG_CANFD0.unTXBAR.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXBAR_AR0	(*(volatile uint_io8_t*)0xB4C00680UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR1	(*(volatile uint_io8_t*)0xB4C00681UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR2	(*(volatile uint_io8_t*)0xB4C00682UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR3	(*(volatile uint_io8_t*)0xB4C00683UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR4	(*(volatile uint_io8_t*)0xB4C00684UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR5	(*(volatile uint_io8_t*)0xB4C00685UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR6	(*(volatile uint_io8_t*)0xB4C00686UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR7	(*(volatile uint_io8_t*)0xB4C00687UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR8	(*(volatile uint_io8_t*)0xB4C00688UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR9	(*(volatile uint_io8_t*)0xB4C00689UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR10	(*(volatile uint_io8_t*)0xB4C0068AUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR11	(*(volatile uint_io8_t*)0xB4C0068BUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR12	(*(volatile uint_io8_t*)0xB4C0068CUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR13	(*(volatile uint_io8_t*)0xB4C0068DUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR14	(*(volatile uint_io8_t*)0xB4C0068EUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR15	(*(volatile uint_io8_t*)0xB4C0068FUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR16	(*(volatile uint_io8_t*)0xB4C00690UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR17	(*(volatile uint_io8_t*)0xB4C00691UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR18	(*(volatile uint_io8_t*)0xB4C00692UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR19	(*(volatile uint_io8_t*)0xB4C00693UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR20	(*(volatile uint_io8_t*)0xB4C00694UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR21	(*(volatile uint_io8_t*)0xB4C00695UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR22	(*(volatile uint_io8_t*)0xB4C00696UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR23	(*(volatile uint_io8_t*)0xB4C00697UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR24	(*(volatile uint_io8_t*)0xB4C00698UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR25	(*(volatile uint_io8_t*)0xB4C00699UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR26	(*(volatile uint_io8_t*)0xB4C0069AUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR27	(*(volatile uint_io8_t*)0xB4C0069BUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR28	(*(volatile uint_io8_t*)0xB4C0069CUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR29	(*(volatile uint_io8_t*)0xB4C0069DUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR30	(*(volatile uint_io8_t*)0xB4C0069EUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBAR_AR31	(*(volatile uint_io8_t*)0xB4C0069FUL)  /*@bfbba@*/

#define CPG_CANFD1_TXBAR	(CPG_CANFD1.unTXBAR.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXBAR_AR0	(*(volatile uint_io8_t*)0xB4C80680UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR1	(*(volatile uint_io8_t*)0xB4C80681UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR2	(*(volatile uint_io8_t*)0xB4C80682UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR3	(*(volatile uint_io8_t*)0xB4C80683UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR4	(*(volatile uint_io8_t*)0xB4C80684UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR5	(*(volatile uint_io8_t*)0xB4C80685UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR6	(*(volatile uint_io8_t*)0xB4C80686UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR7	(*(volatile uint_io8_t*)0xB4C80687UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR8	(*(volatile uint_io8_t*)0xB4C80688UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR9	(*(volatile uint_io8_t*)0xB4C80689UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR10	(*(volatile uint_io8_t*)0xB4C8068AUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR11	(*(volatile uint_io8_t*)0xB4C8068BUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR12	(*(volatile uint_io8_t*)0xB4C8068CUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR13	(*(volatile uint_io8_t*)0xB4C8068DUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR14	(*(volatile uint_io8_t*)0xB4C8068EUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR15	(*(volatile uint_io8_t*)0xB4C8068FUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR16	(*(volatile uint_io8_t*)0xB4C80690UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR17	(*(volatile uint_io8_t*)0xB4C80691UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR18	(*(volatile uint_io8_t*)0xB4C80692UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR19	(*(volatile uint_io8_t*)0xB4C80693UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR20	(*(volatile uint_io8_t*)0xB4C80694UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR21	(*(volatile uint_io8_t*)0xB4C80695UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR22	(*(volatile uint_io8_t*)0xB4C80696UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR23	(*(volatile uint_io8_t*)0xB4C80697UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR24	(*(volatile uint_io8_t*)0xB4C80698UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR25	(*(volatile uint_io8_t*)0xB4C80699UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR26	(*(volatile uint_io8_t*)0xB4C8069AUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR27	(*(volatile uint_io8_t*)0xB4C8069BUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR28	(*(volatile uint_io8_t*)0xB4C8069CUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR29	(*(volatile uint_io8_t*)0xB4C8069DUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR30	(*(volatile uint_io8_t*)0xB4C8069EUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBAR_AR31	(*(volatile uint_io8_t*)0xB4C8069FUL)  /*@bfbba@*/

#define CPG_CANFD2_TXBAR	(CPG_CANFD2.unTXBAR.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXBAR_AR0	(*(volatile uint_io8_t*)0xB4D00680UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR1	(*(volatile uint_io8_t*)0xB4D00681UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR2	(*(volatile uint_io8_t*)0xB4D00682UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR3	(*(volatile uint_io8_t*)0xB4D00683UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR4	(*(volatile uint_io8_t*)0xB4D00684UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR5	(*(volatile uint_io8_t*)0xB4D00685UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR6	(*(volatile uint_io8_t*)0xB4D00686UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR7	(*(volatile uint_io8_t*)0xB4D00687UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR8	(*(volatile uint_io8_t*)0xB4D00688UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR9	(*(volatile uint_io8_t*)0xB4D00689UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR10	(*(volatile uint_io8_t*)0xB4D0068AUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR11	(*(volatile uint_io8_t*)0xB4D0068BUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR12	(*(volatile uint_io8_t*)0xB4D0068CUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR13	(*(volatile uint_io8_t*)0xB4D0068DUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR14	(*(volatile uint_io8_t*)0xB4D0068EUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR15	(*(volatile uint_io8_t*)0xB4D0068FUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR16	(*(volatile uint_io8_t*)0xB4D00690UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR17	(*(volatile uint_io8_t*)0xB4D00691UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR18	(*(volatile uint_io8_t*)0xB4D00692UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR19	(*(volatile uint_io8_t*)0xB4D00693UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR20	(*(volatile uint_io8_t*)0xB4D00694UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR21	(*(volatile uint_io8_t*)0xB4D00695UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR22	(*(volatile uint_io8_t*)0xB4D00696UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR23	(*(volatile uint_io8_t*)0xB4D00697UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR24	(*(volatile uint_io8_t*)0xB4D00698UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR25	(*(volatile uint_io8_t*)0xB4D00699UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR26	(*(volatile uint_io8_t*)0xB4D0069AUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR27	(*(volatile uint_io8_t*)0xB4D0069BUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR28	(*(volatile uint_io8_t*)0xB4D0069CUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR29	(*(volatile uint_io8_t*)0xB4D0069DUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR30	(*(volatile uint_io8_t*)0xB4D0069EUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBAR_AR31	(*(volatile uint_io8_t*)0xB4D0069FUL)  /*@bfbba@*/

#define CPG_CANFD3_TXBAR	(CPG_CANFD3.unTXBAR.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXBAR_AR0	(*(volatile uint_io8_t*)0xB4D80680UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR1	(*(volatile uint_io8_t*)0xB4D80681UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR2	(*(volatile uint_io8_t*)0xB4D80682UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR3	(*(volatile uint_io8_t*)0xB4D80683UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR4	(*(volatile uint_io8_t*)0xB4D80684UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR5	(*(volatile uint_io8_t*)0xB4D80685UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR6	(*(volatile uint_io8_t*)0xB4D80686UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR7	(*(volatile uint_io8_t*)0xB4D80687UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR8	(*(volatile uint_io8_t*)0xB4D80688UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR9	(*(volatile uint_io8_t*)0xB4D80689UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR10	(*(volatile uint_io8_t*)0xB4D8068AUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR11	(*(volatile uint_io8_t*)0xB4D8068BUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR12	(*(volatile uint_io8_t*)0xB4D8068CUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR13	(*(volatile uint_io8_t*)0xB4D8068DUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR14	(*(volatile uint_io8_t*)0xB4D8068EUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR15	(*(volatile uint_io8_t*)0xB4D8068FUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR16	(*(volatile uint_io8_t*)0xB4D80690UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR17	(*(volatile uint_io8_t*)0xB4D80691UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR18	(*(volatile uint_io8_t*)0xB4D80692UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR19	(*(volatile uint_io8_t*)0xB4D80693UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR20	(*(volatile uint_io8_t*)0xB4D80694UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR21	(*(volatile uint_io8_t*)0xB4D80695UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR22	(*(volatile uint_io8_t*)0xB4D80696UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR23	(*(volatile uint_io8_t*)0xB4D80697UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR24	(*(volatile uint_io8_t*)0xB4D80698UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR25	(*(volatile uint_io8_t*)0xB4D80699UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR26	(*(volatile uint_io8_t*)0xB4D8069AUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR27	(*(volatile uint_io8_t*)0xB4D8069BUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR28	(*(volatile uint_io8_t*)0xB4D8069CUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR29	(*(volatile uint_io8_t*)0xB4D8069DUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR30	(*(volatile uint_io8_t*)0xB4D8069EUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBAR_AR31	(*(volatile uint_io8_t*)0xB4D8069FUL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_txbar_field{
    uint_io32_t		u1AR0:1;
    uint_io32_t		u1AR1:1;
    uint_io32_t		u1AR2:1;
    uint_io32_t		u1AR3:1;
    uint_io32_t		u1AR4:1;
    uint_io32_t		u1AR5:1;
    uint_io32_t		u1AR6:1;
    uint_io32_t		u1AR7:1;
    uint_io32_t		u1AR8:1;
    uint_io32_t		u1AR9:1;
    uint_io32_t		u1AR10:1;
    uint_io32_t		u1AR11:1;
    uint_io32_t		u1AR12:1;
    uint_io32_t		u1AR13:1;
    uint_io32_t		u1AR14:1;
    uint_io32_t		u1AR15:1;
    uint_io32_t		u1AR16:1;
    uint_io32_t		u1AR17:1;
    uint_io32_t		u1AR18:1;
    uint_io32_t		u1AR19:1;
    uint_io32_t		u1AR20:1;
    uint_io32_t		u1AR21:1;
    uint_io32_t		u1AR22:1;
    uint_io32_t		u1AR23:1;
    uint_io32_t		u1AR24:1;
    uint_io32_t		u1AR25:1;
    uint_io32_t		u1AR26:1;
    uint_io32_t		u1AR27:1;
    uint_io32_t		u1AR28:1;
    uint_io32_t		u1AR29:1;
    uint_io32_t		u1AR30:1;
    uint_io32_t		u1AR31:1;
}stc_cpg_canfdn_txbar_field_t;

typedef union un_cpg_canfdn_txbar{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txbar_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txbar_t;

/* TXBCR */
#define CPG_CANFD0_TXBCR	(CPG_CANFD0.unTXBCR.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXBCR_CR0	(*(volatile uint_io8_t*)0xB4C006A0UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR1	(*(volatile uint_io8_t*)0xB4C006A1UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR2	(*(volatile uint_io8_t*)0xB4C006A2UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR3	(*(volatile uint_io8_t*)0xB4C006A3UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR4	(*(volatile uint_io8_t*)0xB4C006A4UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR5	(*(volatile uint_io8_t*)0xB4C006A5UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR6	(*(volatile uint_io8_t*)0xB4C006A6UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR7	(*(volatile uint_io8_t*)0xB4C006A7UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR8	(*(volatile uint_io8_t*)0xB4C006A8UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR9	(*(volatile uint_io8_t*)0xB4C006A9UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR10	(*(volatile uint_io8_t*)0xB4C006AAUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR11	(*(volatile uint_io8_t*)0xB4C006ABUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR12	(*(volatile uint_io8_t*)0xB4C006ACUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR13	(*(volatile uint_io8_t*)0xB4C006ADUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR14	(*(volatile uint_io8_t*)0xB4C006AEUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR15	(*(volatile uint_io8_t*)0xB4C006AFUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR16	(*(volatile uint_io8_t*)0xB4C006B0UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR17	(*(volatile uint_io8_t*)0xB4C006B1UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR18	(*(volatile uint_io8_t*)0xB4C006B2UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR19	(*(volatile uint_io8_t*)0xB4C006B3UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR20	(*(volatile uint_io8_t*)0xB4C006B4UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR21	(*(volatile uint_io8_t*)0xB4C006B5UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR22	(*(volatile uint_io8_t*)0xB4C006B6UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR23	(*(volatile uint_io8_t*)0xB4C006B7UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR24	(*(volatile uint_io8_t*)0xB4C006B8UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR25	(*(volatile uint_io8_t*)0xB4C006B9UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR26	(*(volatile uint_io8_t*)0xB4C006BAUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR27	(*(volatile uint_io8_t*)0xB4C006BBUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR28	(*(volatile uint_io8_t*)0xB4C006BCUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR29	(*(volatile uint_io8_t*)0xB4C006BDUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR30	(*(volatile uint_io8_t*)0xB4C006BEUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCR_CR31	(*(volatile uint_io8_t*)0xB4C006BFUL)  /*@bfbba@*/

#define CPG_CANFD1_TXBCR	(CPG_CANFD1.unTXBCR.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXBCR_CR0	(*(volatile uint_io8_t*)0xB4C806A0UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR1	(*(volatile uint_io8_t*)0xB4C806A1UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR2	(*(volatile uint_io8_t*)0xB4C806A2UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR3	(*(volatile uint_io8_t*)0xB4C806A3UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR4	(*(volatile uint_io8_t*)0xB4C806A4UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR5	(*(volatile uint_io8_t*)0xB4C806A5UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR6	(*(volatile uint_io8_t*)0xB4C806A6UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR7	(*(volatile uint_io8_t*)0xB4C806A7UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR8	(*(volatile uint_io8_t*)0xB4C806A8UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR9	(*(volatile uint_io8_t*)0xB4C806A9UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR10	(*(volatile uint_io8_t*)0xB4C806AAUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR11	(*(volatile uint_io8_t*)0xB4C806ABUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR12	(*(volatile uint_io8_t*)0xB4C806ACUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR13	(*(volatile uint_io8_t*)0xB4C806ADUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR14	(*(volatile uint_io8_t*)0xB4C806AEUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR15	(*(volatile uint_io8_t*)0xB4C806AFUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR16	(*(volatile uint_io8_t*)0xB4C806B0UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR17	(*(volatile uint_io8_t*)0xB4C806B1UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR18	(*(volatile uint_io8_t*)0xB4C806B2UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR19	(*(volatile uint_io8_t*)0xB4C806B3UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR20	(*(volatile uint_io8_t*)0xB4C806B4UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR21	(*(volatile uint_io8_t*)0xB4C806B5UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR22	(*(volatile uint_io8_t*)0xB4C806B6UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR23	(*(volatile uint_io8_t*)0xB4C806B7UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR24	(*(volatile uint_io8_t*)0xB4C806B8UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR25	(*(volatile uint_io8_t*)0xB4C806B9UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR26	(*(volatile uint_io8_t*)0xB4C806BAUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR27	(*(volatile uint_io8_t*)0xB4C806BBUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR28	(*(volatile uint_io8_t*)0xB4C806BCUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR29	(*(volatile uint_io8_t*)0xB4C806BDUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR30	(*(volatile uint_io8_t*)0xB4C806BEUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCR_CR31	(*(volatile uint_io8_t*)0xB4C806BFUL)  /*@bfbba@*/

#define CPG_CANFD2_TXBCR	(CPG_CANFD2.unTXBCR.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXBCR_CR0	(*(volatile uint_io8_t*)0xB4D006A0UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR1	(*(volatile uint_io8_t*)0xB4D006A1UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR2	(*(volatile uint_io8_t*)0xB4D006A2UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR3	(*(volatile uint_io8_t*)0xB4D006A3UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR4	(*(volatile uint_io8_t*)0xB4D006A4UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR5	(*(volatile uint_io8_t*)0xB4D006A5UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR6	(*(volatile uint_io8_t*)0xB4D006A6UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR7	(*(volatile uint_io8_t*)0xB4D006A7UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR8	(*(volatile uint_io8_t*)0xB4D006A8UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR9	(*(volatile uint_io8_t*)0xB4D006A9UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR10	(*(volatile uint_io8_t*)0xB4D006AAUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR11	(*(volatile uint_io8_t*)0xB4D006ABUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR12	(*(volatile uint_io8_t*)0xB4D006ACUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR13	(*(volatile uint_io8_t*)0xB4D006ADUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR14	(*(volatile uint_io8_t*)0xB4D006AEUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR15	(*(volatile uint_io8_t*)0xB4D006AFUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR16	(*(volatile uint_io8_t*)0xB4D006B0UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR17	(*(volatile uint_io8_t*)0xB4D006B1UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR18	(*(volatile uint_io8_t*)0xB4D006B2UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR19	(*(volatile uint_io8_t*)0xB4D006B3UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR20	(*(volatile uint_io8_t*)0xB4D006B4UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR21	(*(volatile uint_io8_t*)0xB4D006B5UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR22	(*(volatile uint_io8_t*)0xB4D006B6UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR23	(*(volatile uint_io8_t*)0xB4D006B7UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR24	(*(volatile uint_io8_t*)0xB4D006B8UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR25	(*(volatile uint_io8_t*)0xB4D006B9UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR26	(*(volatile uint_io8_t*)0xB4D006BAUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR27	(*(volatile uint_io8_t*)0xB4D006BBUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR28	(*(volatile uint_io8_t*)0xB4D006BCUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR29	(*(volatile uint_io8_t*)0xB4D006BDUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR30	(*(volatile uint_io8_t*)0xB4D006BEUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCR_CR31	(*(volatile uint_io8_t*)0xB4D006BFUL)  /*@bfbba@*/

#define CPG_CANFD3_TXBCR	(CPG_CANFD3.unTXBCR.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXBCR_CR0	(*(volatile uint_io8_t*)0xB4D806A0UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR1	(*(volatile uint_io8_t*)0xB4D806A1UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR2	(*(volatile uint_io8_t*)0xB4D806A2UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR3	(*(volatile uint_io8_t*)0xB4D806A3UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR4	(*(volatile uint_io8_t*)0xB4D806A4UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR5	(*(volatile uint_io8_t*)0xB4D806A5UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR6	(*(volatile uint_io8_t*)0xB4D806A6UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR7	(*(volatile uint_io8_t*)0xB4D806A7UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR8	(*(volatile uint_io8_t*)0xB4D806A8UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR9	(*(volatile uint_io8_t*)0xB4D806A9UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR10	(*(volatile uint_io8_t*)0xB4D806AAUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR11	(*(volatile uint_io8_t*)0xB4D806ABUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR12	(*(volatile uint_io8_t*)0xB4D806ACUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR13	(*(volatile uint_io8_t*)0xB4D806ADUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR14	(*(volatile uint_io8_t*)0xB4D806AEUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR15	(*(volatile uint_io8_t*)0xB4D806AFUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR16	(*(volatile uint_io8_t*)0xB4D806B0UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR17	(*(volatile uint_io8_t*)0xB4D806B1UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR18	(*(volatile uint_io8_t*)0xB4D806B2UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR19	(*(volatile uint_io8_t*)0xB4D806B3UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR20	(*(volatile uint_io8_t*)0xB4D806B4UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR21	(*(volatile uint_io8_t*)0xB4D806B5UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR22	(*(volatile uint_io8_t*)0xB4D806B6UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR23	(*(volatile uint_io8_t*)0xB4D806B7UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR24	(*(volatile uint_io8_t*)0xB4D806B8UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR25	(*(volatile uint_io8_t*)0xB4D806B9UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR26	(*(volatile uint_io8_t*)0xB4D806BAUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR27	(*(volatile uint_io8_t*)0xB4D806BBUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR28	(*(volatile uint_io8_t*)0xB4D806BCUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR29	(*(volatile uint_io8_t*)0xB4D806BDUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR30	(*(volatile uint_io8_t*)0xB4D806BEUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCR_CR31	(*(volatile uint_io8_t*)0xB4D806BFUL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_txbcr_field{
    uint_io32_t		u1CR0:1;
    uint_io32_t		u1CR1:1;
    uint_io32_t		u1CR2:1;
    uint_io32_t		u1CR3:1;
    uint_io32_t		u1CR4:1;
    uint_io32_t		u1CR5:1;
    uint_io32_t		u1CR6:1;
    uint_io32_t		u1CR7:1;
    uint_io32_t		u1CR8:1;
    uint_io32_t		u1CR9:1;
    uint_io32_t		u1CR10:1;
    uint_io32_t		u1CR11:1;
    uint_io32_t		u1CR12:1;
    uint_io32_t		u1CR13:1;
    uint_io32_t		u1CR14:1;
    uint_io32_t		u1CR15:1;
    uint_io32_t		u1CR16:1;
    uint_io32_t		u1CR17:1;
    uint_io32_t		u1CR18:1;
    uint_io32_t		u1CR19:1;
    uint_io32_t		u1CR20:1;
    uint_io32_t		u1CR21:1;
    uint_io32_t		u1CR22:1;
    uint_io32_t		u1CR23:1;
    uint_io32_t		u1CR24:1;
    uint_io32_t		u1CR25:1;
    uint_io32_t		u1CR26:1;
    uint_io32_t		u1CR27:1;
    uint_io32_t		u1CR28:1;
    uint_io32_t		u1CR29:1;
    uint_io32_t		u1CR30:1;
    uint_io32_t		u1CR31:1;
}stc_cpg_canfdn_txbcr_field_t;

typedef union un_cpg_canfdn_txbcr{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txbcr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txbcr_t;

/* TXBTO */
#define CPG_CANFD0_TXBTO	(CPG_CANFD0.unTXBTO.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXBTO_TO0	(*(volatile uint_io8_t*)0xB4C006C0UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO1	(*(volatile uint_io8_t*)0xB4C006C1UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO2	(*(volatile uint_io8_t*)0xB4C006C2UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO3	(*(volatile uint_io8_t*)0xB4C006C3UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO4	(*(volatile uint_io8_t*)0xB4C006C4UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO5	(*(volatile uint_io8_t*)0xB4C006C5UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO6	(*(volatile uint_io8_t*)0xB4C006C6UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO7	(*(volatile uint_io8_t*)0xB4C006C7UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO8	(*(volatile uint_io8_t*)0xB4C006C8UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO9	(*(volatile uint_io8_t*)0xB4C006C9UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO10	(*(volatile uint_io8_t*)0xB4C006CAUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO11	(*(volatile uint_io8_t*)0xB4C006CBUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO12	(*(volatile uint_io8_t*)0xB4C006CCUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO13	(*(volatile uint_io8_t*)0xB4C006CDUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO14	(*(volatile uint_io8_t*)0xB4C006CEUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO15	(*(volatile uint_io8_t*)0xB4C006CFUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO16	(*(volatile uint_io8_t*)0xB4C006D0UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO17	(*(volatile uint_io8_t*)0xB4C006D1UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO18	(*(volatile uint_io8_t*)0xB4C006D2UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO19	(*(volatile uint_io8_t*)0xB4C006D3UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO20	(*(volatile uint_io8_t*)0xB4C006D4UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO21	(*(volatile uint_io8_t*)0xB4C006D5UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO22	(*(volatile uint_io8_t*)0xB4C006D6UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO23	(*(volatile uint_io8_t*)0xB4C006D7UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO24	(*(volatile uint_io8_t*)0xB4C006D8UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO25	(*(volatile uint_io8_t*)0xB4C006D9UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO26	(*(volatile uint_io8_t*)0xB4C006DAUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO27	(*(volatile uint_io8_t*)0xB4C006DBUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO28	(*(volatile uint_io8_t*)0xB4C006DCUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO29	(*(volatile uint_io8_t*)0xB4C006DDUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO30	(*(volatile uint_io8_t*)0xB4C006DEUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTO_TO31	(*(volatile uint_io8_t*)0xB4C006DFUL)  /*@bfbba@*/

#define CPG_CANFD1_TXBTO	(CPG_CANFD1.unTXBTO.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXBTO_TO0	(*(volatile uint_io8_t*)0xB4C806C0UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO1	(*(volatile uint_io8_t*)0xB4C806C1UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO2	(*(volatile uint_io8_t*)0xB4C806C2UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO3	(*(volatile uint_io8_t*)0xB4C806C3UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO4	(*(volatile uint_io8_t*)0xB4C806C4UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO5	(*(volatile uint_io8_t*)0xB4C806C5UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO6	(*(volatile uint_io8_t*)0xB4C806C6UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO7	(*(volatile uint_io8_t*)0xB4C806C7UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO8	(*(volatile uint_io8_t*)0xB4C806C8UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO9	(*(volatile uint_io8_t*)0xB4C806C9UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO10	(*(volatile uint_io8_t*)0xB4C806CAUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO11	(*(volatile uint_io8_t*)0xB4C806CBUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO12	(*(volatile uint_io8_t*)0xB4C806CCUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO13	(*(volatile uint_io8_t*)0xB4C806CDUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO14	(*(volatile uint_io8_t*)0xB4C806CEUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO15	(*(volatile uint_io8_t*)0xB4C806CFUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO16	(*(volatile uint_io8_t*)0xB4C806D0UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO17	(*(volatile uint_io8_t*)0xB4C806D1UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO18	(*(volatile uint_io8_t*)0xB4C806D2UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO19	(*(volatile uint_io8_t*)0xB4C806D3UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO20	(*(volatile uint_io8_t*)0xB4C806D4UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO21	(*(volatile uint_io8_t*)0xB4C806D5UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO22	(*(volatile uint_io8_t*)0xB4C806D6UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO23	(*(volatile uint_io8_t*)0xB4C806D7UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO24	(*(volatile uint_io8_t*)0xB4C806D8UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO25	(*(volatile uint_io8_t*)0xB4C806D9UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO26	(*(volatile uint_io8_t*)0xB4C806DAUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO27	(*(volatile uint_io8_t*)0xB4C806DBUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO28	(*(volatile uint_io8_t*)0xB4C806DCUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO29	(*(volatile uint_io8_t*)0xB4C806DDUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO30	(*(volatile uint_io8_t*)0xB4C806DEUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTO_TO31	(*(volatile uint_io8_t*)0xB4C806DFUL)  /*@bfbba@*/

#define CPG_CANFD2_TXBTO	(CPG_CANFD2.unTXBTO.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXBTO_TO0	(*(volatile uint_io8_t*)0xB4D006C0UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO1	(*(volatile uint_io8_t*)0xB4D006C1UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO2	(*(volatile uint_io8_t*)0xB4D006C2UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO3	(*(volatile uint_io8_t*)0xB4D006C3UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO4	(*(volatile uint_io8_t*)0xB4D006C4UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO5	(*(volatile uint_io8_t*)0xB4D006C5UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO6	(*(volatile uint_io8_t*)0xB4D006C6UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO7	(*(volatile uint_io8_t*)0xB4D006C7UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO8	(*(volatile uint_io8_t*)0xB4D006C8UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO9	(*(volatile uint_io8_t*)0xB4D006C9UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO10	(*(volatile uint_io8_t*)0xB4D006CAUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO11	(*(volatile uint_io8_t*)0xB4D006CBUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO12	(*(volatile uint_io8_t*)0xB4D006CCUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO13	(*(volatile uint_io8_t*)0xB4D006CDUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO14	(*(volatile uint_io8_t*)0xB4D006CEUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO15	(*(volatile uint_io8_t*)0xB4D006CFUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO16	(*(volatile uint_io8_t*)0xB4D006D0UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO17	(*(volatile uint_io8_t*)0xB4D006D1UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO18	(*(volatile uint_io8_t*)0xB4D006D2UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO19	(*(volatile uint_io8_t*)0xB4D006D3UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO20	(*(volatile uint_io8_t*)0xB4D006D4UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO21	(*(volatile uint_io8_t*)0xB4D006D5UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO22	(*(volatile uint_io8_t*)0xB4D006D6UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO23	(*(volatile uint_io8_t*)0xB4D006D7UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO24	(*(volatile uint_io8_t*)0xB4D006D8UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO25	(*(volatile uint_io8_t*)0xB4D006D9UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO26	(*(volatile uint_io8_t*)0xB4D006DAUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO27	(*(volatile uint_io8_t*)0xB4D006DBUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO28	(*(volatile uint_io8_t*)0xB4D006DCUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO29	(*(volatile uint_io8_t*)0xB4D006DDUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO30	(*(volatile uint_io8_t*)0xB4D006DEUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTO_TO31	(*(volatile uint_io8_t*)0xB4D006DFUL)  /*@bfbba@*/

#define CPG_CANFD3_TXBTO	(CPG_CANFD3.unTXBTO.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXBTO_TO0	(*(volatile uint_io8_t*)0xB4D806C0UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO1	(*(volatile uint_io8_t*)0xB4D806C1UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO2	(*(volatile uint_io8_t*)0xB4D806C2UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO3	(*(volatile uint_io8_t*)0xB4D806C3UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO4	(*(volatile uint_io8_t*)0xB4D806C4UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO5	(*(volatile uint_io8_t*)0xB4D806C5UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO6	(*(volatile uint_io8_t*)0xB4D806C6UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO7	(*(volatile uint_io8_t*)0xB4D806C7UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO8	(*(volatile uint_io8_t*)0xB4D806C8UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO9	(*(volatile uint_io8_t*)0xB4D806C9UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO10	(*(volatile uint_io8_t*)0xB4D806CAUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO11	(*(volatile uint_io8_t*)0xB4D806CBUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO12	(*(volatile uint_io8_t*)0xB4D806CCUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO13	(*(volatile uint_io8_t*)0xB4D806CDUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO14	(*(volatile uint_io8_t*)0xB4D806CEUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO15	(*(volatile uint_io8_t*)0xB4D806CFUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO16	(*(volatile uint_io8_t*)0xB4D806D0UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO17	(*(volatile uint_io8_t*)0xB4D806D1UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO18	(*(volatile uint_io8_t*)0xB4D806D2UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO19	(*(volatile uint_io8_t*)0xB4D806D3UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO20	(*(volatile uint_io8_t*)0xB4D806D4UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO21	(*(volatile uint_io8_t*)0xB4D806D5UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO22	(*(volatile uint_io8_t*)0xB4D806D6UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO23	(*(volatile uint_io8_t*)0xB4D806D7UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO24	(*(volatile uint_io8_t*)0xB4D806D8UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO25	(*(volatile uint_io8_t*)0xB4D806D9UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO26	(*(volatile uint_io8_t*)0xB4D806DAUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO27	(*(volatile uint_io8_t*)0xB4D806DBUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO28	(*(volatile uint_io8_t*)0xB4D806DCUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO29	(*(volatile uint_io8_t*)0xB4D806DDUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO30	(*(volatile uint_io8_t*)0xB4D806DEUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTO_TO31	(*(volatile uint_io8_t*)0xB4D806DFUL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_txbto_field{
    uint_io32_t		u1TO0:1;
    uint_io32_t		u1TO1:1;
    uint_io32_t		u1TO2:1;
    uint_io32_t		u1TO3:1;
    uint_io32_t		u1TO4:1;
    uint_io32_t		u1TO5:1;
    uint_io32_t		u1TO6:1;
    uint_io32_t		u1TO7:1;
    uint_io32_t		u1TO8:1;
    uint_io32_t		u1TO9:1;
    uint_io32_t		u1TO10:1;
    uint_io32_t		u1TO11:1;
    uint_io32_t		u1TO12:1;
    uint_io32_t		u1TO13:1;
    uint_io32_t		u1TO14:1;
    uint_io32_t		u1TO15:1;
    uint_io32_t		u1TO16:1;
    uint_io32_t		u1TO17:1;
    uint_io32_t		u1TO18:1;
    uint_io32_t		u1TO19:1;
    uint_io32_t		u1TO20:1;
    uint_io32_t		u1TO21:1;
    uint_io32_t		u1TO22:1;
    uint_io32_t		u1TO23:1;
    uint_io32_t		u1TO24:1;
    uint_io32_t		u1TO25:1;
    uint_io32_t		u1TO26:1;
    uint_io32_t		u1TO27:1;
    uint_io32_t		u1TO28:1;
    uint_io32_t		u1TO29:1;
    uint_io32_t		u1TO30:1;
    uint_io32_t		u1TO31:1;
}stc_cpg_canfdn_txbto_field_t;

typedef union un_cpg_canfdn_txbto{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txbto_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txbto_t;

/* TXBCF */
#define CPG_CANFD0_TXBCF	(CPG_CANFD0.unTXBCF.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXBCF_CF0	(*(volatile uint_io8_t*)0xB4C006E0UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF1	(*(volatile uint_io8_t*)0xB4C006E1UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF2	(*(volatile uint_io8_t*)0xB4C006E2UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF3	(*(volatile uint_io8_t*)0xB4C006E3UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF4	(*(volatile uint_io8_t*)0xB4C006E4UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF5	(*(volatile uint_io8_t*)0xB4C006E5UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF6	(*(volatile uint_io8_t*)0xB4C006E6UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF7	(*(volatile uint_io8_t*)0xB4C006E7UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF8	(*(volatile uint_io8_t*)0xB4C006E8UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF9	(*(volatile uint_io8_t*)0xB4C006E9UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF10	(*(volatile uint_io8_t*)0xB4C006EAUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF11	(*(volatile uint_io8_t*)0xB4C006EBUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF12	(*(volatile uint_io8_t*)0xB4C006ECUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF13	(*(volatile uint_io8_t*)0xB4C006EDUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF14	(*(volatile uint_io8_t*)0xB4C006EEUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF15	(*(volatile uint_io8_t*)0xB4C006EFUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF16	(*(volatile uint_io8_t*)0xB4C006F0UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF17	(*(volatile uint_io8_t*)0xB4C006F1UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF18	(*(volatile uint_io8_t*)0xB4C006F2UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF19	(*(volatile uint_io8_t*)0xB4C006F3UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF20	(*(volatile uint_io8_t*)0xB4C006F4UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF21	(*(volatile uint_io8_t*)0xB4C006F5UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF22	(*(volatile uint_io8_t*)0xB4C006F6UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF23	(*(volatile uint_io8_t*)0xB4C006F7UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF24	(*(volatile uint_io8_t*)0xB4C006F8UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF25	(*(volatile uint_io8_t*)0xB4C006F9UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF26	(*(volatile uint_io8_t*)0xB4C006FAUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF27	(*(volatile uint_io8_t*)0xB4C006FBUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF28	(*(volatile uint_io8_t*)0xB4C006FCUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF29	(*(volatile uint_io8_t*)0xB4C006FDUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF30	(*(volatile uint_io8_t*)0xB4C006FEUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCF_CF31	(*(volatile uint_io8_t*)0xB4C006FFUL)  /*@bfbba@*/

#define CPG_CANFD1_TXBCF	(CPG_CANFD1.unTXBCF.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXBCF_CF0	(*(volatile uint_io8_t*)0xB4C806E0UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF1	(*(volatile uint_io8_t*)0xB4C806E1UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF2	(*(volatile uint_io8_t*)0xB4C806E2UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF3	(*(volatile uint_io8_t*)0xB4C806E3UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF4	(*(volatile uint_io8_t*)0xB4C806E4UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF5	(*(volatile uint_io8_t*)0xB4C806E5UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF6	(*(volatile uint_io8_t*)0xB4C806E6UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF7	(*(volatile uint_io8_t*)0xB4C806E7UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF8	(*(volatile uint_io8_t*)0xB4C806E8UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF9	(*(volatile uint_io8_t*)0xB4C806E9UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF10	(*(volatile uint_io8_t*)0xB4C806EAUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF11	(*(volatile uint_io8_t*)0xB4C806EBUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF12	(*(volatile uint_io8_t*)0xB4C806ECUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF13	(*(volatile uint_io8_t*)0xB4C806EDUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF14	(*(volatile uint_io8_t*)0xB4C806EEUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF15	(*(volatile uint_io8_t*)0xB4C806EFUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF16	(*(volatile uint_io8_t*)0xB4C806F0UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF17	(*(volatile uint_io8_t*)0xB4C806F1UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF18	(*(volatile uint_io8_t*)0xB4C806F2UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF19	(*(volatile uint_io8_t*)0xB4C806F3UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF20	(*(volatile uint_io8_t*)0xB4C806F4UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF21	(*(volatile uint_io8_t*)0xB4C806F5UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF22	(*(volatile uint_io8_t*)0xB4C806F6UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF23	(*(volatile uint_io8_t*)0xB4C806F7UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF24	(*(volatile uint_io8_t*)0xB4C806F8UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF25	(*(volatile uint_io8_t*)0xB4C806F9UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF26	(*(volatile uint_io8_t*)0xB4C806FAUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF27	(*(volatile uint_io8_t*)0xB4C806FBUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF28	(*(volatile uint_io8_t*)0xB4C806FCUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF29	(*(volatile uint_io8_t*)0xB4C806FDUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF30	(*(volatile uint_io8_t*)0xB4C806FEUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCF_CF31	(*(volatile uint_io8_t*)0xB4C806FFUL)  /*@bfbba@*/

#define CPG_CANFD2_TXBCF	(CPG_CANFD2.unTXBCF.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXBCF_CF0	(*(volatile uint_io8_t*)0xB4D006E0UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF1	(*(volatile uint_io8_t*)0xB4D006E1UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF2	(*(volatile uint_io8_t*)0xB4D006E2UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF3	(*(volatile uint_io8_t*)0xB4D006E3UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF4	(*(volatile uint_io8_t*)0xB4D006E4UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF5	(*(volatile uint_io8_t*)0xB4D006E5UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF6	(*(volatile uint_io8_t*)0xB4D006E6UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF7	(*(volatile uint_io8_t*)0xB4D006E7UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF8	(*(volatile uint_io8_t*)0xB4D006E8UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF9	(*(volatile uint_io8_t*)0xB4D006E9UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF10	(*(volatile uint_io8_t*)0xB4D006EAUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF11	(*(volatile uint_io8_t*)0xB4D006EBUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF12	(*(volatile uint_io8_t*)0xB4D006ECUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF13	(*(volatile uint_io8_t*)0xB4D006EDUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF14	(*(volatile uint_io8_t*)0xB4D006EEUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF15	(*(volatile uint_io8_t*)0xB4D006EFUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF16	(*(volatile uint_io8_t*)0xB4D006F0UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF17	(*(volatile uint_io8_t*)0xB4D006F1UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF18	(*(volatile uint_io8_t*)0xB4D006F2UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF19	(*(volatile uint_io8_t*)0xB4D006F3UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF20	(*(volatile uint_io8_t*)0xB4D006F4UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF21	(*(volatile uint_io8_t*)0xB4D006F5UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF22	(*(volatile uint_io8_t*)0xB4D006F6UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF23	(*(volatile uint_io8_t*)0xB4D006F7UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF24	(*(volatile uint_io8_t*)0xB4D006F8UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF25	(*(volatile uint_io8_t*)0xB4D006F9UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF26	(*(volatile uint_io8_t*)0xB4D006FAUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF27	(*(volatile uint_io8_t*)0xB4D006FBUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF28	(*(volatile uint_io8_t*)0xB4D006FCUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF29	(*(volatile uint_io8_t*)0xB4D006FDUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF30	(*(volatile uint_io8_t*)0xB4D006FEUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCF_CF31	(*(volatile uint_io8_t*)0xB4D006FFUL)  /*@bfbba@*/

#define CPG_CANFD3_TXBCF	(CPG_CANFD3.unTXBCF.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXBCF_CF0	(*(volatile uint_io8_t*)0xB4D806E0UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF1	(*(volatile uint_io8_t*)0xB4D806E1UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF2	(*(volatile uint_io8_t*)0xB4D806E2UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF3	(*(volatile uint_io8_t*)0xB4D806E3UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF4	(*(volatile uint_io8_t*)0xB4D806E4UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF5	(*(volatile uint_io8_t*)0xB4D806E5UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF6	(*(volatile uint_io8_t*)0xB4D806E6UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF7	(*(volatile uint_io8_t*)0xB4D806E7UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF8	(*(volatile uint_io8_t*)0xB4D806E8UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF9	(*(volatile uint_io8_t*)0xB4D806E9UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF10	(*(volatile uint_io8_t*)0xB4D806EAUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF11	(*(volatile uint_io8_t*)0xB4D806EBUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF12	(*(volatile uint_io8_t*)0xB4D806ECUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF13	(*(volatile uint_io8_t*)0xB4D806EDUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF14	(*(volatile uint_io8_t*)0xB4D806EEUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF15	(*(volatile uint_io8_t*)0xB4D806EFUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF16	(*(volatile uint_io8_t*)0xB4D806F0UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF17	(*(volatile uint_io8_t*)0xB4D806F1UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF18	(*(volatile uint_io8_t*)0xB4D806F2UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF19	(*(volatile uint_io8_t*)0xB4D806F3UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF20	(*(volatile uint_io8_t*)0xB4D806F4UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF21	(*(volatile uint_io8_t*)0xB4D806F5UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF22	(*(volatile uint_io8_t*)0xB4D806F6UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF23	(*(volatile uint_io8_t*)0xB4D806F7UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF24	(*(volatile uint_io8_t*)0xB4D806F8UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF25	(*(volatile uint_io8_t*)0xB4D806F9UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF26	(*(volatile uint_io8_t*)0xB4D806FAUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF27	(*(volatile uint_io8_t*)0xB4D806FBUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF28	(*(volatile uint_io8_t*)0xB4D806FCUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF29	(*(volatile uint_io8_t*)0xB4D806FDUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF30	(*(volatile uint_io8_t*)0xB4D806FEUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCF_CF31	(*(volatile uint_io8_t*)0xB4D806FFUL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_txbcf_field{
    uint_io32_t		u1CF0:1;
    uint_io32_t		u1CF1:1;
    uint_io32_t		u1CF2:1;
    uint_io32_t		u1CF3:1;
    uint_io32_t		u1CF4:1;
    uint_io32_t		u1CF5:1;
    uint_io32_t		u1CF6:1;
    uint_io32_t		u1CF7:1;
    uint_io32_t		u1CF8:1;
    uint_io32_t		u1CF9:1;
    uint_io32_t		u1CF10:1;
    uint_io32_t		u1CF11:1;
    uint_io32_t		u1CF12:1;
    uint_io32_t		u1CF13:1;
    uint_io32_t		u1CF14:1;
    uint_io32_t		u1CF15:1;
    uint_io32_t		u1CF16:1;
    uint_io32_t		u1CF17:1;
    uint_io32_t		u1CF18:1;
    uint_io32_t		u1CF19:1;
    uint_io32_t		u1CF20:1;
    uint_io32_t		u1CF21:1;
    uint_io32_t		u1CF22:1;
    uint_io32_t		u1CF23:1;
    uint_io32_t		u1CF24:1;
    uint_io32_t		u1CF25:1;
    uint_io32_t		u1CF26:1;
    uint_io32_t		u1CF27:1;
    uint_io32_t		u1CF28:1;
    uint_io32_t		u1CF29:1;
    uint_io32_t		u1CF30:1;
    uint_io32_t		u1CF31:1;
}stc_cpg_canfdn_txbcf_field_t;

typedef union un_cpg_canfdn_txbcf{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txbcf_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txbcf_t;

/* TXBTIE */
#define CPG_CANFD0_TXBTIE	(CPG_CANFD0.unTXBTIE.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXBTIE_TIE0	(*(volatile uint_io8_t*)0xB4C00700UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE1	(*(volatile uint_io8_t*)0xB4C00701UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE2	(*(volatile uint_io8_t*)0xB4C00702UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE3	(*(volatile uint_io8_t*)0xB4C00703UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE4	(*(volatile uint_io8_t*)0xB4C00704UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE5	(*(volatile uint_io8_t*)0xB4C00705UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE6	(*(volatile uint_io8_t*)0xB4C00706UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE7	(*(volatile uint_io8_t*)0xB4C00707UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE8	(*(volatile uint_io8_t*)0xB4C00708UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE9	(*(volatile uint_io8_t*)0xB4C00709UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE10	(*(volatile uint_io8_t*)0xB4C0070AUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE11	(*(volatile uint_io8_t*)0xB4C0070BUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE12	(*(volatile uint_io8_t*)0xB4C0070CUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE13	(*(volatile uint_io8_t*)0xB4C0070DUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE14	(*(volatile uint_io8_t*)0xB4C0070EUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE15	(*(volatile uint_io8_t*)0xB4C0070FUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE16	(*(volatile uint_io8_t*)0xB4C00710UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE17	(*(volatile uint_io8_t*)0xB4C00711UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE18	(*(volatile uint_io8_t*)0xB4C00712UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE19	(*(volatile uint_io8_t*)0xB4C00713UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE20	(*(volatile uint_io8_t*)0xB4C00714UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE21	(*(volatile uint_io8_t*)0xB4C00715UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE22	(*(volatile uint_io8_t*)0xB4C00716UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE23	(*(volatile uint_io8_t*)0xB4C00717UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE24	(*(volatile uint_io8_t*)0xB4C00718UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE25	(*(volatile uint_io8_t*)0xB4C00719UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE26	(*(volatile uint_io8_t*)0xB4C0071AUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE27	(*(volatile uint_io8_t*)0xB4C0071BUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE28	(*(volatile uint_io8_t*)0xB4C0071CUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE29	(*(volatile uint_io8_t*)0xB4C0071DUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE30	(*(volatile uint_io8_t*)0xB4C0071EUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBTIE_TIE31	(*(volatile uint_io8_t*)0xB4C0071FUL)  /*@bfbba@*/

#define CPG_CANFD1_TXBTIE	(CPG_CANFD1.unTXBTIE.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXBTIE_TIE0	(*(volatile uint_io8_t*)0xB4C80700UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE1	(*(volatile uint_io8_t*)0xB4C80701UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE2	(*(volatile uint_io8_t*)0xB4C80702UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE3	(*(volatile uint_io8_t*)0xB4C80703UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE4	(*(volatile uint_io8_t*)0xB4C80704UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE5	(*(volatile uint_io8_t*)0xB4C80705UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE6	(*(volatile uint_io8_t*)0xB4C80706UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE7	(*(volatile uint_io8_t*)0xB4C80707UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE8	(*(volatile uint_io8_t*)0xB4C80708UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE9	(*(volatile uint_io8_t*)0xB4C80709UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE10	(*(volatile uint_io8_t*)0xB4C8070AUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE11	(*(volatile uint_io8_t*)0xB4C8070BUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE12	(*(volatile uint_io8_t*)0xB4C8070CUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE13	(*(volatile uint_io8_t*)0xB4C8070DUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE14	(*(volatile uint_io8_t*)0xB4C8070EUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE15	(*(volatile uint_io8_t*)0xB4C8070FUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE16	(*(volatile uint_io8_t*)0xB4C80710UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE17	(*(volatile uint_io8_t*)0xB4C80711UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE18	(*(volatile uint_io8_t*)0xB4C80712UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE19	(*(volatile uint_io8_t*)0xB4C80713UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE20	(*(volatile uint_io8_t*)0xB4C80714UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE21	(*(volatile uint_io8_t*)0xB4C80715UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE22	(*(volatile uint_io8_t*)0xB4C80716UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE23	(*(volatile uint_io8_t*)0xB4C80717UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE24	(*(volatile uint_io8_t*)0xB4C80718UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE25	(*(volatile uint_io8_t*)0xB4C80719UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE26	(*(volatile uint_io8_t*)0xB4C8071AUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE27	(*(volatile uint_io8_t*)0xB4C8071BUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE28	(*(volatile uint_io8_t*)0xB4C8071CUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE29	(*(volatile uint_io8_t*)0xB4C8071DUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE30	(*(volatile uint_io8_t*)0xB4C8071EUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBTIE_TIE31	(*(volatile uint_io8_t*)0xB4C8071FUL)  /*@bfbba@*/

#define CPG_CANFD2_TXBTIE	(CPG_CANFD2.unTXBTIE.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXBTIE_TIE0	(*(volatile uint_io8_t*)0xB4D00700UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE1	(*(volatile uint_io8_t*)0xB4D00701UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE2	(*(volatile uint_io8_t*)0xB4D00702UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE3	(*(volatile uint_io8_t*)0xB4D00703UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE4	(*(volatile uint_io8_t*)0xB4D00704UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE5	(*(volatile uint_io8_t*)0xB4D00705UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE6	(*(volatile uint_io8_t*)0xB4D00706UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE7	(*(volatile uint_io8_t*)0xB4D00707UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE8	(*(volatile uint_io8_t*)0xB4D00708UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE9	(*(volatile uint_io8_t*)0xB4D00709UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE10	(*(volatile uint_io8_t*)0xB4D0070AUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE11	(*(volatile uint_io8_t*)0xB4D0070BUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE12	(*(volatile uint_io8_t*)0xB4D0070CUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE13	(*(volatile uint_io8_t*)0xB4D0070DUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE14	(*(volatile uint_io8_t*)0xB4D0070EUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE15	(*(volatile uint_io8_t*)0xB4D0070FUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE16	(*(volatile uint_io8_t*)0xB4D00710UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE17	(*(volatile uint_io8_t*)0xB4D00711UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE18	(*(volatile uint_io8_t*)0xB4D00712UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE19	(*(volatile uint_io8_t*)0xB4D00713UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE20	(*(volatile uint_io8_t*)0xB4D00714UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE21	(*(volatile uint_io8_t*)0xB4D00715UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE22	(*(volatile uint_io8_t*)0xB4D00716UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE23	(*(volatile uint_io8_t*)0xB4D00717UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE24	(*(volatile uint_io8_t*)0xB4D00718UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE25	(*(volatile uint_io8_t*)0xB4D00719UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE26	(*(volatile uint_io8_t*)0xB4D0071AUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE27	(*(volatile uint_io8_t*)0xB4D0071BUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE28	(*(volatile uint_io8_t*)0xB4D0071CUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE29	(*(volatile uint_io8_t*)0xB4D0071DUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE30	(*(volatile uint_io8_t*)0xB4D0071EUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBTIE_TIE31	(*(volatile uint_io8_t*)0xB4D0071FUL)  /*@bfbba@*/

#define CPG_CANFD3_TXBTIE	(CPG_CANFD3.unTXBTIE.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXBTIE_TIE0	(*(volatile uint_io8_t*)0xB4D80700UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE1	(*(volatile uint_io8_t*)0xB4D80701UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE2	(*(volatile uint_io8_t*)0xB4D80702UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE3	(*(volatile uint_io8_t*)0xB4D80703UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE4	(*(volatile uint_io8_t*)0xB4D80704UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE5	(*(volatile uint_io8_t*)0xB4D80705UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE6	(*(volatile uint_io8_t*)0xB4D80706UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE7	(*(volatile uint_io8_t*)0xB4D80707UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE8	(*(volatile uint_io8_t*)0xB4D80708UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE9	(*(volatile uint_io8_t*)0xB4D80709UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE10	(*(volatile uint_io8_t*)0xB4D8070AUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE11	(*(volatile uint_io8_t*)0xB4D8070BUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE12	(*(volatile uint_io8_t*)0xB4D8070CUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE13	(*(volatile uint_io8_t*)0xB4D8070DUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE14	(*(volatile uint_io8_t*)0xB4D8070EUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE15	(*(volatile uint_io8_t*)0xB4D8070FUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE16	(*(volatile uint_io8_t*)0xB4D80710UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE17	(*(volatile uint_io8_t*)0xB4D80711UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE18	(*(volatile uint_io8_t*)0xB4D80712UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE19	(*(volatile uint_io8_t*)0xB4D80713UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE20	(*(volatile uint_io8_t*)0xB4D80714UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE21	(*(volatile uint_io8_t*)0xB4D80715UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE22	(*(volatile uint_io8_t*)0xB4D80716UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE23	(*(volatile uint_io8_t*)0xB4D80717UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE24	(*(volatile uint_io8_t*)0xB4D80718UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE25	(*(volatile uint_io8_t*)0xB4D80719UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE26	(*(volatile uint_io8_t*)0xB4D8071AUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE27	(*(volatile uint_io8_t*)0xB4D8071BUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE28	(*(volatile uint_io8_t*)0xB4D8071CUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE29	(*(volatile uint_io8_t*)0xB4D8071DUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE30	(*(volatile uint_io8_t*)0xB4D8071EUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBTIE_TIE31	(*(volatile uint_io8_t*)0xB4D8071FUL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_txbtie_field{
    uint_io32_t		u1TIE0:1;
    uint_io32_t		u1TIE1:1;
    uint_io32_t		u1TIE2:1;
    uint_io32_t		u1TIE3:1;
    uint_io32_t		u1TIE4:1;
    uint_io32_t		u1TIE5:1;
    uint_io32_t		u1TIE6:1;
    uint_io32_t		u1TIE7:1;
    uint_io32_t		u1TIE8:1;
    uint_io32_t		u1TIE9:1;
    uint_io32_t		u1TIE10:1;
    uint_io32_t		u1TIE11:1;
    uint_io32_t		u1TIE12:1;
    uint_io32_t		u1TIE13:1;
    uint_io32_t		u1TIE14:1;
    uint_io32_t		u1TIE15:1;
    uint_io32_t		u1TIE16:1;
    uint_io32_t		u1TIE17:1;
    uint_io32_t		u1TIE18:1;
    uint_io32_t		u1TIE19:1;
    uint_io32_t		u1TIE20:1;
    uint_io32_t		u1TIE21:1;
    uint_io32_t		u1TIE22:1;
    uint_io32_t		u1TIE23:1;
    uint_io32_t		u1TIE24:1;
    uint_io32_t		u1TIE25:1;
    uint_io32_t		u1TIE26:1;
    uint_io32_t		u1TIE27:1;
    uint_io32_t		u1TIE28:1;
    uint_io32_t		u1TIE29:1;
    uint_io32_t		u1TIE30:1;
    uint_io32_t		u1TIE31:1;
}stc_cpg_canfdn_txbtie_field_t;

typedef union un_cpg_canfdn_txbtie{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txbtie_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txbtie_t;

/* TXBCIE */
#define CPG_CANFD0_TXBCIE	(CPG_CANFD0.unTXBCIE.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXBCIE_CFIE0	(*(volatile uint_io8_t*)0xB4C00720UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE1	(*(volatile uint_io8_t*)0xB4C00721UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE2	(*(volatile uint_io8_t*)0xB4C00722UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE3	(*(volatile uint_io8_t*)0xB4C00723UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE4	(*(volatile uint_io8_t*)0xB4C00724UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE5	(*(volatile uint_io8_t*)0xB4C00725UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE6	(*(volatile uint_io8_t*)0xB4C00726UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE7	(*(volatile uint_io8_t*)0xB4C00727UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE8	(*(volatile uint_io8_t*)0xB4C00728UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE9	(*(volatile uint_io8_t*)0xB4C00729UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE10	(*(volatile uint_io8_t*)0xB4C0072AUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE11	(*(volatile uint_io8_t*)0xB4C0072BUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE12	(*(volatile uint_io8_t*)0xB4C0072CUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE13	(*(volatile uint_io8_t*)0xB4C0072DUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE14	(*(volatile uint_io8_t*)0xB4C0072EUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE15	(*(volatile uint_io8_t*)0xB4C0072FUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE16	(*(volatile uint_io8_t*)0xB4C00730UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE17	(*(volatile uint_io8_t*)0xB4C00731UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE18	(*(volatile uint_io8_t*)0xB4C00732UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE19	(*(volatile uint_io8_t*)0xB4C00733UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE20	(*(volatile uint_io8_t*)0xB4C00734UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE21	(*(volatile uint_io8_t*)0xB4C00735UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE22	(*(volatile uint_io8_t*)0xB4C00736UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE23	(*(volatile uint_io8_t*)0xB4C00737UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE24	(*(volatile uint_io8_t*)0xB4C00738UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE25	(*(volatile uint_io8_t*)0xB4C00739UL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE26	(*(volatile uint_io8_t*)0xB4C0073AUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE27	(*(volatile uint_io8_t*)0xB4C0073BUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE28	(*(volatile uint_io8_t*)0xB4C0073CUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE29	(*(volatile uint_io8_t*)0xB4C0073DUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE30	(*(volatile uint_io8_t*)0xB4C0073EUL)  /*@bfbba@*/
#define CPG_CANFD0_TXBCIE_CFIE31	(*(volatile uint_io8_t*)0xB4C0073FUL)  /*@bfbba@*/

#define CPG_CANFD1_TXBCIE	(CPG_CANFD1.unTXBCIE.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXBCIE_CFIE0	(*(volatile uint_io8_t*)0xB4C80720UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE1	(*(volatile uint_io8_t*)0xB4C80721UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE2	(*(volatile uint_io8_t*)0xB4C80722UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE3	(*(volatile uint_io8_t*)0xB4C80723UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE4	(*(volatile uint_io8_t*)0xB4C80724UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE5	(*(volatile uint_io8_t*)0xB4C80725UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE6	(*(volatile uint_io8_t*)0xB4C80726UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE7	(*(volatile uint_io8_t*)0xB4C80727UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE8	(*(volatile uint_io8_t*)0xB4C80728UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE9	(*(volatile uint_io8_t*)0xB4C80729UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE10	(*(volatile uint_io8_t*)0xB4C8072AUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE11	(*(volatile uint_io8_t*)0xB4C8072BUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE12	(*(volatile uint_io8_t*)0xB4C8072CUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE13	(*(volatile uint_io8_t*)0xB4C8072DUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE14	(*(volatile uint_io8_t*)0xB4C8072EUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE15	(*(volatile uint_io8_t*)0xB4C8072FUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE16	(*(volatile uint_io8_t*)0xB4C80730UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE17	(*(volatile uint_io8_t*)0xB4C80731UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE18	(*(volatile uint_io8_t*)0xB4C80732UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE19	(*(volatile uint_io8_t*)0xB4C80733UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE20	(*(volatile uint_io8_t*)0xB4C80734UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE21	(*(volatile uint_io8_t*)0xB4C80735UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE22	(*(volatile uint_io8_t*)0xB4C80736UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE23	(*(volatile uint_io8_t*)0xB4C80737UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE24	(*(volatile uint_io8_t*)0xB4C80738UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE25	(*(volatile uint_io8_t*)0xB4C80739UL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE26	(*(volatile uint_io8_t*)0xB4C8073AUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE27	(*(volatile uint_io8_t*)0xB4C8073BUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE28	(*(volatile uint_io8_t*)0xB4C8073CUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE29	(*(volatile uint_io8_t*)0xB4C8073DUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE30	(*(volatile uint_io8_t*)0xB4C8073EUL)  /*@bfbba@*/
#define CPG_CANFD1_TXBCIE_CFIE31	(*(volatile uint_io8_t*)0xB4C8073FUL)  /*@bfbba@*/

#define CPG_CANFD2_TXBCIE	(CPG_CANFD2.unTXBCIE.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXBCIE_CFIE0	(*(volatile uint_io8_t*)0xB4D00720UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE1	(*(volatile uint_io8_t*)0xB4D00721UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE2	(*(volatile uint_io8_t*)0xB4D00722UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE3	(*(volatile uint_io8_t*)0xB4D00723UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE4	(*(volatile uint_io8_t*)0xB4D00724UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE5	(*(volatile uint_io8_t*)0xB4D00725UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE6	(*(volatile uint_io8_t*)0xB4D00726UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE7	(*(volatile uint_io8_t*)0xB4D00727UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE8	(*(volatile uint_io8_t*)0xB4D00728UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE9	(*(volatile uint_io8_t*)0xB4D00729UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE10	(*(volatile uint_io8_t*)0xB4D0072AUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE11	(*(volatile uint_io8_t*)0xB4D0072BUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE12	(*(volatile uint_io8_t*)0xB4D0072CUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE13	(*(volatile uint_io8_t*)0xB4D0072DUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE14	(*(volatile uint_io8_t*)0xB4D0072EUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE15	(*(volatile uint_io8_t*)0xB4D0072FUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE16	(*(volatile uint_io8_t*)0xB4D00730UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE17	(*(volatile uint_io8_t*)0xB4D00731UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE18	(*(volatile uint_io8_t*)0xB4D00732UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE19	(*(volatile uint_io8_t*)0xB4D00733UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE20	(*(volatile uint_io8_t*)0xB4D00734UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE21	(*(volatile uint_io8_t*)0xB4D00735UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE22	(*(volatile uint_io8_t*)0xB4D00736UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE23	(*(volatile uint_io8_t*)0xB4D00737UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE24	(*(volatile uint_io8_t*)0xB4D00738UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE25	(*(volatile uint_io8_t*)0xB4D00739UL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE26	(*(volatile uint_io8_t*)0xB4D0073AUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE27	(*(volatile uint_io8_t*)0xB4D0073BUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE28	(*(volatile uint_io8_t*)0xB4D0073CUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE29	(*(volatile uint_io8_t*)0xB4D0073DUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE30	(*(volatile uint_io8_t*)0xB4D0073EUL)  /*@bfbba@*/
#define CPG_CANFD2_TXBCIE_CFIE31	(*(volatile uint_io8_t*)0xB4D0073FUL)  /*@bfbba@*/

#define CPG_CANFD3_TXBCIE	(CPG_CANFD3.unTXBCIE.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXBCIE_CFIE0	(*(volatile uint_io8_t*)0xB4D80720UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE1	(*(volatile uint_io8_t*)0xB4D80721UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE2	(*(volatile uint_io8_t*)0xB4D80722UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE3	(*(volatile uint_io8_t*)0xB4D80723UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE4	(*(volatile uint_io8_t*)0xB4D80724UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE5	(*(volatile uint_io8_t*)0xB4D80725UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE6	(*(volatile uint_io8_t*)0xB4D80726UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE7	(*(volatile uint_io8_t*)0xB4D80727UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE8	(*(volatile uint_io8_t*)0xB4D80728UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE9	(*(volatile uint_io8_t*)0xB4D80729UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE10	(*(volatile uint_io8_t*)0xB4D8072AUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE11	(*(volatile uint_io8_t*)0xB4D8072BUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE12	(*(volatile uint_io8_t*)0xB4D8072CUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE13	(*(volatile uint_io8_t*)0xB4D8072DUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE14	(*(volatile uint_io8_t*)0xB4D8072EUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE15	(*(volatile uint_io8_t*)0xB4D8072FUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE16	(*(volatile uint_io8_t*)0xB4D80730UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE17	(*(volatile uint_io8_t*)0xB4D80731UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE18	(*(volatile uint_io8_t*)0xB4D80732UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE19	(*(volatile uint_io8_t*)0xB4D80733UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE20	(*(volatile uint_io8_t*)0xB4D80734UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE21	(*(volatile uint_io8_t*)0xB4D80735UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE22	(*(volatile uint_io8_t*)0xB4D80736UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE23	(*(volatile uint_io8_t*)0xB4D80737UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE24	(*(volatile uint_io8_t*)0xB4D80738UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE25	(*(volatile uint_io8_t*)0xB4D80739UL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE26	(*(volatile uint_io8_t*)0xB4D8073AUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE27	(*(volatile uint_io8_t*)0xB4D8073BUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE28	(*(volatile uint_io8_t*)0xB4D8073CUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE29	(*(volatile uint_io8_t*)0xB4D8073DUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE30	(*(volatile uint_io8_t*)0xB4D8073EUL)  /*@bfbba@*/
#define CPG_CANFD3_TXBCIE_CFIE31	(*(volatile uint_io8_t*)0xB4D8073FUL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_txbcie_field{
    uint_io32_t		u1CFIE0:1;
    uint_io32_t		u1CFIE1:1;
    uint_io32_t		u1CFIE2:1;
    uint_io32_t		u1CFIE3:1;
    uint_io32_t		u1CFIE4:1;
    uint_io32_t		u1CFIE5:1;
    uint_io32_t		u1CFIE6:1;
    uint_io32_t		u1CFIE7:1;
    uint_io32_t		u1CFIE8:1;
    uint_io32_t		u1CFIE9:1;
    uint_io32_t		u1CFIE10:1;
    uint_io32_t		u1CFIE11:1;
    uint_io32_t		u1CFIE12:1;
    uint_io32_t		u1CFIE13:1;
    uint_io32_t		u1CFIE14:1;
    uint_io32_t		u1CFIE15:1;
    uint_io32_t		u1CFIE16:1;
    uint_io32_t		u1CFIE17:1;
    uint_io32_t		u1CFIE18:1;
    uint_io32_t		u1CFIE19:1;
    uint_io32_t		u1CFIE20:1;
    uint_io32_t		u1CFIE21:1;
    uint_io32_t		u1CFIE22:1;
    uint_io32_t		u1CFIE23:1;
    uint_io32_t		u1CFIE24:1;
    uint_io32_t		u1CFIE25:1;
    uint_io32_t		u1CFIE26:1;
    uint_io32_t		u1CFIE27:1;
    uint_io32_t		u1CFIE28:1;
    uint_io32_t		u1CFIE29:1;
    uint_io32_t		u1CFIE30:1;
    uint_io32_t		u1CFIE31:1;
}stc_cpg_canfdn_txbcie_field_t;

typedef union un_cpg_canfdn_txbcie{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txbcie_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txbcie_t;

/* TXEFC */
#define CPG_CANFD0_TXEFC	(CPG_CANFD0.unTXEFC.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXEFC_EFSA	(CPG_CANFD0.unTXEFC.stcField.u14EFSA)  /*@bf@*/
#define CPG_CANFD0_TXEFC_EFS	(CPG_CANFD0.unTXEFC.stcField.u6EFS)  /*@bf@*/
#define CPG_CANFD0_TXEFC_EFWM	(CPG_CANFD0.unTXEFC.stcField.u6EFWM)  /*@bf@*/

#define CPG_CANFD1_TXEFC	(CPG_CANFD1.unTXEFC.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXEFC_EFSA	(CPG_CANFD1.unTXEFC.stcField.u14EFSA)  /*@bf@*/
#define CPG_CANFD1_TXEFC_EFS	(CPG_CANFD1.unTXEFC.stcField.u6EFS)  /*@bf@*/
#define CPG_CANFD1_TXEFC_EFWM	(CPG_CANFD1.unTXEFC.stcField.u6EFWM)  /*@bf@*/

#define CPG_CANFD2_TXEFC	(CPG_CANFD2.unTXEFC.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXEFC_EFSA	(CPG_CANFD2.unTXEFC.stcField.u14EFSA)  /*@bf@*/
#define CPG_CANFD2_TXEFC_EFS	(CPG_CANFD2.unTXEFC.stcField.u6EFS)  /*@bf@*/
#define CPG_CANFD2_TXEFC_EFWM	(CPG_CANFD2.unTXEFC.stcField.u6EFWM)  /*@bf@*/

#define CPG_CANFD3_TXEFC	(CPG_CANFD3.unTXEFC.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXEFC_EFSA	(CPG_CANFD3.unTXEFC.stcField.u14EFSA)  /*@bf@*/
#define CPG_CANFD3_TXEFC_EFS	(CPG_CANFD3.unTXEFC.stcField.u6EFS)  /*@bf@*/
#define CPG_CANFD3_TXEFC_EFWM	(CPG_CANFD3.unTXEFC.stcField.u6EFWM)  /*@bf@*/

typedef struct stc_cpg_canfdn_txefc_field{
    uint_io32_t		:2;
    uint_io32_t		u14EFSA:14;
    uint_io32_t		u6EFS:6;
    uint_io32_t		:2;
    uint_io32_t		u6EFWM:6;
    uint_io32_t		:2;
}stc_cpg_canfdn_txefc_field_t;

typedef union un_cpg_canfdn_txefc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txefc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txefc_t;

/* TXEFS */
#define CPG_CANFD0_TXEFS	(CPG_CANFD0.unTXEFS.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXEFS_EFFL	(CPG_CANFD0.unTXEFS.stcField.u6EFFL)  /*@bf@*/
#define CPG_CANFD0_TXEFS_EFGI	(CPG_CANFD0.unTXEFS.stcField.u5EFGI)  /*@bf@*/
#define CPG_CANFD0_TXEFS_EFPI	(CPG_CANFD0.unTXEFS.stcField.u5EFPI)  /*@bf@*/
#define CPG_CANFD0_TXEFS_EFF	(*(volatile uint_io8_t*)0xB4C007B8UL)  /*@bfbba@*/
#define CPG_CANFD0_TXEFS_TEFL	(*(volatile uint_io8_t*)0xB4C007B9UL)  /*@bfbba@*/

#define CPG_CANFD1_TXEFS	(CPG_CANFD1.unTXEFS.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXEFS_EFFL	(CPG_CANFD1.unTXEFS.stcField.u6EFFL)  /*@bf@*/
#define CPG_CANFD1_TXEFS_EFGI	(CPG_CANFD1.unTXEFS.stcField.u5EFGI)  /*@bf@*/
#define CPG_CANFD1_TXEFS_EFPI	(CPG_CANFD1.unTXEFS.stcField.u5EFPI)  /*@bf@*/
#define CPG_CANFD1_TXEFS_EFF	(*(volatile uint_io8_t*)0xB4C807B8UL)  /*@bfbba@*/
#define CPG_CANFD1_TXEFS_TEFL	(*(volatile uint_io8_t*)0xB4C807B9UL)  /*@bfbba@*/

#define CPG_CANFD2_TXEFS	(CPG_CANFD2.unTXEFS.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXEFS_EFFL	(CPG_CANFD2.unTXEFS.stcField.u6EFFL)  /*@bf@*/
#define CPG_CANFD2_TXEFS_EFGI	(CPG_CANFD2.unTXEFS.stcField.u5EFGI)  /*@bf@*/
#define CPG_CANFD2_TXEFS_EFPI	(CPG_CANFD2.unTXEFS.stcField.u5EFPI)  /*@bf@*/
#define CPG_CANFD2_TXEFS_EFF	(*(volatile uint_io8_t*)0xB4D007B8UL)  /*@bfbba@*/
#define CPG_CANFD2_TXEFS_TEFL	(*(volatile uint_io8_t*)0xB4D007B9UL)  /*@bfbba@*/

#define CPG_CANFD3_TXEFS	(CPG_CANFD3.unTXEFS.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXEFS_EFFL	(CPG_CANFD3.unTXEFS.stcField.u6EFFL)  /*@bf@*/
#define CPG_CANFD3_TXEFS_EFGI	(CPG_CANFD3.unTXEFS.stcField.u5EFGI)  /*@bf@*/
#define CPG_CANFD3_TXEFS_EFPI	(CPG_CANFD3.unTXEFS.stcField.u5EFPI)  /*@bf@*/
#define CPG_CANFD3_TXEFS_EFF	(*(volatile uint_io8_t*)0xB4D807B8UL)  /*@bfbba@*/
#define CPG_CANFD3_TXEFS_TEFL	(*(volatile uint_io8_t*)0xB4D807B9UL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_txefs_field{
    uint_io32_t		u6EFFL:6;
    uint_io32_t		:2;
    uint_io32_t		u5EFGI:5;
    uint_io32_t		:3;
    uint_io32_t		u5EFPI:5;
    uint_io32_t		:3;
    uint_io32_t		u1EFF:1;
    uint_io32_t		u1TEFL:1;
    uint_io32_t		:6;
}stc_cpg_canfdn_txefs_field_t;

typedef union un_cpg_canfdn_txefs{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txefs_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txefs_t;

/* TXEFA */
#define CPG_CANFD0_TXEFA	(CPG_CANFD0.unTXEFA.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXEFA_EFAI	(CPG_CANFD0.unTXEFA.stcField.u5EFAI)  /*@bf@*/

#define CPG_CANFD1_TXEFA	(CPG_CANFD1.unTXEFA.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXEFA_EFAI	(CPG_CANFD1.unTXEFA.stcField.u5EFAI)  /*@bf@*/

#define CPG_CANFD2_TXEFA	(CPG_CANFD2.unTXEFA.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXEFA_EFAI	(CPG_CANFD2.unTXEFA.stcField.u5EFAI)  /*@bf@*/

#define CPG_CANFD3_TXEFA	(CPG_CANFD3.unTXEFA.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXEFA_EFAI	(CPG_CANFD3.unTXEFA.stcField.u5EFAI)  /*@bf@*/

typedef struct stc_cpg_canfdn_txefa_field{
    uint_io32_t		u5EFAI:5;
    uint_io32_t		:27;
}stc_cpg_canfdn_txefa_field_t;

typedef union un_cpg_canfdn_txefa{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txefa_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txefa_t;

/* FDECR */
#define CPG_CANFD0_FDECR	(CPG_CANFD0.unFDECR.u8Register)  /*@rg@*/
#define CPG_CANFD0_FDECR_SEIE	(*(volatile uint_io8_t*)0xB4C01000UL)  /*@bfbba@*/
#define CPG_CANFD0_FDECR_DEIE	(*(volatile uint_io8_t*)0xB4C01001UL)  /*@bfbba@*/
#define CPG_CANFD0_FDECR_CEREN	(*(volatile uint_io8_t*)0xB4C01002UL)  /*@bfbba@*/
#define CPG_CANFD0_FDECR_CEIV	(*(volatile uint_io8_t*)0xB4C01003UL)  /*@bfbba@*/

#define CPG_CANFD1_FDECR	(CPG_CANFD1.unFDECR.u8Register)  /*@rg@*/
#define CPG_CANFD1_FDECR_SEIE	(*(volatile uint_io8_t*)0xB4C81000UL)  /*@bfbba@*/
#define CPG_CANFD1_FDECR_DEIE	(*(volatile uint_io8_t*)0xB4C81001UL)  /*@bfbba@*/
#define CPG_CANFD1_FDECR_CEREN	(*(volatile uint_io8_t*)0xB4C81002UL)  /*@bfbba@*/
#define CPG_CANFD1_FDECR_CEIV	(*(volatile uint_io8_t*)0xB4C81003UL)  /*@bfbba@*/

#define CPG_CANFD2_FDECR	(CPG_CANFD2.unFDECR.u8Register)  /*@rg@*/
#define CPG_CANFD2_FDECR_SEIE	(*(volatile uint_io8_t*)0xB4D01000UL)  /*@bfbba@*/
#define CPG_CANFD2_FDECR_DEIE	(*(volatile uint_io8_t*)0xB4D01001UL)  /*@bfbba@*/
#define CPG_CANFD2_FDECR_CEREN	(*(volatile uint_io8_t*)0xB4D01002UL)  /*@bfbba@*/
#define CPG_CANFD2_FDECR_CEIV	(*(volatile uint_io8_t*)0xB4D01003UL)  /*@bfbba@*/

#define CPG_CANFD3_FDECR	(CPG_CANFD3.unFDECR.u8Register)  /*@rg@*/
#define CPG_CANFD3_FDECR_SEIE	(*(volatile uint_io8_t*)0xB4D81000UL)  /*@bfbba@*/
#define CPG_CANFD3_FDECR_DEIE	(*(volatile uint_io8_t*)0xB4D81001UL)  /*@bfbba@*/
#define CPG_CANFD3_FDECR_CEREN	(*(volatile uint_io8_t*)0xB4D81002UL)  /*@bfbba@*/
#define CPG_CANFD3_FDECR_CEIV	(*(volatile uint_io8_t*)0xB4D81003UL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_fdecr_field{
    uint_io8_t		u1SEIE:1;
    uint_io8_t		u1DEIE:1;
    uint_io8_t		u1CEREN:1;
    uint_io8_t		u1CEIV:1;
    uint_io8_t		:4;
}stc_cpg_canfdn_fdecr_field_t;

typedef union un_cpg_canfdn_fdecr{
    uint_io8_t		u8Register;
    stc_cpg_canfdn_fdecr_field_t		stcField;
}un_cpg_canfdn_fdecr_t;

/* FDESR */
#define CPG_CANFD0_FDESR	(CPG_CANFD0.unFDESR.u8Register)  /*@rg@*/
#define CPG_CANFD0_FDESR_SEI	(*(volatile uint_io8_t*)0xB4C01008UL)  /*@bfbba@*/
#define CPG_CANFD0_FDESR_DEI	(*(volatile uint_io8_t*)0xB4C01009UL)  /*@bfbba@*/

#define CPG_CANFD1_FDESR	(CPG_CANFD1.unFDESR.u8Register)  /*@rg@*/
#define CPG_CANFD1_FDESR_SEI	(*(volatile uint_io8_t*)0xB4C81008UL)  /*@bfbba@*/
#define CPG_CANFD1_FDESR_DEI	(*(volatile uint_io8_t*)0xB4C81009UL)  /*@bfbba@*/

#define CPG_CANFD2_FDESR	(CPG_CANFD2.unFDESR.u8Register)  /*@rg@*/
#define CPG_CANFD2_FDESR_SEI	(*(volatile uint_io8_t*)0xB4D01008UL)  /*@bfbba@*/
#define CPG_CANFD2_FDESR_DEI	(*(volatile uint_io8_t*)0xB4D01009UL)  /*@bfbba@*/

#define CPG_CANFD3_FDESR	(CPG_CANFD3.unFDESR.u8Register)  /*@rg@*/
#define CPG_CANFD3_FDESR_SEI	(*(volatile uint_io8_t*)0xB4D81008UL)  /*@bfbba@*/
#define CPG_CANFD3_FDESR_DEI	(*(volatile uint_io8_t*)0xB4D81009UL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_fdesr_field{
    uint_io8_t		u1SEI:1;
    uint_io8_t		u1DEI:1;
    uint_io8_t		:6;
}stc_cpg_canfdn_fdesr_field_t;

typedef union un_cpg_canfdn_fdesr{
    uint_io8_t		u8Register;
    stc_cpg_canfdn_fdesr_field_t		stcField;
}un_cpg_canfdn_fdesr_t;

/* FDSEAR */
#define CPG_CANFD0_FDSEAR	(CPG_CANFD0.unFDSEAR.u16Register)  /*@rg@*/
#define CPG_CANFD0_FDSEAR_SRA	CPG_CANFD0_FDSEAR  /*@bfrg@*/

#define CPG_CANFD1_FDSEAR	(CPG_CANFD1.unFDSEAR.u16Register)  /*@rg@*/
#define CPG_CANFD1_FDSEAR_SRA	CPG_CANFD1_FDSEAR  /*@bfrg@*/

#define CPG_CANFD2_FDSEAR	(CPG_CANFD2.unFDSEAR.u16Register)  /*@rg@*/
#define CPG_CANFD2_FDSEAR_SRA	CPG_CANFD2_FDSEAR  /*@bfrg@*/

#define CPG_CANFD3_FDSEAR	(CPG_CANFD3.unFDSEAR.u16Register)  /*@rg@*/
#define CPG_CANFD3_FDSEAR_SRA	CPG_CANFD3_FDSEAR  /*@bfrg@*/

typedef union un_cpg_canfdn_fdsear{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_cpg_canfdn_fdsear_t;

/* FDESCR */
#define CPG_CANFD0_FDESCR	(CPG_CANFD0.unFDESCR.u8Register)  /*@rg@*/
#define CPG_CANFD0_FDESCR_SEIC	(*(volatile uint_io8_t*)0xB4C01028UL)  /*@bfbba@*/
#define CPG_CANFD0_FDESCR_DEIC	(*(volatile uint_io8_t*)0xB4C01029UL)  /*@bfbba@*/

#define CPG_CANFD1_FDESCR	(CPG_CANFD1.unFDESCR.u8Register)  /*@rg@*/
#define CPG_CANFD1_FDESCR_SEIC	(*(volatile uint_io8_t*)0xB4C81028UL)  /*@bfbba@*/
#define CPG_CANFD1_FDESCR_DEIC	(*(volatile uint_io8_t*)0xB4C81029UL)  /*@bfbba@*/

#define CPG_CANFD2_FDESCR	(CPG_CANFD2.unFDESCR.u8Register)  /*@rg@*/
#define CPG_CANFD2_FDESCR_SEIC	(*(volatile uint_io8_t*)0xB4D01028UL)  /*@bfbba@*/
#define CPG_CANFD2_FDESCR_DEIC	(*(volatile uint_io8_t*)0xB4D01029UL)  /*@bfbba@*/

#define CPG_CANFD3_FDESCR	(CPG_CANFD3.unFDESCR.u8Register)  /*@rg@*/
#define CPG_CANFD3_FDESCR_SEIC	(*(volatile uint_io8_t*)0xB4D81028UL)  /*@bfbba@*/
#define CPG_CANFD3_FDESCR_DEIC	(*(volatile uint_io8_t*)0xB4D81029UL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_fdescr_field{
    uint_io8_t		u1SEIC:1;
    uint_io8_t		u1DEIC:1;
    uint_io8_t		:6;
}stc_cpg_canfdn_fdescr_field_t;

typedef union un_cpg_canfdn_fdescr{
    uint_io8_t		u8Register;
    stc_cpg_canfdn_fdescr_field_t		stcField;
}un_cpg_canfdn_fdescr_t;

/* FDDEAR */
#define CPG_CANFD0_FDDEAR	(CPG_CANFD0.unFDDEAR.u16Register)  /*@rg@*/
#define CPG_CANFD0_FDDEAR_DRA	CPG_CANFD0_FDDEAR  /*@bfrg@*/

#define CPG_CANFD1_FDDEAR	(CPG_CANFD1.unFDDEAR.u16Register)  /*@rg@*/
#define CPG_CANFD1_FDDEAR_DRA	CPG_CANFD1_FDDEAR  /*@bfrg@*/

#define CPG_CANFD2_FDDEAR	(CPG_CANFD2.unFDDEAR.u16Register)  /*@rg@*/
#define CPG_CANFD2_FDDEAR_DRA	CPG_CANFD2_FDDEAR  /*@bfrg@*/

#define CPG_CANFD3_FDDEAR	(CPG_CANFD3.unFDDEAR.u16Register)  /*@rg@*/
#define CPG_CANFD3_FDDEAR_DRA	CPG_CANFD3_FDDEAR  /*@bfrg@*/

typedef union un_cpg_canfdn_fddear{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_cpg_canfdn_fddear_t;

/* FDFECR */
#define CPG_CANFD0_FDFECR	(CPG_CANFD0.unFDFECR.u32Register)  /*@rg@*/
#define CPG_CANFD0_FDFECR_EI0	(*(volatile uint_io8_t*)0xB4C01040UL)  /*@bfbba@*/
#define CPG_CANFD0_FDFECR_EI1	(*(volatile uint_io8_t*)0xB4C01041UL)  /*@bfbba@*/
#define CPG_CANFD0_FDFECR_EI2	(*(volatile uint_io8_t*)0xB4C01042UL)  /*@bfbba@*/
#define CPG_CANFD0_FDFECR_EI3	(*(volatile uint_io8_t*)0xB4C01043UL)  /*@bfbba@*/
#define CPG_CANFD0_FDFECR_EI4	(*(volatile uint_io8_t*)0xB4C01044UL)  /*@bfbba@*/
#define CPG_CANFD0_FDFECR_EI5	(*(volatile uint_io8_t*)0xB4C01045UL)  /*@bfbba@*/
#define CPG_CANFD0_FDFECR_EI6	(*(volatile uint_io8_t*)0xB4C01046UL)  /*@bfbba@*/
#define CPG_CANFD0_FDFECR_EI7	(*(volatile uint_io8_t*)0xB4C01047UL)  /*@bfbba@*/
#define CPG_CANFD0_FDFECR_EI8	(*(volatile uint_io8_t*)0xB4C01048UL)  /*@bfbba@*/
#define CPG_CANFD0_FDFECR_EI9	(*(volatile uint_io8_t*)0xB4C01049UL)  /*@bfbba@*/
#define CPG_CANFD0_FDFECR_EI10	(*(volatile uint_io8_t*)0xB4C0104AUL)  /*@bfbba@*/
#define CPG_CANFD0_FDFECR_EI11	(*(volatile uint_io8_t*)0xB4C0104BUL)  /*@bfbba@*/
#define CPG_CANFD0_FDFECR_EI12	(*(volatile uint_io8_t*)0xB4C0104CUL)  /*@bfbba@*/
#define CPG_CANFD0_FDFECR_EI13	(*(volatile uint_io8_t*)0xB4C0104DUL)  /*@bfbba@*/
#define CPG_CANFD0_FDFECR_EI14	(*(volatile uint_io8_t*)0xB4C0104EUL)  /*@bfbba@*/
#define CPG_CANFD0_FDFECR_EI15	(*(volatile uint_io8_t*)0xB4C0104FUL)  /*@bfbba@*/
#define CPG_CANFD0_FDFECR_EY0	(*(volatile uint_io8_t*)0xB4C01050UL)  /*@bfbba@*/
#define CPG_CANFD0_FDFECR_EY1	(*(volatile uint_io8_t*)0xB4C01051UL)  /*@bfbba@*/
#define CPG_CANFD0_FDFECR_EY2	(*(volatile uint_io8_t*)0xB4C01052UL)  /*@bfbba@*/
#define CPG_CANFD0_FDFECR_FERR	(*(volatile uint_io8_t*)0xB4C0105FUL)  /*@bfbba@*/

#define CPG_CANFD1_FDFECR	(CPG_CANFD1.unFDFECR.u32Register)  /*@rg@*/
#define CPG_CANFD1_FDFECR_EI0	(*(volatile uint_io8_t*)0xB4C81040UL)  /*@bfbba@*/
#define CPG_CANFD1_FDFECR_EI1	(*(volatile uint_io8_t*)0xB4C81041UL)  /*@bfbba@*/
#define CPG_CANFD1_FDFECR_EI2	(*(volatile uint_io8_t*)0xB4C81042UL)  /*@bfbba@*/
#define CPG_CANFD1_FDFECR_EI3	(*(volatile uint_io8_t*)0xB4C81043UL)  /*@bfbba@*/
#define CPG_CANFD1_FDFECR_EI4	(*(volatile uint_io8_t*)0xB4C81044UL)  /*@bfbba@*/
#define CPG_CANFD1_FDFECR_EI5	(*(volatile uint_io8_t*)0xB4C81045UL)  /*@bfbba@*/
#define CPG_CANFD1_FDFECR_EI6	(*(volatile uint_io8_t*)0xB4C81046UL)  /*@bfbba@*/
#define CPG_CANFD1_FDFECR_EI7	(*(volatile uint_io8_t*)0xB4C81047UL)  /*@bfbba@*/
#define CPG_CANFD1_FDFECR_EI8	(*(volatile uint_io8_t*)0xB4C81048UL)  /*@bfbba@*/
#define CPG_CANFD1_FDFECR_EI9	(*(volatile uint_io8_t*)0xB4C81049UL)  /*@bfbba@*/
#define CPG_CANFD1_FDFECR_EI10	(*(volatile uint_io8_t*)0xB4C8104AUL)  /*@bfbba@*/
#define CPG_CANFD1_FDFECR_EI11	(*(volatile uint_io8_t*)0xB4C8104BUL)  /*@bfbba@*/
#define CPG_CANFD1_FDFECR_EI12	(*(volatile uint_io8_t*)0xB4C8104CUL)  /*@bfbba@*/
#define CPG_CANFD1_FDFECR_EI13	(*(volatile uint_io8_t*)0xB4C8104DUL)  /*@bfbba@*/
#define CPG_CANFD1_FDFECR_EI14	(*(volatile uint_io8_t*)0xB4C8104EUL)  /*@bfbba@*/
#define CPG_CANFD1_FDFECR_EI15	(*(volatile uint_io8_t*)0xB4C8104FUL)  /*@bfbba@*/
#define CPG_CANFD1_FDFECR_EY0	(*(volatile uint_io8_t*)0xB4C81050UL)  /*@bfbba@*/
#define CPG_CANFD1_FDFECR_EY1	(*(volatile uint_io8_t*)0xB4C81051UL)  /*@bfbba@*/
#define CPG_CANFD1_FDFECR_EY2	(*(volatile uint_io8_t*)0xB4C81052UL)  /*@bfbba@*/
#define CPG_CANFD1_FDFECR_FERR	(*(volatile uint_io8_t*)0xB4C8105FUL)  /*@bfbba@*/

#define CPG_CANFD2_FDFECR	(CPG_CANFD2.unFDFECR.u32Register)  /*@rg@*/
#define CPG_CANFD2_FDFECR_EI0	(*(volatile uint_io8_t*)0xB4D01040UL)  /*@bfbba@*/
#define CPG_CANFD2_FDFECR_EI1	(*(volatile uint_io8_t*)0xB4D01041UL)  /*@bfbba@*/
#define CPG_CANFD2_FDFECR_EI2	(*(volatile uint_io8_t*)0xB4D01042UL)  /*@bfbba@*/
#define CPG_CANFD2_FDFECR_EI3	(*(volatile uint_io8_t*)0xB4D01043UL)  /*@bfbba@*/
#define CPG_CANFD2_FDFECR_EI4	(*(volatile uint_io8_t*)0xB4D01044UL)  /*@bfbba@*/
#define CPG_CANFD2_FDFECR_EI5	(*(volatile uint_io8_t*)0xB4D01045UL)  /*@bfbba@*/
#define CPG_CANFD2_FDFECR_EI6	(*(volatile uint_io8_t*)0xB4D01046UL)  /*@bfbba@*/
#define CPG_CANFD2_FDFECR_EI7	(*(volatile uint_io8_t*)0xB4D01047UL)  /*@bfbba@*/
#define CPG_CANFD2_FDFECR_EI8	(*(volatile uint_io8_t*)0xB4D01048UL)  /*@bfbba@*/
#define CPG_CANFD2_FDFECR_EI9	(*(volatile uint_io8_t*)0xB4D01049UL)  /*@bfbba@*/
#define CPG_CANFD2_FDFECR_EI10	(*(volatile uint_io8_t*)0xB4D0104AUL)  /*@bfbba@*/
#define CPG_CANFD2_FDFECR_EI11	(*(volatile uint_io8_t*)0xB4D0104BUL)  /*@bfbba@*/
#define CPG_CANFD2_FDFECR_EI12	(*(volatile uint_io8_t*)0xB4D0104CUL)  /*@bfbba@*/
#define CPG_CANFD2_FDFECR_EI13	(*(volatile uint_io8_t*)0xB4D0104DUL)  /*@bfbba@*/
#define CPG_CANFD2_FDFECR_EI14	(*(volatile uint_io8_t*)0xB4D0104EUL)  /*@bfbba@*/
#define CPG_CANFD2_FDFECR_EI15	(*(volatile uint_io8_t*)0xB4D0104FUL)  /*@bfbba@*/
#define CPG_CANFD2_FDFECR_EY0	(*(volatile uint_io8_t*)0xB4D01050UL)  /*@bfbba@*/
#define CPG_CANFD2_FDFECR_EY1	(*(volatile uint_io8_t*)0xB4D01051UL)  /*@bfbba@*/
#define CPG_CANFD2_FDFECR_EY2	(*(volatile uint_io8_t*)0xB4D01052UL)  /*@bfbba@*/
#define CPG_CANFD2_FDFECR_FERR	(*(volatile uint_io8_t*)0xB4D0105FUL)  /*@bfbba@*/

#define CPG_CANFD3_FDFECR	(CPG_CANFD3.unFDFECR.u32Register)  /*@rg@*/
#define CPG_CANFD3_FDFECR_EI0	(*(volatile uint_io8_t*)0xB4D81040UL)  /*@bfbba@*/
#define CPG_CANFD3_FDFECR_EI1	(*(volatile uint_io8_t*)0xB4D81041UL)  /*@bfbba@*/
#define CPG_CANFD3_FDFECR_EI2	(*(volatile uint_io8_t*)0xB4D81042UL)  /*@bfbba@*/
#define CPG_CANFD3_FDFECR_EI3	(*(volatile uint_io8_t*)0xB4D81043UL)  /*@bfbba@*/
#define CPG_CANFD3_FDFECR_EI4	(*(volatile uint_io8_t*)0xB4D81044UL)  /*@bfbba@*/
#define CPG_CANFD3_FDFECR_EI5	(*(volatile uint_io8_t*)0xB4D81045UL)  /*@bfbba@*/
#define CPG_CANFD3_FDFECR_EI6	(*(volatile uint_io8_t*)0xB4D81046UL)  /*@bfbba@*/
#define CPG_CANFD3_FDFECR_EI7	(*(volatile uint_io8_t*)0xB4D81047UL)  /*@bfbba@*/
#define CPG_CANFD3_FDFECR_EI8	(*(volatile uint_io8_t*)0xB4D81048UL)  /*@bfbba@*/
#define CPG_CANFD3_FDFECR_EI9	(*(volatile uint_io8_t*)0xB4D81049UL)  /*@bfbba@*/
#define CPG_CANFD3_FDFECR_EI10	(*(volatile uint_io8_t*)0xB4D8104AUL)  /*@bfbba@*/
#define CPG_CANFD3_FDFECR_EI11	(*(volatile uint_io8_t*)0xB4D8104BUL)  /*@bfbba@*/
#define CPG_CANFD3_FDFECR_EI12	(*(volatile uint_io8_t*)0xB4D8104CUL)  /*@bfbba@*/
#define CPG_CANFD3_FDFECR_EI13	(*(volatile uint_io8_t*)0xB4D8104DUL)  /*@bfbba@*/
#define CPG_CANFD3_FDFECR_EI14	(*(volatile uint_io8_t*)0xB4D8104EUL)  /*@bfbba@*/
#define CPG_CANFD3_FDFECR_EI15	(*(volatile uint_io8_t*)0xB4D8104FUL)  /*@bfbba@*/
#define CPG_CANFD3_FDFECR_EY0	(*(volatile uint_io8_t*)0xB4D81050UL)  /*@bfbba@*/
#define CPG_CANFD3_FDFECR_EY1	(*(volatile uint_io8_t*)0xB4D81051UL)  /*@bfbba@*/
#define CPG_CANFD3_FDFECR_EY2	(*(volatile uint_io8_t*)0xB4D81052UL)  /*@bfbba@*/
#define CPG_CANFD3_FDFECR_FERR	(*(volatile uint_io8_t*)0xB4D8105FUL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_fdfecr_field{
    uint_io32_t		u1EI0:1;
    uint_io32_t		u1EI1:1;
    uint_io32_t		u1EI2:1;
    uint_io32_t		u1EI3:1;
    uint_io32_t		u1EI4:1;
    uint_io32_t		u1EI5:1;
    uint_io32_t		u1EI6:1;
    uint_io32_t		u1EI7:1;
    uint_io32_t		u1EI8:1;
    uint_io32_t		u1EI9:1;
    uint_io32_t		u1EI10:1;
    uint_io32_t		u1EI11:1;
    uint_io32_t		u1EI12:1;
    uint_io32_t		u1EI13:1;
    uint_io32_t		u1EI14:1;
    uint_io32_t		u1EI15:1;
    uint_io32_t		u1EY0:1;
    uint_io32_t		u1EY1:1;
    uint_io32_t		u1EY2:1;
    uint_io32_t		:12;
    uint_io32_t		u1FERR:1;
}stc_cpg_canfdn_fdfecr_field_t;

typedef union un_cpg_canfdn_fdfecr{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_fdfecr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_fdfecr_t;

/* TSCNTR */
#define CPG_CANFD0_TSCNTR	(CPG_CANFD0.unTSCNTR.u16Register)  /*@rg@*/
#define CPG_CANFD0_TSCNTR_CCLR	(*(volatile uint_io8_t*)0xB4C01800UL)  /*@bfbba@*/

#define CPG_CANFD1_TSCNTR	(CPG_CANFD1.unTSCNTR.u16Register)  /*@rg@*/
#define CPG_CANFD1_TSCNTR_CCLR	(*(volatile uint_io8_t*)0xB4C81800UL)  /*@bfbba@*/

#define CPG_CANFD2_TSCNTR	(CPG_CANFD2.unTSCNTR.u16Register)  /*@rg@*/
#define CPG_CANFD2_TSCNTR_CCLR	(*(volatile uint_io8_t*)0xB4D01800UL)  /*@bfbba@*/

#define CPG_CANFD3_TSCNTR	(CPG_CANFD3.unTSCNTR.u16Register)  /*@rg@*/
#define CPG_CANFD3_TSCNTR_CCLR	(*(volatile uint_io8_t*)0xB4D81800UL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_tscntr_field{
    uint_io16_t		u1CCLR:1;
    uint_io16_t		:15;
}stc_cpg_canfdn_tscntr_field_t;

typedef union un_cpg_canfdn_tscntr{
    uint_io16_t		u16Register;
    stc_cpg_canfdn_tscntr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_canfdn_tscntr_t;

/* TSMDR */
#define CPG_CANFD0_TSMDR	(CPG_CANFD0.unTSMDR.u16Register)  /*@rg@*/
#define CPG_CANFD0_TSMDR_CNTEN	(*(volatile uint_io8_t*)0xB4C01810UL)  /*@bfbba@*/

#define CPG_CANFD1_TSMDR	(CPG_CANFD1.unTSMDR.u16Register)  /*@rg@*/
#define CPG_CANFD1_TSMDR_CNTEN	(*(volatile uint_io8_t*)0xB4C81810UL)  /*@bfbba@*/

#define CPG_CANFD2_TSMDR	(CPG_CANFD2.unTSMDR.u16Register)  /*@rg@*/
#define CPG_CANFD2_TSMDR_CNTEN	(*(volatile uint_io8_t*)0xB4D01810UL)  /*@bfbba@*/

#define CPG_CANFD3_TSMDR	(CPG_CANFD3.unTSMDR.u16Register)  /*@rg@*/
#define CPG_CANFD3_TSMDR_CNTEN	(*(volatile uint_io8_t*)0xB4D81810UL)  /*@bfbba@*/

typedef struct stc_cpg_canfdn_tsmdr_field{
    uint_io16_t		u1CNTEN:1;
    uint_io16_t		:15;
}stc_cpg_canfdn_tsmdr_field_t;

typedef union un_cpg_canfdn_tsmdr{
    uint_io16_t		u16Register;
    stc_cpg_canfdn_tsmdr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_canfdn_tsmdr_t;

/* TSDIVR_L */
#define CPG_CANFD0_TSDIVR_L	(CPG_CANFD0.unTSDIVR_L.u16Register)  /*@rg@*/
#define CPG_CANFD0_TSDIVR_L_CDIV	CPG_CANFD0_TSDIVR_L  /*@bfrg@*/

#define CPG_CANFD1_TSDIVR_L	(CPG_CANFD1.unTSDIVR_L.u16Register)  /*@rg@*/
#define CPG_CANFD1_TSDIVR_L_CDIV	CPG_CANFD1_TSDIVR_L  /*@bfrg@*/

#define CPG_CANFD2_TSDIVR_L	(CPG_CANFD2.unTSDIVR_L.u16Register)  /*@rg@*/
#define CPG_CANFD2_TSDIVR_L_CDIV	CPG_CANFD2_TSDIVR_L  /*@bfrg@*/

#define CPG_CANFD3_TSDIVR_L	(CPG_CANFD3.unTSDIVR_L.u16Register)  /*@rg@*/
#define CPG_CANFD3_TSDIVR_L_CDIV	CPG_CANFD3_TSDIVR_L  /*@bfrg@*/

typedef union un_cpg_canfdn_tsdivr_l{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_cpg_canfdn_tsdivr_l_t;

/* TSCDTR */
#define CPG_CANFD0_TSCDTR	(CPG_CANFD0.unTSCDTR.u16Register)  /*@rg@*/
#define CPG_CANFD0_TSCDTR_CNT	CPG_CANFD0_TSCDTR  /*@bfrg@*/

#define CPG_CANFD1_TSCDTR	(CPG_CANFD1.unTSCDTR.u16Register)  /*@rg@*/
#define CPG_CANFD1_TSCDTR_CNT	CPG_CANFD1_TSCDTR  /*@bfrg@*/

#define CPG_CANFD2_TSCDTR	(CPG_CANFD2.unTSCDTR.u16Register)  /*@rg@*/
#define CPG_CANFD2_TSCDTR_CNT	CPG_CANFD2_TSCDTR  /*@bfrg@*/

#define CPG_CANFD3_TSCDTR	(CPG_CANFD3.unTSCDTR.u16Register)  /*@rg@*/
#define CPG_CANFD3_TSCDTR_CNT	CPG_CANFD3_TSCDTR  /*@bfrg@*/

typedef union un_cpg_canfdn_tscdtr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_cpg_canfdn_tscdtr_t;

/* TSCPCLR */
#define CPG_CANFD0_TSCPCLR	(CPG_CANFD0.unTSCPCLR.u16Register)  /*@rg@*/
#define CPG_CANFD0_TSCPCLR_CMP	CPG_CANFD0_TSCPCLR  /*@bfrg@*/

#define CPG_CANFD1_TSCPCLR	(CPG_CANFD1.unTSCPCLR.u16Register)  /*@rg@*/
#define CPG_CANFD1_TSCPCLR_CMP	CPG_CANFD1_TSCPCLR  /*@bfrg@*/

#define CPG_CANFD2_TSCPCLR	(CPG_CANFD2.unTSCPCLR.u16Register)  /*@rg@*/
#define CPG_CANFD2_TSCPCLR_CMP	CPG_CANFD2_TSCPCLR  /*@bfrg@*/

#define CPG_CANFD3_TSCPCLR	(CPG_CANFD3.unTSCPCLR.u16Register)  /*@rg@*/
#define CPG_CANFD3_TSCPCLR_CMP	CPG_CANFD3_TSCPCLR  /*@bfrg@*/

typedef union un_cpg_canfdn_tscpclr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_cpg_canfdn_tscpclr_t;


typedef struct stc_cpg_canfdn{
    un_cpg_canfdn_crel_t	unCREL;	/* 0x00000000 */
    un_cpg_canfdn_endn_t	unENDN;	/* 0x00000004 */
    uint_io8_t	au8Reserved0[4];	/* 0x00000008 */
    un_cpg_canfdn_dbtp_t	unDBTP;	/* 0x0000000C */
    un_cpg_canfdn_test_t	unTEST;	/* 0x00000010 */
    un_cpg_canfdn_rwd_t	unRWD;	/* 0x00000014 */
    un_cpg_canfdn_cccr_t	unCCCR;	/* 0x00000018 */
    un_cpg_canfdn_nbtp_t	unNBTP;	/* 0x0000001C */
    un_cpg_canfdn_tscc_t	unTSCC;	/* 0x00000020 */
    un_cpg_canfdn_tscv_t	unTSCV;	/* 0x00000024 */
    un_cpg_canfdn_tocc_t	unTOCC;	/* 0x00000028 */
    un_cpg_canfdn_tocv_t	unTOCV;	/* 0x0000002C */
    uint_io8_t	au8Reserved1[16];	/* 0x00000030 */
    un_cpg_canfdn_ecr_t	unECR;	/* 0x00000040 */
    un_cpg_canfdn_psr_t	unPSR;	/* 0x00000044 */
    un_cpg_canfdn_tdcr_t	unTDCR;	/* 0x00000048 */
    uint_io8_t	au8Reserved2[4];	/* 0x0000004C */
    un_cpg_canfdn_ir_t	unIR;	/* 0x00000050 */
    un_cpg_canfdn_ie_t	unIE;	/* 0x00000054 */
    un_cpg_canfdn_ils_t	unILS;	/* 0x00000058 */
    un_cpg_canfdn_ile_t	unILE;	/* 0x0000005C */
    uint_io8_t	au8Reserved3[32];	/* 0x00000060 */
    un_cpg_canfdn_gfc_t	unGFC;	/* 0x00000080 */
    un_cpg_canfdn_sidfc_t	unSIDFC;	/* 0x00000084 */
    un_cpg_canfdn_xidfc_t	unXIDFC;	/* 0x00000088 */
    uint_io8_t	au8Reserved4[4];	/* 0x0000008C */
    un_cpg_canfdn_xidam_t	unXIDAM;	/* 0x00000090 */
    un_cpg_canfdn_hpms_t	unHPMS;	/* 0x00000094 */
    un_cpg_canfdn_ndat1_t	unNDAT1;	/* 0x00000098 */
    un_cpg_canfdn_ndat2_t	unNDAT2;	/* 0x0000009C */
    un_cpg_canfdn_rxf0c_t	unRXF0C;	/* 0x000000A0 */
    un_cpg_canfdn_rxf0s_t	unRXF0S;	/* 0x000000A4 */
    un_cpg_canfdn_rxf0a_t	unRXF0A;	/* 0x000000A8 */
    un_cpg_canfdn_rxbc_t	unRXBC;	/* 0x000000AC */
    un_cpg_canfdn_rxf1c_t	unRXF1C;	/* 0x000000B0 */
    un_cpg_canfdn_rxf1s_t	unRXF1S;	/* 0x000000B4 */
    un_cpg_canfdn_rxf1a_t	unRXF1A;	/* 0x000000B8 */
    un_cpg_canfdn_rxesc_t	unRXESC;	/* 0x000000BC */
    un_cpg_canfdn_txbc_t	unTXBC;	/* 0x000000C0 */
    un_cpg_canfdn_txfqs_t	unTXFQS;	/* 0x000000C4 */
    un_cpg_canfdn_txesc_t	unTXESC;	/* 0x000000C8 */
    un_cpg_canfdn_txbrp_t	unTXBRP;	/* 0x000000CC */
    un_cpg_canfdn_txbar_t	unTXBAR;	/* 0x000000D0 */
    un_cpg_canfdn_txbcr_t	unTXBCR;	/* 0x000000D4 */
    un_cpg_canfdn_txbto_t	unTXBTO;	/* 0x000000D8 */
    un_cpg_canfdn_txbcf_t	unTXBCF;	/* 0x000000DC */
    un_cpg_canfdn_txbtie_t	unTXBTIE;	/* 0x000000E0 */
    un_cpg_canfdn_txbcie_t	unTXBCIE;	/* 0x000000E4 */
    uint_io8_t	au8Reserved5[8];	/* 0x000000E8 */
    un_cpg_canfdn_txefc_t	unTXEFC;	/* 0x000000F0 */
    un_cpg_canfdn_txefs_t	unTXEFS;	/* 0x000000F4 */
    un_cpg_canfdn_txefa_t	unTXEFA;	/* 0x000000F8 */
    uint_io8_t	au8Reserved6[260];	/* 0x000000FC */
    un_cpg_canfdn_fdecr_t	unFDECR;	/* 0x00000200 */
    un_cpg_canfdn_fdesr_t	unFDESR;	/* 0x00000201 */
    un_cpg_canfdn_fdsear_t	unFDSEAR;	/* 0x00000202 */
    uint_io8_t	au8Reserved7[1];	/* 0x00000204 */
    un_cpg_canfdn_fdescr_t	unFDESCR;	/* 0x00000205 */
    un_cpg_canfdn_fddear_t	unFDDEAR;	/* 0x00000206 */
    un_cpg_canfdn_fdfecr_t	unFDFECR;	/* 0x00000208 */
    uint_io8_t	au8Reserved8[244];	/* 0x0000020C */
    un_cpg_canfdn_tscntr_t	unTSCNTR;	/* 0x00000300 */
    un_cpg_canfdn_tsmdr_t	unTSMDR;	/* 0x00000302 */
    un_cpg_canfdn_tsdivr_l_t	unTSDIVR_L;	/* 0x00000304 */
    uint_io8_t	au8Reserved9[2];	/* 0x00000306 */
    un_cpg_canfdn_tscdtr_t	unTSCDTR;	/* 0x00000308 */
    un_cpg_canfdn_tscpclr_t	unTSCPCLR;	/* 0x0000030A */
    uint_io8_t	au8Reserved10[64756];	/* 0x0000030C */
}stc_cpg_canfdn_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_cpg_canfdn_t	stcCPG_CANFD[4];
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 65536(0x10000) bytes */


#endif /* __S6J3360_CANFD_H */
