/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_EBI_H
#define __S6J3360_EBI_H

#include "s6j3360io_basetypes.h"

/* EBI base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define EBI	stcEBI
#else /* __IO_DEFINE */
#define EBI	(*((volatile stc_ebi_t*)0xB0100000))
#endif /* __IO_DEFINE */

/* UNLOCK */
#define EBI_UNLOCK	(EBI.unUNLOCK.u32Register)  /*@rg@*/
#define EBI_UNLOCK_UNLOCK	EBI_UNLOCK  /*@bfrg@*/

typedef union un_ebi_unlock{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ebi_unlock_t;

/* LSTSR */
#define EBI_LSTSR	(EBI.unLSTSR.u32Register)  /*@rg@*/
#define EBI_LSTSR_LOCKSTATUS	(EBI.unLSTSR.stcField.u1LOCKSTATUS)  /*@bf@*/

typedef struct stc_ebi_lstsr_field{
    uint_io32_t		u1LOCKSTATUS:1;
    uint_io32_t		:31;
}stc_ebi_lstsr_field_t;

typedef union un_ebi_lstsr{
    uint_io32_t		u32Register;
    stc_ebi_lstsr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ebi_lstsr_t;

/* SFMR[0-7] */
#define EBI_SFMR0	(EBI.unSFMR0.u32Register)  /*@rg@*/
#define EBI_SFMR0_WDTH	(EBI.unSFMR0.stcField.u2WDTH)  /*@bf@*/
#define EBI_SFMR0_RBMON	(EBI.unSFMR0.stcField.u1RBMON)  /*@bf@*/
#define EBI_SFMR0_WEOFF	(EBI.unSFMR0.stcField.u1WEOFF)  /*@bf@*/
#define EBI_SFMR0_NAND	(EBI.unSFMR0.stcField.u1NAND)  /*@bf@*/
#define EBI_SFMR0_PAGE	(EBI.unSFMR0.stcField.u1PAGE)  /*@bf@*/
#define EBI_SFMR0_RDY	(EBI.unSFMR0.stcField.u1RDY)  /*@bf@*/
#define EBI_SFMR0_ENDIANESS	(EBI.unSFMR0.stcField.u1ENDIANESS)  /*@bf@*/

#define EBI_SFMR1	(EBI.unSFMR1.u32Register)  /*@rg@*/
#define EBI_SFMR1_WDTH	(EBI.unSFMR1.stcField.u2WDTH)  /*@bf@*/
#define EBI_SFMR1_RBMON	(EBI.unSFMR1.stcField.u1RBMON)  /*@bf@*/
#define EBI_SFMR1_WEOFF	(EBI.unSFMR1.stcField.u1WEOFF)  /*@bf@*/
#define EBI_SFMR1_NAND	(EBI.unSFMR1.stcField.u1NAND)  /*@bf@*/
#define EBI_SFMR1_PAGE	(EBI.unSFMR1.stcField.u1PAGE)  /*@bf@*/
#define EBI_SFMR1_RDY	(EBI.unSFMR1.stcField.u1RDY)  /*@bf@*/
#define EBI_SFMR1_ENDIANESS	(EBI.unSFMR1.stcField.u1ENDIANESS)  /*@bf@*/

#define EBI_SFMR2	(EBI.unSFMR2.u32Register)  /*@rg@*/
#define EBI_SFMR2_WDTH	(EBI.unSFMR2.stcField.u2WDTH)  /*@bf@*/
#define EBI_SFMR2_RBMON	(EBI.unSFMR2.stcField.u1RBMON)  /*@bf@*/
#define EBI_SFMR2_WEOFF	(EBI.unSFMR2.stcField.u1WEOFF)  /*@bf@*/
#define EBI_SFMR2_NAND	(EBI.unSFMR2.stcField.u1NAND)  /*@bf@*/
#define EBI_SFMR2_PAGE	(EBI.unSFMR2.stcField.u1PAGE)  /*@bf@*/
#define EBI_SFMR2_RDY	(EBI.unSFMR2.stcField.u1RDY)  /*@bf@*/
#define EBI_SFMR2_ENDIANESS	(EBI.unSFMR2.stcField.u1ENDIANESS)  /*@bf@*/

#define EBI_SFMR3	(EBI.unSFMR3.u32Register)  /*@rg@*/
#define EBI_SFMR3_WDTH	(EBI.unSFMR3.stcField.u2WDTH)  /*@bf@*/
#define EBI_SFMR3_RBMON	(EBI.unSFMR3.stcField.u1RBMON)  /*@bf@*/
#define EBI_SFMR3_WEOFF	(EBI.unSFMR3.stcField.u1WEOFF)  /*@bf@*/
#define EBI_SFMR3_NAND	(EBI.unSFMR3.stcField.u1NAND)  /*@bf@*/
#define EBI_SFMR3_PAGE	(EBI.unSFMR3.stcField.u1PAGE)  /*@bf@*/
#define EBI_SFMR3_RDY	(EBI.unSFMR3.stcField.u1RDY)  /*@bf@*/
#define EBI_SFMR3_ENDIANESS	(EBI.unSFMR3.stcField.u1ENDIANESS)  /*@bf@*/

#define EBI_SFMR4	(EBI.unSFMR4.u32Register)  /*@rg@*/
#define EBI_SFMR4_WDTH	(EBI.unSFMR4.stcField.u2WDTH)  /*@bf@*/
#define EBI_SFMR4_RBMON	(EBI.unSFMR4.stcField.u1RBMON)  /*@bf@*/
#define EBI_SFMR4_WEOFF	(EBI.unSFMR4.stcField.u1WEOFF)  /*@bf@*/
#define EBI_SFMR4_NAND	(EBI.unSFMR4.stcField.u1NAND)  /*@bf@*/
#define EBI_SFMR4_PAGE	(EBI.unSFMR4.stcField.u1PAGE)  /*@bf@*/
#define EBI_SFMR4_RDY	(EBI.unSFMR4.stcField.u1RDY)  /*@bf@*/
#define EBI_SFMR4_ENDIANESS	(EBI.unSFMR4.stcField.u1ENDIANESS)  /*@bf@*/

#define EBI_SFMR5	(EBI.unSFMR5.u32Register)  /*@rg@*/
#define EBI_SFMR5_WDTH	(EBI.unSFMR5.stcField.u2WDTH)  /*@bf@*/
#define EBI_SFMR5_RBMON	(EBI.unSFMR5.stcField.u1RBMON)  /*@bf@*/
#define EBI_SFMR5_WEOFF	(EBI.unSFMR5.stcField.u1WEOFF)  /*@bf@*/
#define EBI_SFMR5_NAND	(EBI.unSFMR5.stcField.u1NAND)  /*@bf@*/
#define EBI_SFMR5_PAGE	(EBI.unSFMR5.stcField.u1PAGE)  /*@bf@*/
#define EBI_SFMR5_RDY	(EBI.unSFMR5.stcField.u1RDY)  /*@bf@*/
#define EBI_SFMR5_ENDIANESS	(EBI.unSFMR5.stcField.u1ENDIANESS)  /*@bf@*/

#define EBI_SFMR6	(EBI.unSFMR6.u32Register)  /*@rg@*/
#define EBI_SFMR6_WDTH	(EBI.unSFMR6.stcField.u2WDTH)  /*@bf@*/
#define EBI_SFMR6_RBMON	(EBI.unSFMR6.stcField.u1RBMON)  /*@bf@*/
#define EBI_SFMR6_WEOFF	(EBI.unSFMR6.stcField.u1WEOFF)  /*@bf@*/
#define EBI_SFMR6_NAND	(EBI.unSFMR6.stcField.u1NAND)  /*@bf@*/
#define EBI_SFMR6_PAGE	(EBI.unSFMR6.stcField.u1PAGE)  /*@bf@*/
#define EBI_SFMR6_RDY	(EBI.unSFMR6.stcField.u1RDY)  /*@bf@*/
#define EBI_SFMR6_ENDIANESS	(EBI.unSFMR6.stcField.u1ENDIANESS)  /*@bf@*/

#define EBI_SFMR7	(EBI.unSFMR7.u32Register)  /*@rg@*/
#define EBI_SFMR7_WDTH	(EBI.unSFMR7.stcField.u2WDTH)  /*@bf@*/
#define EBI_SFMR7_RBMON	(EBI.unSFMR7.stcField.u1RBMON)  /*@bf@*/
#define EBI_SFMR7_WEOFF	(EBI.unSFMR7.stcField.u1WEOFF)  /*@bf@*/
#define EBI_SFMR7_NAND	(EBI.unSFMR7.stcField.u1NAND)  /*@bf@*/
#define EBI_SFMR7_PAGE	(EBI.unSFMR7.stcField.u1PAGE)  /*@bf@*/
#define EBI_SFMR7_RDY	(EBI.unSFMR7.stcField.u1RDY)  /*@bf@*/
#define EBI_SFMR7_ENDIANESS	(EBI.unSFMR7.stcField.u1ENDIANESS)  /*@bf@*/

typedef struct stc_ebi_sfmrn_field{
    uint_io32_t		u2WDTH:2;
    uint_io32_t		u1RBMON:1;
    uint_io32_t		u1WEOFF:1;
    uint_io32_t		u1NAND:1;
    uint_io32_t		u1PAGE:1;
    uint_io32_t		u1RDY:1;
    uint_io32_t		u1ENDIANESS:1;
    uint_io32_t		:24;
}stc_ebi_sfmrn_field_t;

typedef union un_ebi_sfmrn{
    uint_io32_t		u32Register;
    stc_ebi_sfmrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ebi_sfmrn_t;

/* SFACCR[0-7] */
#define EBI_SFACCR0	(EBI.unSFACCR0.u32Register)  /*@rg@*/
#define EBI_SFACCR0_RACC	(EBI.unSFACCR0.stcField.u4RACC)  /*@bf@*/
#define EBI_SFACCR0_RADC	(EBI.unSFACCR0.stcField.u4RADC)  /*@bf@*/
#define EBI_SFACCR0_FRADC	(EBI.unSFACCR0.stcField.u4FRADC)  /*@bf@*/
#define EBI_SFACCR0_RIDLC	(EBI.unSFACCR0.stcField.u4RIDLC)  /*@bf@*/
#define EBI_SFACCR0_WACC	(EBI.unSFACCR0.stcField.u4WACC)  /*@bf@*/
#define EBI_SFACCR0_WADC	(EBI.unSFACCR0.stcField.u4WADC)  /*@bf@*/
#define EBI_SFACCR0_WWEC	(EBI.unSFACCR0.stcField.u4WWEC)  /*@bf@*/
#define EBI_SFACCR0_WIDLC	(EBI.unSFACCR0.stcField.u4WIDLC)  /*@bf@*/

#define EBI_SFACCR1	(EBI.unSFACCR1.u32Register)  /*@rg@*/
#define EBI_SFACCR1_RACC	(EBI.unSFACCR1.stcField.u4RACC)  /*@bf@*/
#define EBI_SFACCR1_RADC	(EBI.unSFACCR1.stcField.u4RADC)  /*@bf@*/
#define EBI_SFACCR1_FRADC	(EBI.unSFACCR1.stcField.u4FRADC)  /*@bf@*/
#define EBI_SFACCR1_RIDLC	(EBI.unSFACCR1.stcField.u4RIDLC)  /*@bf@*/
#define EBI_SFACCR1_WACC	(EBI.unSFACCR1.stcField.u4WACC)  /*@bf@*/
#define EBI_SFACCR1_WADC	(EBI.unSFACCR1.stcField.u4WADC)  /*@bf@*/
#define EBI_SFACCR1_WWEC	(EBI.unSFACCR1.stcField.u4WWEC)  /*@bf@*/
#define EBI_SFACCR1_WIDLC	(EBI.unSFACCR1.stcField.u4WIDLC)  /*@bf@*/

#define EBI_SFACCR2	(EBI.unSFACCR2.u32Register)  /*@rg@*/
#define EBI_SFACCR2_RACC	(EBI.unSFACCR2.stcField.u4RACC)  /*@bf@*/
#define EBI_SFACCR2_RADC	(EBI.unSFACCR2.stcField.u4RADC)  /*@bf@*/
#define EBI_SFACCR2_FRADC	(EBI.unSFACCR2.stcField.u4FRADC)  /*@bf@*/
#define EBI_SFACCR2_RIDLC	(EBI.unSFACCR2.stcField.u4RIDLC)  /*@bf@*/
#define EBI_SFACCR2_WACC	(EBI.unSFACCR2.stcField.u4WACC)  /*@bf@*/
#define EBI_SFACCR2_WADC	(EBI.unSFACCR2.stcField.u4WADC)  /*@bf@*/
#define EBI_SFACCR2_WWEC	(EBI.unSFACCR2.stcField.u4WWEC)  /*@bf@*/
#define EBI_SFACCR2_WIDLC	(EBI.unSFACCR2.stcField.u4WIDLC)  /*@bf@*/

#define EBI_SFACCR3	(EBI.unSFACCR3.u32Register)  /*@rg@*/
#define EBI_SFACCR3_RACC	(EBI.unSFACCR3.stcField.u4RACC)  /*@bf@*/
#define EBI_SFACCR3_RADC	(EBI.unSFACCR3.stcField.u4RADC)  /*@bf@*/
#define EBI_SFACCR3_FRADC	(EBI.unSFACCR3.stcField.u4FRADC)  /*@bf@*/
#define EBI_SFACCR3_RIDLC	(EBI.unSFACCR3.stcField.u4RIDLC)  /*@bf@*/
#define EBI_SFACCR3_WACC	(EBI.unSFACCR3.stcField.u4WACC)  /*@bf@*/
#define EBI_SFACCR3_WADC	(EBI.unSFACCR3.stcField.u4WADC)  /*@bf@*/
#define EBI_SFACCR3_WWEC	(EBI.unSFACCR3.stcField.u4WWEC)  /*@bf@*/
#define EBI_SFACCR3_WIDLC	(EBI.unSFACCR3.stcField.u4WIDLC)  /*@bf@*/

#define EBI_SFACCR4	(EBI.unSFACCR4.u32Register)  /*@rg@*/
#define EBI_SFACCR4_RACC	(EBI.unSFACCR4.stcField.u4RACC)  /*@bf@*/
#define EBI_SFACCR4_RADC	(EBI.unSFACCR4.stcField.u4RADC)  /*@bf@*/
#define EBI_SFACCR4_FRADC	(EBI.unSFACCR4.stcField.u4FRADC)  /*@bf@*/
#define EBI_SFACCR4_RIDLC	(EBI.unSFACCR4.stcField.u4RIDLC)  /*@bf@*/
#define EBI_SFACCR4_WACC	(EBI.unSFACCR4.stcField.u4WACC)  /*@bf@*/
#define EBI_SFACCR4_WADC	(EBI.unSFACCR4.stcField.u4WADC)  /*@bf@*/
#define EBI_SFACCR4_WWEC	(EBI.unSFACCR4.stcField.u4WWEC)  /*@bf@*/
#define EBI_SFACCR4_WIDLC	(EBI.unSFACCR4.stcField.u4WIDLC)  /*@bf@*/

#define EBI_SFACCR5	(EBI.unSFACCR5.u32Register)  /*@rg@*/
#define EBI_SFACCR5_RACC	(EBI.unSFACCR5.stcField.u4RACC)  /*@bf@*/
#define EBI_SFACCR5_RADC	(EBI.unSFACCR5.stcField.u4RADC)  /*@bf@*/
#define EBI_SFACCR5_FRADC	(EBI.unSFACCR5.stcField.u4FRADC)  /*@bf@*/
#define EBI_SFACCR5_RIDLC	(EBI.unSFACCR5.stcField.u4RIDLC)  /*@bf@*/
#define EBI_SFACCR5_WACC	(EBI.unSFACCR5.stcField.u4WACC)  /*@bf@*/
#define EBI_SFACCR5_WADC	(EBI.unSFACCR5.stcField.u4WADC)  /*@bf@*/
#define EBI_SFACCR5_WWEC	(EBI.unSFACCR5.stcField.u4WWEC)  /*@bf@*/
#define EBI_SFACCR5_WIDLC	(EBI.unSFACCR5.stcField.u4WIDLC)  /*@bf@*/

#define EBI_SFACCR6	(EBI.unSFACCR6.u32Register)  /*@rg@*/
#define EBI_SFACCR6_RACC	(EBI.unSFACCR6.stcField.u4RACC)  /*@bf@*/
#define EBI_SFACCR6_RADC	(EBI.unSFACCR6.stcField.u4RADC)  /*@bf@*/
#define EBI_SFACCR6_FRADC	(EBI.unSFACCR6.stcField.u4FRADC)  /*@bf@*/
#define EBI_SFACCR6_RIDLC	(EBI.unSFACCR6.stcField.u4RIDLC)  /*@bf@*/
#define EBI_SFACCR6_WACC	(EBI.unSFACCR6.stcField.u4WACC)  /*@bf@*/
#define EBI_SFACCR6_WADC	(EBI.unSFACCR6.stcField.u4WADC)  /*@bf@*/
#define EBI_SFACCR6_WWEC	(EBI.unSFACCR6.stcField.u4WWEC)  /*@bf@*/
#define EBI_SFACCR6_WIDLC	(EBI.unSFACCR6.stcField.u4WIDLC)  /*@bf@*/

#define EBI_SFACCR7	(EBI.unSFACCR7.u32Register)  /*@rg@*/
#define EBI_SFACCR7_RACC	(EBI.unSFACCR7.stcField.u4RACC)  /*@bf@*/
#define EBI_SFACCR7_RADC	(EBI.unSFACCR7.stcField.u4RADC)  /*@bf@*/
#define EBI_SFACCR7_FRADC	(EBI.unSFACCR7.stcField.u4FRADC)  /*@bf@*/
#define EBI_SFACCR7_RIDLC	(EBI.unSFACCR7.stcField.u4RIDLC)  /*@bf@*/
#define EBI_SFACCR7_WACC	(EBI.unSFACCR7.stcField.u4WACC)  /*@bf@*/
#define EBI_SFACCR7_WADC	(EBI.unSFACCR7.stcField.u4WADC)  /*@bf@*/
#define EBI_SFACCR7_WWEC	(EBI.unSFACCR7.stcField.u4WWEC)  /*@bf@*/
#define EBI_SFACCR7_WIDLC	(EBI.unSFACCR7.stcField.u4WIDLC)  /*@bf@*/

typedef struct stc_ebi_sfaccrn_field{
    uint_io32_t		u4RACC:4;
    uint_io32_t		u4RADC:4;
    uint_io32_t		u4FRADC:4;
    uint_io32_t		u4RIDLC:4;
    uint_io32_t		u4WACC:4;
    uint_io32_t		u4WADC:4;
    uint_io32_t		u4WWEC:4;
    uint_io32_t		u4WIDLC:4;
}stc_ebi_sfaccrn_field_t;

typedef union un_ebi_sfaccrn{
    uint_io32_t		u32Register;
    stc_ebi_sfaccrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ebi_sfaccrn_t;

/* SFADDCR[0-7] */
#define EBI_SFADDCR0	(EBI.unSFADDCR0.u32Register)  /*@rg@*/
#define EBI_SFADDCR0_ADDR	(EBI.unSFADDCR0.au8Byte[0])  /*@bfbyte@*/
#define EBI_SFADDCR0_MASK	(EBI.unSFADDCR0.au8Byte[2])  /*@bfbyte@*/

#define EBI_SFADDCR1	(EBI.unSFADDCR1.u32Register)  /*@rg@*/
#define EBI_SFADDCR1_ADDR	(EBI.unSFADDCR1.au8Byte[0])  /*@bfbyte@*/
#define EBI_SFADDCR1_MASK	(EBI.unSFADDCR1.au8Byte[2])  /*@bfbyte@*/

#define EBI_SFADDCR2	(EBI.unSFADDCR2.u32Register)  /*@rg@*/
#define EBI_SFADDCR2_ADDR	(EBI.unSFADDCR2.au8Byte[0])  /*@bfbyte@*/
#define EBI_SFADDCR2_MASK	(EBI.unSFADDCR2.au8Byte[2])  /*@bfbyte@*/

#define EBI_SFADDCR3	(EBI.unSFADDCR3.u32Register)  /*@rg@*/
#define EBI_SFADDCR3_ADDR	(EBI.unSFADDCR3.au8Byte[0])  /*@bfbyte@*/
#define EBI_SFADDCR3_MASK	(EBI.unSFADDCR3.au8Byte[2])  /*@bfbyte@*/

#define EBI_SFADDCR4	(EBI.unSFADDCR4.u32Register)  /*@rg@*/
#define EBI_SFADDCR4_ADDR	(EBI.unSFADDCR4.au8Byte[0])  /*@bfbyte@*/
#define EBI_SFADDCR4_MASK	(EBI.unSFADDCR4.au8Byte[2])  /*@bfbyte@*/

#define EBI_SFADDCR5	(EBI.unSFADDCR5.u32Register)  /*@rg@*/
#define EBI_SFADDCR5_ADDR	(EBI.unSFADDCR5.au8Byte[0])  /*@bfbyte@*/
#define EBI_SFADDCR5_MASK	(EBI.unSFADDCR5.au8Byte[2])  /*@bfbyte@*/

#define EBI_SFADDCR6	(EBI.unSFADDCR6.u32Register)  /*@rg@*/
#define EBI_SFADDCR6_ADDR	(EBI.unSFADDCR6.au8Byte[0])  /*@bfbyte@*/
#define EBI_SFADDCR6_MASK	(EBI.unSFADDCR6.au8Byte[2])  /*@bfbyte@*/

#define EBI_SFADDCR7	(EBI.unSFADDCR7.u32Register)  /*@rg@*/
#define EBI_SFADDCR7_ADDR	(EBI.unSFADDCR7.au8Byte[0])  /*@bfbyte@*/
#define EBI_SFADDCR7_MASK	(EBI.unSFADDCR7.au8Byte[2])  /*@bfbyte@*/

typedef struct stc_ebi_sfaddcrn_field{
    uint_io32_t		u8ADDR:8;
    uint_io32_t		:8;
    uint_io32_t		u8MASK:8;
    uint_io32_t		:8;
}stc_ebi_sfaddcrn_field_t;

typedef union un_ebi_sfaddcrn{
    uint_io32_t		u32Register;
    stc_ebi_sfaddcrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ebi_sfaddcrn_t;

/* ERRR */
#define EBI_ERRR	(EBI.unERRR.u32Register)  /*@rg@*/
#define EBI_ERRR_SFER	(EBI.unERRR.stcField.u1SFER)  /*@bf@*/

typedef struct stc_ebi_errr_field{
    uint_io32_t		u1SFER:1;
    uint_io32_t		:31;
}stc_ebi_errr_field_t;

typedef union un_ebi_errr{
    uint_io32_t		u32Register;
    stc_ebi_errr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ebi_errr_t;


typedef struct stc_ebi{
    un_ebi_unlock_t	unUNLOCK;	/* 0x00000000 */
    un_ebi_lstsr_t	unLSTSR;	/* 0x00000004 */
    un_ebi_sfmrn_t	unSFMR0;	/* 0x00000008 */
    un_ebi_sfmrn_t	unSFMR1;	/* 0x0000000C */
    un_ebi_sfmrn_t	unSFMR2;	/* 0x00000010 */
    un_ebi_sfmrn_t	unSFMR3;	/* 0x00000014 */
    un_ebi_sfmrn_t	unSFMR4;	/* 0x00000018 */
    un_ebi_sfmrn_t	unSFMR5;	/* 0x0000001C */
    un_ebi_sfmrn_t	unSFMR6;	/* 0x00000020 */
    un_ebi_sfmrn_t	unSFMR7;	/* 0x00000024 */
    un_ebi_sfaccrn_t	unSFACCR0;	/* 0x00000028 */
    un_ebi_sfaccrn_t	unSFACCR1;	/* 0x0000002C */
    un_ebi_sfaccrn_t	unSFACCR2;	/* 0x00000030 */
    un_ebi_sfaccrn_t	unSFACCR3;	/* 0x00000034 */
    un_ebi_sfaccrn_t	unSFACCR4;	/* 0x00000038 */
    un_ebi_sfaccrn_t	unSFACCR5;	/* 0x0000003C */
    un_ebi_sfaccrn_t	unSFACCR6;	/* 0x00000040 */
    un_ebi_sfaccrn_t	unSFACCR7;	/* 0x00000044 */
    un_ebi_sfaddcrn_t	unSFADDCR0;	/* 0x00000048 */
    un_ebi_sfaddcrn_t	unSFADDCR1;	/* 0x0000004C */
    un_ebi_sfaddcrn_t	unSFADDCR2;	/* 0x00000050 */
    un_ebi_sfaddcrn_t	unSFADDCR3;	/* 0x00000054 */
    un_ebi_sfaddcrn_t	unSFADDCR4;	/* 0x00000058 */
    un_ebi_sfaddcrn_t	unSFADDCR5;	/* 0x0000005C */
    un_ebi_sfaddcrn_t	unSFADDCR6;	/* 0x00000060 */
    un_ebi_sfaddcrn_t	unSFADDCR7;	/* 0x00000064 */
    uint_io8_t	au8Reserved0[20];	/* 0x00000068 */
    un_ebi_errr_t	unERRR;	/* 0x0000007C */
    uint_io8_t	au8Reserved1[896];	/* 0x00000080 */
}stc_ebi_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_ebi_t	stcEBI;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_EBI_H */
