/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_EIC_H
#define __S6J3360_EIC_H

#include "s6j3360io_basetypes.h"

/* EIC00 base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define EIC00	stcEIC00
#else /* __IO_DEFINE */
#define EIC00	(*((volatile stc_eic00_t*)0xB0620000UL))
#endif /* __IO_DEFINE */

/* ENIR */
#define EIC00_ENIR	(EIC00.unENIR.u32Register)  /*@rg@*/
#define EIC00_ENIR_EN0	(*(volatile uint_io8_t*)0xB0900000UL)  /*@bfbba@*/
#define EIC00_ENIR_EN1	(*(volatile uint_io8_t*)0xB0900001UL)  /*@bfbba@*/
#define EIC00_ENIR_EN2	(*(volatile uint_io8_t*)0xB0900002UL)  /*@bfbba@*/
#define EIC00_ENIR_EN3	(*(volatile uint_io8_t*)0xB0900003UL)  /*@bfbba@*/
#define EIC00_ENIR_EN4	(*(volatile uint_io8_t*)0xB0900004UL)  /*@bfbba@*/
#define EIC00_ENIR_EN5	(*(volatile uint_io8_t*)0xB0900005UL)  /*@bfbba@*/
#define EIC00_ENIR_EN6	(*(volatile uint_io8_t*)0xB0900006UL)  /*@bfbba@*/
#define EIC00_ENIR_EN7	(*(volatile uint_io8_t*)0xB0900007UL)  /*@bfbba@*/
#define EIC00_ENIR_EN8	(*(volatile uint_io8_t*)0xB0900008UL)  /*@bfbba@*/
#define EIC00_ENIR_EN9	(*(volatile uint_io8_t*)0xB0900009UL)  /*@bfbba@*/
#define EIC00_ENIR_EN10	(*(volatile uint_io8_t*)0xB090000AUL)  /*@bfbba@*/
#define EIC00_ENIR_EN11	(*(volatile uint_io8_t*)0xB090000BUL)  /*@bfbba@*/
#define EIC00_ENIR_EN12	(*(volatile uint_io8_t*)0xB090000CUL)  /*@bfbba@*/
#define EIC00_ENIR_EN13	(*(volatile uint_io8_t*)0xB090000DUL)  /*@bfbba@*/
#define EIC00_ENIR_EN14	(*(volatile uint_io8_t*)0xB090000EUL)  /*@bfbba@*/
#define EIC00_ENIR_EN15	(*(volatile uint_io8_t*)0xB090000FUL)  /*@bfbba@*/
#define EIC00_ENIR_EN16	(*(volatile uint_io8_t*)0xB0900010UL)  /*@bfbba@*/
#define EIC00_ENIR_EN17	(*(volatile uint_io8_t*)0xB0900011UL)  /*@bfbba@*/
#define EIC00_ENIR_EN18	(*(volatile uint_io8_t*)0xB0900012UL)  /*@bfbba@*/
#define EIC00_ENIR_EN19	(*(volatile uint_io8_t*)0xB0900013UL)  /*@bfbba@*/
#define EIC00_ENIR_EN20	(*(volatile uint_io8_t*)0xB0900014UL)  /*@bfbba@*/
#define EIC00_ENIR_EN21	(*(volatile uint_io8_t*)0xB0900015UL)  /*@bfbba@*/
#define EIC00_ENIR_EN22	(*(volatile uint_io8_t*)0xB0900016UL)  /*@bfbba@*/
#define EIC00_ENIR_EN23	(*(volatile uint_io8_t*)0xB0900017UL)  /*@bfbba@*/
#define EIC00_ENIR_EN24	(*(volatile uint_io8_t*)0xB0900018UL)  /*@bfbba@*/
#define EIC00_ENIR_EN25	(*(volatile uint_io8_t*)0xB0900019UL)  /*@bfbba@*/
#define EIC00_ENIR_EN26	(*(volatile uint_io8_t*)0xB090001AUL)  /*@bfbba@*/
#define EIC00_ENIR_EN27	(*(volatile uint_io8_t*)0xB090001BUL)  /*@bfbba@*/
#define EIC00_ENIR_EN28	(*(volatile uint_io8_t*)0xB090001CUL)  /*@bfbba@*/
#define EIC00_ENIR_EN29	(*(volatile uint_io8_t*)0xB090001DUL)  /*@bfbba@*/
#define EIC00_ENIR_EN30	(*(volatile uint_io8_t*)0xB090001EUL)  /*@bfbba@*/
#define EIC00_ENIR_EN31	(*(volatile uint_io8_t*)0xB090001FUL)  /*@bfbba@*/

typedef struct stc_eic00_enir_field{
    uint_io32_t		u1EN0:1;
    uint_io32_t		u1EN1:1;
    uint_io32_t		u1EN2:1;
    uint_io32_t		u1EN3:1;
    uint_io32_t		u1EN4:1;
    uint_io32_t		u1EN5:1;
    uint_io32_t		u1EN6:1;
    uint_io32_t		u1EN7:1;
    uint_io32_t		u1EN8:1;
    uint_io32_t		u1EN9:1;
    uint_io32_t		u1EN10:1;
    uint_io32_t		u1EN11:1;
    uint_io32_t		u1EN12:1;
    uint_io32_t		u1EN13:1;
    uint_io32_t		u1EN14:1;
    uint_io32_t		u1EN15:1;
    uint_io32_t		u1EN16:1;
    uint_io32_t		u1EN17:1;
    uint_io32_t		u1EN18:1;
    uint_io32_t		u1EN19:1;
    uint_io32_t		u1EN20:1;
    uint_io32_t		u1EN21:1;
    uint_io32_t		u1EN22:1;
    uint_io32_t		u1EN23:1;
    uint_io32_t		u1EN24:1;
    uint_io32_t		u1EN25:1;
    uint_io32_t		u1EN26:1;
    uint_io32_t		u1EN27:1;
    uint_io32_t		u1EN28:1;
    uint_io32_t		u1EN29:1;
    uint_io32_t		u1EN30:1;
    uint_io32_t		u1EN31:1;
}stc_eic00_enir_field_t;

typedef union un_eic00_enir{
    uint_io32_t		u32Register;
    stc_eic00_enir_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_enir_t;

/* ENISR */
#define EIC00_ENISR	(EIC00.unENISR.u32Register)  /*@rg@*/
#define EIC00_ENISR_ENS0	(*(volatile uint_io8_t*)0xB0900020UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS1	(*(volatile uint_io8_t*)0xB0900021UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS2	(*(volatile uint_io8_t*)0xB0900022UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS3	(*(volatile uint_io8_t*)0xB0900023UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS4	(*(volatile uint_io8_t*)0xB0900024UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS5	(*(volatile uint_io8_t*)0xB0900025UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS6	(*(volatile uint_io8_t*)0xB0900026UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS7	(*(volatile uint_io8_t*)0xB0900027UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS8	(*(volatile uint_io8_t*)0xB0900028UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS9	(*(volatile uint_io8_t*)0xB0900029UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS10	(*(volatile uint_io8_t*)0xB090002AUL)  /*@bfbba@*/
#define EIC00_ENISR_ENS11	(*(volatile uint_io8_t*)0xB090002BUL)  /*@bfbba@*/
#define EIC00_ENISR_ENS12	(*(volatile uint_io8_t*)0xB090002CUL)  /*@bfbba@*/
#define EIC00_ENISR_ENS13	(*(volatile uint_io8_t*)0xB090002DUL)  /*@bfbba@*/
#define EIC00_ENISR_ENS14	(*(volatile uint_io8_t*)0xB090002EUL)  /*@bfbba@*/
#define EIC00_ENISR_ENS15	(*(volatile uint_io8_t*)0xB090002FUL)  /*@bfbba@*/
#define EIC00_ENISR_ENS16	(*(volatile uint_io8_t*)0xB0900030UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS17	(*(volatile uint_io8_t*)0xB0900031UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS18	(*(volatile uint_io8_t*)0xB0900032UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS19	(*(volatile uint_io8_t*)0xB0900033UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS20	(*(volatile uint_io8_t*)0xB0900034UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS21	(*(volatile uint_io8_t*)0xB0900035UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS22	(*(volatile uint_io8_t*)0xB0900036UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS23	(*(volatile uint_io8_t*)0xB0900037UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS24	(*(volatile uint_io8_t*)0xB0900038UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS25	(*(volatile uint_io8_t*)0xB0900039UL)  /*@bfbba@*/
#define EIC00_ENISR_ENS26	(*(volatile uint_io8_t*)0xB090003AUL)  /*@bfbba@*/
#define EIC00_ENISR_ENS27	(*(volatile uint_io8_t*)0xB090003BUL)  /*@bfbba@*/
#define EIC00_ENISR_ENS28	(*(volatile uint_io8_t*)0xB090003CUL)  /*@bfbba@*/
#define EIC00_ENISR_ENS29	(*(volatile uint_io8_t*)0xB090003DUL)  /*@bfbba@*/
#define EIC00_ENISR_ENS30	(*(volatile uint_io8_t*)0xB090003EUL)  /*@bfbba@*/
#define EIC00_ENISR_ENS31	(*(volatile uint_io8_t*)0xB090003FUL)  /*@bfbba@*/

typedef struct stc_eic00_enisr_field{
    uint_io32_t		u1ENS0:1;
    uint_io32_t		u1ENS1:1;
    uint_io32_t		u1ENS2:1;
    uint_io32_t		u1ENS3:1;
    uint_io32_t		u1ENS4:1;
    uint_io32_t		u1ENS5:1;
    uint_io32_t		u1ENS6:1;
    uint_io32_t		u1ENS7:1;
    uint_io32_t		u1ENS8:1;
    uint_io32_t		u1ENS9:1;
    uint_io32_t		u1ENS10:1;
    uint_io32_t		u1ENS11:1;
    uint_io32_t		u1ENS12:1;
    uint_io32_t		u1ENS13:1;
    uint_io32_t		u1ENS14:1;
    uint_io32_t		u1ENS15:1;
    uint_io32_t		u1ENS16:1;
    uint_io32_t		u1ENS17:1;
    uint_io32_t		u1ENS18:1;
    uint_io32_t		u1ENS19:1;
    uint_io32_t		u1ENS20:1;
    uint_io32_t		u1ENS21:1;
    uint_io32_t		u1ENS22:1;
    uint_io32_t		u1ENS23:1;
    uint_io32_t		u1ENS24:1;
    uint_io32_t		u1ENS25:1;
    uint_io32_t		u1ENS26:1;
    uint_io32_t		u1ENS27:1;
    uint_io32_t		u1ENS28:1;
    uint_io32_t		u1ENS29:1;
    uint_io32_t		u1ENS30:1;
    uint_io32_t		u1ENS31:1;
}stc_eic00_enisr_field_t;

typedef union un_eic00_enisr{
    uint_io32_t		u32Register;
    stc_eic00_enisr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_enisr_t;

/* ENICR */
#define EIC00_ENICR	(EIC00.unENICR.u32Register)  /*@rg@*/
#define EIC00_ENICR_ENC0	(*(volatile uint_io8_t*)0xB0900040UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC1	(*(volatile uint_io8_t*)0xB0900041UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC2	(*(volatile uint_io8_t*)0xB0900042UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC3	(*(volatile uint_io8_t*)0xB0900043UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC4	(*(volatile uint_io8_t*)0xB0900044UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC5	(*(volatile uint_io8_t*)0xB0900045UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC6	(*(volatile uint_io8_t*)0xB0900046UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC7	(*(volatile uint_io8_t*)0xB0900047UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC8	(*(volatile uint_io8_t*)0xB0900048UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC9	(*(volatile uint_io8_t*)0xB0900049UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC10	(*(volatile uint_io8_t*)0xB090004AUL)  /*@bfbba@*/
#define EIC00_ENICR_ENC11	(*(volatile uint_io8_t*)0xB090004BUL)  /*@bfbba@*/
#define EIC00_ENICR_ENC12	(*(volatile uint_io8_t*)0xB090004CUL)  /*@bfbba@*/
#define EIC00_ENICR_ENC13	(*(volatile uint_io8_t*)0xB090004DUL)  /*@bfbba@*/
#define EIC00_ENICR_ENC14	(*(volatile uint_io8_t*)0xB090004EUL)  /*@bfbba@*/
#define EIC00_ENICR_ENC15	(*(volatile uint_io8_t*)0xB090004FUL)  /*@bfbba@*/
#define EIC00_ENICR_ENC16	(*(volatile uint_io8_t*)0xB0900050UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC17	(*(volatile uint_io8_t*)0xB0900051UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC18	(*(volatile uint_io8_t*)0xB0900052UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC19	(*(volatile uint_io8_t*)0xB0900053UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC20	(*(volatile uint_io8_t*)0xB0900054UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC21	(*(volatile uint_io8_t*)0xB0900055UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC22	(*(volatile uint_io8_t*)0xB0900056UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC23	(*(volatile uint_io8_t*)0xB0900057UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC24	(*(volatile uint_io8_t*)0xB0900058UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC25	(*(volatile uint_io8_t*)0xB0900059UL)  /*@bfbba@*/
#define EIC00_ENICR_ENC26	(*(volatile uint_io8_t*)0xB090005AUL)  /*@bfbba@*/
#define EIC00_ENICR_ENC27	(*(volatile uint_io8_t*)0xB090005BUL)  /*@bfbba@*/
#define EIC00_ENICR_ENC28	(*(volatile uint_io8_t*)0xB090005CUL)  /*@bfbba@*/
#define EIC00_ENICR_ENC29	(*(volatile uint_io8_t*)0xB090005DUL)  /*@bfbba@*/
#define EIC00_ENICR_ENC30	(*(volatile uint_io8_t*)0xB090005EUL)  /*@bfbba@*/
#define EIC00_ENICR_ENC31	(*(volatile uint_io8_t*)0xB090005FUL)  /*@bfbba@*/

typedef struct stc_eic00_enicr_field{
    uint_io32_t		u1ENC0:1;
    uint_io32_t		u1ENC1:1;
    uint_io32_t		u1ENC2:1;
    uint_io32_t		u1ENC3:1;
    uint_io32_t		u1ENC4:1;
    uint_io32_t		u1ENC5:1;
    uint_io32_t		u1ENC6:1;
    uint_io32_t		u1ENC7:1;
    uint_io32_t		u1ENC8:1;
    uint_io32_t		u1ENC9:1;
    uint_io32_t		u1ENC10:1;
    uint_io32_t		u1ENC11:1;
    uint_io32_t		u1ENC12:1;
    uint_io32_t		u1ENC13:1;
    uint_io32_t		u1ENC14:1;
    uint_io32_t		u1ENC15:1;
    uint_io32_t		u1ENC16:1;
    uint_io32_t		u1ENC17:1;
    uint_io32_t		u1ENC18:1;
    uint_io32_t		u1ENC19:1;
    uint_io32_t		u1ENC20:1;
    uint_io32_t		u1ENC21:1;
    uint_io32_t		u1ENC22:1;
    uint_io32_t		u1ENC23:1;
    uint_io32_t		u1ENC24:1;
    uint_io32_t		u1ENC25:1;
    uint_io32_t		u1ENC26:1;
    uint_io32_t		u1ENC27:1;
    uint_io32_t		u1ENC28:1;
    uint_io32_t		u1ENC29:1;
    uint_io32_t		u1ENC30:1;
    uint_io32_t		u1ENC31:1;
}stc_eic00_enicr_field_t;

typedef union un_eic00_enicr{
    uint_io32_t		u32Register;
    stc_eic00_enicr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_enicr_t;

/* EIRR */
#define EIC00_EIRR	(EIC00.unEIRR.u32Register)  /*@rg@*/
#define EIC00_EIRR_ER0	(*(volatile uint_io8_t*)0xB0900060UL)  /*@bfbba@*/
#define EIC00_EIRR_ER1	(*(volatile uint_io8_t*)0xB0900061UL)  /*@bfbba@*/
#define EIC00_EIRR_ER2	(*(volatile uint_io8_t*)0xB0900062UL)  /*@bfbba@*/
#define EIC00_EIRR_ER3	(*(volatile uint_io8_t*)0xB0900063UL)  /*@bfbba@*/
#define EIC00_EIRR_ER4	(*(volatile uint_io8_t*)0xB0900064UL)  /*@bfbba@*/
#define EIC00_EIRR_ER5	(*(volatile uint_io8_t*)0xB0900065UL)  /*@bfbba@*/
#define EIC00_EIRR_ER6	(*(volatile uint_io8_t*)0xB0900066UL)  /*@bfbba@*/
#define EIC00_EIRR_ER7	(*(volatile uint_io8_t*)0xB0900067UL)  /*@bfbba@*/
#define EIC00_EIRR_ER8	(*(volatile uint_io8_t*)0xB0900068UL)  /*@bfbba@*/
#define EIC00_EIRR_ER9	(*(volatile uint_io8_t*)0xB0900069UL)  /*@bfbba@*/
#define EIC00_EIRR_ER10	(*(volatile uint_io8_t*)0xB090006AUL)  /*@bfbba@*/
#define EIC00_EIRR_ER11	(*(volatile uint_io8_t*)0xB090006BUL)  /*@bfbba@*/
#define EIC00_EIRR_ER12	(*(volatile uint_io8_t*)0xB090006CUL)  /*@bfbba@*/
#define EIC00_EIRR_ER13	(*(volatile uint_io8_t*)0xB090006DUL)  /*@bfbba@*/
#define EIC00_EIRR_ER14	(*(volatile uint_io8_t*)0xB090006EUL)  /*@bfbba@*/
#define EIC00_EIRR_ER15	(*(volatile uint_io8_t*)0xB090006FUL)  /*@bfbba@*/
#define EIC00_EIRR_ER16	(*(volatile uint_io8_t*)0xB0900070UL)  /*@bfbba@*/
#define EIC00_EIRR_ER17	(*(volatile uint_io8_t*)0xB0900071UL)  /*@bfbba@*/
#define EIC00_EIRR_ER18	(*(volatile uint_io8_t*)0xB0900072UL)  /*@bfbba@*/
#define EIC00_EIRR_ER19	(*(volatile uint_io8_t*)0xB0900073UL)  /*@bfbba@*/
#define EIC00_EIRR_ER20	(*(volatile uint_io8_t*)0xB0900074UL)  /*@bfbba@*/
#define EIC00_EIRR_ER21	(*(volatile uint_io8_t*)0xB0900075UL)  /*@bfbba@*/
#define EIC00_EIRR_ER22	(*(volatile uint_io8_t*)0xB0900076UL)  /*@bfbba@*/
#define EIC00_EIRR_ER23	(*(volatile uint_io8_t*)0xB0900077UL)  /*@bfbba@*/
#define EIC00_EIRR_ER24	(*(volatile uint_io8_t*)0xB0900078UL)  /*@bfbba@*/
#define EIC00_EIRR_ER25	(*(volatile uint_io8_t*)0xB0900079UL)  /*@bfbba@*/
#define EIC00_EIRR_ER26	(*(volatile uint_io8_t*)0xB090007AUL)  /*@bfbba@*/
#define EIC00_EIRR_ER27	(*(volatile uint_io8_t*)0xB090007BUL)  /*@bfbba@*/
#define EIC00_EIRR_ER28	(*(volatile uint_io8_t*)0xB090007CUL)  /*@bfbba@*/
#define EIC00_EIRR_ER29	(*(volatile uint_io8_t*)0xB090007DUL)  /*@bfbba@*/
#define EIC00_EIRR_ER30	(*(volatile uint_io8_t*)0xB090007EUL)  /*@bfbba@*/
#define EIC00_EIRR_ER31	(*(volatile uint_io8_t*)0xB090007FUL)  /*@bfbba@*/

typedef struct stc_eic00_eirr_field{
    uint_io32_t		u1ER0:1;
    uint_io32_t		u1ER1:1;
    uint_io32_t		u1ER2:1;
    uint_io32_t		u1ER3:1;
    uint_io32_t		u1ER4:1;
    uint_io32_t		u1ER5:1;
    uint_io32_t		u1ER6:1;
    uint_io32_t		u1ER7:1;
    uint_io32_t		u1ER8:1;
    uint_io32_t		u1ER9:1;
    uint_io32_t		u1ER10:1;
    uint_io32_t		u1ER11:1;
    uint_io32_t		u1ER12:1;
    uint_io32_t		u1ER13:1;
    uint_io32_t		u1ER14:1;
    uint_io32_t		u1ER15:1;
    uint_io32_t		u1ER16:1;
    uint_io32_t		u1ER17:1;
    uint_io32_t		u1ER18:1;
    uint_io32_t		u1ER19:1;
    uint_io32_t		u1ER20:1;
    uint_io32_t		u1ER21:1;
    uint_io32_t		u1ER22:1;
    uint_io32_t		u1ER23:1;
    uint_io32_t		u1ER24:1;
    uint_io32_t		u1ER25:1;
    uint_io32_t		u1ER26:1;
    uint_io32_t		u1ER27:1;
    uint_io32_t		u1ER28:1;
    uint_io32_t		u1ER29:1;
    uint_io32_t		u1ER30:1;
    uint_io32_t		u1ER31:1;
}stc_eic00_eirr_field_t;

typedef union un_eic00_eirr{
    uint_io32_t		u32Register;
    stc_eic00_eirr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_eirr_t;

/* EIRCR */
#define EIC00_EIRCR	(EIC00.unEIRCR.u32Register)  /*@rg@*/
#define EIC00_EIRCR_ERC0	(*(volatile uint_io8_t*)0xB0900080UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC1	(*(volatile uint_io8_t*)0xB0900081UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC2	(*(volatile uint_io8_t*)0xB0900082UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC3	(*(volatile uint_io8_t*)0xB0900083UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC4	(*(volatile uint_io8_t*)0xB0900084UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC5	(*(volatile uint_io8_t*)0xB0900085UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC6	(*(volatile uint_io8_t*)0xB0900086UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC7	(*(volatile uint_io8_t*)0xB0900087UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC8	(*(volatile uint_io8_t*)0xB0900088UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC9	(*(volatile uint_io8_t*)0xB0900089UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC10	(*(volatile uint_io8_t*)0xB090008AUL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC11	(*(volatile uint_io8_t*)0xB090008BUL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC12	(*(volatile uint_io8_t*)0xB090008CUL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC13	(*(volatile uint_io8_t*)0xB090008DUL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC14	(*(volatile uint_io8_t*)0xB090008EUL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC15	(*(volatile uint_io8_t*)0xB090008FUL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC16	(*(volatile uint_io8_t*)0xB0900090UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC17	(*(volatile uint_io8_t*)0xB0900091UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC18	(*(volatile uint_io8_t*)0xB0900092UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC19	(*(volatile uint_io8_t*)0xB0900093UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC20	(*(volatile uint_io8_t*)0xB0900094UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC21	(*(volatile uint_io8_t*)0xB0900095UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC22	(*(volatile uint_io8_t*)0xB0900096UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC23	(*(volatile uint_io8_t*)0xB0900097UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC24	(*(volatile uint_io8_t*)0xB0900098UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC25	(*(volatile uint_io8_t*)0xB0900099UL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC26	(*(volatile uint_io8_t*)0xB090009AUL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC27	(*(volatile uint_io8_t*)0xB090009BUL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC28	(*(volatile uint_io8_t*)0xB090009CUL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC29	(*(volatile uint_io8_t*)0xB090009DUL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC30	(*(volatile uint_io8_t*)0xB090009EUL)  /*@bfbba@*/
#define EIC00_EIRCR_ERC31	(*(volatile uint_io8_t*)0xB090009FUL)  /*@bfbba@*/

typedef struct stc_eic00_eircr_field{
    uint_io32_t		u1ERC0:1;
    uint_io32_t		u1ERC1:1;
    uint_io32_t		u1ERC2:1;
    uint_io32_t		u1ERC3:1;
    uint_io32_t		u1ERC4:1;
    uint_io32_t		u1ERC5:1;
    uint_io32_t		u1ERC6:1;
    uint_io32_t		u1ERC7:1;
    uint_io32_t		u1ERC8:1;
    uint_io32_t		u1ERC9:1;
    uint_io32_t		u1ERC10:1;
    uint_io32_t		u1ERC11:1;
    uint_io32_t		u1ERC12:1;
    uint_io32_t		u1ERC13:1;
    uint_io32_t		u1ERC14:1;
    uint_io32_t		u1ERC15:1;
    uint_io32_t		u1ERC16:1;
    uint_io32_t		u1ERC17:1;
    uint_io32_t		u1ERC18:1;
    uint_io32_t		u1ERC19:1;
    uint_io32_t		u1ERC20:1;
    uint_io32_t		u1ERC21:1;
    uint_io32_t		u1ERC22:1;
    uint_io32_t		u1ERC23:1;
    uint_io32_t		u1ERC24:1;
    uint_io32_t		u1ERC25:1;
    uint_io32_t		u1ERC26:1;
    uint_io32_t		u1ERC27:1;
    uint_io32_t		u1ERC28:1;
    uint_io32_t		u1ERC29:1;
    uint_io32_t		u1ERC30:1;
    uint_io32_t		u1ERC31:1;
}stc_eic00_eircr_field_t;

typedef union un_eic00_eircr{
    uint_io32_t		u32Register;
    stc_eic00_eircr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_eircr_t;

/* NFER */
#define EIC00_NFER	(EIC00.unNFER.u32Register)  /*@rg@*/
#define EIC00_NFER_NFE0	(*(volatile uint_io8_t*)0xB09000A0UL)  /*@bfbba@*/
#define EIC00_NFER_NFE1	(*(volatile uint_io8_t*)0xB09000A1UL)  /*@bfbba@*/
#define EIC00_NFER_NFE2	(*(volatile uint_io8_t*)0xB09000A2UL)  /*@bfbba@*/
#define EIC00_NFER_NFE3	(*(volatile uint_io8_t*)0xB09000A3UL)  /*@bfbba@*/
#define EIC00_NFER_NFE4	(*(volatile uint_io8_t*)0xB09000A4UL)  /*@bfbba@*/
#define EIC00_NFER_NFE5	(*(volatile uint_io8_t*)0xB09000A5UL)  /*@bfbba@*/
#define EIC00_NFER_NFE6	(*(volatile uint_io8_t*)0xB09000A6UL)  /*@bfbba@*/
#define EIC00_NFER_NFE7	(*(volatile uint_io8_t*)0xB09000A7UL)  /*@bfbba@*/
#define EIC00_NFER_NFE8	(*(volatile uint_io8_t*)0xB09000A8UL)  /*@bfbba@*/
#define EIC00_NFER_NFE9	(*(volatile uint_io8_t*)0xB09000A9UL)  /*@bfbba@*/
#define EIC00_NFER_NFE10	(*(volatile uint_io8_t*)0xB09000AAUL)  /*@bfbba@*/
#define EIC00_NFER_NFE11	(*(volatile uint_io8_t*)0xB09000ABUL)  /*@bfbba@*/
#define EIC00_NFER_NFE12	(*(volatile uint_io8_t*)0xB09000ACUL)  /*@bfbba@*/
#define EIC00_NFER_NFE13	(*(volatile uint_io8_t*)0xB09000ADUL)  /*@bfbba@*/
#define EIC00_NFER_NFE14	(*(volatile uint_io8_t*)0xB09000AEUL)  /*@bfbba@*/
#define EIC00_NFER_NFE15	(*(volatile uint_io8_t*)0xB09000AFUL)  /*@bfbba@*/
#define EIC00_NFER_NFE16	(*(volatile uint_io8_t*)0xB09000B0UL)  /*@bfbba@*/
#define EIC00_NFER_NFE17	(*(volatile uint_io8_t*)0xB09000B1UL)  /*@bfbba@*/
#define EIC00_NFER_NFE18	(*(volatile uint_io8_t*)0xB09000B2UL)  /*@bfbba@*/
#define EIC00_NFER_NFE19	(*(volatile uint_io8_t*)0xB09000B3UL)  /*@bfbba@*/
#define EIC00_NFER_NFE20	(*(volatile uint_io8_t*)0xB09000B4UL)  /*@bfbba@*/
#define EIC00_NFER_NFE21	(*(volatile uint_io8_t*)0xB09000B5UL)  /*@bfbba@*/
#define EIC00_NFER_NFE22	(*(volatile uint_io8_t*)0xB09000B6UL)  /*@bfbba@*/
#define EIC00_NFER_NFE23	(*(volatile uint_io8_t*)0xB09000B7UL)  /*@bfbba@*/
#define EIC00_NFER_NFE24	(*(volatile uint_io8_t*)0xB09000B8UL)  /*@bfbba@*/
#define EIC00_NFER_NFE25	(*(volatile uint_io8_t*)0xB09000B9UL)  /*@bfbba@*/
#define EIC00_NFER_NFE26	(*(volatile uint_io8_t*)0xB09000BAUL)  /*@bfbba@*/
#define EIC00_NFER_NFE27	(*(volatile uint_io8_t*)0xB09000BBUL)  /*@bfbba@*/
#define EIC00_NFER_NFE28	(*(volatile uint_io8_t*)0xB09000BCUL)  /*@bfbba@*/
#define EIC00_NFER_NFE29	(*(volatile uint_io8_t*)0xB09000BDUL)  /*@bfbba@*/
#define EIC00_NFER_NFE30	(*(volatile uint_io8_t*)0xB09000BEUL)  /*@bfbba@*/
#define EIC00_NFER_NFE31	(*(volatile uint_io8_t*)0xB09000BFUL)  /*@bfbba@*/

typedef struct stc_eic00_nfer_field{
    uint_io32_t		u1NFE0:1;
    uint_io32_t		u1NFE1:1;
    uint_io32_t		u1NFE2:1;
    uint_io32_t		u1NFE3:1;
    uint_io32_t		u1NFE4:1;
    uint_io32_t		u1NFE5:1;
    uint_io32_t		u1NFE6:1;
    uint_io32_t		u1NFE7:1;
    uint_io32_t		u1NFE8:1;
    uint_io32_t		u1NFE9:1;
    uint_io32_t		u1NFE10:1;
    uint_io32_t		u1NFE11:1;
    uint_io32_t		u1NFE12:1;
    uint_io32_t		u1NFE13:1;
    uint_io32_t		u1NFE14:1;
    uint_io32_t		u1NFE15:1;
    uint_io32_t		u1NFE16:1;
    uint_io32_t		u1NFE17:1;
    uint_io32_t		u1NFE18:1;
    uint_io32_t		u1NFE19:1;
    uint_io32_t		u1NFE20:1;
    uint_io32_t		u1NFE21:1;
    uint_io32_t		u1NFE22:1;
    uint_io32_t		u1NFE23:1;
    uint_io32_t		u1NFE24:1;
    uint_io32_t		u1NFE25:1;
    uint_io32_t		u1NFE26:1;
    uint_io32_t		u1NFE27:1;
    uint_io32_t		u1NFE28:1;
    uint_io32_t		u1NFE29:1;
    uint_io32_t		u1NFE30:1;
    uint_io32_t		u1NFE31:1;
}stc_eic00_nfer_field_t;

typedef union un_eic00_nfer{
    uint_io32_t		u32Register;
    stc_eic00_nfer_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_nfer_t;

/* NFESR */
#define EIC00_NFESR	(EIC00.unNFESR.u32Register)  /*@rg@*/
#define EIC00_NFESR_NFES0	(*(volatile uint_io8_t*)0xB09000C0UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES1	(*(volatile uint_io8_t*)0xB09000C1UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES2	(*(volatile uint_io8_t*)0xB09000C2UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES3	(*(volatile uint_io8_t*)0xB09000C3UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES4	(*(volatile uint_io8_t*)0xB09000C4UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES5	(*(volatile uint_io8_t*)0xB09000C5UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES6	(*(volatile uint_io8_t*)0xB09000C6UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES7	(*(volatile uint_io8_t*)0xB09000C7UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES8	(*(volatile uint_io8_t*)0xB09000C8UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES9	(*(volatile uint_io8_t*)0xB09000C9UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES10	(*(volatile uint_io8_t*)0xB09000CAUL)  /*@bfbba@*/
#define EIC00_NFESR_NFES11	(*(volatile uint_io8_t*)0xB09000CBUL)  /*@bfbba@*/
#define EIC00_NFESR_NFES12	(*(volatile uint_io8_t*)0xB09000CCUL)  /*@bfbba@*/
#define EIC00_NFESR_NFES13	(*(volatile uint_io8_t*)0xB09000CDUL)  /*@bfbba@*/
#define EIC00_NFESR_NFES14	(*(volatile uint_io8_t*)0xB09000CEUL)  /*@bfbba@*/
#define EIC00_NFESR_NFES15	(*(volatile uint_io8_t*)0xB09000CFUL)  /*@bfbba@*/
#define EIC00_NFESR_NFES16	(*(volatile uint_io8_t*)0xB09000D0UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES17	(*(volatile uint_io8_t*)0xB09000D1UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES18	(*(volatile uint_io8_t*)0xB09000D2UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES19	(*(volatile uint_io8_t*)0xB09000D3UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES20	(*(volatile uint_io8_t*)0xB09000D4UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES21	(*(volatile uint_io8_t*)0xB09000D5UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES22	(*(volatile uint_io8_t*)0xB09000D6UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES23	(*(volatile uint_io8_t*)0xB09000D7UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES24	(*(volatile uint_io8_t*)0xB09000D8UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES25	(*(volatile uint_io8_t*)0xB09000D9UL)  /*@bfbba@*/
#define EIC00_NFESR_NFES26	(*(volatile uint_io8_t*)0xB09000DAUL)  /*@bfbba@*/
#define EIC00_NFESR_NFES27	(*(volatile uint_io8_t*)0xB09000DBUL)  /*@bfbba@*/
#define EIC00_NFESR_NFES28	(*(volatile uint_io8_t*)0xB09000DCUL)  /*@bfbba@*/
#define EIC00_NFESR_NFES29	(*(volatile uint_io8_t*)0xB09000DDUL)  /*@bfbba@*/
#define EIC00_NFESR_NFES30	(*(volatile uint_io8_t*)0xB09000DEUL)  /*@bfbba@*/
#define EIC00_NFESR_NFES31	(*(volatile uint_io8_t*)0xB09000DFUL)  /*@bfbba@*/

typedef struct stc_eic00_nfesr_field{
    uint_io32_t		u1NFES0:1;
    uint_io32_t		u1NFES1:1;
    uint_io32_t		u1NFES2:1;
    uint_io32_t		u1NFES3:1;
    uint_io32_t		u1NFES4:1;
    uint_io32_t		u1NFES5:1;
    uint_io32_t		u1NFES6:1;
    uint_io32_t		u1NFES7:1;
    uint_io32_t		u1NFES8:1;
    uint_io32_t		u1NFES9:1;
    uint_io32_t		u1NFES10:1;
    uint_io32_t		u1NFES11:1;
    uint_io32_t		u1NFES12:1;
    uint_io32_t		u1NFES13:1;
    uint_io32_t		u1NFES14:1;
    uint_io32_t		u1NFES15:1;
    uint_io32_t		u1NFES16:1;
    uint_io32_t		u1NFES17:1;
    uint_io32_t		u1NFES18:1;
    uint_io32_t		u1NFES19:1;
    uint_io32_t		u1NFES20:1;
    uint_io32_t		u1NFES21:1;
    uint_io32_t		u1NFES22:1;
    uint_io32_t		u1NFES23:1;
    uint_io32_t		u1NFES24:1;
    uint_io32_t		u1NFES25:1;
    uint_io32_t		u1NFES26:1;
    uint_io32_t		u1NFES27:1;
    uint_io32_t		u1NFES28:1;
    uint_io32_t		u1NFES29:1;
    uint_io32_t		u1NFES30:1;
    uint_io32_t		u1NFES31:1;
}stc_eic00_nfesr_field_t;

typedef union un_eic00_nfesr{
    uint_io32_t		u32Register;
    stc_eic00_nfesr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_nfesr_t;

/* NFECR */
#define EIC00_NFECR	(EIC00.unNFECR.u32Register)  /*@rg@*/
#define EIC00_NFECR_NFEC0	(*(volatile uint_io8_t*)0xB09000E0UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC1	(*(volatile uint_io8_t*)0xB09000E1UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC2	(*(volatile uint_io8_t*)0xB09000E2UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC3	(*(volatile uint_io8_t*)0xB09000E3UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC4	(*(volatile uint_io8_t*)0xB09000E4UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC5	(*(volatile uint_io8_t*)0xB09000E5UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC6	(*(volatile uint_io8_t*)0xB09000E6UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC7	(*(volatile uint_io8_t*)0xB09000E7UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC8	(*(volatile uint_io8_t*)0xB09000E8UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC9	(*(volatile uint_io8_t*)0xB09000E9UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC10	(*(volatile uint_io8_t*)0xB09000EAUL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC11	(*(volatile uint_io8_t*)0xB09000EBUL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC12	(*(volatile uint_io8_t*)0xB09000ECUL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC13	(*(volatile uint_io8_t*)0xB09000EDUL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC14	(*(volatile uint_io8_t*)0xB09000EEUL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC15	(*(volatile uint_io8_t*)0xB09000EFUL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC16	(*(volatile uint_io8_t*)0xB09000F0UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC17	(*(volatile uint_io8_t*)0xB09000F1UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC18	(*(volatile uint_io8_t*)0xB09000F2UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC19	(*(volatile uint_io8_t*)0xB09000F3UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC20	(*(volatile uint_io8_t*)0xB09000F4UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC21	(*(volatile uint_io8_t*)0xB09000F5UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC22	(*(volatile uint_io8_t*)0xB09000F6UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC23	(*(volatile uint_io8_t*)0xB09000F7UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC24	(*(volatile uint_io8_t*)0xB09000F8UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC25	(*(volatile uint_io8_t*)0xB09000F9UL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC26	(*(volatile uint_io8_t*)0xB09000FAUL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC27	(*(volatile uint_io8_t*)0xB09000FBUL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC28	(*(volatile uint_io8_t*)0xB09000FCUL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC29	(*(volatile uint_io8_t*)0xB09000FDUL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC30	(*(volatile uint_io8_t*)0xB09000FEUL)  /*@bfbba@*/
#define EIC00_NFECR_NFEC31	(*(volatile uint_io8_t*)0xB09000FFUL)  /*@bfbba@*/

typedef struct stc_eic00_nfecr_field{
    uint_io32_t		u1NFEC0:1;
    uint_io32_t		u1NFEC1:1;
    uint_io32_t		u1NFEC2:1;
    uint_io32_t		u1NFEC3:1;
    uint_io32_t		u1NFEC4:1;
    uint_io32_t		u1NFEC5:1;
    uint_io32_t		u1NFEC6:1;
    uint_io32_t		u1NFEC7:1;
    uint_io32_t		u1NFEC8:1;
    uint_io32_t		u1NFEC9:1;
    uint_io32_t		u1NFEC10:1;
    uint_io32_t		u1NFEC11:1;
    uint_io32_t		u1NFEC12:1;
    uint_io32_t		u1NFEC13:1;
    uint_io32_t		u1NFEC14:1;
    uint_io32_t		u1NFEC15:1;
    uint_io32_t		u1NFEC16:1;
    uint_io32_t		u1NFEC17:1;
    uint_io32_t		u1NFEC18:1;
    uint_io32_t		u1NFEC19:1;
    uint_io32_t		u1NFEC20:1;
    uint_io32_t		u1NFEC21:1;
    uint_io32_t		u1NFEC22:1;
    uint_io32_t		u1NFEC23:1;
    uint_io32_t		u1NFEC24:1;
    uint_io32_t		u1NFEC25:1;
    uint_io32_t		u1NFEC26:1;
    uint_io32_t		u1NFEC27:1;
    uint_io32_t		u1NFEC28:1;
    uint_io32_t		u1NFEC29:1;
    uint_io32_t		u1NFEC30:1;
    uint_io32_t		u1NFEC31:1;
}stc_eic00_nfecr_field_t;

typedef union un_eic00_nfecr{
    uint_io32_t		u32Register;
    stc_eic00_nfecr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_nfecr_t;

/* ELVR[0-3] */
#define EIC00_ELVR0	(EIC00.unELVR0.u32Register)  /*@rg@*/
#define EIC00_ELVR0_LA0	(*(volatile uint_io8_t*)0xB0900100UL)  /*@bfbba@*/
#define EIC00_ELVR0_LB0	(*(volatile uint_io8_t*)0xB0900101UL)  /*@bfbba@*/
#define EIC00_ELVR0_LC0	(*(volatile uint_io8_t*)0xB0900102UL)  /*@bfbba@*/
#define EIC00_ELVR0_LA1	(*(volatile uint_io8_t*)0xB0900104UL)  /*@bfbba@*/
#define EIC00_ELVR0_LB1	(*(volatile uint_io8_t*)0xB0900105UL)  /*@bfbba@*/
#define EIC00_ELVR0_LC1	(*(volatile uint_io8_t*)0xB0900106UL)  /*@bfbba@*/
#define EIC00_ELVR0_LA2	(*(volatile uint_io8_t*)0xB0900108UL)  /*@bfbba@*/
#define EIC00_ELVR0_LB2	(*(volatile uint_io8_t*)0xB0900109UL)  /*@bfbba@*/
#define EIC00_ELVR0_LC2	(*(volatile uint_io8_t*)0xB090010AUL)  /*@bfbba@*/
#define EIC00_ELVR0_LA3	(*(volatile uint_io8_t*)0xB090010CUL)  /*@bfbba@*/
#define EIC00_ELVR0_LB3	(*(volatile uint_io8_t*)0xB090010DUL)  /*@bfbba@*/
#define EIC00_ELVR0_LC3	(*(volatile uint_io8_t*)0xB090010EUL)  /*@bfbba@*/
#define EIC00_ELVR0_LA4	(*(volatile uint_io8_t*)0xB0900110UL)  /*@bfbba@*/
#define EIC00_ELVR0_LB4	(*(volatile uint_io8_t*)0xB0900111UL)  /*@bfbba@*/
#define EIC00_ELVR0_LC4	(*(volatile uint_io8_t*)0xB0900112UL)  /*@bfbba@*/
#define EIC00_ELVR0_LA5	(*(volatile uint_io8_t*)0xB0900114UL)  /*@bfbba@*/
#define EIC00_ELVR0_LB5	(*(volatile uint_io8_t*)0xB0900115UL)  /*@bfbba@*/
#define EIC00_ELVR0_LC5	(*(volatile uint_io8_t*)0xB0900116UL)  /*@bfbba@*/
#define EIC00_ELVR0_LA6	(*(volatile uint_io8_t*)0xB0900118UL)  /*@bfbba@*/
#define EIC00_ELVR0_LB6	(*(volatile uint_io8_t*)0xB0900119UL)  /*@bfbba@*/
#define EIC00_ELVR0_LC6	(*(volatile uint_io8_t*)0xB090011AUL)  /*@bfbba@*/
#define EIC00_ELVR0_LA7	(*(volatile uint_io8_t*)0xB090011CUL)  /*@bfbba@*/
#define EIC00_ELVR0_LB7	(*(volatile uint_io8_t*)0xB090011DUL)  /*@bfbba@*/
#define EIC00_ELVR0_LC7	(*(volatile uint_io8_t*)0xB090011EUL)  /*@bfbba@*/

#define EIC00_ELVR1	(EIC00.unELVR1.u32Register)  /*@rg@*/
#define EIC00_ELVR1_LA0	(*(volatile uint_io8_t*)0xB0900120UL)  /*@bfbba@*/
#define EIC00_ELVR1_LB0	(*(volatile uint_io8_t*)0xB0900121UL)  /*@bfbba@*/
#define EIC00_ELVR1_LC0	(*(volatile uint_io8_t*)0xB0900122UL)  /*@bfbba@*/
#define EIC00_ELVR1_LA1	(*(volatile uint_io8_t*)0xB0900124UL)  /*@bfbba@*/
#define EIC00_ELVR1_LB1	(*(volatile uint_io8_t*)0xB0900125UL)  /*@bfbba@*/
#define EIC00_ELVR1_LC1	(*(volatile uint_io8_t*)0xB0900126UL)  /*@bfbba@*/
#define EIC00_ELVR1_LA2	(*(volatile uint_io8_t*)0xB0900128UL)  /*@bfbba@*/
#define EIC00_ELVR1_LB2	(*(volatile uint_io8_t*)0xB0900129UL)  /*@bfbba@*/
#define EIC00_ELVR1_LC2	(*(volatile uint_io8_t*)0xB090012AUL)  /*@bfbba@*/
#define EIC00_ELVR1_LA3	(*(volatile uint_io8_t*)0xB090012CUL)  /*@bfbba@*/
#define EIC00_ELVR1_LB3	(*(volatile uint_io8_t*)0xB090012DUL)  /*@bfbba@*/
#define EIC00_ELVR1_LC3	(*(volatile uint_io8_t*)0xB090012EUL)  /*@bfbba@*/
#define EIC00_ELVR1_LA4	(*(volatile uint_io8_t*)0xB0900130UL)  /*@bfbba@*/
#define EIC00_ELVR1_LB4	(*(volatile uint_io8_t*)0xB0900131UL)  /*@bfbba@*/
#define EIC00_ELVR1_LC4	(*(volatile uint_io8_t*)0xB0900132UL)  /*@bfbba@*/
#define EIC00_ELVR1_LA5	(*(volatile uint_io8_t*)0xB0900134UL)  /*@bfbba@*/
#define EIC00_ELVR1_LB5	(*(volatile uint_io8_t*)0xB0900135UL)  /*@bfbba@*/
#define EIC00_ELVR1_LC5	(*(volatile uint_io8_t*)0xB0900136UL)  /*@bfbba@*/
#define EIC00_ELVR1_LA6	(*(volatile uint_io8_t*)0xB0900138UL)  /*@bfbba@*/
#define EIC00_ELVR1_LB6	(*(volatile uint_io8_t*)0xB0900139UL)  /*@bfbba@*/
#define EIC00_ELVR1_LC6	(*(volatile uint_io8_t*)0xB090013AUL)  /*@bfbba@*/
#define EIC00_ELVR1_LA7	(*(volatile uint_io8_t*)0xB090013CUL)  /*@bfbba@*/
#define EIC00_ELVR1_LB7	(*(volatile uint_io8_t*)0xB090013DUL)  /*@bfbba@*/
#define EIC00_ELVR1_LC7	(*(volatile uint_io8_t*)0xB090013EUL)  /*@bfbba@*/

#define EIC00_ELVR2	(EIC00.unELVR2.u32Register)  /*@rg@*/
#define EIC00_ELVR2_LA0	(*(volatile uint_io8_t*)0xB0900140UL)  /*@bfbba@*/
#define EIC00_ELVR2_LB0	(*(volatile uint_io8_t*)0xB0900141UL)  /*@bfbba@*/
#define EIC00_ELVR2_LC0	(*(volatile uint_io8_t*)0xB0900142UL)  /*@bfbba@*/
#define EIC00_ELVR2_LA1	(*(volatile uint_io8_t*)0xB0900144UL)  /*@bfbba@*/
#define EIC00_ELVR2_LB1	(*(volatile uint_io8_t*)0xB0900145UL)  /*@bfbba@*/
#define EIC00_ELVR2_LC1	(*(volatile uint_io8_t*)0xB0900146UL)  /*@bfbba@*/
#define EIC00_ELVR2_LA2	(*(volatile uint_io8_t*)0xB0900148UL)  /*@bfbba@*/
#define EIC00_ELVR2_LB2	(*(volatile uint_io8_t*)0xB0900149UL)  /*@bfbba@*/
#define EIC00_ELVR2_LC2	(*(volatile uint_io8_t*)0xB090014AUL)  /*@bfbba@*/
#define EIC00_ELVR2_LA3	(*(volatile uint_io8_t*)0xB090014CUL)  /*@bfbba@*/
#define EIC00_ELVR2_LB3	(*(volatile uint_io8_t*)0xB090014DUL)  /*@bfbba@*/
#define EIC00_ELVR2_LC3	(*(volatile uint_io8_t*)0xB090014EUL)  /*@bfbba@*/
#define EIC00_ELVR2_LA4	(*(volatile uint_io8_t*)0xB0900150UL)  /*@bfbba@*/
#define EIC00_ELVR2_LB4	(*(volatile uint_io8_t*)0xB0900151UL)  /*@bfbba@*/
#define EIC00_ELVR2_LC4	(*(volatile uint_io8_t*)0xB0900152UL)  /*@bfbba@*/
#define EIC00_ELVR2_LA5	(*(volatile uint_io8_t*)0xB0900154UL)  /*@bfbba@*/
#define EIC00_ELVR2_LB5	(*(volatile uint_io8_t*)0xB0900155UL)  /*@bfbba@*/
#define EIC00_ELVR2_LC5	(*(volatile uint_io8_t*)0xB0900156UL)  /*@bfbba@*/
#define EIC00_ELVR2_LA6	(*(volatile uint_io8_t*)0xB0900158UL)  /*@bfbba@*/
#define EIC00_ELVR2_LB6	(*(volatile uint_io8_t*)0xB0900159UL)  /*@bfbba@*/
#define EIC00_ELVR2_LC6	(*(volatile uint_io8_t*)0xB090015AUL)  /*@bfbba@*/
#define EIC00_ELVR2_LA7	(*(volatile uint_io8_t*)0xB090015CUL)  /*@bfbba@*/
#define EIC00_ELVR2_LB7	(*(volatile uint_io8_t*)0xB090015DUL)  /*@bfbba@*/
#define EIC00_ELVR2_LC7	(*(volatile uint_io8_t*)0xB090015EUL)  /*@bfbba@*/

#define EIC00_ELVR3	(EIC00.unELVR3.u32Register)  /*@rg@*/
#define EIC00_ELVR3_LA0	(*(volatile uint_io8_t*)0xB0900160UL)  /*@bfbba@*/
#define EIC00_ELVR3_LB0	(*(volatile uint_io8_t*)0xB0900161UL)  /*@bfbba@*/
#define EIC00_ELVR3_LC0	(*(volatile uint_io8_t*)0xB0900162UL)  /*@bfbba@*/
#define EIC00_ELVR3_LA1	(*(volatile uint_io8_t*)0xB0900164UL)  /*@bfbba@*/
#define EIC00_ELVR3_LB1	(*(volatile uint_io8_t*)0xB0900165UL)  /*@bfbba@*/
#define EIC00_ELVR3_LC1	(*(volatile uint_io8_t*)0xB0900166UL)  /*@bfbba@*/
#define EIC00_ELVR3_LA2	(*(volatile uint_io8_t*)0xB0900168UL)  /*@bfbba@*/
#define EIC00_ELVR3_LB2	(*(volatile uint_io8_t*)0xB0900169UL)  /*@bfbba@*/
#define EIC00_ELVR3_LC2	(*(volatile uint_io8_t*)0xB090016AUL)  /*@bfbba@*/
#define EIC00_ELVR3_LA3	(*(volatile uint_io8_t*)0xB090016CUL)  /*@bfbba@*/
#define EIC00_ELVR3_LB3	(*(volatile uint_io8_t*)0xB090016DUL)  /*@bfbba@*/
#define EIC00_ELVR3_LC3	(*(volatile uint_io8_t*)0xB090016EUL)  /*@bfbba@*/
#define EIC00_ELVR3_LA4	(*(volatile uint_io8_t*)0xB0900170UL)  /*@bfbba@*/
#define EIC00_ELVR3_LB4	(*(volatile uint_io8_t*)0xB0900171UL)  /*@bfbba@*/
#define EIC00_ELVR3_LC4	(*(volatile uint_io8_t*)0xB0900172UL)  /*@bfbba@*/
#define EIC00_ELVR3_LA5	(*(volatile uint_io8_t*)0xB0900174UL)  /*@bfbba@*/
#define EIC00_ELVR3_LB5	(*(volatile uint_io8_t*)0xB0900175UL)  /*@bfbba@*/
#define EIC00_ELVR3_LC5	(*(volatile uint_io8_t*)0xB0900176UL)  /*@bfbba@*/
#define EIC00_ELVR3_LA6	(*(volatile uint_io8_t*)0xB0900178UL)  /*@bfbba@*/
#define EIC00_ELVR3_LB6	(*(volatile uint_io8_t*)0xB0900179UL)  /*@bfbba@*/
#define EIC00_ELVR3_LC6	(*(volatile uint_io8_t*)0xB090017AUL)  /*@bfbba@*/
#define EIC00_ELVR3_LA7	(*(volatile uint_io8_t*)0xB090017CUL)  /*@bfbba@*/
#define EIC00_ELVR3_LB7	(*(volatile uint_io8_t*)0xB090017DUL)  /*@bfbba@*/
#define EIC00_ELVR3_LC7	(*(volatile uint_io8_t*)0xB090017EUL)  /*@bfbba@*/

typedef struct stc_eic00_elvrn_field{
    uint_io32_t		u1LA0:1;
    uint_io32_t		u1LB0:1;
    uint_io32_t		u1LC0:1;
    uint_io32_t		:1;
    uint_io32_t		u1LA1:1;
    uint_io32_t		u1LB1:1;
    uint_io32_t		u1LC1:1;
    uint_io32_t		:1;
    uint_io32_t		u1LA2:1;
    uint_io32_t		u1LB2:1;
    uint_io32_t		u1LC2:1;
    uint_io32_t		:1;
    uint_io32_t		u1LA3:1;
    uint_io32_t		u1LB3:1;
    uint_io32_t		u1LC3:1;
    uint_io32_t		:1;
    uint_io32_t		u1LA4:1;
    uint_io32_t		u1LB4:1;
    uint_io32_t		u1LC4:1;
    uint_io32_t		:1;
    uint_io32_t		u1LA5:1;
    uint_io32_t		u1LB5:1;
    uint_io32_t		u1LC5:1;
    uint_io32_t		:1;
    uint_io32_t		u1LA6:1;
    uint_io32_t		u1LB6:1;
    uint_io32_t		u1LC6:1;
    uint_io32_t		:1;
    uint_io32_t		u1LA7:1;
    uint_io32_t		u1LB7:1;
    uint_io32_t		u1LC7:1;
    uint_io32_t		:1;
}stc_eic00_elvrn_field_t;

typedef union un_eic00_elvrn{
    uint_io32_t		u32Register;
    stc_eic00_elvrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_elvrn_t;

/* NMIR */
#define EIC00_NMIR	(EIC00.unNMIR.u32Register)  /*@rg@*/
#define EIC00_NMIR_NMIINT	(*(volatile uint_io8_t*)0xB0900180UL)  /*@bfbba@*/
#define EIC00_NMIR_NMICLR	(*(volatile uint_io8_t*)0xB0900188UL)  /*@bfbba@*/

typedef struct stc_eic00_nmir_field{
    uint_io32_t		u1NMIINT:1;
    uint_io32_t		:7;
    uint_io32_t		u1NMICLR:1;
    uint_io32_t		:23;
}stc_eic00_nmir_field_t;

typedef union un_eic00_nmir{
    uint_io32_t		u32Register;
    stc_eic00_nmir_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_nmir_t;

/* DRER */
#define EIC00_DRER	(EIC00.unDRER.u32Register)  /*@rg@*/
#define EIC00_DRER_DRE0	(*(volatile uint_io8_t*)0xB09001A0UL)  /*@bfbba@*/
#define EIC00_DRER_DRE1	(*(volatile uint_io8_t*)0xB09001A1UL)  /*@bfbba@*/
#define EIC00_DRER_DRE2	(*(volatile uint_io8_t*)0xB09001A2UL)  /*@bfbba@*/
#define EIC00_DRER_DRE3	(*(volatile uint_io8_t*)0xB09001A3UL)  /*@bfbba@*/
#define EIC00_DRER_DRE4	(*(volatile uint_io8_t*)0xB09001A4UL)  /*@bfbba@*/
#define EIC00_DRER_DRE5	(*(volatile uint_io8_t*)0xB09001A5UL)  /*@bfbba@*/
#define EIC00_DRER_DRE6	(*(volatile uint_io8_t*)0xB09001A6UL)  /*@bfbba@*/
#define EIC00_DRER_DRE7	(*(volatile uint_io8_t*)0xB09001A7UL)  /*@bfbba@*/
#define EIC00_DRER_DRE8	(*(volatile uint_io8_t*)0xB09001A8UL)  /*@bfbba@*/
#define EIC00_DRER_DRE9	(*(volatile uint_io8_t*)0xB09001A9UL)  /*@bfbba@*/
#define EIC00_DRER_DRE10	(*(volatile uint_io8_t*)0xB09001AAUL)  /*@bfbba@*/
#define EIC00_DRER_DRE11	(*(volatile uint_io8_t*)0xB09001ABUL)  /*@bfbba@*/
#define EIC00_DRER_DRE12	(*(volatile uint_io8_t*)0xB09001ACUL)  /*@bfbba@*/
#define EIC00_DRER_DRE13	(*(volatile uint_io8_t*)0xB09001ADUL)  /*@bfbba@*/
#define EIC00_DRER_DRE14	(*(volatile uint_io8_t*)0xB09001AEUL)  /*@bfbba@*/
#define EIC00_DRER_DRE15	(*(volatile uint_io8_t*)0xB09001AFUL)  /*@bfbba@*/
#define EIC00_DRER_DRE16	(*(volatile uint_io8_t*)0xB09001B0UL)  /*@bfbba@*/
#define EIC00_DRER_DRE17	(*(volatile uint_io8_t*)0xB09001B1UL)  /*@bfbba@*/
#define EIC00_DRER_DRE18	(*(volatile uint_io8_t*)0xB09001B2UL)  /*@bfbba@*/
#define EIC00_DRER_DRE19	(*(volatile uint_io8_t*)0xB09001B3UL)  /*@bfbba@*/
#define EIC00_DRER_DRE20	(*(volatile uint_io8_t*)0xB09001B4UL)  /*@bfbba@*/
#define EIC00_DRER_DRE21	(*(volatile uint_io8_t*)0xB09001B5UL)  /*@bfbba@*/
#define EIC00_DRER_DRE22	(*(volatile uint_io8_t*)0xB09001B6UL)  /*@bfbba@*/
#define EIC00_DRER_DRE23	(*(volatile uint_io8_t*)0xB09001B7UL)  /*@bfbba@*/
#define EIC00_DRER_DRE24	(*(volatile uint_io8_t*)0xB09001B8UL)  /*@bfbba@*/
#define EIC00_DRER_DRE25	(*(volatile uint_io8_t*)0xB09001B9UL)  /*@bfbba@*/
#define EIC00_DRER_DRE26	(*(volatile uint_io8_t*)0xB09001BAUL)  /*@bfbba@*/
#define EIC00_DRER_DRE27	(*(volatile uint_io8_t*)0xB09001BBUL)  /*@bfbba@*/
#define EIC00_DRER_DRE28	(*(volatile uint_io8_t*)0xB09001BCUL)  /*@bfbba@*/
#define EIC00_DRER_DRE29	(*(volatile uint_io8_t*)0xB09001BDUL)  /*@bfbba@*/
#define EIC00_DRER_DRE30	(*(volatile uint_io8_t*)0xB09001BEUL)  /*@bfbba@*/
#define EIC00_DRER_DRE31	(*(volatile uint_io8_t*)0xB09001BFUL)  /*@bfbba@*/

typedef struct stc_eic00_drer_field{
    uint_io32_t		u1DRE0:1;
    uint_io32_t		u1DRE1:1;
    uint_io32_t		u1DRE2:1;
    uint_io32_t		u1DRE3:1;
    uint_io32_t		u1DRE4:1;
    uint_io32_t		u1DRE5:1;
    uint_io32_t		u1DRE6:1;
    uint_io32_t		u1DRE7:1;
    uint_io32_t		u1DRE8:1;
    uint_io32_t		u1DRE9:1;
    uint_io32_t		u1DRE10:1;
    uint_io32_t		u1DRE11:1;
    uint_io32_t		u1DRE12:1;
    uint_io32_t		u1DRE13:1;
    uint_io32_t		u1DRE14:1;
    uint_io32_t		u1DRE15:1;
    uint_io32_t		u1DRE16:1;
    uint_io32_t		u1DRE17:1;
    uint_io32_t		u1DRE18:1;
    uint_io32_t		u1DRE19:1;
    uint_io32_t		u1DRE20:1;
    uint_io32_t		u1DRE21:1;
    uint_io32_t		u1DRE22:1;
    uint_io32_t		u1DRE23:1;
    uint_io32_t		u1DRE24:1;
    uint_io32_t		u1DRE25:1;
    uint_io32_t		u1DRE26:1;
    uint_io32_t		u1DRE27:1;
    uint_io32_t		u1DRE28:1;
    uint_io32_t		u1DRE29:1;
    uint_io32_t		u1DRE30:1;
    uint_io32_t		u1DRE31:1;
}stc_eic00_drer_field_t;

typedef union un_eic00_drer{
    uint_io32_t		u32Register;
    stc_eic00_drer_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_drer_t;

/* DRESR */
#define EIC00_DRESR	(EIC00.unDRESR.u32Register)  /*@rg@*/
#define EIC00_DRESR_DRES0	(*(volatile uint_io8_t*)0xB09001C0UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES1	(*(volatile uint_io8_t*)0xB09001C1UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES2	(*(volatile uint_io8_t*)0xB09001C2UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES3	(*(volatile uint_io8_t*)0xB09001C3UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES4	(*(volatile uint_io8_t*)0xB09001C4UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES5	(*(volatile uint_io8_t*)0xB09001C5UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES6	(*(volatile uint_io8_t*)0xB09001C6UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES7	(*(volatile uint_io8_t*)0xB09001C7UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES8	(*(volatile uint_io8_t*)0xB09001C8UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES9	(*(volatile uint_io8_t*)0xB09001C9UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES10	(*(volatile uint_io8_t*)0xB09001CAUL)  /*@bfbba@*/
#define EIC00_DRESR_DRES11	(*(volatile uint_io8_t*)0xB09001CBUL)  /*@bfbba@*/
#define EIC00_DRESR_DRES12	(*(volatile uint_io8_t*)0xB09001CCUL)  /*@bfbba@*/
#define EIC00_DRESR_DRES13	(*(volatile uint_io8_t*)0xB09001CDUL)  /*@bfbba@*/
#define EIC00_DRESR_DRES14	(*(volatile uint_io8_t*)0xB09001CEUL)  /*@bfbba@*/
#define EIC00_DRESR_DRES15	(*(volatile uint_io8_t*)0xB09001CFUL)  /*@bfbba@*/
#define EIC00_DRESR_DRES16	(*(volatile uint_io8_t*)0xB09001D0UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES17	(*(volatile uint_io8_t*)0xB09001D1UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES18	(*(volatile uint_io8_t*)0xB09001D2UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES19	(*(volatile uint_io8_t*)0xB09001D3UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES20	(*(volatile uint_io8_t*)0xB09001D4UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES21	(*(volatile uint_io8_t*)0xB09001D5UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES22	(*(volatile uint_io8_t*)0xB09001D6UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES23	(*(volatile uint_io8_t*)0xB09001D7UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES24	(*(volatile uint_io8_t*)0xB09001D8UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES25	(*(volatile uint_io8_t*)0xB09001D9UL)  /*@bfbba@*/
#define EIC00_DRESR_DRES26	(*(volatile uint_io8_t*)0xB09001DAUL)  /*@bfbba@*/
#define EIC00_DRESR_DRES27	(*(volatile uint_io8_t*)0xB09001DBUL)  /*@bfbba@*/
#define EIC00_DRESR_DRES28	(*(volatile uint_io8_t*)0xB09001DCUL)  /*@bfbba@*/
#define EIC00_DRESR_DRES29	(*(volatile uint_io8_t*)0xB09001DDUL)  /*@bfbba@*/
#define EIC00_DRESR_DRES30	(*(volatile uint_io8_t*)0xB09001DEUL)  /*@bfbba@*/
#define EIC00_DRESR_DRES31	(*(volatile uint_io8_t*)0xB09001DFUL)  /*@bfbba@*/

typedef struct stc_eic00_dresr_field{
    uint_io32_t		u1DRES0:1;
    uint_io32_t		u1DRES1:1;
    uint_io32_t		u1DRES2:1;
    uint_io32_t		u1DRES3:1;
    uint_io32_t		u1DRES4:1;
    uint_io32_t		u1DRES5:1;
    uint_io32_t		u1DRES6:1;
    uint_io32_t		u1DRES7:1;
    uint_io32_t		u1DRES8:1;
    uint_io32_t		u1DRES9:1;
    uint_io32_t		u1DRES10:1;
    uint_io32_t		u1DRES11:1;
    uint_io32_t		u1DRES12:1;
    uint_io32_t		u1DRES13:1;
    uint_io32_t		u1DRES14:1;
    uint_io32_t		u1DRES15:1;
    uint_io32_t		u1DRES16:1;
    uint_io32_t		u1DRES17:1;
    uint_io32_t		u1DRES18:1;
    uint_io32_t		u1DRES19:1;
    uint_io32_t		u1DRES20:1;
    uint_io32_t		u1DRES21:1;
    uint_io32_t		u1DRES22:1;
    uint_io32_t		u1DRES23:1;
    uint_io32_t		u1DRES24:1;
    uint_io32_t		u1DRES25:1;
    uint_io32_t		u1DRES26:1;
    uint_io32_t		u1DRES27:1;
    uint_io32_t		u1DRES28:1;
    uint_io32_t		u1DRES29:1;
    uint_io32_t		u1DRES30:1;
    uint_io32_t		u1DRES31:1;
}stc_eic00_dresr_field_t;

typedef union un_eic00_dresr{
    uint_io32_t		u32Register;
    stc_eic00_dresr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_dresr_t;

/* DRECR */
#define EIC00_DRECR	(EIC00.unDRECR.u32Register)  /*@rg@*/
#define EIC00_DRECR_DREC0	(*(volatile uint_io8_t*)0xB09001E0UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC1	(*(volatile uint_io8_t*)0xB09001E1UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC2	(*(volatile uint_io8_t*)0xB09001E2UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC3	(*(volatile uint_io8_t*)0xB09001E3UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC4	(*(volatile uint_io8_t*)0xB09001E4UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC5	(*(volatile uint_io8_t*)0xB09001E5UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC6	(*(volatile uint_io8_t*)0xB09001E6UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC7	(*(volatile uint_io8_t*)0xB09001E7UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC8	(*(volatile uint_io8_t*)0xB09001E8UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC9	(*(volatile uint_io8_t*)0xB09001E9UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC10	(*(volatile uint_io8_t*)0xB09001EAUL)  /*@bfbba@*/
#define EIC00_DRECR_DREC11	(*(volatile uint_io8_t*)0xB09001EBUL)  /*@bfbba@*/
#define EIC00_DRECR_DREC12	(*(volatile uint_io8_t*)0xB09001ECUL)  /*@bfbba@*/
#define EIC00_DRECR_DREC13	(*(volatile uint_io8_t*)0xB09001EDUL)  /*@bfbba@*/
#define EIC00_DRECR_DREC14	(*(volatile uint_io8_t*)0xB09001EEUL)  /*@bfbba@*/
#define EIC00_DRECR_DREC15	(*(volatile uint_io8_t*)0xB09001EFUL)  /*@bfbba@*/
#define EIC00_DRECR_DREC16	(*(volatile uint_io8_t*)0xB09001F0UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC17	(*(volatile uint_io8_t*)0xB09001F1UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC18	(*(volatile uint_io8_t*)0xB09001F2UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC19	(*(volatile uint_io8_t*)0xB09001F3UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC20	(*(volatile uint_io8_t*)0xB09001F4UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC21	(*(volatile uint_io8_t*)0xB09001F5UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC22	(*(volatile uint_io8_t*)0xB09001F6UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC23	(*(volatile uint_io8_t*)0xB09001F7UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC24	(*(volatile uint_io8_t*)0xB09001F8UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC25	(*(volatile uint_io8_t*)0xB09001F9UL)  /*@bfbba@*/
#define EIC00_DRECR_DREC26	(*(volatile uint_io8_t*)0xB09001FAUL)  /*@bfbba@*/
#define EIC00_DRECR_DREC27	(*(volatile uint_io8_t*)0xB09001FBUL)  /*@bfbba@*/
#define EIC00_DRECR_DREC28	(*(volatile uint_io8_t*)0xB09001FCUL)  /*@bfbba@*/
#define EIC00_DRECR_DREC29	(*(volatile uint_io8_t*)0xB09001FDUL)  /*@bfbba@*/
#define EIC00_DRECR_DREC30	(*(volatile uint_io8_t*)0xB09001FEUL)  /*@bfbba@*/
#define EIC00_DRECR_DREC31	(*(volatile uint_io8_t*)0xB09001FFUL)  /*@bfbba@*/

typedef struct stc_eic00_drecr_field{
    uint_io32_t		u1DREC0:1;
    uint_io32_t		u1DREC1:1;
    uint_io32_t		u1DREC2:1;
    uint_io32_t		u1DREC3:1;
    uint_io32_t		u1DREC4:1;
    uint_io32_t		u1DREC5:1;
    uint_io32_t		u1DREC6:1;
    uint_io32_t		u1DREC7:1;
    uint_io32_t		u1DREC8:1;
    uint_io32_t		u1DREC9:1;
    uint_io32_t		u1DREC10:1;
    uint_io32_t		u1DREC11:1;
    uint_io32_t		u1DREC12:1;
    uint_io32_t		u1DREC13:1;
    uint_io32_t		u1DREC14:1;
    uint_io32_t		u1DREC15:1;
    uint_io32_t		u1DREC16:1;
    uint_io32_t		u1DREC17:1;
    uint_io32_t		u1DREC18:1;
    uint_io32_t		u1DREC19:1;
    uint_io32_t		u1DREC20:1;
    uint_io32_t		u1DREC21:1;
    uint_io32_t		u1DREC22:1;
    uint_io32_t		u1DREC23:1;
    uint_io32_t		u1DREC24:1;
    uint_io32_t		u1DREC25:1;
    uint_io32_t		u1DREC26:1;
    uint_io32_t		u1DREC27:1;
    uint_io32_t		u1DREC28:1;
    uint_io32_t		u1DREC29:1;
    uint_io32_t		u1DREC30:1;
    uint_io32_t		u1DREC31:1;
}stc_eic00_drecr_field_t;

typedef union un_eic00_drecr{
    uint_io32_t		u32Register;
    stc_eic00_drecr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_drecr_t;

/* DRFR */
#define EIC00_DRFR	(EIC00.unDRFR.u32Register)  /*@rg@*/
#define EIC00_DRFR_DRF0	(*(volatile uint_io8_t*)0xB0900200UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF1	(*(volatile uint_io8_t*)0xB0900201UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF2	(*(volatile uint_io8_t*)0xB0900202UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF3	(*(volatile uint_io8_t*)0xB0900203UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF4	(*(volatile uint_io8_t*)0xB0900204UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF5	(*(volatile uint_io8_t*)0xB0900205UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF6	(*(volatile uint_io8_t*)0xB0900206UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF7	(*(volatile uint_io8_t*)0xB0900207UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF8	(*(volatile uint_io8_t*)0xB0900208UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF9	(*(volatile uint_io8_t*)0xB0900209UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF10	(*(volatile uint_io8_t*)0xB090020AUL)  /*@bfbba@*/
#define EIC00_DRFR_DRF11	(*(volatile uint_io8_t*)0xB090020BUL)  /*@bfbba@*/
#define EIC00_DRFR_DRF12	(*(volatile uint_io8_t*)0xB090020CUL)  /*@bfbba@*/
#define EIC00_DRFR_DRF13	(*(volatile uint_io8_t*)0xB090020DUL)  /*@bfbba@*/
#define EIC00_DRFR_DRF14	(*(volatile uint_io8_t*)0xB090020EUL)  /*@bfbba@*/
#define EIC00_DRFR_DRF15	(*(volatile uint_io8_t*)0xB090020FUL)  /*@bfbba@*/
#define EIC00_DRFR_DRF16	(*(volatile uint_io8_t*)0xB0900210UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF17	(*(volatile uint_io8_t*)0xB0900211UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF18	(*(volatile uint_io8_t*)0xB0900212UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF19	(*(volatile uint_io8_t*)0xB0900213UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF20	(*(volatile uint_io8_t*)0xB0900214UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF21	(*(volatile uint_io8_t*)0xB0900215UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF22	(*(volatile uint_io8_t*)0xB0900216UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF23	(*(volatile uint_io8_t*)0xB0900217UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF24	(*(volatile uint_io8_t*)0xB0900218UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF25	(*(volatile uint_io8_t*)0xB0900219UL)  /*@bfbba@*/
#define EIC00_DRFR_DRF26	(*(volatile uint_io8_t*)0xB090021AUL)  /*@bfbba@*/
#define EIC00_DRFR_DRF27	(*(volatile uint_io8_t*)0xB090021BUL)  /*@bfbba@*/
#define EIC00_DRFR_DRF28	(*(volatile uint_io8_t*)0xB090021CUL)  /*@bfbba@*/
#define EIC00_DRFR_DRF29	(*(volatile uint_io8_t*)0xB090021DUL)  /*@bfbba@*/
#define EIC00_DRFR_DRF30	(*(volatile uint_io8_t*)0xB090021EUL)  /*@bfbba@*/
#define EIC00_DRFR_DRF31	(*(volatile uint_io8_t*)0xB090021FUL)  /*@bfbba@*/

typedef struct stc_eic00_drfr_field{
    uint_io32_t		u1DRF0:1;
    uint_io32_t		u1DRF1:1;
    uint_io32_t		u1DRF2:1;
    uint_io32_t		u1DRF3:1;
    uint_io32_t		u1DRF4:1;
    uint_io32_t		u1DRF5:1;
    uint_io32_t		u1DRF6:1;
    uint_io32_t		u1DRF7:1;
    uint_io32_t		u1DRF8:1;
    uint_io32_t		u1DRF9:1;
    uint_io32_t		u1DRF10:1;
    uint_io32_t		u1DRF11:1;
    uint_io32_t		u1DRF12:1;
    uint_io32_t		u1DRF13:1;
    uint_io32_t		u1DRF14:1;
    uint_io32_t		u1DRF15:1;
    uint_io32_t		u1DRF16:1;
    uint_io32_t		u1DRF17:1;
    uint_io32_t		u1DRF18:1;
    uint_io32_t		u1DRF19:1;
    uint_io32_t		u1DRF20:1;
    uint_io32_t		u1DRF21:1;
    uint_io32_t		u1DRF22:1;
    uint_io32_t		u1DRF23:1;
    uint_io32_t		u1DRF24:1;
    uint_io32_t		u1DRF25:1;
    uint_io32_t		u1DRF26:1;
    uint_io32_t		u1DRF27:1;
    uint_io32_t		u1DRF28:1;
    uint_io32_t		u1DRF29:1;
    uint_io32_t		u1DRF30:1;
    uint_io32_t		u1DRF31:1;
}stc_eic00_drfr_field_t;

typedef union un_eic00_drfr{
    uint_io32_t		u32Register;
    stc_eic00_drfr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_eic00_drfr_t;


typedef struct stc_eic00{
    un_eic00_enir_t	unENIR;	/* 0x00000000 */
    un_eic00_enisr_t	unENISR;	/* 0x00000004 */
    un_eic00_enicr_t	unENICR;	/* 0x00000008 */
    un_eic00_eirr_t	unEIRR;	/* 0x0000000C */
    un_eic00_eircr_t	unEIRCR;	/* 0x00000010 */
    un_eic00_nfer_t	unNFER;	/* 0x00000014 */
    un_eic00_nfesr_t	unNFESR;	/* 0x00000018 */
    un_eic00_nfecr_t	unNFECR;	/* 0x0000001C */
    un_eic00_elvrn_t	unELVR0;	/* 0x00000020 */
    un_eic00_elvrn_t	unELVR1;	/* 0x00000024 */
    un_eic00_elvrn_t	unELVR2;	/* 0x00000028 */
    un_eic00_elvrn_t	unELVR3;	/* 0x0000002C */
    un_eic00_nmir_t	unNMIR;	/* 0x00000030 */
    un_eic00_drer_t	unDRER;	/* 0x00000034 */
    un_eic00_dresr_t	unDRESR;	/* 0x00000038 */
    un_eic00_drecr_t	unDRECR;	/* 0x0000003C */
    un_eic00_drfr_t	unDRFR;	/* 0x00000040 */
    uint_io8_t	au8Reserved0[131004];	/* 0x00000044 */
}stc_eic00_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_eic00_t	stcEIC00;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 131072(0x20000) bytes */


#endif /* __S6J3360_EIC_H */
